---
title: Navigation
page_title: jQuery FileManager Documentation | Navigation in FileManager
description: "Get familiar with the navigation possibilities in the FileManager and how you can drill down to the specific file you need to manipulate with."
slug: navigation_kendoui_filemanager_widget
position: 5
---

# Navigation Overview

The navigation within the file structure in the FileManager is achieved with the help of an inbuilt [TreeView](#treeview) and [Breadcrumb](#breadcrumb) components.

## TreeView
On the left-hand side of the FileManager there is a nested [Kendo UI TreeView]({% slug overview_kendoui_treeview_widget %}) component, listing all folders loaded in the FileManager. The TreeView allows dragging and dropping files inside it, or between the Grid and ListView. It also provides you the possibility to rename files or folders, as well as execute commands with the inbuilt ContextMenu. 

The nested [Kendo UI TreeView]({% slug overview_kendoui_treeview_widget %}) component is the standard component from the Kendo UI suite. This is why, all functionalities and features, such as Keyboard Support and Accessibility compliance, are inherited.

## Breadcrumb

As of R1 2020, the [Breadcrumb]({% slug overview_kendoui_breadcrumb_widget %}) component is added to the Kendo UI suite and it is incorporated in the FileManager.

## See Also

* [Overview of Kendo UI FileManager]({% slug overview_kendoui_filemanager_widget %})
* [Kendo UI TreeView]({% slug overview_kendoui_treeview_widget %})
* [Breadcrumb]({% slug overview_kendoui_breadcrumb_widget %})
* [Sort in Kendo UI FileManager]({% slug sort_kendoui_filemanager_widget %})
* [Search in Kendo UI FileManager]({% slug search_kendoui_filemanager_widget %})
