---
title: Overview
page_title: jQuery Grid Documentation | Grid Globalization
description: "Get started with the jQuery Grid by Kendo UI and learn about the globalization options it supports."
slug: globalization_kendoui_grid_widget
position: 1
---

# Grid Globalization

The globalization process combines the translation of component messages (localization) with adapting them to specific cultures (internationalization and right-to-left support).

The globalization functionality of the Grid is enabled through:
* [Internationalization for culture locales]({% slug intl_kendoui_grid_widget %})
* [Localization of messages]({% slug localization_kendoui_grid_widget %})
* [Right-to-left support]({% slug rtl_kendoui_grid_widget %})

For more information on using localization, internationalization, and right-to-left languages with Kendo UI widgets, refer to the article on [globalization support by Kendo UI for jQuery]({% slug overview_kendoui_globalization %}).

## See Also

* [Localization Support by the Grid (Demo)](https://demos.telerik.com/kendo-ui/grid/localization)
* [RTL Support by the Grid (Demo)](https://demos.telerik.com/kendo-ui/grid/right-to-left-support)
* [Globalization in Kendo UI for jQuery]({% slug overview_kendoui_globalization %})
* [JavaScript API Reference of the Grid](/api/javascript/ui/grid)
