---
title: Comparison
page_title: jQuery PivotGridV2 Documentation | Comparison
description: "Learn about the differences between the old and the new version of the Kendo UI PivotGrid widget."
slug: comparison_kendoui_pivotgridv2
position: 2
---

# Comparison

As of the November 2021 release, Kendo UI introduces the brand new PivotGridV2 which aims to replace the old Kendo UI PivotGrid. In this article you will learn about the major differences between the two widgets and what to expect in the future.

- [Why Do Two PivotGrid Widgets Exist?](#why-do-two-pivotgrid-widgets-exist)
- [What Can I Expect from the New PivotGridV2?](#what-can-i-expect-from-the-new-pivotgridv2)
    - [New Engine](#new-engine)
    - [Performance](#performance)
    - [Design](#design)
    - [Customization](#customization)
- [Summary](#summary)

## Why Do Two PivotGrid Widgets Exist?

There are many developers who use and depend on the PivotGrid. Making any drastic changes to the source code of the old widget would undoubtedly interfere with their work. That is why the decision to introduce a second widget, was taken.

Тhe old and new versions of the PivotGrid can coexist. The old PivotGrid will not disappear with the upcoming release. This allows developers to smoothly transition to the new version without rushing their projects.

## What Can I Expect from the New PivotGridV2?

The new PivotGridV2 has improved performance, brand new design and is easier to customize.

### New Engine

The engine for the new PivotGridV2 is a cross-team development effort, meaning that it will be used by multiple different Kendo suites such as JQuery, Angular, React, and so on. This approach will ultimately lead to the implementation of many new features as all of them will be shared between the different products.

### Performance

Performance is another important aspect that is improved in the new PivotGridV2. Merging newly requested data on top of the already present data in the widget, will be much faster.

### Design

The new PivotGridV2 has a brand new design and some additional basic UX functionalities such as hiding the [`configurator`]({% slug overview_kendoui_pivotconfiguratorv2 %}) when it is not in use. This approach will provide the end user with much better experience when working with the widget.

### Customization

The new PivotGridV2 will be easier to customize when it comes down to functionalities such as data aggregation.

## Summary

Developers are encouraged to use the PivotGridV2 when starting new projects.

Here's a quick summary to outline the benefits of the new PivotGridV2:

- Brand-new engine which allows for quicker implementation of features and quicker bugfixes.
- Improved performance of the entire widget.
- Brand new design.
- Easier to customize compared to the old PivotGrid.
- Improved API as new features are implemented.

## See Also

* [Basic Usage of the PivotGridV2 (Demo)](https://demos.telerik.com/kendo-ui/pivotgridv2/index)
* [PivotGridV2 JavaScript API Reference](/api/javascript/ui/pivotgridv2)