---
title: List of Keyboard Shortcuts
page_title: jQuery Spreadsheet Documentation | List of Keyboard Shortcuts
description: "Get started with the jQuery Spreadsheet by Kendo UI and check out the list of its keyboard shortcuts."
slug: list_ofkeyboard_shortcuts_spreadsheet_widget
position: 3
---

# List of Keyboard Shortcuts

The following table provides a list of the keyboard shortcuts the Spreadsheet supports.

| Shortcuts | Description |
| :--- | :--- |
| `Ctrl` + `A` | Selects the whole worksheet |
| `Ctrl` + `C` | Copies selected cells |
| `Ctrl` + `P` | Displays the **Print** dialog box |
| `Ctrl` + `S` | Saves the active spreadsheet file |
| `Ctrl` + `V` | Inserts copied or cut cells to a selected location within the worksheet |
| `Ctrl` + `X` | Cuts selected cells |
| `Ctrl` + `Y` | Repeats the last action, if possible by using the `Redo` command |
| `Ctrl` + `Z` | Reverses the last action or deletes the last typed entry by using the `Undo` command |
| `Ctrl` + select a cell | Selects an adjacent or non adjacent cell |
| `Ctrl` + select cells | Selects a range of adjacent or nonadjacent cells. To simultaneously select more than one range of cells, repeat this command. The selected ranges can also overlap. |
| `Ctrl` + select a row or column | Selects an adjacent or nonadjacent row or column. |
| `Ctrl` + select rows or columns | Selects a range of adjacent or nonadjacent rows or columns. To simultaneously select more than one range of rows or columns, repeat this command. The selected ranges can also overlap. |
| `Arrow` keys | Move a cell up, down, left, or right in a worksheet |
| `Ctrl` + `Arrow` key | Navigates to the last cell of the current series of data. If there is another set of data afterwards, the first cell of the new series will be selected. Otherwise, you will be navigated to the last cell of the worksheet in the corresponding direction |
| `Shift` + `Arrow` key | Selects (a range of) adjacent cells, rows, or columns, by extending the selection by one cell, row, or column |
| `Ctrl` + `Shift` + `Arrow` key | Extends the selection of cells to the last cell of the current series of data. If there is another set of data afterwards, the cell selection will be extended to the first cell of the new series of data. Otherwise, the cell selection will be extended to the last cell of the worksheet in the corresponding direction |
| `Down Arrow` / `Up Arrow` key | <ul><li>In a menu or a submenu, selects the next or previous command</li> <li>In a dialog box, the arrow keys move between options in an active drop-down list, or between options in a group of options</li></ul> |
| `F2` | Enters editing mode for the currently selected cell |
| `F10` | Focuses the first tool of Spreadsheet toolbar |
| `Backspace` | <ul><li>In the Formula bar, it deletes one character to the left from the formula text</li> <li>In cell selection mode, it removes the content of the active cell</li> <li>In cell editing mode, it deletes the character to the left of the insertion point</li></ul> |
| `Delete` | <ul><li>In the Formula bar, it deletes the character to the right of the insertion point from the formula text</li><li>In cell selection mode, it removes the content from selected cells without affecting cell formats</li> <li>In cell editing mode, it deletes the character to the right of the insertion point</li></ul> |
| `End` | <ul><li>In cell selection mode, moves to the far right cell of the active row</li> <li>In a menu or submenu, selects the last command</li></ul>
| `Ctrl` + `End` | <ul><li>In cell selection mode, moves to the last cell on a worksheet, in the lowest used row of the used column on the bottom-right</li> <li>In the formula bar, `Ctrl` + `End` moves the cursor to the end of the text</li> </ul> |
| `Ctrl` + `Shift` + `End` | <ul><li>In cell selection mode, extends the selection of cells to the last cell on the worksheet located in lower-right corner</li> <li>In the formula bar, `Ctrl` + `Shift` + `End` selects all text in the formula bar from the cursor position to the end</li></ul> |
| `Enter` | <ul><li>In cell editing mode or in the **Formula bar**, completes a cell entry and selects the cell below</li> <li>In a data form, it moves to the first field in the next record</li> <li>In the command toolbar, opens a selected menu or performs the action for a selected command</li> <li>In a dialog box, it performs the action for the default command button in the dialog box (the button with the bold outline)</li></ul> |
| `Alt` + `Enter` | In cell editing mode or in the **Formula bar** creates a new row within the cell |
| `Esc` | <ul><li>In cell editing mode or in the **Formula bar**, cancels an entry in the cell or **Formula Bar**</li> <li>Closes an open menu or submenu, dialog box, or message window</li></ul> |
| `Home` | <ul><li>In cell selection mode, moves to the beginning of a row in a worksheet</li> <li>In a menu or submenu, selects the first command</li></ul> |
| `Ctrl` + `Home` | <ul><li>In cell selection mode, moves to the first cell (the top-left cell) on a worksheet</li> <li>In the formula bar, `Ctrl` + `Home` moves the cursor to the beginning of the text</li> </ul> |
| `Ctrl` + `Shift` + `Home` | Extends the selection of cells to the beginning of the worksheet |
| `Page Down` | Moves one screen down in a worksheet |
| `Page Up` | Moves one screen up in a worksheet |
| `Spacebar` | In a dialog box, performs the action for the selected button, or selects or clears a check box |
| `Alt` + `Spacebar` | Displays the **Control** menu for the Spreadsheet window |
| `Tab` | <ul><li>In cell selection mode, moves one cell to the right in a worksheet.</li> <li>In a dialog box, moves to the next option or option group in a dialog box</li> <li>In range selection of cells, rows or columns, moves to the next cell within the active range. If the focus is on the last cell (the bottom-right cell) in the range, the focus will return to the first cell on the top-left</li><li>If the currently active cell is the last cell in the Sheet (the cell on the last row in the last column), pressing `Tab` will move the focus outside of the Spreadsheet to the next focusable element on the page.</li></ul> |
| `Shift` + `Tab` | <ul><li>In cell selection mode, moves one cell to the right in a worksheet</li> <li>In a dialog box, moves to the next option or option group in a dialog box</li> <li>In range selection of cells, rows or columns, moves to the previous cell within the active range. If the focus is on the first cell (the top-left cell) in the range, the focus will return to the last cell on the bottom-right</li> <li><li>If the currently active cell is the first cell in the Sheet (the cell on the first row in the first column), pressing `Shift` + `Tab` will move the focus outside of the Sheet to the Named ranges ComboBox on the Spreadsheet Toolbar.</li></li></ul> |

When the focus is within the Spreadsheet Sheet, fast way to navigate away from the Spreadsheet is to press `Ctrl` + `End` (to move the focus to the last cell on the Sheet) and the `Tab`. Similarly, to move the focus from the Sheet to the Spreadsheet Toolbar, press `Ctrl` + `Home` and then `Shift` + `Tab`.

## See Also

* [List of Formulas and Functions]({% slug list_offormulas_andfunctions_spreadsheet_widget %})
* [User Guide]({% slug user_guide_spreadsheet_widget %})
