---
title: Overview
page_title: Kendo UI for jQuery OrgChart Documentation | OrgChart Accessibility
description: "Get started with the Kendo UI for jQuery OrgChart and learn about its accessibility support for WAI-ARIA, Section 508, and WCAG 2.1."
slug: accessibility_kendoui_orgchart_widget
position: 1
---

# OrgChart Accessibility

The OrgChart is accessible by screen readers and provides WAI-ARIA, Section 508, WCAG 2.1, and keyboard support.

For more information, refer to:
* [Keyboard navigation by the Kendo UI OrgChart]({% slug keynav_kendoui_orgchart_widget %})
* [Accessibility in Kendo UI for jQuery]({% slug overview_accessibility_support_kendoui %})

## WAI-ARIA

The widget follows the WAI-ARIA Authoring Practices for implementing the keyboard navigation for its component role and is tested against the popular screen readers. For more information, refer to the article on [WAI-ARIA support in Kendo UI for jQuery]({% slug wai_aria_accessibility_support %}).

## Section 508

The OrgChart is compliant with the Section 508 requirements. For more information, refer to the article on [Section 508 support in Kendo UI for jQuery]({% slug section508_accessibility_support %}).

## WCAG 2.1

The OrgChart supports the standards for providing accessible web content which are set by the [Web Content Accessibility Guidelines 2.1](https://www.w3.org/TR/WCAG/). For more information, refer to the article on [WCAG 2.1 compliance in Kendo UI for jQuery]({% slug section508_wcag21_accessibility_support %})

## See Also

* [Keyboard Navigation in the OrgChart (Demo)](https://demos.telerik.com/kendo-ui/orgchart/keyboard-navigation)
* [Keyboard Navigation in the OrgChart]({% slug keynav_kendoui_orgchart_widget %})
* [Keyboard Support in Kendo UI for jQuery]({% slug keyboard_shortcuts_accessibility_support %})
* [Accessibility in Kendo UI for jQuery]({% slug overview_accessibility_support_kendoui %})
