---
title: Overview
page_title: jQuery Captcha Documentation | Captcha Accessibility
description: "Get started with the jQuery Captcha and learn about its accessibility support for WAI-ARIA, Section 508, and WCAG 2.1."
slug: accessibility_kendoui_captcha_widget
position: 1
---

# Captcha Accessibility

The Captcha is accessible by screen readers and provides WAI-ARIA, Section 508, WCAG 2.1, and keyboard support.

For more information, refer to:
* [Keyboard navigation by the Kendo UI Captcha]({% slug keynav_captcha_jquery %})
* [Accessibility in Kendo UI for jQuery]({% slug overview_accessibility_support_kendoui %})

## WAI-ARIA

The widget follows the WAI-ARIA Authoring Practices for implementing the keyboard navigation for its component role and is tested against the popular screen readers. For more information, refer to the article on [WAI-ARIA support in Kendo UI for jQuery]({% slug wai_aria_accessibility_support %}).

## Section 508

The Captcha is compliant with the Section 508 requirements. For more information, refer to the article on [Section 508 support in Kendo UI for jQuery]({% slug section508_accessibility_support %}).

## WCAG 2.1

The Captcha supports the standards for providing accessible web content which are set by the [Web Content Accessibility Guidelines 2.1](https://www.w3.org/TR/WCAG/). For more information, refer to the article on [WCAG 2.1 compliance in Kendo UI for jQuery]({% slug section508_wcag21_accessibility_support %})

## See Also

* [Keyboard Navigation by the Captcha (Demo)](https://demos.telerik.com/kendo-ui/captcha/keyboard-navigation)
* [Keyboard Navigation by the Captcha]({% slug keynav_captcha_jquery %})
* [Keyboard Support in Kendo UI for jQuery]({% slug keyboard_shortcuts_accessibility_support %})
* [Accessibility in Kendo UI for jQuery]({% slug overview_accessibility_support_kendoui %})
