---
title: Overview
page_title: jQuery CheckBoxGroup Documentation | CheckBoxGroup Overview
description: "Get started with the jQuery CheckBoxGroup by Kendo UI and learn how to create, initialize, and enable the widget."
slug: overview_kendoui_checkboxgroup_widget
position: 1
---

# CheckBoxGroup Overview

The CheckBoxGroup allows to style and provide checkbox functionality to list elements, set the position of the labels, attributes and custom css classes.

* [Demo page for the CheckBoxGroup](https://demos.telerik.com/kendo-ui/checkboxgroup/index)

## Initializing the CheckBoxGroup

To initialize the CheckBoxGroup, use the `<ul />` tag.

The following example demonstrates how to initialize the CheckBoxGroup from an existing `<ul />` element.

```dojo
    <ul id="checkboxgroup"></ul>

    <script>
        $(document).ready(function(){
            $("#checkboxgroup").kendoCheckBoxGroup();
        });
    </script>
```

## Functionality and Features

* [Binding]({% slug binding_kendoui_checkboxgroup %})
* [Label]({% slug label_checkboxgroup_widget %})
* [Layout]({% slug layout_checkboxgroup_widget %})

## See Also

* [Basic Usage of the CheckBoxGroup (Demo)](https://demos.telerik.com/kendo-ui/checkboxgroup/index)
* [JavaScript API Reference of the CheckBoxGroup](/api/javascript/ui/checkboxgroup)
