---
title: Overview
page_title: jQuery DateInput Documentation | DateInput Overview
description: "Get started with the jQuery DateInput by Kendo UI and learn how to create, initialize, and enable the widget."
slug: overview_kendoui_dateinput_widget
position: 1
---

# DateInput Overview

The DateInput represents an input field that recognizes and formats scheduling values such as dates.

It provides separate sections for days, months, years, hours, and minutes, and also supports the customization of date and time formats.

* [Demo page for the DateInput](https://demos.telerik.com/kendo-ui/dateinput/index)

## Basic Configuration

The following example demonstrates how to initialize the DateInput.

```dojo
    <input id="dateInput" />

    <script>
      $(document).ready(function(){
        $("#dateInput").kendoDateInput();
      });
    </script>
```

## Functionality and Features

* [Selected dates and formats]({% slug selecteddates_kendoui_dateinput %})
* [Integration with other editors]({% slug integration_kendoui_dateinput %})
* [Globalization]({% slug globalization_kendoui_dateinput_widget %})

## See Also

* [Basic Usage of the DateInput (Demo)](https://demos.telerik.com/kendo-ui/dateinput/index)
* [Using the API of the DateInput (Demo)](https://demos.telerik.com/kendo-ui/dateinput/api)
* [JavaScript API Reference of the DateInput](/api/javascript/ui/dateinput)
