---
title: Calendar Types
page_title: jQuery DateTimePicker Documentation | Calendar Types
description: "Get started with the jQuery DateTimePicker by Kendo UI and learn how to create, initialize, and enable the widget."
slug: calendartypes_kendoui_datetimepicker
position: 7
---

# Calendar Types

By default, the DatePicker works with `Date` objects which support only the [Gregorian](https://en.wikipedia.org/wiki/Gregorian_calendar) calendar.

As a result, the DateTimePicker does not support other calendar types such as Lunar.

To work around the default behavior of the DateTimePicker and simulate a different calendar type, use either of the following approaches:
* Use the JavaScript `Date` object.
* Create a date that is in the past.

## See Also

* [Basic Usage of the DateTimePicker (Demo)](https://demos.telerik.com/kendo-ui/datetimepicker/index)
* [JavaScript API Reference of the DateTimePicker](/api/javascript/ui/datetimepicker)
