---
title: Overview
page_title: jQuery DropDownList Documentation | DropDownList Globalization
description: "Get started with the jQuery DropDownList by Kendo UI and learn about the globalization options it supports."
slug: globalization_dropdownlist_widget
position: 1
---

# DropDownList Globalization

The globalization process combines the translation of component messages (localization) with adapting them to specific cultures (internationalization and right-to-left support).

The globalization functionality of the DropDownList is enabled through:
* [Internationalization for culture locales]({% slug intl_kendoui_ddl_widget %})
* [Localization of messages]({% slug localization_kendoui_ddl_widget %})
* [Right-to-left support]({% slug rtl_kendoui_ddl_widget %})

For more information on using localization, internationalization, and right-to-left languages with Kendo UI widgets, refer to the article on [globalization support by Kendo UI for jQuery]({% slug overview_kendoui_globalization %}).

## See Also

* [RTL Support by the DropDownList (Demo)](https://demos.telerik.com/kendo-ui/dropdownlist/right-to-left-support)
* [Globalization in Kendo UI for jQuery]({% slug overview_kendoui_globalization %})
* [JavaScript API Reference of the DropDownList](/api/javascript/ui/dropdownlist)
