---
title: Overview
page_title: jQuery DropDownTree Documentation | DropDownTree Overview
description: "Get started with the jQuery DropDownTree by Kendo UI and learn how to create, initialize, and enable the widget."
slug: overview_kendoui_dropdowntree_widget
position: 1
---

# DropDownTree Overview

The DropDownTree represents an editor of hierarchical data, rendered in a tree-like structure, which provides multiple selection option and custom nodes.

The DropDownTree is available in the Kendo UI for jQuery suite as of the Kendo UI R2 2018.

* [Demo page for the DropDownTree](https://demos.telerik.com/kendo-ui/dropdowntree/index)

## Initializing the DropDownTree

You can initialize the Kendo UI DropDownTree widget from an `input` element and then [bind it to local or remote data]({% slug databinding_kendoui_dropdowntree %}), or to [flat data]({% slug bindtoflattables_dropdowntree_widget %}).

> * When you initialize the DropDownList, create it within a `$(document).ready()` statement because the widget has to be initialized after the DOM is fully loaded.
> * The DropDownTree copies any styles and CSS classes from the `input` element to the `wrapper` element and visible input.

## Functionality and Features

* [Data binding]({% slug databinding_kendoui_dropdowntree %})
* [Checkboxes]({% slug checkboxes_kendoui_dropdowntree %})
* [Filtering]({% slug filtering_kendoui_dropdowntree %})
* [Items]({% slug items_kendoui_dropdowntree %})
* [Templates]({% slug templates_kendoui_dropdowntree %})
* [Appearance]({% slug appearance_kendoui_dropdowntree %})

## See Also

* [Basic Usage of the DropDownTree (Demo)](https://demos.telerik.com/kendo-ui/dropdowntree/index)
* [Using the API of the DropDownTree (Demo)](https://demos.telerik.com/kendo-ui/dropdowntree/api)
* [JavaScript API Reference of the DropDownTree](/api/javascript/ui/dropdowntree)
