---
title: Resize the Editor by Dragging
page_title: Resize the Editor by Dragging | Kendo UI Editor
description: "Learn how to resize the Kendo UI Editor widget by dragging."
previous_url: /controls/editors/editor/how-to/resize-editor-by-dragging
slug: howto_resize_the_editor_by_dragging_editor
---

# Resize the Editor by Dragging

The following example demonstrates how to resize the Kendo UI Editor by dragging its bottom-right corner.

```dojo
<style>
      .editor-wrap {
        position: relative;
      }
      .editor-wrap .k-overlay {
        position: absolute;
        opacity: 0;
        z-index: 1;
      }
      .editor-wrap .k-resize-se {
        position: absolute;
        z-index: 2;
        bottom: 6px;
        right: 6px;
      }
      .editor-wrap > .k-editor {
        height: 100%;
      }
    </style>

    <div class="editor-wrap">
      <textarea id="editor1" class="kendoEditor"></textarea>
    </div>

    <br /><br />

    <div class="editor-wrap">
      <textarea id="editor2" class="kendoEditor"></textarea>
    </div>

    <script>

      // When you use server-side wrappers, the Editor initialization statements will be autogenerated.
      $(function(){
        $("#editor1").kendoEditor();
        $("#editor2").kendoEditor();
      });

    </script>

    <script>

      // Custom code starts here.
      // Wrap it in a document.ready handler.
      // Otherwise, it will be executed before the Editors are created.
      $(function(){

        var wrappers = $(".editor-wrap");
        wrappers.each(function(idx, element){
          var wrapper = $(element);
          // Add the resize handle.
          var resizeHandle = $("<span class='k-icon k-resize-se' />").appendTo(wrapper);

          resizeHandle.kendoDraggable({
            dragstart: function(e) {
              // Overlay the iframe to prevent an event gap.
              wrapper.append("<div class='k-overlay' />");
              // Cache some offsets for later use.
              this.top = wrapper.offset().top - this.element.height();
              this.left = wrapper.offset().left - this.element.width();
              var win = $(window);
              this.scrollTop = win.scrollTop();
              this.scrollLeft = win.scrollLeft();
            },
            drag: function(e) {
              // Update the wrapper height.
              wrapper.children(".k-editor").height((e.clientY || e.originalEvent.clientY) - this.top + this.scrollTop);
              wrapper.width((e.clientX || e.originalEvent.clientX) - this.left + this.scrollLeft);
            },
            dragend: function(e) {
              // Remove the overlay.
              wrapper.children(".k-overlay").remove();
            }
          });
        });

      });

    </script>
```

## See Also

* [Basic Usage of the Editor (Demo)](https://demos.telerik.com/kendo-ui/editor/index)
* [Using the API of the Editor (Demo)](https://demos.telerik.com/kendo-ui/editor/api)
* [JavaScript API Reference of the Editor](/api/javascript/ui/editor)
