---
title: Overview
page_title: jQuery NumericTextBox Documentation | NumericTextBox Globalization
description: "Get started with the jQuery NumericTextBox by Kendo UI and learn about the globalization options it supports."
slug: globalization_numerictextbox
position: 1
---

# NumericTextBox Globalization

The globalization process combines the translation of component messages (localization) with adapting them to specific cultures (internationalization and right-to-left support).

To determine the number precision and other culture-specific properties, the NumericTextBox uses the `kendo.culture.current` culture.

The globalization functionality of the NumericTextBox is enabled through:
* [Internationalization for culture locales]({% slug intl_numerictextbox %})
* [Localization of messages]({% slug localization_numerictextbox %})
* [Right-to-left support]({% slug rtl_numerictextbox %})

For more information on using localization, internationalization, and right-to-left languages with Kendo UI widgets, refer to the article on [globalization support by Kendo UI for jQuery]({% slug overview_kendoui_globalization %}).

## See Also

* [RTL Support by the NumericTextBox (Demo)](https://demos.telerik.com/kendo-ui/numerictextbox/right-to-left-support)
* [Globalization in Kendo UI for jQuery]({% slug overview_kendoui_globalization %})
* [JavaScript API Reference of the NumericTextBox](/api/javascript/ui/numerictextbox)
