---
title: Overview
page_title: jQuery RadioGroup Documentation | RadioGroup Overview
description: "Get started with the jQuery RadioGroup by Kendo UI and learn how to create, initialize, and enable the widget."
slug: overview_kendoui_radiogroup_widget
position: 1
---

# RadioGroup Overview

The RadioGroup allows to style and provide radio buttons functionality to list elements, set the position of the labels, attributes and custom css classes.

* [Demo page for the RadioGroup](https://demos.telerik.com/kendo-ui/radiogroup/index) 

## Initializing the RadioGroup

To initialize the RadioGroup, use the `<ul />` tag.

The following example demonstrates how to initialize the RadioGroup from an existing `<ul />`.

```dojo
    <ul id="radiogroup"></ul>

    <script>
        $(document).ready(function(){
            $("#radiogroup").kendoRadioGroup({
                items: ["Andora", "Italy", "Malta"]
            });
        });
    </script>
```

## Functionality and Features

* [Binding]({% slug binding_kendoui_radiogroup %})
* [Label]({% slug label_radiogroup_widget %})
* [Layout]({% slug layout_radiogroup_widget %})

## See Also 

* [Basic Usage of the RadioGroup (Demo)](https://demos.telerik.com/kendo-ui/radiogroup/index)
* [JavaScript API Reference of the RadioGroup](/api/javascript/ui/radiogroup)
