---
title: Keyboard Navigation
page_title: jQuery Slider Documentation | Keyboard Navigation
description: "Get started with the jQuery Slider by Kendo UI and learn about the accessibility support it provides through its keyboard navigation functionality."
slug: keynav_kendoui_slider
position: 2
---

# Keyboard Navigation

The keyboard navigation of the Slider is always available.

For a complete example, refer to the [demo on keyboard navigation of the Slider](https://demos.telerik.com/kendo-ui/slider/keyboard-navigation).

The user can focus the drag handles of the Slider through tabbing. When focused in this way, the respective drag handle supports the following keyboard shortcuts.

> In the right-to-left (RTL) mode, the behavior of the left and right `Arrow` keys is reversed.

| SHORTCUT						          | DESCRIPTION				                                 |
|:---                           |:---                                                |
| `Left Arrow` or `Down Arrow`  | Increments the value by a `smallStep` amount.      |
| `Right Arrow` or `Left Arrow` | Decrements the value by a `smallStep` amount.       |
| `Page Up`                     | Increments the value by a `largeStep` amount.       |
| `Page Down`                   | Decrements the value by a `largeStep` amount.       |
| `Home`                        | Places the focused drag handle at the minimum value. |
| `End`                         | Places the focused drag handle at the maximum value. |

## See Also

* [Keyboard Navigation by the Slider (Demo)](https://demos.telerik.com/kendo-ui/slider/keyboard-navigation)
* [Keyboard Support in Kendo UI for jQuery]({% slug keyboard_shortcuts_accessibility_support %})
* [Accessibility in the Slider]({% slug accessibility_kendoui_slider %})
