---
title: Overview
page_title: jQuery Sortable Documentation | Sortable Overview
description: "Get started with the jQuery Sortable by Kendo UI and learn how to create, initialize, and enable the widget."
slug: overview_kendoui_sortable_widget
position: 1
---

# Sortable Overview

The Sortable provides a sortable drag-and-drop functionality to elements within a list.

The Sortable does not support integration with the Kendo UI TreeList widget.

* [Demo page for the Sortable](https://demos.telerik.com/kendo-ui/sortable/index)

## Initializing the Sortable

To initialize the Sortable, use an existing HTML element and enable the reordering of the element children.

The following example demonstrates how to initialize Sortable by using jQuery plugin syntax.

```dojo
    <ul id="sortable">
        <li>Item1</li>
        <li>Item2</li>
        <li>Item3</li>
    </ul>

    <script>
        $("#sortable").kendoSortable();
    </script>
```

## Functionality and Features

* [Hint]({% slug hint_kendoui_sortable %})
* [Items]({% slug items_kendoui_sortable %})
* [Cursor]({% slug cursor_kendoui_sortable %})
* [Placeholder]({% slug placeholder_kendoui_sortable %})
* [Integration with other Kendo UI widgets]({% slug integrationwith_grid_sortable %})
* [Common Scenarios]({% slug scenarios_kendoui_sortable %})

## See Also

* [Basic Usage of the Sortable (Demo)](https://demos.telerik.com/kendo-ui/sortable/index)
* [JavaScript API Reference of the Sortable](/api/javascript/ui/sortable)
