---
title: Messages
page_title: jQuery Notification Documentation | Messages
description: "Get started with the jQuery Notification by Kendo UI and set the position and stacking of its messages."
slug: positionstacking_kendoui_notification
position: 3
---

# Messages  

You can render [popup](#rendering-popup-messages) and [static](#rendering-static-messages) Notifications by defining their positioning and stacking, and also enable a [single Notification to render different messages](#rendering-different-messages-for-single-notifications).

## Rendering Popup Messages

By default, the Notification creates popups which overlay the other page content. If you do not define any position settings, the first popup will be displayed near the bottom-right corner of the browser viewport and subsequent popups will stack upwards.

You can independently control positioning and stacking. If you do not define any stacking settings, based on the position settings, the popups will stack upwards or downwards. For example, popups displayed at the top of the viewport will stack downwards and vice versa. The automatic settings of the stacking functionality comply with a common preference among users. However, you can render leftward or rightward stacking by explicitly defining the respective settings.

Popups are [pinned](/api/javascript/ui/notification/configuration/position.pinned) by default and they do not change their position when users scroll the page. The pinned functionality is achieved by applying a `position:fixed` style to the popups. To enable the popups to move together with the scrolled page, use the `position:absolute` style.

If the popup content is expected to vary and stacking is likely to occur, explicitly define dimensions. In this way, the popups are aligned and look better when stacked next to one another.

The following example demonstrates how to manage the positioning, stacking, and sizing functionalities of notifications.

    <span id="notification"></span>

  	<script>
    	$(function(){
    		$("#notification").kendoNotification({
                position: {
                    // The Notification popup will scroll together with the other content.
                    pinned: false,
                    // The first Notification popup will appear 30px from the top and right edge of the viewport.
                    top: 30,
                    right: 30
                },
                // New notifications will appear under the previous ones.
                stacking: "down",
                // Set the appropriate size.
                width: 300,
                height: 50
            });
    	});
  	</script>

In some cases, the popup notifications appear too quickly or occupy too much space on the screen. As a result, if pinned, the subsequent popups will appear outside the visible viewport area and will be inaccessible. In such scenarios, consider using a shorter hiding delay or static notifications for better usability.

Stacking works with the help of a Globally Unique Identifier (GUID), which is generated by the widget upon initialization and appended as a CSS class to each notification element. In this way every Notification instance can recognize and manage its own currently visible notifications independently.

When a popup notification message from a given stack is hidden, the remaining visible popups do not move. To achieve automatic moving and repositioning, refer to the article on [moving visible Notifications after hiding others]({% slug howto_move_notifications_after_hiding_others %}).

> The usage of two or more Notification instances which display notifications in the same place on the page is not recommended because the notifications from the multiple instances will overlap.

## Rendering Static Messages

The Notification also enables you to display static notifications which do not overlay other elements but take part in the so-called normal flow of the page content. In such cases, the positioning settings are ignored. When you use static notifications, the stacking direction can only be set to `down`, which is the default setting, or `up` depending on whether new messages have to appear after or before the existing ones. Static notifications are displayed if a target container is specified. A single widget instance can display a popup or a static notification but not both of them at one time.

The following example demonstrates how to enable static notifications.

    <div id="notification"></div>

	<script>
	$(function(){
		$("#notification").kendoNotification({
            // Insert all notifications to the originating element of the widget.
            appendTo: "#notification",
            // New notifications will appear above previous ones.
            stacking: "up"
        });
	});
	</script>

## Rendering Different Messages for Single Notifications

A single Notification instance can display different messages with different settings, for example, messages related to automatic hiding or hide timeouts. To apply the desired configuration options, use the [`setOptions`](/api/javascript/ui/widget/methods/setoptions) method. The new options will apply to all messages displayed later on. To restore or change the widget settings again, use `setOptions` as many times as necessary.

    <span id="notification"></span>
    <script>
        var notificationWidget = $("#notification").kendoNotification({
            autoHideAfter: 1000
        }).data("kendoNotification");

        notificationWidget.show("foo text"); //The  message will automatically hide after one second.

        notificationWidget.setOptions({
            autoHideAfter: 2000
        });

        notificationWidget.show("bar text"); // The message will automatically hide after two seconds.
    </script>

## See Also

* [Basic Usage of the Notification (Demo)](https://demos.telerik.com/kendo-ui/notification/index)
* [Using the API of the Notification (Demo)](https://demos.telerik.com/kendo-ui/notification/api)
* [JavaScript API Reference of the Notification](/api/javascript/ui/notification)
