---
title: Overview
page_title: jQuery Window Documentation | Window Globalization
description: "Get started with the jQuery Window by Kendo UI and learn about the globalization options it supports."
slug: globalization_window
position: 1
---

# Window Globalization

The globalization process combines the translation of component messages (localization) with adapting them to specific cultures (internationalization and right-to-left support).

The globalization functionality of the Window is enabled through:
* [Internationalization for culture locales]({% slug intl_window %})
* [Localization of messages]({% slug localization_window %})
* [Right-to-left support]({% slug rtl_window %})

For more information on using localization, internationalization, and right-to-left languages with Kendo UI widgets, refer to the article on [globalization support by Kendo UI for jQuery]({% slug overview_kendoui_globalization %}).

## See Also

* [RTL Support by the Window (Demo)](https://demos.telerik.com/kendo-ui/window/right-to-left-support)
* [Globalization in Kendo UI for jQuery]({% slug overview_kendoui_globalization %})
* [JavaScript API Reference of the Window](/api/javascript/ui/window)
