---
title: Keyboard Navigation
page_title: jQuery ScrollView Documentation | Keyboard Navigation
description: "Get started with the jQuery ScrollView by Kendo UI and learn about the accessibility support it provides through its keyboard navigation functionality."
slug: keynav_scrollview_jquery
position: 2
---

# Keyboard Navigation

The keyboard navigation of the ScrollView is always available.

To enable it, use the [`navigatable`](/api/javascript/ui/scrollview/configuration/navigatable) property. For a complete example, refer to the [demo on using the keyboard navigation of the ScrollView](https://demos.telerik.com/kendo-ui/scrollview/keyboard-navigation).

The ScrollView supports the following keyboard shortcuts:

### Focus:

|Shortcut |Description
|:---     |:---
|`Access key + W`  |Focuses the widget


### List of images:

|Shortcut |Description
|:---     |:---
|`Left arrow`  |Switches to the previous item
|`Right arrow`  |Switches to the next item


### Prev/Next buttons:

|Shortcut |Description
|:---     |:---
|`Enter`  |Triggers a click for the button
|`Space`  |Triggers a click for the button


### Pager:

|Shortcut |Description
|:---     |:---
|`Left arrow`  |Focuses to the previous dot in the pager
|`Right arrow`  |Focuses to the next dot in the pager
|`Enter`  |Selects the focused item in the pager
|`Space`  |Selects the focused item in the pager

## See Also

* [Keyboard Navigation by the SrollView (Demo)](https://demos.telerik.com/kendo-ui/scrollview/keyboard-navigation)
* [Keyboard Support in Kendo UI for jQuery]({% slug keyboard_shortcuts_accessibility_support %})
* [ScrollView Overview](https://docs.telerik.com/kendo-ui/controls/media/scrollview/overview)
