---
title: Overview
page_title: jQuery Button Documentation | Button Globalization
description: "Get started with the jQuery Button by Kendo UI and learn about the globalization options it supports."
slug: globalization_button
position: 1
---

# Button Globalization

The globalization process combines the translation of component messages (localization) with adapting them to specific cultures (internationalization and right-to-left support).

The globalization functionality of the Button is enabled through:
* [Internationalization for culture locales]({% slug intl_button %})
* [Localization of messages]({% slug localization_button %})
* [Right-to-left support]({% slug rtl_button %})

For more information on using localization, internationalization, and right-to-left languages with Kendo UI widgets, refer to the article on [globalization support by Kendo UI for jQuery]({% slug overview_kendoui_globalization %}).

## See Also

* [RTL Support by the Button (Demo)](https://demos.telerik.com/kendo-ui/button/right-to-left-support)
* [Globalization in Kendo UI for jQuery]({% slug overview_kendoui_globalization %})
* [JavaScript API Reference of the Button](/api/javascript/ui/button)
