---
title: Keyboard Navigation
page_title: jQuery Drawer Documentation | Keyboard Navigation
description: "Get started with the jQuery Drawer by Kendo UI and learn about the accessibility support it provides through its keyboard navigation functionality."
slug: keynav_drawer_jquery
position: 2
---

# Keyboard Navigation

The keyboard navigation of the Drawer is always available.

When the Drawer is focused, the current active item is selected. For a complete example, refer to the [demo on keyboard navigation of the Drawer](https://demos.telerik.com/kendo-ui/drawer/keyboard-navigation).

Kendo UI Drawer supports the following keyboard shortcuts:

| SHORTCUT						| DESCRIPTION				                                                        |
|:---                 |:---                                                                                |
| `Home`              | Focuses the first item in the drawer.                                                            |
| `End`               | Focuses the last item in the drawer.                                                             |
| `Up Arrow`          | Focuses the previous item in the drawer.                        |
| `Down Arrow`        | Focuses the next item in the drawer. |
| `Enter`             | Selects the focused item.                                             |
| `Space`             | Selects the focused item.                                             |
| `Esc`               | Hides the drawer.                                                               |

## See Also

* [Keyboard Navigation by the Drawer (Demo)](https://demos.telerik.com/kendo-ui/drawer/keyboard-navigation)
* [Keyboard Support in Kendo UI for jQuery]({% slug keyboard_shortcuts_accessibility_support %})
* [Accessibility in the Drawer]({% slug accessibility_drawer_jquery %})
