---
title: Keyboard Navigation
page_title: jQuery ContextMenu Documentation | Keyboard Navigation
description: "Get started with the jQuery ContextMenu by Kendo UI and learn about the accessibility support it provides through its keyboard navigation functionality."
slug: keynav_contextmenu_jquery
position: 2
---

# Keyboard Navigation

The keyboard navigation of the ContextMenu is always available.

When the ContextMenu gets opened its first item is focused. When the ContextMenu gets closed, in case the target element is focusable it gets focused.


Kendo UI ContextMenu supports the following keyboard shortcuts:

| SHORTCUT			  | DESCRIPTION				                                                           |
|:---                 |:---                                                                                |
| `Home`              | Focuses the first item.                                                            |
| `End`               | Focuses the last item.                                                             |
| `Left Arrow`        | Closes an item group.                                                              |
| `Right Arrow`       | Opens an item group of a ContextMenu.                                              |
| `Up Arrow`          | Moves the active item of ContextMenu upwards.                                      |
| `Down Arrow`        | Moves the active item of ContextMenu downwards.                                    |
| `Enter`             | Selects or navigates the focused item.                                             |
| `Space`             | Selects or navigates the focused item.                                             |
| `Esc`               | Closes an item group.                                                              |
| `Shift`+ `Tab`      | Blurs the Menu and moves the focus to the next (previous) focusable page element.  |

## See Also

* [Keyboard Navigation by the ContextMenu (Demo)](https://demos.telerik.com/kendo-ui/menu/context-menu-keyboard-navigation)
* [Keyboard Support in Kendo UI for jQuery]({% slug keyboard_shortcuts_accessibility_support %})
* [Accessibility in the ContextMenu]({% slug accessibility_kendoui_contextmenu_widget %})
