---
title: Use Custom Event Template with Specific Background Color
page_title: Use Custom Event Template with Specific Background Color | Kendo UI Scheduler
description: "Learn how to use a custom event template to render events with specific background color in a Kendo UI Scheduler widget."
previous_url: /controls/scheduling/scheduler/how-to/event-custom-background-color
slug: howto_use_custom_event_templatewith_specific_background_color_scheduler
---

# Use Custom Event Template with Specific Background Color

The following example demonstrates how to use the event template to render events with specific background color in the Scheduler.

```dojo
<style>
    .k-scheduler-header-wrap div.k-event,
    .k-scheduler-content div.k-event {
        background-color: red;
    }

    .movie-template
    {
        background-color: yellow;
        height: 100%;
    }

    .movie-template p
    {
        margin: 0;
    }
</style>
<div id="example">
  <div id="scheduler"></div>
</div>

<script id="event-template" type="text/x-kendo-template">
    <div class="movie-template">
      <p>
          #: kendo.toString(start, "hh:mm") # - #: kendo.toString(end, "hh:mm") #
      </p>
      <h3>#: title #</h3>
      <p>#: description #</p>
      </div>
</script>
<script>
      $(function() {
        $("#scheduler").kendoScheduler({
          date: new Date("2013/6/13"),
          startTime: new Date("2013/6/13 07:00 AM"),
          height: 600,
          views: [
            "day",
            { type: "workWeek", selected: true },
            "week",
            "month",
            "agenda"
          ],
          eventTemplate: $("#event-template").html(),
          timezone: "Etc/UTC",
          dataSource: {
            batch: true,
            transport: {
              read: {
                url: "https://demos.telerik.com/kendo-ui/service/tasks",
                dataType: "jsonp"
              },
              update: {
                url: "https://demos.telerik.com/kendo-ui/service/tasks/update",
                dataType: "jsonp"
              },
              create: {
                url: "https://demos.telerik.com/kendo-ui/service/tasks/create",
                dataType: "jsonp"
              },
              destroy: {
                url: "https://demos.telerik.com/kendo-ui/service/tasks/destroy",
                dataType: "jsonp"
              },
              parameterMap: function(options, operation) {
                if (operation !== "read" && options.models) {
                  return {models: kendo.stringify(options.models)};
                }
              }
            },
            schema: {
              model: {
                id: "taskId",
                fields: {
                  taskId: { from: "TaskID", type: "number" },
                  title: { from: "Title", defaultValue: "No title", validation: { required: true } },
                  start: { type: "date", from: "Start" },
                  end: { type: "date", from: "End" },
                  startTimezone: { from: "StartTimezone" },
                  endTimezone: { from: "EndTimezone" },
                  description: { from: "Description" },
                  recurrenceId: { from: "RecurrenceID" },
                  recurrenceRule: { from: "RecurrenceRule" },
                  recurrenceException: { from: "RecurrenceException" },
                  ownerId: { from: "OwnerID", defaultValue: 1 },
                  isAllDay: { type: "boolean", from: "IsAllDay" }
                }
              }
            },
            filter: {
              logic: "or",
              filters: [
                { field: "ownerId", operator: "eq", value: 1 },
                { field: "ownerId", operator: "eq", value: 2 }
              ]
            }
          }
        });
      });
</script>
```

## See Also

* [Basic Usage of the Scheduler (Demo)](https://demos.telerik.com/kendo-ui/scheduler/index)
* [Using the API of the Scheduler (Demo)](https://demos.telerik.com/kendo-ui/scheduler/api)
* [JavaScript API Reference of the Scheduler](/api/javascript/ui/scheduler)
