---
title: Overview
page_title: Drawing Overview | Kendo UI Drawing Library
description: "Learn about the Kendo UI Drawing API, the cross-browser vector graphics library of the framework."
slug: overview_kendoui_drawingapi
position: 1
---

# Drawing Overview

The [Kendo UI Drawing library (Drawing API)](https://demos.telerik.com/kendo-ui/drawing/index) is a cross-browser vector graphics library and provides a simple object model for building and manipulating visual scenes.

The Kendo UI Drawing library:
- Serves as a foundation of and as an extension point for the Kendo UI widgets which render data visualization such as Charts and Diagrams.
- Is also a standalone component that is suitable for building custom visualizations.
- Offers a [low-level API](/api/javascript/drawing)&mdash;a simple object model for building and manipulating visual scenes which can be rendered as SVG and PDF documents, Canvas elements, and PNG images.

To build a scene, you can create drawing elements such as curves, images, and text. Scene elements are live and respond to changes of their appearance and geometry. To render scenes on and off screen, use the drawing surface. Surfaces encapsulate specific browser technologies such as SVG or Canvas.

**Figure 1: Drawing library components**

![Drawing API Components](images/components.png)

## See Also

* [Drawing Basic Shapes]({% slug basicshapes_drawingapi %})
* [Drawing DOM Elements]({% slug drawingofhtmlelements_drawingapi %})
* [Exporting Drawings to PDF]({% slug pdfderawingexport_drawingapi %})
* [Exporting Drawings to Images]({% slug exportpng_kendoui_drawingapi %})
* [Exporting Drawings to SVG]({% slug exportingtosvg_drawing %})
* [PDF Output]({% slug pdfderawingexport_drawingapi %})
* [Limitations and Browser Support for Kendo UI Drawing API]({% slug supportedbrowsers_drawingapi %})
