---
title: Using Predefined Models
page_title: Using Predefined Models
description: Familiarize yourself with the predefined models available in the Telerik REPL tool.
slug: using_predefined_models_repl_aspnetcore
permalink: /getting-started/repl/predefined-models
position: 2
---

## Using Predefined Models

Telerik REPL uses the predefined models available in the Telerik UI for ASP.NET Core demos. You can find them in your Telerik UI for ASP.NET Core installation folder, which should be at a location similar to the following:

*C:\Program Files (x86)\Progress\Telerik UI for ASP.NET Core Rn YYYY\wrappers\aspnetcore\Examples\AspNet.Core\VSYYYY\Kendo.Mvc.Examples\Models*

Here is an extensive list containing the available models:

**Activity.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Scheduler
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;
    using Kendo.Mvc.UI;

    public class Activity : ISchedulerEvent
    {
        public int ID { get; set; }

        public string Title { get; set; }

        public string Image { get; set; }

        public DateTime Start { get; set; }

        public DateTime End { get; set; }

        public string Description { get; set; }

        public bool IsAllDay { get; set; }

        public string Recurrence { get; set; }

        public string RecurrenceRule { get; set; }

        public string RecurrenceException { get; set; }

        public string StartTimezone { get; set; }

        public string EndTimezone { get; set; }

        public int? Attendee { get; set; }
    }
}
```
**AntennaGainItem.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Chart
{
    public class AntennaGainItem
    {
        public double Azimuth { get; set; }
        public double Gain { get; set; }

        public AntennaGainItem(double azimuth, double gain)
        {
            Azimuth = azimuth;
            Gain = gain;
        }
    }
}
```
**AprilSales.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class AprilSales
    {
        public AprilSales()
        {
        }

        public AprilSales(int current, int target, string category)
        {
            Current = current;
            Target = target;
            Category = category;
        }

        public string Category { get; set; }
        public int Current { get; set; }
        public int Target { get; set; }
    }
}
```
**AspNetMvcDescription.cs**

```C#
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class AspNetMvcDescription : IFrameworkDescription
    {
        public string Name
        {
            get
            {
                return "ASP.NET MVC";
            }
        }

        public IEnumerable<ExampleFile> GetFiles(HttpServerUtilityBase server, string example, string section)
        {
            yield return new ExampleFile
            {
                Name = example + ".cshtml",
                Url = String.Format("~/Views/{0}/{1}.cshtml", section, example)
            };

            var path = server.MapPath("~/Controllers/");

            if (Directory.Exists(path))
            {
                var sections = Directory.GetDirectories(path);

                var directory = sections.FirstOrDefault(s =>
                {
                    var dir = Path.GetFileName(s.ToLower().Replace("_", "-"));

                    return dir.Equals(section) || dir.EndsWith(section + "s");
                });

                if (directory != null)
                {
                    var controllers = Directory.GetFiles(directory);

                    var controller = controllers.FirstOrDefault(c => Path.GetFileName(c).ToLower().Replace("_", "-") == example + "controller.cs");

                    if (controller != null)
                    {
                        yield return new ExampleFile
                        {
                            Name = Path.GetFileName(controller),
                            Url = "~/Controllers/" + Path.GetFileName(directory) + "/" + Path.GetFileName(controller)
                        };

                        var source = File.ReadAllText(controller);

                        if (source.Contains("productService"))
                        {
                            yield return new ExampleFile
                            {
                                Name = "ProductService.cs",
                                Url = "~/Models/ProductService.cs"
                            };
                        }

                        if (source.Contains("SchedulerTaskService"))
                        {
                            yield return new ExampleFile
                            {
                                Name = "SchedulerTaskService.cs",
                                Url = "~/Models/Scheduler/SchedulerTaskService.cs"
                            };
                        }

                        if (source.Contains("GanttTaskService"))
                        {
                            yield return new ExampleFile
                            {
                                Name = "GanttTaskService.cs",
                                Url = "~/Models/Gantt/GanttTaskService.cs"
                            };
                        }

                        if (source.Contains("meetingService"))
                        {
                            yield return new ExampleFile
                            {
                                Name = "SchedulerMeetingService.cs",
                                Url = "~/Models/Scheduler/SchedulerMeetingService.cs"
                            };
                        }

                        if (source.Contains("TreeListController"))
                        {
                            yield return new ExampleFile
                            {
                                Name = "EmployeeDirectoryController.cs",
                                Url = "~/Controllers/TreeList/EmployeeDirectoryController.cs"
                            };
                        }
                    }
                }
            }
        }
    }
}

```
**BarChartsLocalDataViewModel.cs**

```C#
using System;
using System.Linq;

namespace Kendo.Mvc.Examples.Models
{
    public class BarChartsLocalDataViewModel : BlogComments
    {
        public BarChartsLocalDataViewModel()
        {
        }

        public BarChartsLocalDataViewModel(BlogComments blogComments)
            : base(blogComments.Blog, blogComments.Day, blogComments.Value)
        {
        }

        public string UserColor { get; set; }
    }
}
```
**BaseUnit.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public enum BaseUnit
    {
        Years = 0,
        Months = 1,
        Weeks = 2,
        Days = 3,
        Hours = 4,
        Minutes = 5
    }
}
```
**BlogComments.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class BlogComments
    {

        public BlogComments()
        {
        }

        public BlogComments(string blog, int day, int value)
        {
            Blog = blog;
            Day = day;
            Value = value;
        }

        public string Blog { get; set; }
        public int Day { get; set; }
        public int Value  { get; set; }
    }
}
```
**BubbleChartsGroupedDataViewModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class BubbleChartsGroupedDataViewModel : Medals
    {
        public BubbleChartsGroupedDataViewModel()
        {
        }

        public BubbleChartsGroupedDataViewModel(Medals medals)
            : base(medals.Year, medals.Standing, medals.Number, medals.Country)
        {
        }

        public string Color { get; set; }
    }
}
```
**BudgetReportItem.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class BudgetReportItem
    {
        public string Unit { get; set; }
        public int Budget { get; set; }
        public int Spending { get; set; }

        public BudgetReportItem(string unit, int budget, int spending)
        {
            Unit = unit;
            Budget = budget;
            Spending = spending;
        }
    }
}
```
**BulletChartItem.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class BulletChartItem
    {
        public double Current { get; set; }
        public double Target { get; set; }
        public string Category { get; set; }
    }
}
```
**BulletChartLocalDataViewModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class BulletChartLocalDataViewModel
    {
        public BulletChartLocalDataViewModel()
        {
            mmHg = new List<BulletChartItem>();
            hPa = new List<BulletChartItem>();
        }

        public List<BulletChartItem> mmHg;
        public List<BulletChartItem> hPa;
    }
}
```
**CaptchaModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class CaptchaModel
    {
        private string _captchaValue;
        public string Captcha {
            get
            {
                return string.IsNullOrEmpty(_captchaValue) ? "" : _captchaValue;
            }
            set
            {
                _captchaValue = value;
            }
        }
        public string CaptchaID { get; set; }
    }
}
```
**CardViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models.TaskBoard
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;

    public class CardViewModel
    {
        public int ID { get; set; }
        public string Title { get; set; }
        public int Order { get; set; }
        public string Description { get; set; }
        public string Status { get; set; }
        public string Color { get; set; }
        public string Image { get; set; }
    }
}

```
**CashFlowData.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class CashFlowData
    {
        public string Period { get; set; }
        public decimal? Amount { get; set; }
        public string Summary { get; set; }
    }
}
```
**Category.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Category
    {
        public Category()
        {
            this.Products = new HashSet<Product>();
            this.DetailProducts = new HashSet<DetailProduct>();
        }

        public int CategoryID { get; set; }
        public string CategoryName { get; set; }
        public string Description { get; set; }
        public byte[] Picture { get; set; }

        public virtual ICollection<Product> Products { get; set; }
        public virtual ICollection<DetailProduct> DetailProducts { get; set; }
    }
}

```
**CategoryItem.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class CategoryItem
    {
        public string CategoryName { get; set; }
        public List<SubCategoryItem> SubCategories { get; set; }
    }
}
```
**CategoryViewModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class CategoryViewModel
    {
        public int CategoryID { get; set; }
        public string CategoryName { get; set; }
    }
}
```
**ChartCategoryPoint.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class ChartCategoryPoint
    {
        public int Value { get; set; }
        public string Category { get; set; }
    }
}
```
**ChartDataRepository.BoxPlot.cs**

```C#
using System.Collections.Generic;
using System;

namespace Kendo.Mvc.Examples.Models
{
    public partial class ChartDataRepository
    {
        public static IList<OzoneConcentration> OzoneConcentration()
        {
            return new OzoneConcentration[] {
                new OzoneConcentration { Year = 1990, Lower = 1.3, Q1 = 2.15, Median = 2.95, Q3 = 3.725, Upper = 4.7, Mean = 2.9, Outliers = new List<double>() {1, 9}},
                new OzoneConcentration { Year = 1991, Lower = 2, Q1 = 3.825, Median = 5.45, Q3 = 6.425, Upper = 8.2, Mean = 5.2, Outliers = new List<double>() {1.5, 2, 8.9}},
                new OzoneConcentration { Year = 1992, Lower = 3.8, Q1 = 4.725, Median = 5.55, Q3 = 5.75, Upper = 8.7, Mean = 5.5 },
                new OzoneConcentration { Year = 1993, Lower = 3, Q1 = 4.375, Median = 4.95, Q3 = 5.85, Upper = 8, Mean = 5.2, Outliers = new List<double>() {3, 9.5}},
                new OzoneConcentration { Year = 1994, Lower = 2.5, Q1 = 3.925, Median = 4.15, Q3 = 4.45, Upper = 5.1, Mean = 4.1 },
                new OzoneConcentration { Year = 1995, Lower = 2.4, Q1 = 3.725, Median = 4.95, Q3 = 5.85, Upper = 7.7, Mean = 4.9, Outliers = new List<double>() {2.1, 8.3, 9.8}},
                new OzoneConcentration { Year = 1996, Lower = 1.7, Q1 = 2.3, Median = 3.9, Q3 = 5, Upper = 5.5, Mean = 3.7, Outliers = new List<double>() {1.1, 9.1}},
                new OzoneConcentration { Year = 1997, Lower = 2.2, Q1 = 2.5, Median = 3.1, Q3 = 3.975, Upper = 4.3, Mean = 3.2, Outliers = new List<double>() {1.6, 1.8, 9.8}},
                new OzoneConcentration { Year = 1998, Lower = 1.9, Q1 = 2.7, Median = 3.35, Q3 = 4.575, Upper = 5.7, Mean = 3.6, Outliers = new List<double>() {1.1, 8.3}},
                new OzoneConcentration { Year = 1999, Lower = 1.7, Q1 = 2.65, Median = 3.3, Q3 = 4.05, Upper = 5, Mean = 3.4 },
                new OzoneConcentration { Year = 2000, Lower = 1.4, Q1 = 2.25, Median = 3.3, Q3 = 4.65, Upper = 5.7, Mean = 3.4 },
                new OzoneConcentration { Year = 2001, Lower = 1.9, Q1 = 2.85, Median = 4, Q3 = 4.45, Upper = 6.1, Mean = 3.9, Outliers = new List<double>() {1, 1.2}},
                new OzoneConcentration { Year = 2002, Lower = 1.5, Q1 = 2.35, Median = 4.1, Q3 = 5.225, Upper = 5.7, Mean = 3.9, Outliers = new List<double>() {9, 9.5}},
                new OzoneConcentration { Year = 2003, Lower = 1.8, Q1 = 2.325, Median = 3.35, Q3 = 4, Upper = 5.4, Mean = 3.3, Outliers = new List<double>() {1, 6}},
                new OzoneConcentration { Year = 2004, Lower = 1.8, Q1 = 2.75, Median = 3.35, Q3 = 3.825, Upper = 4.9, Mean = 3.4 },
                new OzoneConcentration { Year = 2005, Lower = 1.7, Q1 = 2.275, Median = 3.2, Q3 = 3.825, Upper = 5.5, Mean = 3.2, Outliers = new List<double>() {0.5, 6.7}},
                new OzoneConcentration { Year = 2006, Lower = 1.2, Q1 = 1.95, Median = 2.45, Q3 = 3.075, Upper = 3.5, Mean = 2.5 },
                new OzoneConcentration { Year = 2007, Lower = 1.3, Q1 = 1.9, Median = 3.05, Q3 = 3.425, Upper = 4, Mean = 2.7, Outliers = new List<double>() {7, 8.5}}
            };
        }

        public static IList<OzoneConcentration> OzoneConcentrationRemote()
        {
            return new OzoneConcentration[] {
                new OzoneConcentration { Year = 1996, Lower = 1.3, Q1 = 2.15, Median = 2.95, Q3 = 3.725, Upper = 4.7, Mean = 2.9, Outliers = new List<double>() {1, 9}},
                new OzoneConcentration { Year = 1997, Lower = 2, Q1 = 3.825, Median = 5.45, Q3 = 6.425, Upper = 8.2, Mean = 5.2, Outliers = new List<double>() {1.5, 2, 8.9}},
                new OzoneConcentration { Year = 1998, Lower = 3.8, Q1 = 4.725, Median = 5.55, Q3 = 5.75, Upper = 8.7, Mean = 5.5 },
                new OzoneConcentration { Year = 1999, Lower = 3, Q1 = 4.375, Median = 4.95, Q3 = 5.85, Upper = 8, Mean = 5.2, Outliers = new List<double>() {3, 9.5}},
                new OzoneConcentration { Year = 2000, Lower = 2.5, Q1 = 3.925, Median = 4.15, Q3 = 4.45, Upper = 5.1, Mean = 4.1 },
                new OzoneConcentration { Year = 2001, Lower = 2.4, Q1 = 3.725, Median = 4.95, Q3 = 5.85, Upper = 7.7, Mean = 4.9, Outliers = new List<double>() {2.1, 8.3, 9.8}},
                new OzoneConcentration { Year = 2002, Lower = 1.7, Q1 = 2.3, Median = 3.9, Q3 = 5, Upper = 5.5, Mean = 3.7, Outliers = new List<double>() {1.1, 9.1}},
                new OzoneConcentration { Year = 2003, Lower = 2.2, Q1 = 2.5, Median = 3.1, Q3 = 3.975, Upper = 4.3, Mean = 3.2, Outliers = new List<double>() {1.6, 1.8, 9.8}},
                new OzoneConcentration { Year = 2004, Lower = 1.9, Q1 = 2.7, Median = 3.35, Q3 = 4.575, Upper = 5.7, Mean = 3.6, Outliers = new List<double>() {1.1, 8.3}},
                new OzoneConcentration { Year = 2005, Lower = 1.7, Q1 = 2.65, Median = 3.3, Q3 = 4.05, Upper = 5, Mean = 3.4 },
                new OzoneConcentration { Year = 2006, Lower = 1.4, Q1 = 2.25, Median = 3.3, Q3 = 4.65, Upper = 5.7, Mean = 3.4 },
                new OzoneConcentration { Year = 2007, Lower = 1.9, Q1 = 2.85, Median = 4, Q3 = 4.45, Upper = 6.1, Mean = 3.9, Outliers = new List<double>() {1, 1.2}},
                new OzoneConcentration { Year = 2008, Lower = 1.5, Q1 = 2.35, Median = 4.1, Q3 = 5.225, Upper = 5.7, Mean = 3.9, Outliers = new List<double>() {9, 9.5}},
                new OzoneConcentration { Year = 2009, Lower = 1.8, Q1 = 2.325, Median = 3.35, Q3 = 4, Upper = 5.4, Mean = 3.3, Outliers = new List<double>() {1, 6}},
                new OzoneConcentration { Year = 2010, Lower = 1.8, Q1 = 2.75, Median = 3.35, Q3 = 3.825, Upper = 4.9, Mean = 3.4 },
                new OzoneConcentration { Year = 2011, Lower = 1.7, Q1 = 2.275, Median = 3.2, Q3 = 3.825, Upper = 5.5, Mean = 3.2, Outliers = new List<double>() {0.5, 6.7}},
                new OzoneConcentration { Year = 2012, Lower = 1.2, Q1 = 1.95, Median = 2.45, Q3 = 3.075, Upper = 3.5, Mean = 2.5 },
                new OzoneConcentration { Year = 2013, Lower = 1.3, Q1 = 1.9, Median = 3.05, Q3 = 3.425, Upper = 4, Mean = 2.7, Outliers = new List<double>() {7, 8.5}}
            };
        }
    }
}

```
**ChartDataRepository.cs**

```C#
using System.Collections.Generic;
using System;
using Kendo.Mvc.Examples.Models.Chart;

namespace Kendo.Mvc.Examples.Models
{
    public partial class ChartDataRepository
    {
        public static IList<AprilSales> AprilSalesData()
        {
            return new AprilSales[]
            {
                new AprilSales(2373, 5000, "1"),
                new AprilSales(3283, 5250, "2"),
                new AprilSales(4532, 5500, "3"),
                new AprilSales(4620, 5750, "4"),
                new AprilSales(6504, 6000, "5"),
                new AprilSales(6715, 6250, "6"),
                new AprilSales(6234, 6500, "7"),
                new AprilSales(6750, 6750, "8"),
                new AprilSales(6300, 7000, "9"),
                new AprilSales(6459, 7250, "10"),
                new AprilSales(8305, 7500, "11"),
                new AprilSales(7222, 7750, "12"),
                new AprilSales(6734, 8000, "13"),
                new AprilSales(7863, 8250, "14"),
                new AprilSales(8743, 8500, "15"),
                new AprilSales(8846, 8750, "16"),
                new AprilSales(8567, 9000, "17"),
                new AprilSales(8193, 9250, "18"),
                new AprilSales(9458, 9500, "19"),
                new AprilSales(9254, 9750, "20"),
                new AprilSales(10234, 10000, "21"),
                new AprilSales(9608, 10250, "22"),
                new AprilSales(9350, 10500, "23"),
                new AprilSales(8842, 10500, "24"),
                new AprilSales(8349, 10500, "25"),
                new AprilSales(8846, 10500, "26"),
                new AprilSales(9567, 10500, "27"),
                new AprilSales(10734, 10500, "28"),
                new AprilSales(10124, 10500, "29"),
                new AprilSales(9680, 10500, "30"),
            };
        }

        public static IList<PricePerformance> PricePerformanceData()
        {
            return new List<PricePerformance>
            {
                new PricePerformance {
                    Family = "Pentium",
                    Model = "D 820",
                    Price = 105,
                    Performance = 100
                },

                new PricePerformance {
                    Family = "Pentium",
                    Model = "D 915",
                    Price = 120,
                    Performance = 102
                },

                new PricePerformance {
                    Family = "Pentium",
                    Model = "D 945",
                    Price = 160,
                    Performance = 118
                },

                new PricePerformance {
                    Family = "Pentium",
                    Model = "XE 965",
                    Price = 1000,
                    Performance = 137
                },

                new PricePerformance {
                    Family = "Core 2 Duo",
                    Model = "E6300",
                    Price = 185,
                    Performance = 134
                },

                new PricePerformance {
                    Family = "Core 2 Duo",
                    Model = "E6400",
                    Price = 210,
                    Performance = 143
                },

                new PricePerformance {
                    Family = "Core 2 Duo",
                    Model = "E6600",
                    Price = 305,
                    Performance = 163
                },

                new PricePerformance {
                    Family = "Core 2 Duo",
                    Model = "E6700",
                    Price = 530,
                    Performance = 177
                },

                new PricePerformance {
                    Family = "Core 2 Extreme",
                    Model = "X6800",
                    Price = 1000,
                    Performance = 190
                },

                new PricePerformance {
                    Family = "Athlon 64",
                    Model = "X2 3800+",
                    Price = 148,
                    Performance = 115
                },

                new PricePerformance {
                    Family = "Athlon 64",
                    Model = "X2 4200+",
                    Price = 170,
                    Performance = 125
                },

                new PricePerformance {
                    Family = "Athlon 64",
                    Model = "X2 4600+",
                    Price = 205,
                    Performance = 138
                },

                new PricePerformance {
                    Family = "Athlon 64",
                    Model = "X2 5000+",
                    Price = 290,
                    Performance = 143
                },

                new PricePerformance {
                    Family = "Athlon 64",
                    Model = "FX-62",
                    Price = 800,
                    Performance = 147
                }
            };
        }

        public static IList<SiteOptimizationItem> BeforeOptimizationData()
        {
            return new List<SiteOptimizationItem>
            {
                new SiteOptimizationItem{
                    Description= "All Visitors",
                    Visitors= 23945
                },
                new SiteOptimizationItem{
                    Description= "Tried the Demos",
                    Visitors= 19156
                },
                new SiteOptimizationItem{
                    Description= "Downloaded",
                    Visitors= 13984
                },
                new SiteOptimizationItem{
                    Description= "Requested a Quote",
                    Visitors= 3216
                },
                new SiteOptimizationItem{
                    Description= "Purchased",
                    Visitors= 1673
                }
            };
        }

        public static IList<SiteOptimizationItem> AfterOptimizationData()
        {
            return new List<SiteOptimizationItem>
            {
                new SiteOptimizationItem{
                    Description= "All Visitors",
                    Visitors= 28536
                },
                new SiteOptimizationItem{
                    Description= "Tried the Demos",
                    Visitors= 26539
                },
                new SiteOptimizationItem{
                    Description= "Downloaded",
                    Visitors= 23088
                },
                new SiteOptimizationItem{
                    Description= "Requested a Quote",
                    Visitors= 13853
                },
                new SiteOptimizationItem{
                    Description= "Purchased",
                    Visitors= 9697
                }
            };
        }

        public static IList<EngineDataPoint> EngineData()
        {
            return new EngineDataPoint[]
            {
                new EngineDataPoint(1000, 50,  10),
                new EngineDataPoint(1500, 65,  19),
                new EngineDataPoint(2000, 80,  30),
                new EngineDataPoint(2500, 92,  44),
                new EngineDataPoint(3000, 104, 59),
                new EngineDataPoint(3500, 114, 76),
                new EngineDataPoint(4000, 120, 91),
                new EngineDataPoint(4500, 125, 107),
                new EngineDataPoint(5000, 130, 124),
                new EngineDataPoint(5500, 133, 139),
                new EngineDataPoint(6000, 130, 149),
                new EngineDataPoint(6500, 122, 151),
                new EngineDataPoint(7000, 110, 147)
            };
        }

        public static IList<InternetUsers> InternetUsers()
        {
            return new InternetUsers[] {
                new InternetUsers(1994,4.9,"United States"),
                new InternetUsers(1995,9.2,"United States"),
                new InternetUsers(1996,16.4,"United States"),
                new InternetUsers(1997,21.6,"United States"),
                new InternetUsers(1998,30.1,"United States"),
                new InternetUsers(1999,35.9,"United States"),
                new InternetUsers(2000,43.1,"United States"),
                new InternetUsers(2001,49.2,"United States"),
                new InternetUsers(2002,59.0,"United States"),
                new InternetUsers(2003,61.9,"United States"),
                new InternetUsers(2004,65,"United States"),
                new InternetUsers(2005,68.3,"United States"),
                new InternetUsers(2006,69.2,"United States"),
                new InternetUsers(2007,75.3,"United States"),
                new InternetUsers(2008,74.2,"United States"),
                new InternetUsers(2009,71.2,"United States"),
                new InternetUsers(2010,74.2,"United States"),
                new InternetUsers(2011,78.2,"United States")
            };
        }

        public static IList<GrandSlam> GrandSlam()
        {
            return new GrandSlam[] {
                new GrandSlam(2003, 13, 3, "MIN: 13"),
                new GrandSlam(2004, 22, 1),
                new GrandSlam(2005, 24, 2),
                new GrandSlam(2006, 27, 1, "MAX: 27"),
                new GrandSlam(2007, 26, 1),
                new GrandSlam(2008, 24, 3),
                new GrandSlam(2009, 26, 2),
                new GrandSlam(2010, 20, 3),
                new GrandSlam(2011, 20, 4),
                new GrandSlam(2012, 19, 3),
            };
        }

        public static IEnumerable<ElectricityProduction> SpainElectricityProduction()
        {
            return new ElectricityProduction[] {
                new ElectricityProduction("2000", 18, 31807, 4727, 62206),
                new ElectricityProduction("2001", 24, 43864, 6759, 63708),
                new ElectricityProduction("2002", 30, 26270, 9342, 63016),
                new ElectricityProduction("2003", 41, 43897, 12075, 61875),
                new ElectricityProduction("2004", 56, 34439, 15700, 63606),
                new ElectricityProduction("2005", 41, 23025, 21176, 57539),
                new ElectricityProduction("2006", 119, 29831, 23297, 60126),
                new ElectricityProduction("2007", 508, 30522, 27568, 55103),
                new ElectricityProduction("2008", 2578, 26112, 32203, 58973)
            };
        }

        public static IList<ScreenResolution> WorldScreenResolution()
        {
            return new ScreenResolution[] {
                new ScreenResolution() {Year = "2000",Resolution = "1024x768",Share = 25,VisibleInLegend = false,OrderNumber = 1},
                new ScreenResolution() {Year = "2000",Resolution = "Other",Share = 75,VisibleInLegend = false,OrderNumber = 2},
                new ScreenResolution() {Year = "2001",Resolution = "1024x768",Share = 29,VisibleInLegend = false,OrderNumber = 1},
                new ScreenResolution() {Year = "2001",Resolution = "Other",Share = 71,VisibleInLegend = false,OrderNumber = 2},
                new ScreenResolution() {Year = "2002",Resolution = "1024x768",Share = 34,VisibleInLegend = false,OrderNumber = 1},
                new ScreenResolution() {Year = "2002",Resolution = "Other",Share = 66,VisibleInLegend = false,OrderNumber = 2},
                new ScreenResolution() {Year = "2003",Resolution = "1024x768",Share = 40,VisibleInLegend = false,OrderNumber = 1},
                new ScreenResolution() {Year = "2003",Resolution = "Other",Share = 60,VisibleInLegend = false,OrderNumber = 2},
                new ScreenResolution() {Year = "2004",Resolution = "1024x768",Share = 47,VisibleInLegend = false,OrderNumber = 1},
                new ScreenResolution() {Year = "2004",Resolution = "Other",Share = 53,VisibleInLegend = false,OrderNumber = 2},
                new ScreenResolution() {Year = "2005",Resolution = "1024x768",Share = 53,VisibleInLegend = false,OrderNumber = 1},
                new ScreenResolution() {Year = "2005",Resolution = "Other",Share = 47,VisibleInLegend = false,OrderNumber = 2},
                new ScreenResolution() {Year = "2006",Resolution = "1024x768",Share = 57,VisibleInLegend = false,OrderNumber = 1},
                new ScreenResolution() {Year = "2006",Resolution = "Other",Share = 43,VisibleInLegend = false,OrderNumber = 2},
                new ScreenResolution() {Year = "2007",Resolution = "1024x768",Share = 54,VisibleInLegend = false,OrderNumber = 1},
                new ScreenResolution() {Year = "2007",Resolution = "Other",Share = 46,VisibleInLegend = false,OrderNumber = 2},
                new ScreenResolution() {Year = "2008",Resolution = "1024x768",Share = 48,VisibleInLegend = false,OrderNumber = 1},
                new ScreenResolution() {Year = "2008",Resolution = "Other",Share = 52,VisibleInLegend = false,OrderNumber = 2},
                new ScreenResolution() {Year = "2009",Resolution = "1024x768",Share = 36,VisibleInLegend = false,OrderNumber = 1},
                new ScreenResolution() {Year = "2009",Resolution = "Other",Share = 64,VisibleInLegend = false,OrderNumber = 2}
            };
        }

        public static IEnumerable<ElectricitySource> SpainElectricityBreakdown()
        {
            return new ElectricitySource[] {
                new ElectricitySource("Hydro", 22) { Explode = true },
                new ElectricitySource("Solar", 2),
                new ElectricitySource("Nuclear", 49),
                new ElectricitySource("Wind", 27)
            };
        }

        public static IList<Medals> Medals()
        {
            return new Medals[] {
                new Medals(1984,1,10,"Japan"),
                new Medals(1988,1,4,"Japan"),
                new Medals(1992,1,3,"Japan"),
                new Medals(1996,1,3,"Japan"),
                new Medals(2000,1,5,"Japan"),
                new Medals(2004,1,16,"Japan"),
                new Medals(2008,1,9,"Japan"),
                new Medals(2012,1,7,"Japan"),
                new Medals(1984,2,8,"Japan"),
                new Medals(1988,2,3,"Japan"),
                new Medals(1992,2,8,"Japan"),
                new Medals(1996,2,6,"Japan"),
                new Medals(2000,2,8,"Japan"),
                new Medals(2004,2,9,"Japan"),
                new Medals(2008,2,6,"Japan"),
                new Medals(2012,2,14,"Japan"),
                new Medals(1984,3,14,"Japan"),
                new Medals(1988,3,7,"Japan"),
                new Medals(1992,3,11,"Japan"),
                new Medals(1996,3,5,"Japan"),
                new Medals(2000,3,5,"Japan"),
                new Medals(2004,3,12,"Japan"),
                new Medals(2008,3,10,"Japan"),
                new Medals(2012,3,17,"Japan")
            };
        }

        public static IList<BlogComments> BlogComments()
        {
            return new BlogComments[] {
                 new BlogComments("My blog", 1, 3),
                 new BlogComments("My blog", 2, 7),
                 new BlogComments("My blog", 3, 12),
                 new BlogComments("My blog", 4, 15),
                 new BlogComments("My blog", 5, 6),
                 new BlogComments("My blog", 6, 23),
                 new BlogComments("My blog", 7, 12),
                 new BlogComments("My blog", 8, 10),
                 new BlogComments("My blog", 9, 17),
                 new BlogComments("My blog", 10, 13),
                 new BlogComments("My blog", 11, 14),
                 new BlogComments("My blog", 12, 15),
                 new BlogComments("My blog", 13, 3),
                 new BlogComments("My blog", 14, 6),
                 new BlogComments("My blog", 15, 23),
                 new BlogComments("My blog", 16, 25),
                 new BlogComments("My blog", 17, 21),
                 new BlogComments("My blog", 18, 18),
                 new BlogComments("My blog", 19, 17),
                 new BlogComments("My blog", 20, 16),
                 new BlogComments("My blog", 21, 11),
                 new BlogComments("My blog", 22, 3),
                 new BlogComments("My blog", 23, 8),
                 new BlogComments("My blog", 24, 5),
                 new BlogComments("My blog", 25, 4),
                 new BlogComments("My blog", 26, 1),
                 new BlogComments("My blog", 27, 7),
                 new BlogComments("My blog", 28, 6),
                 new BlogComments("My blog", 29, 3),
                 new BlogComments("My blog", 30, 6)
            };
        }

        public static IList<JobGrowth> JobGrowthData()
        {
            return new JobGrowth[] {
                new JobGrowth {
                    Growth = -2500,
                    Jobs = 50000,
                    Applications = 500000,
                    Company = "Microsoft"
                }, new JobGrowth {
                    Growth = 500,
                    Jobs = 110000,
                    Applications = 7600000,
                    Company = "Starbucks"
                }, new JobGrowth {
                    Growth = 7000,
                    Jobs = 19000,
                    Applications = 700000,
                    Company = "Google"
                }, new JobGrowth {
                    Growth = 1400,
                    Jobs = 150000,
                    Applications = 700000,
                    Company = "Publix Super Markets"
                }, new JobGrowth {
                    Growth = 2400,
                    Jobs = 30000,
                    Applications = 300000,
                    Company = "PricewaterhouseCoopers"
                }, new JobGrowth {
                    Growth = 2450,
                    Jobs = 34000,
                    Applications = 90000,
                    Company = "Cisco"
                }, new JobGrowth {
                    Growth = 2700,
                    Jobs = 34000,
                    Applications = 400000,
                    Company = "Accenture"
                }, new JobGrowth {
                    Growth = 2900,
                    Jobs = 40000,
                    Applications = 450000,
                    Company = "Deloitte"
                }, new JobGrowth {
                    Growth = 3000,
                    Jobs = 55000,
                    Applications = 900000,
                    Company = "Whole Foods Market"
                }
            };
        }

        public static IList<JobGrowth> JobGrowthDataComparative()
        {
            return new JobGrowth[] {
                new JobGrowth {
                    Growth = -2500,
                    Jobs = 50000,
                    Applications = 500000,
                    Company = "Microsoft",
                    Year = 2011
                }, new JobGrowth {
                    Growth = 500,
                    Jobs = 110000,
                    Applications = 7600000,
                    Company = "Starbucks",
                    Year = 2011
                }, new JobGrowth {
                    Growth = 7000,
                    Jobs = 19000,
                    Applications = 700000,
                    Company = "Google",
                    Year = 2011
                },
                new JobGrowth {
                    Growth = -2000,
                    Jobs = 60000,
                    Applications = 900000,
                    Company = "Microsoft",
                    Year = 2012
                }, new JobGrowth {
                    Growth = 4000,
                    Jobs = 130000,
                    Applications = 8600000,
                    Company = "Starbucks",
                    Year = 2012
                }, new JobGrowth {
                    Growth = 9000,
                    Jobs = 29000,
                    Applications = 2200000,
                    Company = "Google",
                    Year = 2012
                }
            };
        }

        public static IList<MarriagesDivorcesData> MarriagesDivorcesStats()
        {
            return new MarriagesDivorcesData[] {
                new MarriagesDivorcesData {
                    State = "Alabama",
                    Marriages = 7,
                    Divorces = 3.7,
                    Population = 4627851
                },
                new MarriagesDivorcesData {
                    State = "Alaska",
                    Marriages = 6.9,
                    Divorces = 3.6,
                    Population = 686293
                },
                new MarriagesDivorcesData {
                    State = "Arizona",
                    Marriages = 5.8,
                    Divorces = 2.5,
                    Population = 6500180
                },
                new MarriagesDivorcesData {
                    State = "Arkansas",
                    Marriages = 10.2,
                    Divorces = 5.7,
                    Population = 2855390
                },
                new MarriagesDivorcesData {
                    State = "California",
                    Marriages = 8.1,
                    Divorces = 4.1,
                    Population = 36756666
                },
                new MarriagesDivorcesData {
                    State = "Colorado",
                    Marriages = 12.1,
                    Divorces = 3.2,
                    Population = 4861515
                },
                new MarriagesDivorcesData {
                    State = "Connecticut",
                    Marriages = 7,
                    Divorces = 3.2,
                    Population = 3501252
                },
                new MarriagesDivorcesData {
                    State = "Delaware",
                    Marriages = 5.5,
                    Divorces = 1.9,
                    Population = 873092
                },
                new MarriagesDivorcesData {
                    State = "Florida",
                    Marriages = 7.8,
                    Divorces = 3.6,
                    Population = 18328340
                },
                new MarriagesDivorcesData {
                    State = "Georgia",
                    Marriages = 15.1,
                    Divorces = 5.2,
                    Population = 9685744
                },
                new MarriagesDivorcesData {
                    State = "Hawaii",
                    Marriages = 12.6,
                    Divorces = 6,
                    Population = 1288198
                },
                new MarriagesDivorcesData {
                    State = "Idaho",
                    Marriages = 15.7,
                    Divorces = 7.1,
                    Population = 1523816
                },
                new MarriagesDivorcesData {
                    State = "Illinois",
                    Marriages = 6.4,
                    Divorces = 1.9,
                    Population = 12901563
                },
                new MarriagesDivorcesData {
                    State = "Indiana",
                    Marriages = 6.9,
                    Divorces = 4.9,
                    Population = 6376792
                },
                new MarriagesDivorcesData {
                    State = "Iowa",
                    Marriages = 8.2,
                    Divorces = 2,
                    Population = 3002555
                },
                new MarriagesDivorcesData {
                    State = "Kansas",
                    Marriages = 8.1,
                    Divorces = 1.3,
                    Population = 2802134
                },
                new MarriagesDivorcesData {
                    State = "Kentucky",
                    Marriages = 9.2,
                    Divorces = 7.1,
                    Population = 4269245
                },
                new MarriagesDivorcesData {
                    State = "Louisiana",
                    Marriages = 7.1,
                    Divorces = 1.8,
                    Population = 4410796
                },
                new MarriagesDivorcesData {
                    State = "Maine",
                    Marriages = 9.6,
                    Divorces = 4.2,
                    Population = 1316456
                },
                new MarriagesDivorcesData {
                    State = "Maryland",
                    Marriages = 6.3,
                    Divorces = 3.5,
                    Population = 5633597
                },
                new MarriagesDivorcesData {
                    State = "Massachusetts",
                    Marriages = 13.1,
                    Divorces = 8,
                    Population = 6497967
                },
                new MarriagesDivorcesData {
                    State = "Michigan",
                    Marriages = 8.1,
                    Divorces = 2.9,
                    Population = 10003422
                },
                new MarriagesDivorcesData {
                    State = "Minnesota",
                    Marriages = 9.5,
                    Divorces = 4.5,
                    Population = 5220393
                },
                new MarriagesDivorcesData {
                    State = "Mississippi",
                    Marriages = 6.7,
                    Divorces = 2.9,
                    Population = 2938618
                },
                new MarriagesDivorcesData {
                    State = "Missouri",
                    Marriages = 16.6,
                    Divorces = 3.1,
                    Population = 5911605
                },
                new MarriagesDivorcesData {
                    State = "Montana",
                    Marriages = 15,
                    Divorces = 9.1,
                    Population = 967440
                },
                new MarriagesDivorcesData {
                    State = "Nebraska",
                    Marriages = 13.3,
                    Divorces = 1.2,
                    Population = 1783432
                },
                new MarriagesDivorcesData {
                    State = "Nevada",
                    Marriages = 21.2,
                    Divorces = 8.5,
                    Population = 2600167
                },
                new MarriagesDivorcesData {
                    State = "New Hampshire",
                    Marriages = 11.8,
                    Divorces = 7.1,
                    Population = 1315809
                },
                new MarriagesDivorcesData {
                    State = "New Jersey",
                    Marriages = 15.1,
                    Divorces = 7.4,
                    Population = 8682661
                },
                new MarriagesDivorcesData {
                    State = "New Mexico",
                    Marriages = 3.1,
                    Divorces = 4.8,
                    Population = 1984356
                },
                new MarriagesDivorcesData {
                    State = "New York",
                    Marriages = 17.3,
                    Divorces = 9.1,
                    Population = 19490297
                },
                new MarriagesDivorcesData {
                    State = "North Carolina",
                    Marriages = 13.1,
                    Divorces = 1.6,
                    Population = 9222414
                },
                new MarriagesDivorcesData {
                    State = "North Dakota",
                    Marriages = 5.8,
                    Divorces = 2.5,
                    Population = 641481
                },
                new MarriagesDivorcesData {
                    State = "Ohio",
                    Marriages = 18.9,
                    Divorces = 7.9,
                    Population = 11485910
                },
                new MarriagesDivorcesData {
                    State = "Oklahoma",
                    Marriages = 9.1,
                    Divorces = 4.1,
                    Population = 3642361
                },
                new MarriagesDivorcesData {
                    State = "Oregon",
                    Marriages = 7,
                    Divorces = 3.4,
                    Population = 3790060
                },
                new MarriagesDivorcesData {
                    State = "Pennsylvania",
                    Marriages = 9.1,
                    Divorces = 2.6,
                    Population = 12448279
                },
                new MarriagesDivorcesData {
                    State = "Rhode Island",
                    Marriages = 6.8,
                    Divorces = 2.9,
                    Population = 1050788
                },
                new MarriagesDivorcesData {
                    State = "South Carolina",
                    Marriages = 16,
                    Divorces = 2.6,
                    Population = 4479800
                },
                new MarriagesDivorcesData {
                    State = "South Dakota",
                    Marriages = 6.7,
                    Divorces = 2.7,
                    Population = 804194
                },
                new MarriagesDivorcesData {
                    State = "Tennessee",
                    Marriages = 18.1,
                    Divorces = 1.6,
                    Population = 6214888
                },
                new MarriagesDivorcesData {
                    State = "Texas",
                    Marriages = 7.1,
                    Divorces = 0.8,
                    Population = 24326974
                },
                new MarriagesDivorcesData {
                    State = "Utah",
                    Marriages = 19.4,
                    Divorces = 3.4,
                    Population = 2736424
                },
                new MarriagesDivorcesData {
                    State = "Vermont",
                    Marriages = 14.1,
                    Divorces = 3.4,
                    Population = 621270
                },
                new MarriagesDivorcesData {
                    State = "Virginia",
                    Marriages = 10,
                    Divorces = 3.1,
                    Population = 7769089
                },
                new MarriagesDivorcesData {
                    State = "Washington",
                    Marriages = 7.5,
                    Divorces = 3.4,
                    Population = 6549224
                },
                new MarriagesDivorcesData {
                    State = "West Virginia",
                    Marriages = 8.3,
                    Divorces = 2.8,
                    Population = 1814468
                },
                new MarriagesDivorcesData {
                    State = "Wisconsin",
                    Marriages = 7.9,
                    Divorces = 2.4,
                    Population = 5627967
                },
                new MarriagesDivorcesData {
                    State = "Wyoming",
                    Marriages = 9.5,
                    Divorces = 4,
                    Population = 532668
                }
            };
        }

        public static IList<DatePoint> DatePoints()
        {
            return new DatePoint[]
            {
                new DatePoint(30, DateTime.Parse("2011/12/20")),
                new DatePoint(50, DateTime.Parse("2011/12/21")),
                new DatePoint(45, DateTime.Parse("2011/12/22")),
                new DatePoint(40, DateTime.Parse("2011/12/23")),
                new DatePoint(35, DateTime.Parse("2011/12/24")),
                new DatePoint(40, DateTime.Parse("2011/12/25")),
                new DatePoint(42, DateTime.Parse("2011/12/26")),
                new DatePoint(40, DateTime.Parse("2011/12/27")),
                new DatePoint(35, DateTime.Parse("2011/12/28")),
                new DatePoint(43, DateTime.Parse("2011/12/29")),
                new DatePoint(38, DateTime.Parse("2011/12/30")),
                new DatePoint(30, DateTime.Parse("2011/12/31")),
                new DatePoint(48, DateTime.Parse("2012/01/01")),
                new DatePoint(50, DateTime.Parse("2012/01/02")),
                new DatePoint(55, DateTime.Parse("2012/01/03")),
                new DatePoint(35, DateTime.Parse("2012/01/04")),
                new DatePoint(30, DateTime.Parse("2012/01/05"))
            };
        }

        public static IList<DownloadSpeed> DownloadSpeeds()
        {
            return new DownloadSpeed[]
            {
                new DownloadSpeed(30, 35, 80, 90, "Monday"),
                new DownloadSpeed(60, 70, 60, 70, "Tuesday"),
                new DownloadSpeed(50, 60, 70, 100, "Wednesday"),
                new DownloadSpeed(30, 50, 100, 140, "Thursday"),
                new DownloadSpeed(40, 50, 90, 110, "Friday"),
                new DownloadSpeed(50, 60, 80, 100, "Saturday"),
                new DownloadSpeed(30, 40, 50, 70, "Sunday")
            };
        }

        public static IList<Forecast> ForecastData()
        {
            return new List<Forecast>()
            {
                new Forecast
                {
                    Temperature = 15,
                    Weather = "cloudy",
                    Day = "Monday"
                },
                new Forecast
                {
                    Temperature = 16,
                    Weather = "rainy",
                    Day = "Tuesday"
                },
                new Forecast
                {
                    Temperature = 20,
                    Weather = "cloudy",
                    Day = "Wednesday"
                },
                new Forecast
                {
                    Temperature = 23,
                    Weather = "sunny",
                    Day = "Thursday"
                },
                new Forecast
                {
                    Temperature = 17,
                    Weather = "cloudy",
                    Day = "Friday"
                },
                new Forecast
                {
                    Temperature = 20,
                    Weather = "sunny",
                    Day = "Saturday"
                },
                new Forecast
                {
                    Temperature = 25,
                    Weather = "sunny",
                    Day = "Sunday"
                }

            };
        }

        public static IList<ChartCategoryPoint> PanAndZoomData()
        {
            IList<ChartCategoryPoint> data = new List<ChartCategoryPoint>();
            Random random = new Random(0);
            for (var i = 0; i < 100; i++)
            {
                var value = random.Next(0, 11);
                data.Add( new ChartCategoryPoint
                {
                    Category = "C" + i,
                    Value = value
                });
            }

            return data;
        }

        public static IList<ChartScatterPoint> SineInterval(double min, double max)
        {
            IList<ChartScatterPoint> data = new List<ChartScatterPoint>();
            var step = Math.PI / 4;
            for (var i = min; i < max; i += step)
            {
                data.Add(new ChartScatterPoint
                {
                    X = i,
                    Y = Math.Sin(i)
                });
            }

            return data;
        }
    }
}
```
**ChartDataRepository.Polar.cs**

```C#
using System.Collections.Generic;
using System;
using Kendo.Mvc.Examples.Models.Chart;

namespace Kendo.Mvc.Examples.Models
{
    public partial class ChartDataRepository
    {
        public static IList<AntennaGainItem> AntennaGain()
        {
            return new AntennaGainItem[] {
                new AntennaGainItem(0, 0),
                new AntennaGainItem(10, 0),
                new AntennaGainItem(20, 0),
                new AntennaGainItem(30, -1),
                new AntennaGainItem(40, -2),
                new AntennaGainItem(50, -3),
                new AntennaGainItem(60, -5),
                new AntennaGainItem(70, -7),
                new AntennaGainItem(80, -10),
                new AntennaGainItem(90, -13),
                new AntennaGainItem(100, -16),
                new AntennaGainItem(110, -20),
                new AntennaGainItem(120, -19),
                new AntennaGainItem(130, -18),
                new AntennaGainItem(140, -17),
                new AntennaGainItem(150, -16),
                new AntennaGainItem(160, -15),
                new AntennaGainItem(170, -14),
                new AntennaGainItem(180, -13),
                new AntennaGainItem(190, -14),
                new AntennaGainItem(200, -15),
                new AntennaGainItem(210, -16),
                new AntennaGainItem(220, -17),
                new AntennaGainItem(230, -18),
                new AntennaGainItem(240, -19),
                new AntennaGainItem(250, -20),
                new AntennaGainItem(260, -16),
                new AntennaGainItem(270, -13),
                new AntennaGainItem(280, -10),
                new AntennaGainItem(290, -7),
                new AntennaGainItem(300, -5),
                new AntennaGainItem(310, -3),
                new AntennaGainItem(320, -2),
                new AntennaGainItem(330, -1),
                new AntennaGainItem(340, 0),
                new AntennaGainItem(350, 0),
                new AntennaGainItem(0, 0)
            };
        }

        public static IList<SunPositionItem> SunPosition()
        {
            return new SunPositionItem[] {
                new SunPositionItem("08:00", 4.9, 92.7),
                new SunPositionItem("09:00", 17.6, 100.6),
                new SunPositionItem("10:00", 30.1, 109.7),
                new SunPositionItem("11:00", 41.8, 121.3),
                new SunPositionItem("12:00", 51.8, 137.7),
                new SunPositionItem("13:00", 58.5, 161.5),
                new SunPositionItem("14:00", 59.4, 190.7),
                new SunPositionItem("15:00", 54.1, 216.6),
                new SunPositionItem("16:00", 44.8, 234.8),
                new SunPositionItem("17:00", 33.5, 247.6),
                new SunPositionItem("18:00", 21.2, 257.2),
                new SunPositionItem("19:00", 8.4, 265.3)
            };
        }
    }
}
```
**ChartDataRepository.Radar.cs**

```C#
using System.Collections.Generic;
using System;

namespace Kendo.Mvc.Examples.Models
{
    public partial class ChartDataRepository
    {
        public static IList<BudgetReportItem> BudgetReport()
        {
            return new BudgetReportItem[] {
                new BudgetReportItem("Sales", 40000, 52800),
                new BudgetReportItem("Marketing", 20000, 42000),
                new BudgetReportItem("Development", 60000, 21400),
                new BudgetReportItem("Customer Support", 30000, 28500),
                new BudgetReportItem("IT", 25000, 18900),
                new BudgetReportItem("Administration", 10000, 11100)
            };
        }

        public static IList<ProteinScoreItem> ProteinQualityData()
        {
            return new ProteinScoreItem[] {
                new ProteinScoreItem("Tryptophan", "Trp", 3),
                new ProteinScoreItem("Threonine", "Thr", 4),
                new ProteinScoreItem("Isoleucine", "Iso", 5),
                new ProteinScoreItem("Leucine", "Leu", 5),
                new ProteinScoreItem("Lysine", "Lys", 5),
                new ProteinScoreItem("Methionine + Cystine", "M+C", 2),
                new ProteinScoreItem("Phenylalanine + Tyrosine", "p+T", 3),
                new ProteinScoreItem("Valine", "Val", 5),
                new ProteinScoreItem("Histidine", "Hys", 4)
            };
        }

        public static IList<WindDataItem> WindData()
        {
            return new WindDataItem[] {
                new WindDataItem(0, "N", "< 0.5", 0),
                new WindDataItem(0, "N", "0.5 to 2", 2),
                new WindDataItem(0, "N", "2 to 4", 3),
                new WindDataItem(0, "N", "4 to 6", 2.5),
                new WindDataItem(0, "N", "6 to 8", 1),
                new WindDataItem(0, "N", "8 to 10", 0.5),
                new WindDataItem(0, "N", "> 10", 0.1),
                new WindDataItem(1, "NNE", "< 0.5", 0),
                new WindDataItem(1, "NNE", "0.5 to 2", 0.1),
                new WindDataItem(1, "NNE", "2 to 4", 0.1),
                new WindDataItem(1, "NNE", "4 to 6", 0),
                new WindDataItem(1, "NNE", "6 to 8", 0),
                new WindDataItem(1, "NNE", "8 to 10", 0),
                new WindDataItem(1, "NNE", "> 10", 0),
                new WindDataItem(2, "NE", "< 0.5", 0),
                new WindDataItem(2, "NE", "0.5 to 2", 0.2),
                new WindDataItem(2, "NE", "2 to 4", 0),
                new WindDataItem(2, "NE", "4 to 6", 0),
                new WindDataItem(2, "NE", "6 to 8", 0),
                new WindDataItem(2, "NE", "8 to 10", 0),
                new WindDataItem(2, "NE", "> 10", 0),
                new WindDataItem(3, "ENE", "< 0.5", 0),
                new WindDataItem(3, "ENE", "0.5 to 2", 0.2),
                new WindDataItem(3, "ENE", "2 to 4", 0.1),
                new WindDataItem(3, "ENE", "4 to 6", 0),
                new WindDataItem(3, "ENE", "6 to 8", 0),
                new WindDataItem(3, "ENE", "8 to 10", 0),
                new WindDataItem(3, "ENE", "> 10", 0),
                new WindDataItem(4, "E", "< 0.5", 0),
                new WindDataItem(4, "E", "0.5 to 2", 0.2),
                new WindDataItem(4, "E", "2 to 4", 0.3),
                new WindDataItem(4, "E", "4 to 6", 0),
                new WindDataItem(4, "E", "6 to 8", 0),
                new WindDataItem(4, "E", "8 to 10", 0),
                new WindDataItem(4, "E", "> 10", 0),
                new WindDataItem(5, "ESE", "< 0.5", 0),
                new WindDataItem(5, "ESE", "0.5 to 2", 0.4),
                new WindDataItem(5, "ESE", "2 to 4", 0.4),
                new WindDataItem(5, "ESE", "4 to 6", 0.1),
                new WindDataItem(5, "ESE", "6 to 8", 0.1),
                new WindDataItem(5, "ESE", "8 to 10", 0),
                new WindDataItem(5, "ESE", "> 10", 0),
                new WindDataItem(6, "SE", "< 0.5", 0),
                new WindDataItem(6, "SE", "0.5 to 2", 0.8),
                new WindDataItem(6, "SE", "2 to 4", 1.4),
                new WindDataItem(6, "SE", "4 to 6", 1.4),
                new WindDataItem(6, "SE", "6 to 8", 1),
                new WindDataItem(6, "SE", "8 to 10", 0.1),
                new WindDataItem(6, "SE", "> 10", 0),
                new WindDataItem(7, "SSE", "< 0.5", 0.1),
                new WindDataItem(7, "SSE", "0.5 to 2", 6),
                new WindDataItem(7, "SSE", "2 to 4", 2),
                new WindDataItem(7, "SSE", "4 to 6", 0.8),
                new WindDataItem(7, "SSE", "6 to 8", 0.5),
                new WindDataItem(7, "SSE", "8 to 10", 0),
                new WindDataItem(7, "SSE", "> 10", 0),
                new WindDataItem(8, "S", "< 0.5", 0.2),
                new WindDataItem(8, "S", "0.5 to 2", 10),
                new WindDataItem(8, "S", "2 to 4", 1),
                new WindDataItem(8, "S", "4 to 6", 0),
                new WindDataItem(8, "S", "6 to 8", 0),
                new WindDataItem(8, "S", "8 to 10", 0),
                new WindDataItem(8, "S", "> 10", 0),
                new WindDataItem(9, "SSW", "< 0.5", 0.1),
                new WindDataItem(9, "SSW", "0.5 to 2", 8),
                new WindDataItem(9, "SSW", "2 to 4", 1),
                new WindDataItem(9, "SSW", "4 to 6", 0),
                new WindDataItem(9, "SSW", "6 to 8", 0),
                new WindDataItem(9, "SSW", "8 to 10", 0),
                new WindDataItem(9, "SSW", "> 10", 0),
                new WindDataItem(10, "SW", "< 0.5", 0),
                new WindDataItem(10, "SW", "0.5 to 2", 6),
                new WindDataItem(10, "SW", "2 to 4", 3),
                new WindDataItem(10, "SW", "4 to 6", 1),
                new WindDataItem(10, "SW", "6 to 8", 0.1),
                new WindDataItem(10, "SW", "8 to 10", 0),
                new WindDataItem(10, "SW", "> 10", 0),
                new WindDataItem(11, "WSW", "< 0.5", 0),
                new WindDataItem(11, "WSW", "0.5 to 2", 3),
                new WindDataItem(11, "WSW", "2 to 4", 4),
                new WindDataItem(11, "WSW", "4 to 6", 1),
                new WindDataItem(11, "WSW", "6 to 8", 0),
                new WindDataItem(11, "WSW", "8 to 10", 0),
                new WindDataItem(11, "WSW", "> 10", 0),
                new WindDataItem(12, "W", "< 0.5", 0),
                new WindDataItem(12, "W", "0.5 to 2", 2),
                new WindDataItem(12, "W", "2 to 4", 3),
                new WindDataItem(12, "W", "4 to 6", 1),
                new WindDataItem(12, "W", "6 to 8", 0),
                new WindDataItem(12, "W", "8 to 10", 0),
                new WindDataItem(12, "W", "> 10", 0.1),
                new WindDataItem(13, "WNW", "< 0.5", 0),
                new WindDataItem(13, "WNW", "0.5 to 2", 1),
                new WindDataItem(13, "WNW", "2 to 4", 5),
                new WindDataItem(13, "WNW", "4 to 6", 2),
                new WindDataItem(13, "WNW", "6 to 8", 0.5),
                new WindDataItem(13, "WNW", "8 to 10", 0),
                new WindDataItem(13, "WNW", "> 10", 0.1),
                new WindDataItem(14, "NW", "< 0.5", 0),
                new WindDataItem(14, "NW", "0.5 to 2", 2),
                new WindDataItem(14, "NW", "2 to 4", 5),
                new WindDataItem(14, "NW", "4 to 6", 2),
                new WindDataItem(14, "NW", "6 to 8", 1),
                new WindDataItem(14, "NW", "8 to 10", 0.1),
                new WindDataItem(14, "NW", "> 10", 0.1),
                new WindDataItem(15, "NNW", "< 0.5", 0),
                new WindDataItem(15, "NNW", "0.5 to 2", 4),
                new WindDataItem(15, "NNW", "2 to 4", 5),
                new WindDataItem(15, "NNW", "4 to 6", 5),
                new WindDataItem(15, "NNW", "6 to 8", 3),
                new WindDataItem(15, "NNW", "8 to 10", 1),
                new WindDataItem(15, "NNW", "> 10", 0.2)
            };
        }
    }
}
```
**ChartDataRepository.Stock.cs**

```C#
using System.Collections.Generic;
using System;

namespace Kendo.Mvc.Examples.Models
{
    public partial class ChartDataRepository
    {
        public static IEnumerable<StockDataPoint> StockData()
        {
            return new StockDataPoint[]
            {
                new StockDataPoint {
                    Date = DateTime.Parse("2011/12/30"),
                    Close = 405m,
                    Volume = 6414369,
                    Open = 403.51m,
                    High = 406.28m,
                    Low = 403.49m,
                    Symbol = "2. AAPL"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/11/30"),
                    Close = 382.2m,
                    Volume = 14464710,
                    Open = 381.29m,
                    High = 382.276m,
                    Low = 378.3m,
                    Symbol = "2. AAPL"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/10/31"),
                    Close = 404.78m,
                    Volume = 13762250,
                    Open = 402.42m,
                    High = 409.33m,
                    Low = 401.05m,
                    Symbol = "2. AAPL"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/9/30"),
                    Close = 381.32m,
                    Volume = 19553550,
                    Open = 387.12m,
                    High = 388.89m,
                    Low = 381.18m,
                    Symbol = "2. AAPL"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/8/31"),
                    Close = 384.83m,
                    Volume = 18643770,
                    Open = 390.57m,
                    High = 392.08m,
                    Low = 381.86m,
                    Symbol = "2. AAPL"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/7/29"),
                    Close = 390.48m,
                    Volume = 22550900,
                    Open = 387.64m,
                    High = 395.15m,
                    Low = 384m,
                    Symbol = "2. AAPL"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/6/30"),
                    Close = 335.67m,
                    Volume = 11526680,
                    Open = 334.7m,
                    High = 336.13m,
                    Low = 332.84m,
                    Symbol = "2. AAPL"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/5/31"),
                    Close = 347.83m,
                    Volume = 14869200,
                    Open = 341.1m,
                    High = 347.83m,
                    Low = 341m,
                    Symbol = "2. AAPL"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/4/29"),
                    Close = 350.13m,
                    Volume = 29776300,
                    Open = 346.78m,
                    High = 353.95m,
                    Low = 346.666m,
                    Symbol = "2. AAPL"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/3/31"),
                    Close = 348.5075m,
                    Volume = 9779020,
                    Open = 346.36m,
                    High = 349.8m,
                    Low = 346.06m,
                    Symbol = "2. AAPL"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/2/28"),
                    Close = 353.21m,
                    Volume = 14356740,
                    Open = 351.24m,
                    High = 355.05m,
                    Low = 351.12m,
                    Symbol = "2. AAPL"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/1/31"),
                    Close = 339.32m,
                    Volume = 13457510,
                    Open = 335.8m,
                    High = 340.04m,
                    Low = 334.3m,
                    Symbol = "2. AAPL"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/12/30"),
                    Close = 173.1m,
                    Volume = 4279069,
                    Open = 173.36m,
                    High = 175.17m,
                    Low = 172.49m,
                    Symbol = "3. AMZN"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/11/30"),
                    Close = 192.29m,
                    Volume = 7700490,
                    Open = 194.76m,
                    High = 195.3m,
                    Low = 188.75m,
                    Symbol = "3. AMZN"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/10/31"),
                    Close = 213.51m,
                    Volume = 7336799,
                    Open = 215.79m,
                    High = 218.89m,
                    Low = 213.04m,
                    Symbol = "3. AMZN"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/9/30"),
                    Close = 216.23m,
                    Volume = 6549641,
                    Open = 218.19m,
                    High = 223m,
                    Low = 215.21m,
                    Symbol = "3. AMZN"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/8/31"),
                    Close = 215.23m,
                    Volume = 7397287,
                    Open = 212.27m,
                    High = 216.17m,
                    Low = 211.35m,
                    Symbol = "3. AMZN"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/7/29"),
                    Close = 222.52m,
                    Volume = 5166268,
                    Open = 221.29m,
                    High = 225.75m,
                    Low = 219.51m,
                    Symbol = "3. AMZN"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/6/30"),
                    Close = 204.49m,
                    Volume = 4446007,
                    Open = 200.78m,
                    High = 205.2m,
                    Low = 200.5m,
                    Symbol = "3. AMZN"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/5/31"),
                    Close = 196.69m,
                    Volume = 3405698,
                    Open = 195.94m,
                    High = 198.44m,
                    Low = 195.03m,
                    Symbol = "3. AMZN"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/4/29"),
                    Close = 195.81m,
                    Volume = 5697726,
                    Open = 194.38m,
                    High = 196.59m,
                    Low = 193.78m,
                    Symbol = "3. AMZN"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/3/31"),
                    Close = 180.13m,
                    Volume = 4824628,
                    Open = 179.31m,
                    High = 181.57m,
                    Low = 178.5m,
                    Symbol = "3. AMZN"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/2/28"),
                    Close = 173.29m,
                    Volume = 6781774,
                    Open = 173.91m,
                    High = 175.89m,
                    Low = 172.15m,
                    Symbol = "3. AMZN"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/1/31"),
                    Close = 169.64m,
                    Volume = 6716002,
                    Open = 170.16m,
                    High = 171.44m,
                    Low = 167.41m,
                    Symbol = "3. AMZN"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/12/30"),
                    Close = 645.9m,
                    Volume = 1780941,
                    Open = 642.02m,
                    High = 646.76m,
                    Low = 642.02m,
                    Symbol = "1. GOOG"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/11/30"),
                    Close = 599.39m,
                    Volume = 3390173,
                    Open = 597.95m,
                    High = 599.51m,
                    Low = 592.09m,
                    Symbol = "1. GOOG"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/10/31"),
                    Close = 592.64m,
                    Volume = 2557538,
                    Open = 595.09m,
                    High = 599.69m,
                    Low = 591.67m,
                    Symbol = "1. GOOG"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/9/30"),
                    Close = 515.04m,
                    Volume = 2723353,
                    Open = 520.21m,
                    High = 524m,
                    Low = 514.38m,
                    Symbol = "1. GOOG"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/8/31"),
                    Close = 540.96m,
                    Volume = 2689989,
                    Open = 544.74m,
                    High = 546.3m,
                    Low = 536m,
                    Symbol = "1. GOOG"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/7/29"),
                    Close = 603.69m,
                    Volume = 4133695,
                    Open = 604.23m,
                    High = 614.96m,
                    Low = 603.69m,
                    Symbol = "1. GOOG"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/6/30"),
                    Close = 506.38m,
                    Volume = 2427330,
                    Open = 501.99m,
                    High = 506.67m,
                    Low = 501.5m,
                    Symbol = "1. GOOG"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/5/31"),
                    Close = 529.02m,
                    Volume = 2685830,
                    Open = 525m,
                    High = 529.05m,
                    Low = 523.5m,
                    Symbol = "1. GOOG"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/4/29"),
                    Close = 544.1m,
                    Volume = 3522997,
                    Open = 540m,
                    High = 544.1m,
                    Low = 538.51m,
                    Symbol = "1. GOOG"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/3/31"),
                    Close = 586.76m,
                    Volume = 2028228,
                    Open = 583m,
                    High = 588.1612m,
                    Low = 581.74m,
                    Symbol = "1. GOOG"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/2/28"),
                    Close = 613.4m,
                    Volume = 2281411,
                    Open = 610m,
                    High = 616.49m,
                    Low = 608.01m,
                    Symbol = "1. GOOG"
                },
                new StockDataPoint {
                    Date = DateTime.Parse("2011/1/31"),
                    Close = 600.36m,
                    Volume = 2804332,
                    Open = 603.6m,
                    High = 604.47m,
                    Low = 595.55m,
                    Symbol = "1. GOOG"
                }
            };
        }
    }
}
```
**ChartOverviewDataRepository.cs**

```C#
using System;
using System.Collections.Generic;

namespace Kendo.Mvc.Examples.Models.Chart
{
    public class ChartOverviewDataRepository
    {
        public static IEnumerable<ProductCategoriesModel> ProductCategoriesData()
        {
            return new ProductCategoriesModel[] {
                new ProductCategoriesModel("2010", 2085200, 3080700, 1485700, 6651600),
                new ProductCategoriesModel("2011", 2091800, 3386400, 1525800, 7004000),
                new ProductCategoriesModel("2012", 3002100, 2627000, 1095500, 6724600),
                new ProductCategoriesModel("2013", 3008000, 4389700, 1907500, 9305200),
                new ProductCategoriesModel("2014", 3015000, 3443900, 1570000, 8028900),
                new ProductCategoriesModel("2015", 3035000, 2302500, 2117600, 7455100),
                new ProductCategoriesModel("2016", 3042000, 2983100, 2329700, 8354800),
                new ProductCategoriesModel("2017", 3044400, 3052200, 2756800, 8853400),
                new ProductCategoriesModel("2018", 3057800, 2611200, 3220300, 8889300),
                new ProductCategoriesModel("2019", 3087800, 2211200, 3020300, 8319300)
            };
        }

        public static IEnumerable<FunnelSalesModel> FunnelSalesData()
        {
            return new FunnelSalesModel[] {
                new FunnelSalesModel("Impressions", 35319300),
                new FunnelSalesModel("Listed Properties", 15319300),
                new FunnelSalesModel("Properties Shown", 12319300),
                new FunnelSalesModel("Total Sales", 8319300)
            };
        }

        public static IEnumerable<RegionSalesModel> RegionSalesData()
        {
            return new RegionSalesModel[] {
                new RegionSalesModel("Africa", 17.6),
                new RegionSalesModel("Middle East", 9.2),
                new RegionSalesModel("North America", 4.6),
                new RegionSalesModel("Asia", 30.8),
                new RegionSalesModel("Europe", 21.1),
                new RegionSalesModel("Latin America", 16.3)
            };
        }

        public static IList<SalesPerformersModel> SalesPerformers()
        {
            return new SalesPerformersModel[] {
                new SalesPerformersModel("John Smith", 1594000),
                new SalesPerformersModel("Annie Johnson", 1860500),
                new SalesPerformersModel("Christine Quinn", 1035000),
                new SalesPerformersModel("Sophia Williams", 980000),
                new SalesPerformersModel("Jacob Martinez", 1780000)
            };
        }
    }
}
```
**ChartScatterPoint.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class ChartScatterPoint
    {
        public double X { get; set; }
        public double Y { get; set; }
    }
}
```
**CheckBoxGroupViewModel.cs**

```C#
using Kendo.Mvc.UI;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class CheckBoxGroupViewModel
    {
        public List<IInputGroupItem> Items { get; set; }

        [Required]
        public string[] CheckBoxGroupValue { get; set; }
    }
}
```
**Client.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models.SpreadStreamProcessing
{
    public class Client
    {
        public Client(string name, string company)
        {
            this.Name = name;
            this.Company = company;
        }

        public string Name { get; private set; }

        public string Company { get; private set; }
    }
}
```
**Column.cs**

```C#
namespace Kendo.Mvc.Examples.Models.TaskBoard
{
    public class Column
    {
        public int ID { get; set; }
        public string Text { get; set; }
        public string Status { get; set; }
        public string Image { get; set; }
        public int Order { get; set; }
    }
}

```
**ColumnsViewModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models.WordsProcessing
{
    public class ColumnsViewModel
    {
        public string Field { get; set; }

        public string Title { get; set; }
    }
}
```
**CompensationStats.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    using System.Collections.Generic;

    public class CompensationStats
    {
        public CompensationStats()
        {
        }

        public CompensationStats(string year, double hourly, double change, double direct, IList<SocialBenefits> benefits)
        {
            Year = year;
            Hourly = hourly;
            Change = change;
            Direct = direct;
            Benefits = benefits;
        }

        public string Year { get; set; }
        public double Hourly { get; set; }
        public double Change { get; set; }
        public double Direct { get; set; }
        public IList<SocialBenefits> Benefits { get; set; }
    }

    public partial class ChartDataRepository
    {
        public static IList<CompensationStats> CompensationData()
        {
            return new CompensationStats[]
            {
                new CompensationStats("2011", 46.29, 16.69, 32.09, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 9.25),
                    new SocialBenefits(SocialBenefitType.Direct, 4.41)
                }),
                new CompensationStats("2010", 39.67, 18.7, 29.73, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 7.93),
                    new SocialBenefits(SocialBenefitType.Direct, 3.78)
                }),
                new CompensationStats("2009", 33.42, -6.93, 31.69, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 6.78),
                    new SocialBenefits(SocialBenefitType.Direct, 3.17)
                }),
                new CompensationStats("2008", 35.91, 7.61, 31.87, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 7.39),
                    new SocialBenefits(SocialBenefitType.Direct, 3.39)
                }),
                new CompensationStats("2007", 33.37, 14.4, 28.41, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 6.86),
                    new SocialBenefits(SocialBenefitType.Direct, 3.15)
                }),
                new CompensationStats("2006", 29.17, 2.17, 25.1, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 6.07),
                    new SocialBenefits(SocialBenefitType.Direct, 2.75)
                }),
                new CompensationStats("2005", 28.55, 6.73, 24.2, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 6.08),
                    new SocialBenefits(SocialBenefitType.Direct, 2.67)
                }),
                new CompensationStats("2004", 26.75, 18.1, 23.34, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 5.74),
                    new SocialBenefits(SocialBenefitType.Direct, 2.5)
                }),
                new CompensationStats("2003", 22.65, 30.02, 21.16, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 4.79),
                    new SocialBenefits(SocialBenefitType.Direct, 2.12)
                }),
                new CompensationStats("2002", 17.42, 15.98, 17.37, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 3.61),
                    new SocialBenefits(SocialBenefitType.Direct, 1.64)
                }),
                new CompensationStats("2001", 15.02, -8.69, 16.06, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 2.92),
                    new SocialBenefits(SocialBenefitType.Direct, 1.44)
                }),
                new CompensationStats("2000", 16.45, -9.32, 16.06, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 3.08),
                    new SocialBenefits(SocialBenefitType.Direct, 1.59)
                }),
                new CompensationStats("1999", 18.14, 5.77, 18.13, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 3.42),
                    new SocialBenefits(SocialBenefitType.Direct, 1.75)
                }),
                new CompensationStats("1998", 17.15, -9.4, 18.37, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 3.17),
                    new SocialBenefits(SocialBenefitType.Direct, 1.66)
                }),
                new CompensationStats("1997", 18.93, -1.25, 18.17, new SocialBenefits[] {
                    new SocialBenefits(SocialBenefitType.Social, 3.46),
                    new SocialBenefits(SocialBenefitType.Direct, 1.84)
                })
            };
        }

    }
}
```
**Config.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Configuration;

namespace Kendo.Mvc.Examples.Models
{
    public static class Config
    {
        private static readonly string NavigationData = "~/App_Data/{suite}.nav.json";

        public static string SuiteNavigationData(string suite)
        {
            return NavigationData.Replace("{suite}", suite);
        }
    }
}
```
**CorporateData.cs**

```C#
using System;
using System.Collections.Generic;

namespace Kendo.Mvc.Examples.Models.Chart
{
    public class CorporateData
    {
        public CorporateData(string firstName, string lastName, string image, string title, string colorScheme)
        {
            FirstName = firstName;
            LastName = lastName;
            Image = image;
            Title = title;
            ColorScheme = colorScheme;
            Items = new List<CorporateData>();
        }

        public string FirstName { get; set; }
        public string LastName { get; set; }
        public string Image { get; set; }
        public string Title { get; set; }
        public string ColorScheme { get; set; }

        public List<CorporateData> Items { get; set; }
    }
}

```
**Country.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Country
    {
        public Country()
        {
            this.DetailProducts = new HashSet<DetailProduct>();
        }

        public byte CountryID { get; set; }
        public string CountryNameShort { get; set; }
        public string CountryNameLong { get; set; }

        public virtual ICollection<DetailProduct> DetailProducts { get; set; }
    }
}

```
**CountryViewModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class CountryViewModel
    {
        public byte CountryID { get; set; }
        public string CountryNameShort { get; set; }
        public string CountryNameLong { get; set; }
    }
}
```
**Customer.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Customer
    {
        public Customer()
        {
            this.Orders = new HashSet<Order>();
            this.CustomerDemographics = new HashSet<CustomerDemographic>();
        }

        public string CustomerID { get; set; }
        public string CompanyName { get; set; }
        public string ContactName { get; set; }
        public string ContactTitle { get; set; }
        public string Address { get; set; }
        public string City { get; set; }
        public string Region { get; set; }
        public string PostalCode { get; set; }
        public string Country { get; set; }
        public string Phone { get; set; }
        public string Fax { get; set; }
        public Nullable<bool> Bool { get; set; }

        public virtual ICollection<Order> Orders { get; set; }
        public virtual ICollection<CustomerDemographic> CustomerDemographics { get; set; }
    }
}

```
**CustomerDemographic.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class CustomerDemographic
    {
        public CustomerDemographic()
        {
            this.Customers = new HashSet<Customer>();
        }

        public string CustomerTypeID { get; set; }
        public string CustomerDesc { get; set; }

        public virtual ICollection<Customer> Customers { get; set; }
    }
}

```
**CustomerViewModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class CustomerViewModel
    {
        public string CustomerID { get; set; }
        public string CompanyName { get; set; }
        public string ContactName { get; set; }
        public string ContactTitle { get; set; }
        public string Address { get; set; }
        public string City { get; set; }
        public string Region { get; set; }
        public string PostalCode { get; set; }
        public string Country { get; set; }
        public string Phone { get; set; }
        public string Fax { get; set; }
        public Nullable<bool> Bool { get; set; }
    }
}
```
**CustomValidationProductViewModel.cs**

```C#
using System;
using System.ComponentModel.DataAnnotations;
using System.Text.RegularExpressions;
using System.Web.Mvc;
using System.Collections.Generic;

namespace Kendo.Mvc.Examples.Models
{
    public class CustomValidationProductViewModel
    {
        public int ProductID { get; set; }

        [Required]
        [CustomProductNameValidation(ErrorMessage="ProductName should start with capital letter")]
        public string ProductName { get; set; }

        [DataType(DataType.Currency)]
        public decimal UnitPrice { get; set; }
    }

    [AttributeUsage(AttributeTargets.Field | AttributeTargets.Property, AllowMultiple = false, Inherited = true)]
    public class CustomProductNameValidationAttribute : ValidationAttribute, IClientValidatable
    {
        public override bool IsValid(object value)
        {
            var productName = (string) value;
            if (!string.IsNullOrEmpty(productName))
	        {
		        return Regex.IsMatch(productName, "^[A-Z]");
            }
            return true;
        }

        public IEnumerable<ModelClientValidationRule> GetClientValidationRules(ModelMetadata metadata, ControllerContext context)
        {
            yield return new ModelClientValidationRule
            {
                ErrorMessage = ErrorMessage,
                ValidationType = "productnamevalidation"
            };
        }
    }
}
```
**DataFilter.cs**

```C#
using System.Collections.Generic;

namespace Kendo.Mvc.Examples.Models
{
    /// <summary>
    /// Represents a filter expression of Kendo DataSource.
    /// </summary>
    public class DataFilter
    {
        /// <summary>
        /// Gets or sets the name of the sorted field (property). Set to <c>null</c> if the <c>Filters</c> property is set.
        /// </summary>
        public string Field { get; set; }

        /// <summary>
        /// Gets or sets the filtering operator. Set to <c>null</c> if the <c>Filters</c> property is set.
        /// </summary>
        public string Operator { get; set; }

        /// <summary>
        /// Gets or sets the filtering value. Set to <c>null</c> if the <c>Filters</c> property is set.
        /// </summary>
        public object Value { get; set; }

        /// <summary>
        /// Gets or sets the filtering logic. Can be set to "or" or "and". Set to <c>null</c> unless <c>Filters</c> is set.
        /// </summary>
        public string Logic { get; set; }

        /// <summary>
        /// Gets or sets the child filter expressions. Set to <c>null</c> if there are no child expressions.
        /// </summary>
        public IList<DataFilter> Filters { get; set; }
    }
}
```
**DatePoint.cs**

```C#
using System;

namespace Kendo.Mvc.Examples.Models
{
    public class DatePoint
    {
        public DatePoint(double value, DateTime date)
        {
            Value = value;
            Date = date;
        }

        public DateTime Date { get; set; }
        public double Value { get; set; }
    }
}

```
**DependencyViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Gantt
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;
    using Kendo.Mvc.UI;

    public class DependencyViewModel : IGanttDependency
    {
        public int DependencyID { get; set; }

        public int PredecessorID { get; set; }
        public int SuccessorID { get; set; }
        public DependencyType Type { get; set; }

        public GanttDependency ToEntity()
        {
            return new GanttDependency
            {
                ID = DependencyID,
                PredecessorID = PredecessorID,
                SuccessorID = SuccessorID,
                Type = (int)Type
            };
        }
    }
}
```
**DestinationViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.ComponentModel.DataAnnotations;

    public class DestinationViewModel
    {
        public string Country { get; set; }
        public string Title { get; set; }
        public string Description { get; set; }
        public string ImageUrl { get; set; }
    }
}

```
**DetailProduct.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class DetailProduct
    {
        public int ProductID { get; set; }
        public string ProductName { get; set; }
        public Nullable<decimal> UnitPrice { get; set; }
        public Nullable<short> UnitsInStock { get; set; }
        public string QuantityPerUnit { get; set; }
        public bool Discontinued { get; set; }
        public Nullable<int> UnitsOnOrder { get; set; }
        public Nullable<int> CategoryID { get; set; }
        public Nullable<byte> CountryID { get; set; }
        public Nullable<byte> CustomerRating { get; set; }
        public Nullable<int> TargetSales { get; set; }
        public Nullable<System.DateTime> LastSupply { get; set; }

        public virtual Category Category { get; set; }
        public virtual Country Country { get; set; }
    }
}

```
**DetailProductService.cs**

```C#
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class DetailProductService : IDisposable
    {
        private static bool UpdateDatabase = false;
        private SampleEntities entities;

        public DetailProductService(SampleEntities entities)
        {
            this.entities = entities;
        }

        public IList<DetailProductViewModel> GetDetailProducts()
        {
            var result = HttpContext.Current.Session["DetailProducts"] as IList<DetailProductViewModel>;

            if (result == null || UpdateDatabase)
            {
                result = entities.DetailProducts.Select(product => new DetailProductViewModel
                {
                    ProductID = product.ProductID,
                    ProductName = product.ProductName,
                    UnitPrice = product.UnitPrice.HasValue ? product.UnitPrice.Value : default(decimal),
                    UnitsInStock = product.UnitsInStock.HasValue ? product.UnitsInStock.Value : default(short),
                    QuantityPerUnit = product.QuantityPerUnit,
                    Discontinued = product.Discontinued,
                    UnitsOnOrder = product.UnitsOnOrder.HasValue ? (int)product.UnitsOnOrder.Value : default(int),
                    CategoryID = product.CategoryID,
                    Country = new CountryViewModel()
                    {
                        CountryID = product.Country.CountryID,
                        CountryNameShort = product.Country.CountryNameShort,
                        CountryNameLong = product.Country.CountryNameLong
                    },
                    CustomerRating = product.CustomerRating,
                    TargetSales = product.TargetSales,
                    CountryID = product.CountryID,
                    Category = new CategoryViewModel()
                    {
                        CategoryID = product.Category.CategoryID,
                        CategoryName = product.Category.CategoryName
                    },
                    LastSupply = DateTime.Today
                }).ToList();

                HttpContext.Current.Session["Products"] = result;
            }

            return result;
        }

        public IEnumerable<DetailProductViewModel> Read()
        {
            return GetDetailProducts();
        }

        public void Create(DetailProductViewModel product)
        {
            if (!UpdateDatabase)
            {
                var first = GetDetailProducts().OrderByDescending(e => e.ProductID).FirstOrDefault();
                var id = (first != null) ? first.ProductID : 0;

                product.ProductID = id + 1;

                if (product.CategoryID == null)
                {
                    product.CategoryID = 1;
                }

                if (product.Category == null)
                {
                    product.Category = new CategoryViewModel() { CategoryID = 1, CategoryName = "Beverages" };
                }

                if (product.CountryID == null)
                {
                    product.CountryID = 1;
                }

                if (product.Country == null)
                {
                    product.Country = new CountryViewModel() { CountryID = 1, CountryNameShort = "bg", CountryNameLong = "Bulgaria" };
                }



                GetDetailProducts().Insert(0, product);
            }
            else
            {
                var entity = new DetailProduct();

                entity.ProductName = product.ProductName;
                entity.UnitPrice = product.UnitPrice;
                entity.UnitsInStock = (short)product.UnitsInStock;
                entity.Discontinued = product.Discontinued;
                entity.CategoryID = product.CategoryID;
                entity.CustomerRating = product.CustomerRating;
                entity.TargetSales = product.TargetSales;

                if (entity.CategoryID == null)
                {
                    entity.CategoryID = 1;
                }

                if (product.Category != null)
                {
                    entity.CategoryID = product.Category.CategoryID;
                }

                if (product.CountryID == null)
                {
                    product.CountryID = 1;
                }

                if (product.Country != null)
                {
                    entity.CountryID = product.Country.CountryID;
                }

                entities.DetailProducts.Add(entity);
                entities.SaveChanges();

                product.ProductID = entity.ProductID;
            }
        }

        public void Update(DetailProductViewModel product)
        {
            if (!UpdateDatabase)
            {
                var target = One(e => e.ProductID == product.ProductID);

                if (target != null)
                {
                    target.ProductName = product.ProductName;
                    target.UnitPrice = product.UnitPrice;
                    target.UnitsInStock = product.UnitsInStock;
                    target.Discontinued = product.Discontinued;
                    target.CustomerRating = product.CustomerRating;
                    target.TargetSales = product.TargetSales;

                    if (product.CategoryID == null)
                    {
                        product.CategoryID = 1;
                    }

                    if (product.Category != null)
                    {
                        product.CategoryID = product.Category.CategoryID;
                    }
                    else
                    {
                        product.Category = new CategoryViewModel()
                        {
                            CategoryID = (int)product.CategoryID,
                            CategoryName = entities.Categories.Where(s => s.CategoryID == product.CategoryID).Select(s => s.CategoryName).First()
                        };
                    }

                    if (product.Country != null)
                    {
                        product.CategoryID = product.Country.CountryID;
                    }
                    else
                    {
                        product.Country = new CountryViewModel()
                        {
                            CountryID = (byte)product.CountryID,
                            CountryNameShort = entities.Countries.Where(s => s.CountryID == product.CategoryID).Select(s => s.CountryNameShort).First(),
                            CountryNameLong = entities.Countries.Where(s => s.CountryID == product.CategoryID).Select(s => s.CountryNameLong).First()
                        };
                    }

                    target.CategoryID = product.CategoryID;
                    target.Category = product.Category;
                }
            }
            else
            {
                var entity = new DetailProduct();

                entity.ProductID = product.ProductID;
                entity.ProductName = product.ProductName;
                entity.UnitPrice = product.UnitPrice;
                entity.UnitsInStock = (short)product.UnitsInStock;
                entity.Discontinued = product.Discontinued;
                entity.CategoryID = product.CategoryID;
                entity.CustomerRating = product.CustomerRating;
                entity.TargetSales = product.TargetSales;

                if (product.Category != null)
                {
                    entity.CategoryID = product.Category.CategoryID;
                }

                if (product.Country != null)
                {
                    entity.CountryID = product.Country.CountryID;
                }

                entities.DetailProducts.Attach(entity);
                entities.Entry(entity).State = EntityState.Modified;
                entities.SaveChanges();
            }
        }

        public void Destroy(DetailProductViewModel product)
        {
            if (!UpdateDatabase)
            {
                var target = GetDetailProducts().FirstOrDefault(p => p.ProductID == product.ProductID);
                if (target != null)
                {
                    GetDetailProducts().Remove(target);
                }
            }
            else
            {
                var entity = new DetailProduct();

                entity.ProductID = product.ProductID;

                entities.DetailProducts.Attach(entity);

                entities.DetailProducts.Remove(entity);

                var orderDetails = entities.Order_Details.Where(pd => pd.ProductID == entity.ProductID);

                foreach (var orderDetail in orderDetails)
                {
                    entities.Order_Details.Remove(orderDetail);
                }

                entities.SaveChanges();
            }
        }

        public DetailProductViewModel One(Func<DetailProductViewModel, bool> predicate)
        {
            return GetDetailProducts().FirstOrDefault(predicate);
        }

        public void Dispose()
        {
            entities.Dispose();
        }
    }
}
```
**DetailProductViewModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class DetailProductViewModel
    {
        private int? targetSales;
        [ScaffoldColumn(false)]
        public int ProductID
        {
            get;
            set;
        }

        [Required]
        [Display(Name = "Product name")]
        public string ProductName
        {
            get;
            set;
        }

        [Display(Name = "Unit price")]
        [DataType(DataType.Currency)]
        [Range(0, int.MaxValue)]
        public decimal UnitPrice
        {
            get;
            set;
        }

        [Display(Name = "Units in stock")]
        [DataType("Integer")]
        [Range(0, int.MaxValue)]
        public int UnitsInStock
        {
            get;
            set;
        }

        public bool Discontinued
        {
            get;
            set;
        }

        [Display(Name = "Last supply")]
        [DataType(DataType.Date)]
        public DateTime LastSupply
        {
            get;
            set;
        }

        [DataType("Integer")]
        public int UnitsOnOrder
        {
            get;
            set;
        }
        public CategoryViewModel Category
        {
            get;
            set;
        }

        public int? CategoryID { get; set; }
        public int? CountryID { get; set; }

        public string QuantityPerUnit { get; set; }
        public CountryViewModel Country { get; set; }
        public byte? CustomerRating { get; set; }
        public int? TargetSales
        {
            get
            {
                return targetSales;
            }
            set
            {
                targetSales = value;
                TotalSales = value * 100;
            }
        }
        public int? TotalSales { get; set; }
    }
}
```
**DiagramConnectionService.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    using System.Linq;
    using System.Web.Mvc;
    using Kendo.Mvc.UI;
    using System;
    using System.Data;
    using System.Web;
    using System.Collections.Generic;

    public class DiagramConnectionService
    {
        private static bool UpdateDatabase = false;
        private SampleEntities db;

        public DiagramConnectionService(SampleEntities context)
        {
            db = context;
        }

        public DiagramConnectionService()
            : this(new SampleEntities())
        {
        }

        public virtual IList<OrgChartConnection> GetAll()
        {
            var result = HttpContext.Current.Session["DiagramConnections"] as IList<OrgChartConnection>;

            if (result == null || UpdateDatabase)
            {
                result = db.OrgChartConnections.AsNoTracking().ToList();

                HttpContext.Current.Session["DiagramConnections"] = result;
            }

            return result;
        }

        public virtual void Insert(OrgChartConnection connection, ModelStateDictionary modelState)
        {
            if (!UpdateDatabase)
            {
                var first = GetAll().OrderByDescending(e => e.Id).FirstOrDefault();
                var id = (first != null) ? first.Id : 0;

                connection.Id = id + 1;

                GetAll().Insert(0, connection);
            }
            else
            {
                db.OrgChartConnections.Add(connection);
                db.SaveChanges();

                connection.Id = connection.Id;
            }
        }

        public virtual void Update(OrgChartConnection connection, ModelStateDictionary modelState)
        {
            if (!UpdateDatabase)
            {
                var target = One(e => e.Id == connection.Id);

                if (target != null)
                {
                    target.FromShapeId = connection.FromShapeId;
                    target.ToShapeId = connection.ToShapeId;
                    target.Text = connection.Text;
                    target.FromPointX = connection.FromPointX;
                    target.FromPointY = connection.FromPointY;
                    target.ToPointX = connection.ToPointX;
                    target.ToPointY = connection.ToPointY;
                }
            }
            else
            {
                db.OrgChartConnections.Attach(connection);
                db.Entry(connection).State = EntityState.Modified;
                db.SaveChanges();
            }
        }

        public virtual void Delete(OrgChartConnection connection, ModelStateDictionary modelState)
        {
            if (!UpdateDatabase)
            {
                var target = One(p => p.Id == connection.Id);
                if (target != null)
                {
                    GetAll().Remove(target);
                }
            }
            else
            {
                db.OrgChartConnections.Attach(connection);

                Delete(connection);

                db.OrgChartConnections.Remove(connection);
                db.SaveChanges();
            }
        }

        private void Delete(OrgChartConnection connection)
        {
            var result = db.OrgChartShapes.Where(t => t.Id == connection.Id).First();

            db.OrgChartShapes.Remove(result);
        }

        public OrgChartConnection One(Func<OrgChartConnection, bool> predicate)
        {
            return GetAll().FirstOrDefault(predicate);
        }

        public void Dispose()
        {
            db.Dispose();
        }
    }
}
```
**DiagramDataRepository.cs**

```C#
using System.Collections.Generic;
using System;
using System.Linq;
using Kendo.Mvc.Examples.Models.Chart;

namespace Kendo.Mvc.Examples.Models
{
    public partial class DiagramDataRepository
    {
        public static List<CorporateData> OrgChart()
        {
            List<CorporateData> result = new List<CorporateData>();
            CorporateData antonio = new CorporateData("Antonio", "Moreno", "antonio.jpg", "Team Lead", "#1696d3");
            result.Add(antonio);

            CorporateData elizabeth = new CorporateData("Elizabeth", "Brown", "elizabeth.jpg", "Design Lead", "#ef6944");
            antonio.Items.Add(elizabeth);

            CorporateData ann = new CorporateData("Ann", "Devon", "ann.jpg", "UI Designer", "#ef6944");
            elizabeth.Items.Add(ann);

            CorporateData diego = new CorporateData("Diego", "Roel", "diego.jpg", "QA Engineer", "#ee587b");
            antonio.Items.Add(diego);

            CorporateData fran = new CorporateData("Fran", "Wilson", "fran.jpg", "QA Intern", "#ee587b");
            diego.Items.Add(fran);

            CorporateData felipe = new CorporateData("Felipe", "Izquiedro", "felipe.jpg", "Senior Developer", "#75be16");
            antonio.Items.Add(felipe);

            CorporateData daniel = new CorporateData("Daniel", "Tonini", "daniel.jpg", "Developer", "#75be16");
            felipe.Items.Add(daniel);

            return result;
        }

        public static List<DiagramNode> DiagramNodes()
        {
            var result = new List<DiagramNode>();
            var root = new DiagramNode("0");
            result.Add(root);

            AddNodes(root, new int[] { 3, 2, 2 });

            return result;
        }

        private static void AddNodes(DiagramNode root, IEnumerable<int> levels)
        {
            if (levels.Any())
            {
                for (int i = 0; i < levels.First(); i++)
                {
                    var node = new DiagramNode(root.Name + "." + i);
                    root.Items.Add(node);

                    if (levels.Count() > 1)
                    {
                        AddNodes(node, levels.Skip(1));
                    }
                }
            }
        }
    }
}
```
**DiagramNode.cs**

```C#
using System;
using System.Collections.Generic;
namespace Kendo.Mvc.Examples.Models
{
    public class DiagramNode
    {
        public DiagramNode()
        {
        }

        public DiagramNode(string name)
        {
            Name = name;
            Items = new List<DiagramNode>();
        }

        public string Name { get; set; }

        public List<DiagramNode> Items { get; set; }
    }
}
```
**DiagramShapeService.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    using System.Linq;
    using System.Web.Mvc;
    using Kendo.Mvc.UI;
    using System;
    using System.Data;
    using System.Web;
    using System.Collections.Generic;

    public class DiagramShapeService
    {
        private static bool UpdateDatabase = false;
        private SampleEntities db;

        public DiagramShapeService(SampleEntities context)
        {
            db = context;
        }

        public DiagramShapeService()
            : this(new SampleEntities())
        {
        }

        public virtual IList<OrgChartShape> GetAll()
        {
            var result = HttpContext.Current.Session["DiagramShapes"] as IList<OrgChartShape>;

            if (result == null || UpdateDatabase)
            {
                result = db.OrgChartShapes.AsNoTracking().ToList();

                HttpContext.Current.Session["DiagramShapes"] = result;
            }

            return result;
        }

        public virtual void Insert(OrgChartShape shape, ModelStateDictionary modelState)
        {
            if (!UpdateDatabase)
            {
                var first = GetAll().OrderByDescending(e => e.Id).FirstOrDefault();
                var id = (first != null) ? first.Id : 0;

                shape.Id = id + 1;

                GetAll().Insert(0, shape);
            }
            else
            {
                db.OrgChartShapes.Add(shape);
                db.SaveChanges();

                shape.Id = shape.Id;
            }
        }

        public virtual void Update(OrgChartShape shape, ModelStateDictionary modelState)
        {
            if (!UpdateDatabase)
            {
                var target = One(e => e.Id == shape.Id);

                if (target != null)
                {
                    target.JobTitle = shape.JobTitle;
                    target.Color = shape.Color;
                }
            }
            else
            {
                db.OrgChartShapes.Attach(shape);
                db.Entry(shape).State = EntityState.Modified;
                db.SaveChanges();
            }
        }

        public virtual void Delete(OrgChartShape shape, ModelStateDictionary modelState)
        {
            if (!UpdateDatabase)
            {
                var target = One(p => p.Id == shape.Id);
                if (target != null)
                {
                    GetAll().Remove(target);
                }
            }
            else
            {
                db.OrgChartShapes.Attach(shape);

                Delete(shape);

                db.OrgChartShapes.Remove(shape);
                db.SaveChanges();
            }
        }

        private void Delete(OrgChartShape shape)
        {
            var result = db.OrgChartShapes.Where(t => t.Id == shape.Id).First();

            db.OrgChartShapes.Remove(result);
        }

        public OrgChartShape One(Func<OrgChartShape, bool> predicate)
        {
            return GetAll().FirstOrDefault(predicate);
        }

        public void Dispose()
        {
            db.Dispose();
        }
    }
}
```
**DocumentDescriptionViewModel.cs**

```C#
using Kendo.Mvc.UI;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models.WordsProcessing
{
    public class DocumentDescriptionViewModel
    {
        public string Columns { get; set; }

        public string FileType { get; set; }

        public bool RepeateHeader { get; set; }

        public string RowBackground { get; set; }

        public string GroupHeaderBackground { get; set; }

        public string HeaderBackground { get; set; }
    }
}
```
**DocumentExportHelper.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Telerik.Documents.SpreadsheetStreaming;

namespace Kendo.Mvc.Examples.Models.SpreadStreamProcessing
{
    public class DocumentExportHelper
    {

        //private static readonly int HeaderRowHeight = 22;
        //private static readonly int RowHeight = 18;
        //private static readonly string[] ColumnHeaders = { "ID", "DATE", "TIME", "CLIENT", "COMPANY", "SHIPPING", "DISCOUNT", "STATUS" };
        //private static readonly double[] ColumnWidths = { 9.43, 12.29, 10.71, 15.43, 21.71, 14.29, 13.57, 11.29 };

        public int HeaderRowHeight { get; set; }
        public string[] ColumnHeaders { get; set; }
        public double[] ColumnWidths { get; set; }


        public DocumentExportHelper(int headerRowHeight, string[] columnHeaders, double[] columnWidths)
        {
            this.HeaderRowHeight = headerRowHeight;
            this.ColumnHeaders = columnHeaders;
            this.ColumnWidths = columnWidths;
        }


        #region Columns Export Methods

        public void ExportIdColumn(IRowExporter rowExporter, DocumentRow row, SpreadCellFormat normalFormat)
        {
            using (ICellExporter cellExporter = rowExporter.CreateCellExporter())
            {
                //this.UpdateProgess();
                cellExporter.SetValue(row.Id);
                cellExporter.SetFormat(normalFormat);
            }
        }

        public void ExportDateColumn(IRowExporter rowExporter, DocumentRow row)
        {
            using (ICellExporter cellExporter = rowExporter.CreateCellExporter())
            {
                SpreadCellFormat dateFormat = new SpreadCellFormat();
                dateFormat.FontSize = 10;
                dateFormat.VerticalAlignment = SpreadVerticalAlignment.Center;
                dateFormat.HorizontalAlignment = SpreadHorizontalAlignment.Center;
                dateFormat.NumberFormat = "m/d/yyyy";

                //this.UpdateProgess();
                cellExporter.SetValue(row.Date);
                cellExporter.SetFormat(dateFormat);
            }
        }

        public void ExportTimeColumn(IRowExporter rowExporter, DocumentRow row)
        {
            using (ICellExporter cellExporter = rowExporter.CreateCellExporter())
            {
                SpreadCellFormat timeFormat = new SpreadCellFormat();
                timeFormat.FontSize = 10;
                timeFormat.VerticalAlignment = SpreadVerticalAlignment.Center;
                timeFormat.HorizontalAlignment = SpreadHorizontalAlignment.Center;
                timeFormat.NumberFormat = "h:mm;@";

                //this.UpdateProgess();
                cellExporter.SetValue(row.Time);
                cellExporter.SetFormat(timeFormat);
            }
        }

        public void ExportClientColumn(IRowExporter rowExporter, DocumentRow row, SpreadCellFormat normalFormat)
        {
            using (ICellExporter cellExporter = rowExporter.CreateCellExporter())
            {
                //this.UpdateProgess();
                cellExporter.SetValue(row.Client);
                cellExporter.SetFormat(normalFormat);
            }
        }

        public void ExportCompanyColumn(IRowExporter rowExporter, DocumentRow row, SpreadCellFormat normalFormat)
        {
            using (ICellExporter cellExporter = rowExporter.CreateCellExporter())
            {
                //this.UpdateProgess();
                cellExporter.SetValue(row.Company);
                cellExporter.SetFormat(normalFormat);
            }
        }

        public void ExportShippingColumn(IRowExporter rowExporter, DocumentRow row)
        {
            using (ICellExporter cellExporter = rowExporter.CreateCellExporter())
            {
                SpreadCellFormat expressFormat = new SpreadCellFormat();
                expressFormat.FontSize = 10;
                expressFormat.VerticalAlignment = SpreadVerticalAlignment.Center;
                expressFormat.HorizontalAlignment = SpreadHorizontalAlignment.Center;

                if (row.Shipping == Shipping.Express)
                {
                    expressFormat.IsBold = true;
                    expressFormat.ForeColor = new SpreadThemableColor(new SpreadColor(192, 0, 0));
                }

                string shipping = string.Empty;
                switch (row.Shipping)
                {
                    case Shipping.Express:
                        shipping = "express";
                        break;
                    case Shipping.OneDay:
                        shipping = "1 day";
                        break;
                    case Shipping.TwoDays:
                        shipping = "2 days";
                        break;
                    case Shipping.Regular:
                        shipping = "regular";
                        break;
                }

                //this.UpdateProgess();
                cellExporter.SetValue(shipping);
                cellExporter.SetFormat(expressFormat);
            }
        }

        public void ExportDiscountColumn(IRowExporter rowExporter, DocumentRow row)
        {
            using (ICellExporter cellExporter = rowExporter.CreateCellExporter())
            {
                SpreadCellFormat percentFormat = new SpreadCellFormat();
                percentFormat.FontSize = 10;
                percentFormat.VerticalAlignment = SpreadVerticalAlignment.Center;
                percentFormat.HorizontalAlignment = SpreadHorizontalAlignment.Center;
                percentFormat.NumberFormat = "0%";

                //this.UpdateProgess();
                cellExporter.SetValue(row.Discount);
                cellExporter.SetFormat(percentFormat);
            }
        }

        public void ExportStatusColumn(IRowExporter rowExporter, DocumentRow row)
        {
            using (ICellExporter cellExporter = rowExporter.CreateCellExporter())
            {
                SpreadColor color = null;
                switch (row.Shipping)
                {
                    case Shipping.Express:
                        color = new SpreadColor(242, 116, 33);
                        break;
                    case Shipping.OneDay:
                        color = new SpreadColor(255, 192, 0);
                        break;
                    case Shipping.TwoDays:
                        color = new SpreadColor(142, 188, 0);
                        break;
                    case Shipping.Regular:
                        color = new SpreadColor(27, 157, 222);
                        break;
                }

                SpreadCellFormat statusFormat = new SpreadCellFormat();
                statusFormat.Fill = SpreadPatternFill.CreateSolidFill(color);
                SpreadBorder border = new SpreadBorder(SpreadBorderStyle.Thin, new SpreadThemableColor(new SpreadColor(255, 255, 255)));
                statusFormat.LeftBorder = border;
                statusFormat.TopBorder = border;
                statusFormat.RightBorder = border;
                statusFormat.BottomBorder = border;

                //this.UpdateProgess();
                cellExporter.SetFormat(statusFormat);
            }
        }

        #endregion


        public void ExportHeaderRows(IWorksheetExporter worksheetExporter)
        {
            using (IRowExporter rowExporter = worksheetExporter.CreateRowExporter())
            {
                rowExporter.SetHeightInPoints(HeaderRowHeight);

                using (ICellExporter cellExporter = rowExporter.CreateCellExporter())
                {
                    SpreadCellFormat format = new SpreadCellFormat();
                    format.FontFamily = new SpreadThemableFontFamily("Segoe UI");
                    format.FontSize = 16;
                    format.Fill = SpreadPatternFill.CreateSolidFill(new SpreadColor(51, 153, 51));
                    format.ForeColor = new SpreadThemableColor(new SpreadColor(255, 255, 255));
                    format.HorizontalAlignment = SpreadHorizontalAlignment.Left;
                    format.VerticalAlignment = SpreadVerticalAlignment.Center;

                    cellExporter.SetFormat(format);
                    cellExporter.SetValue("ORDERS LOG");
                }
            }

            using (IRowExporter rowExporter = worksheetExporter.CreateRowExporter())
            {
                rowExporter.SetHeightInPoints(HeaderRowHeight);

                using (ICellExporter cellExporter = rowExporter.CreateCellExporter())
                {
                    SpreadCellFormat format = new SpreadCellFormat();
                    format.FontFamily = new SpreadThemableFontFamily("Segoe UI");
                    format.FontSize = 14;
                    format.HorizontalAlignment = SpreadHorizontalAlignment.Left;
                    format.VerticalAlignment = SpreadVerticalAlignment.Center;

                    cellExporter.SetFormat(format);
                    cellExporter.SetValue("REPORT");
                }

                rowExporter.SkipCells(5);

                using (ICellExporter cellExporter = rowExporter.CreateCellExporter())
                {
                    SpreadCellFormat format = new SpreadCellFormat();
                    format.FontFamily = new SpreadThemableFontFamily("Segoe UI");
                    format.FontSize = 14;
                    format.NumberFormat = "[$-409]mmm-yy;@";
                    format.HorizontalAlignment = SpreadHorizontalAlignment.Center;
                    format.VerticalAlignment = SpreadVerticalAlignment.Center;

                    cellExporter.SetFormat(format);
                    cellExporter.SetFormula("=TODAY()");
                }
            }

            using (IRowExporter rowExporter = worksheetExporter.CreateRowExporter())
            {
                rowExporter.SetHeightInPoints(HeaderRowHeight);

                SpreadCellFormat format = new SpreadCellFormat();
                format.IsBold = true;
                format.Fill = SpreadPatternFill.CreateSolidFill(new SpreadColor(142, 196, 65));
                format.ForeColor = new SpreadThemableColor(new SpreadColor(255, 255, 255));
                format.HorizontalAlignment = SpreadHorizontalAlignment.Center;
                format.VerticalAlignment = SpreadVerticalAlignment.Center;

                for (int i = 0; i < ColumnHeaders.Length; i++)
                {
                    using (ICellExporter cellExporter = rowExporter.CreateCellExporter())
                    {
                        cellExporter.SetFormat(format);
                        cellExporter.SetValue(ColumnHeaders[i]);
                    }
                }
            }
        }
    }
}
```
**DocumentHelper.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models.SpreadStreamProcessing
{
    public class DocumentHelper
    {
        private static readonly Random random;
        private static readonly int StartingId = 1000;
        private static readonly string[] ClientNames = { "Agnes Hill", "Alexandra Kennedy", "Alison Ross", "Alison Thompson", "Charles Miller", "Edward Hall",
                                                   "Francis Stevens", "Glenda White", "Gregory Morrison", "Hannah Watson", "Jack Sims", "James Smith", "Jennie Walker",
                                                   "Jerry Wright", "Joe Lawrence", "Juan Jacobs", "Kara Wood", "Keith Clark", "Lynda Evans", "Marian Rodriguez",
                                                   "Mark Moore", "Natasha Green", "Nora Allen", "Patty Prince", "Ralph Burke", "Robyn Mason", "Roger Peters",
                                                   "Samuel Green", "Scott Fox", "Scott Lewis", "Terry Lawson"};

        private static readonly string[] Companies = { "Circuit Design", "Excella", "Integra Design", "Plan Smart", "Webcom Services", "Zig Zag Coder" };
        private static readonly int MaximumMinutesBetweenOrders = 40;

        private static Client[] Clients;

        static DocumentHelper()
        {
            random = new Random();
        }

        public static DocumentRow GenerateDocumentRow(int documentRowsCount, int rowIndex)
        {
            if (Clients == null)
            {
                InitializeClients();
            }

            int id = StartingId + rowIndex;

            int minuteDelta = random.Next(MaximumMinutesBetweenOrders);
            DateTime beginingDate = DateTime.Now.Date.AddMinutes((documentRowsCount - rowIndex) * MaximumMinutesBetweenOrders * -1);
            DateTime date = beginingDate.AddMinutes(minuteDelta * -1);
            DateTime time = date;

            int clinetIndex = random.Next(Clients.Length);
            Client client = Clients[clinetIndex];

            double discount = random.Next(15) / 100f;

            Shipping shipping = (Shipping)random.Next(Enum.GetValues(typeof(Shipping)).Length);

            DocumentRow row = new DocumentRow(
                id,
                date,
                time,
                client,
                discount,
                shipping);

            return row;
        }

        private static void InitializeClients()
        {
            Clients = new Client[ClientNames.Length];
            for (int i = 0; i < Clients.Length; i++)
            {
                int companyIndex = random.Next(0, Companies.Length);
                Clients[i] = new Client(ClientNames[i], Companies[companyIndex]);
            }
        }
    }
}
```
**DocumentRow.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models.SpreadStreamProcessing
{
    public class DocumentRow
    {
        public DocumentRow(int id, DateTime date, DateTime time, Client client, double discount, Shipping shipping)
        {
            this.Id = id;
            this.Date = date;
            this.Time = time;
            this.Client = client.Name;
            this.Company = client.Company;
            this.Discount = discount;
            this.Shipping = shipping;
        }

        public int Id { get; private set; }

        public DateTime Date { get; private set; }
        public DateTime Time { get; private set; }
        public string Client { get; private set; }
        public string Company { get; private set; }
        public double Discount { get; private set; }
        public Shipping Shipping { get; private set; }
    }
}
```
**DocumentSettings.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Telerik.Documents.SpreadsheetStreaming;

namespace Kendo.Mvc.Examples.Models.SpreadStreamProcessing
{
    public class DocumentSettings
    {
        private int exportedCellsCount;
        private double exportTime;
        private SpreadDocumentFormat selectedDocumentFormat;
        private int totalCellsCount;

        public SpreadDocumentFormat SelectedDocumentFormat
        {
            get
            {
                return this.selectedDocumentFormat;
            }
            set
            {
                if (this.selectedDocumentFormat != value)
                {
                    this.selectedDocumentFormat = value;
                }
            }
        }

        public IEnumerable<SpreadDocumentFormat> ExportFormats
        {
            get
            {
                return Enum.GetValues(typeof(SpreadDocumentFormat)).Cast<SpreadDocumentFormat>();
            }
        }

        public int ExportedCellsCount
        {
            get
            {
                return this.exportedCellsCount;
            }
            set
            {
                if (this.exportedCellsCount != value)
                {
                    this.exportedCellsCount = value;
                }
            }
        }

        public int TotalCellsCount
        {
            get
            {
                return this.totalCellsCount;
            }
            set
            {
                if (this.totalCellsCount != value)
                {
                    this.totalCellsCount = value;
                }
            }
        }

        public double ExportTime
        {
            get
            {
                return this.exportTime;
            }
            set
            {
                if (this.exportTime != value)
                {
                    this.exportTime = value;
                }
            }
        }
    }
}
```
**DownloadSpeed.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class DownloadSpeed
    {
        public DownloadSpeed()
        {
        }

        public DownloadSpeed(int wf, int wt, int of, int ot, string day)
        {
            this.WiFiFrom = wf;
            this.WiFiTo = wt;
            this.OpticalFrom = of;
            this.OpticalTo = ot;
            this.Day = day;
        }

        public int WiFiFrom { get; set; }
        public int WiFiTo { get; set; }
        public int OpticalFrom { get; set; }
        public int OpticalTo { get; set; }
        public string Day { get; set; }
    }
}
```
**ElectricityProduction.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class ElectricityProduction
    {
        public ElectricityProduction()
        {
        }

        public ElectricityProduction(string year, int solar, int hydro, int wind, int nuclear)
        {
            Year = year;
            Solar = solar;
            Hydro = hydro;
            Wind = wind;
            Nuclear = nuclear;
        }

        public string Year { get; set; }
        public int Solar { get; set; }
        public int Nuclear { get; set; }
        public int Hydro { get; set; }
        public int Wind { get; set; }
    }
}
```
**ElectricitySource.cs**

```C#
using System;
using System.Linq;

namespace Kendo.Mvc.Examples.Models
{
    public class ElectricitySource
    {
        public ElectricitySource()
        {
        }

        public ElectricitySource(string source, int percentage)
        {
            Source = source;
            Percentage = percentage;
        }

        public string Source { get; set; }
        public int Percentage { get; set; }
        public bool Explode { get; set; }
    }
}
```
**Employee.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Employee
    {
        public Employee()
        {
            this.Employees1 = new HashSet<Employee>();
            this.Orders = new HashSet<Order>();
            this.Territories = new HashSet<Territory>();
        }

        public int EmployeeID { get; set; }
        public string LastName { get; set; }
        public string FirstName { get; set; }
        public string Title { get; set; }
        public string TitleOfCourtesy { get; set; }
        public Nullable<System.DateTime> BirthDate { get; set; }
        public Nullable<System.DateTime> HireDate { get; set; }
        public string Address { get; set; }
        public string City { get; set; }
        public string Region { get; set; }
        public string PostalCode { get; set; }
        public string Country { get; set; }
        public string HomePhone { get; set; }
        public string Extension { get; set; }
        public byte[] Photo { get; set; }
        public string Notes { get; set; }
        public Nullable<int> ReportsTo { get; set; }
        public string PhotoPath { get; set; }

        public virtual ICollection<Employee> Employees1 { get; set; }
        public virtual Employee Employee1 { get; set; }
        public virtual ICollection<Order> Orders { get; set; }
        public virtual ICollection<Territory> Territories { get; set; }
    }
}

```
**EmployeeDirectory.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class EmployeeDirectory
    {
        public EmployeeDirectory()
        {
            this.EmployeeDirectory1 = new HashSet<EmployeeDirectory>();
        }

        public int EmployeeID { get; set; }
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public Nullable<int> ReportsTo { get; set; }
        public string Address { get; set; }
        public string City { get; set; }
        public string Country { get; set; }
        public string Phone { get; set; }
        public Nullable<int> Extension { get; set; }
        public Nullable<System.DateTime> BirthDate { get; set; }
        public Nullable<System.DateTime> HireDate { get; set; }
        public string Position { get; set; }

        public virtual ICollection<EmployeeDirectory> EmployeeDirectory1 { get; set; }
        public virtual EmployeeDirectory EmployeeDirectory2 { get; set; }
    }
}

```
**EmployeeDirectoryModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models.TreeList
{
    using System;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;

    public class EmployeeDirectoryModel
    {
        [ScaffoldColumn(false)]
        public int EmployeeId { get; set; }

        [Required]
        [DisplayName("First name")]
        public string FirstName { get; set; }

        [DisplayName("Last name")]
        public string LastName { get; set; }

        [ScaffoldColumn(false)]
        public int? ReportsTo { get; set; }

        public string Address { get; set; }

        public string City { get; set; }

        public string Country { get; set; }

        public string Phone { get; set; }

        [Range(0, 9999)]
        [DataType("Integer")]
        public int? Extension { get; set; }

        public string Position { get; set; }

        private DateTime? birthDate;
        [DataType(DataType.Date)]
        [DisplayName("Birthday")]
        public DateTime? BirthDate
        {
            get
            {
                return birthDate;
            }
            set
            {
                if (value.HasValue)
                {
                    birthDate = value.Value;
                }
                else
                {
                    birthDate = null;
                }
            }
        }


        private DateTime? hireDate;
        [DataType(DataType.Date)]
        [DisplayName("Hire Date")]
        public DateTime? HireDate
        {
            get
            {
                return hireDate;
            }
            set
            {
                if (value.HasValue)
                {
                    hireDate = value.Value;
                }
                else
                {
                    hireDate = null;
                }
            }
        }

        public string CountryFlag { get; set; }

        public EmployeeDirectory ToEntity()
        {
            return new EmployeeDirectory
            {
                EmployeeID = EmployeeId,
                FirstName = FirstName,
                LastName = LastName,
                ReportsTo = ReportsTo,
                Address = Address,
                City = City,
                Country = Country,
                Phone = Phone,
                Extension = Extension,
                Position = Position,
                HireDate = HireDate,
                BirthDate = BirthDate
            };
        }
    }
}
```
**EmployeeDirectoryRemoteModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models.TreeList
{
    using System;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;

    public class EmployeeDirectoryRemoteModel
    {
        [ScaffoldColumn(false)]
        public int EmployeeId { get; set; }

        [Required]
        [DisplayName("First name")]
        public string FirstName { get; set; }

        [Required]
        [DisplayName("Last name")]
        public string LastName { get; set; }

        [ScaffoldColumn(false)]
        public int? ReportsTo { get; set; }

        public string Address { get; set; }

        public string City { get; set; }

        public string Country { get; set; }

        public string Phone { get; set; }

        [Required]
        [Range(0, 9999)]
        [DataType("Integer")]
        public int? Extension { get; set; }

        [ScaffoldColumn(false)]
        public bool hasChildren { get; set; }
        public string Position { get; set; }

        private DateTime? birthDate;
        [DataType(DataType.Date)]
        [DisplayName("Birthday")]
        public DateTime? BirthDate
        {
            get
            {
                return birthDate;
            }
            set
            {
                if (value.HasValue)
                {
                    birthDate = value.Value;
                }
                else
                {
                    birthDate = null;
                }
            }
        }


        private DateTime? hireDate;
        [DataType(DataType.Date)]
        [DisplayName("Hire Date")]
        public DateTime? HireDate
        {
            get
            {
                return hireDate;
            }
            set
            {
                if (value.HasValue)
                {
                    hireDate = value.Value;
                }
                else
                {
                    hireDate = null;
                }
            }
        }

        public EmployeeDirectory ToEntity()
        {
            return new EmployeeDirectory
            {
                EmployeeID = EmployeeId,
                FirstName = FirstName,
                LastName = LastName,
                ReportsTo = ReportsTo,
                Address = Address,
                City = City,
                Country = Country,
                Phone = Phone,
                Extension = Extension,
                Position = Position,
                HireDate = HireDate,
                BirthDate = BirthDate
            };
        }
    }
}
```
**EmployeeDirectoryService.cs**

```C#
namespace Kendo.Mvc.Examples.Models.TreeList
{
    using System.Linq;
    using System.Web.Mvc;
    using Kendo.Mvc.UI;
    using System;
    using System.Data;
    using System.Data.Entity;
    using System.Data.Objects;
    using System.Collections.Generic;
    using System.Web;

    public static class EmployeeDirectoryIEnumerableExtensions
    {
        public static EmployeeDirectoryModel ToEmployeeDirectoryModel(this EmployeeDirectory employee)
        {
            return new EmployeeDirectoryModel
            {
                EmployeeId = employee.EmployeeID,
                ReportsTo = employee.ReportsTo,
                FirstName = employee.FirstName,
                LastName = employee.LastName,
                Address = employee.Address,
                City = employee.City,
                Country = employee.Country,
                BirthDate = employee.BirthDate,
                HireDate = employee.HireDate,
                Phone = employee.Phone,
                Position = employee.Position,
                Extension = employee.Extension
            };
        }

        public static EmployeeDirectoryRemoteModel ToEmployeeDirectoryRemoteModel(this EmployeeDirectory employee, bool hasChildren)
        {
            return new EmployeeDirectoryRemoteModel
            {
                EmployeeId = employee.EmployeeID,
                ReportsTo = employee.ReportsTo,
                FirstName = employee.FirstName,
                LastName = employee.LastName,
                Address = employee.Address,
                City = employee.City,
                Country = employee.Country,
                BirthDate = employee.BirthDate,
                HireDate = employee.HireDate,
                Phone = employee.Phone,
                Position = employee.Position,
                Extension = employee.Extension,
                hasChildren = hasChildren
            };
        }
    }

    public class EmployeeDirectoryService
    {
        private static bool UpdateDatabase = false;
        private SampleEntities db;

        public EmployeeDirectoryService(SampleEntities context)
        {
            db = context;
        }

        public EmployeeDirectoryService()
            : this(new SampleEntities())
        {
        }

        public virtual IList<EmployeeDirectoryModel> GetAll()
        {
            var result = HttpContext.Current.Session["EmployeeDirectory"] as IList<EmployeeDirectoryModel>;

            if (result == null || UpdateDatabase)
            {
                result = db.EmployeeDirectory.ToList().Select(employee => employee.ToEmployeeDirectoryModel()).ToList();

                HttpContext.Current.Session["EmployeeDirectory"] = result;
            }

            return result;
        }

        public virtual IList<EmployeeDirectoryRemoteModel> GetAllRemote()
        {
            return db.EmployeeDirectory.ToList().Select(employee => employee.ToEmployeeDirectoryRemoteModel(db.EmployeeDirectory.Where(s => s.ReportsTo == employee.EmployeeID).Count() > 0)).ToList();
        }

        public virtual void Insert(EmployeeDirectoryModel employee, ModelStateDictionary modelState)
        {
            if (ValidateModel(employee, modelState))
            {
                if (!UpdateDatabase)
                {
                    var first = GetAll().OrderByDescending(e => e.EmployeeId).FirstOrDefault();
                    var id = (first != null) ? first.EmployeeId : 0;

                    employee.EmployeeId = id + 1;

                    GetAll().Insert(0, employee);
                }
                else
                {
                    var entity = employee.ToEntity();

                    db.EmployeeDirectory.Add(entity);
                    db.SaveChanges();

                    employee.EmployeeId = entity.EmployeeID;
                }
            }
        }

        public virtual void Update(EmployeeDirectoryModel employee, ModelStateDictionary modelState)
        {
            if (ValidateModel(employee, modelState))
            {
                if (!UpdateDatabase)
                {
                    var target = One(e => e.EmployeeId == employee.EmployeeId);

                    if (target != null)
                    {
                        target.FirstName = employee.FirstName;
                        target.LastName = employee.LastName;
                        target.Address = employee.Address;
                        target.City = employee.City;
                        target.Country = employee.Country;
                        target.Phone = employee.Phone;
                        target.Extension = employee.Extension;
                        target.BirthDate = employee.BirthDate;
                        target.HireDate = employee.HireDate;
                        target.Position = employee.Position;
                        target.ReportsTo = employee.ReportsTo;
                    }
                }
                else
                {
                    var entity = employee.ToEntity();
                    db.EmployeeDirectory.Attach(entity);
                    db.Entry(entity).State = EntityState.Modified;
                    db.SaveChanges();
                }
            }
        }

        public virtual void Delete(EmployeeDirectoryModel employee, ModelStateDictionary modelState)
        {
            if (!UpdateDatabase)
            {
                var target = One(p => p.EmployeeId == employee.EmployeeId);
                if (target != null)
                {
                    DeleteSessionChildren(target);

                    GetAll().Remove(target);
                }
            }
            else
            {
                var entity = employee.ToEntity();

                db.EmployeeDirectory.Attach(entity);

                DeleteEntityChildren(entity);

                db.SaveChanges();
            }
        }

        private void DeleteEntityChildren(EmployeeDirectory employee)
        {
            var children = db.EmployeeDirectory.Where(e => e.ReportsTo == employee.EmployeeID);

            foreach (var subordinate in children)
            {
                DeleteEntityChildren(subordinate);
            }

            db.EmployeeDirectory.Remove(employee);
        }

        private void DeleteSessionChildren(EmployeeDirectoryModel employee)
        {
            var allEmployees = GetAll();
            var employees = GetAll().Where(m => m.ReportsTo == employee.EmployeeId).ToList();

            foreach (var subordinate in employees)
            {
                DeleteSessionChildren(subordinate);

                allEmployees.Remove(subordinate);
            }
        }

        public EmployeeDirectoryModel One(Func<EmployeeDirectoryModel, bool> predicate)
        {
            return GetAll().FirstOrDefault(predicate);
        }

        private bool ValidateModel(EmployeeDirectoryModel employee, ModelStateDictionary modelState)
        {
            if (employee.HireDate < employee.BirthDate)
            {
                modelState.AddModelError("errors", "Employee cannot be hired before birth.");
                return false;
            }

            return true;
        }

        public void Dispose()
        {
            db.Dispose();
        }
    }
}
```
**EmployeeViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using System.Web.Mvc;

    public class EmployeeViewModel
    {
        public int EmployeeID
        {
            get;
            set;
        }

        [Required]
        public string FirstName
        {
            get;
            set;
        }

        public string EmployeeName
        {
            get;
            set;
        }

        [Required]
        public string LastName
        {
            get;
            set;
        }

        public string Title
        {
            get;
            set;
        }

        public string Country
        {
            get;
            set;
        }

        public string City
        {
            get;
            set;
        }

        public string Address
        {
            get;
            set;
        }

        public string HomePhone
        {
            get;
            set;
        }

        [Required]
        [AllowHtml]
        public string Notes
        {
            get;
            set;
        }

        public int? ReportsTo
        {
            get;
            set;
        }
    }
}
```
**EngineDataPoint.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class EngineDataPoint
    {
        public EngineDataPoint()
        {
        }

        public EngineDataPoint(int rpm, double torque, double power)
        {
            RPM = rpm;
            Torque = torque;
            Power = power;
        }

        public int RPM;
        public double Torque;
        public double Power;
    }
}

```
**ExampleFile.cs**

```C#
using System;
using System.IO;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class ExampleFile
    {
        public string Name { get; set; }
        public string Url { get; set; }

        public bool Exists(HttpServerUtilityBase server)
        {
            NormalizeUrl(server);

            return File.Exists(server.MapPath(Url));
        }

        private void NormalizeUrl(HttpServerUtilityBase server)
        {
            var normalized = Url.Replace("-", "_");

            if (File.Exists(server.MapPath(normalized)))
            {
                Url = normalized;
                Name = Name.Replace("-", "_");
            }
        }
    }
}
```
**ExampleLink.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class ExampleLink
    {
        public string Text { get; set; }
        public string Url { get; set; }
    }
}
```
**FileHelper.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Kendo.Mvc.Examples.Models
{

    public class FileHelper
    {
        public int ID { get; set; }
        public int CompressedSize { get; set; }
        public int UncompressedSize { get; set; }
        public string FileNameInZip { get; set; }
        public string IconPath { get; set; }
        public byte[] Data { get; set; }
    }
}

```
**ForeCast.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class Forecast
    {
        public int Temperature { get; set; }
        public string Weather { get; set; }
        public string Day { get; set; }
    }
}
```
**FormItemsViewModels.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Form
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.DataAnnotations;

    public class FormItemsViewModels
    {
        [Required]
        public string TextBox { get; set; }
        public string TextArea { get; set; }

        [Required]
        public int? NumericTextBox { get; set; }

        public string MaskedTextBox { get; set; }

        public DateTime? DatePicker { get; set; }

        [Required]
        public DateTime? DateTimePicker { get; set; }

        [Required]
        public bool Switch { get; set; }

        public string ComboBox { get; set; }

        public string RadioGroup { get; set; }

        public string[] CheckBoxGroup { get; set; }

        [Required]
        public bool Agree { get; set; }
    }
}

```
**FormOrderViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Form
{
    using System.ComponentModel.DataAnnotations;

    public class FormOrderViewModel
    {
        [Required(ErrorMessage = "First Name is Required")]
        public string FirstName
        {
            get; set;
        }

        [Required(ErrorMessage = "Last Name is Required")]
        public string LastName
        {
            get;
            set;
        }

        [Required]
        [EmailAddress(ErrorMessage = "Invalid Email Address")]
        public string Email
        {
            get;
            set;
        }

        [Required]
        [Display(Name = "Ship Country")]
        public string ShipCountry { get; set; }

        [Required]
        public string City
        {
            get;
            set;
        }

        [Required]
        public string Address
        {
            get;
            set;
        }

        [Required]
        public bool Agree
        {
            get;
            set;
        }
    }
}

```
**FunnelSalesModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models.Chart
{
    public class FunnelSalesModel
    {
        public FunnelSalesModel(string category, int value)
        {
            Category = category;
            Value = value;
        }
        public string Category { get; set; }

        public int Value { get; set; }
    }

}

```
**GanttAssignmentService.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Gantt
{
    using System;
    using System.Collections.Generic;
    using System.Data;
    using System.Linq;
    using System.Web;

    public class GanttAssignmentService
    {
        private static bool UpdateDatabase = false;
        private SampleEntities db;

        public GanttAssignmentService(SampleEntities context)
        {
            db = context;
        }

        public GanttAssignmentService()
            : this(new SampleEntities())
        {
        }

        public virtual IList<ResourceAssignmentViewModel> GetAll()
        {
            var result = HttpContext.Current.Session["GanttAssignments"] as IList<ResourceAssignmentViewModel>;

            if (result == null || UpdateDatabase)
            {
                result = db.GanttResourceAssignments.ToList().Select(assignment => new ResourceAssignmentViewModel
                {
                    ID = assignment.ID,
                    TaskID = assignment.TaskID,
                    ResourceID = assignment.ResourceID,
                    Units = assignment.Units
                }).ToList();

                HttpContext.Current.Session["GanttAssignments"] = result;
            }

            return result;
        }

        public virtual void Insert(ResourceAssignmentViewModel assignment)
        {
            if (!UpdateDatabase)
            {
                var first = GetAll().OrderByDescending(e => e.ID).FirstOrDefault();
                var id = (first != null) ? first.ID : 0;

                assignment.ID = id + 1;

                GetAll().Insert(0, assignment);
            }
            else
            {
                var entity = assignment.ToEntity();

                db.GanttResourceAssignments.Add(entity);
                db.SaveChanges();

                assignment.ID = entity.ID;
            }
        }

        public virtual void Update(ResourceAssignmentViewModel assignment)
        {
            if (!UpdateDatabase)
            {
                var target = One(e => e.ID == assignment.ID);

                if (target != null)
                {
                    target.ResourceID = assignment.ResourceID;
                    target.TaskID = assignment.TaskID;
                    target.Units = assignment.Units;
                }
            }
            else
            {
                var entity = assignment.ToEntity();

                db.GanttResourceAssignments.Attach(entity);
                db.Entry(entity).State = EntityState.Modified;
                db.SaveChanges();
            }
        }

        public virtual void Delete(ResourceAssignmentViewModel assignment)
        {
            if (!UpdateDatabase)
            {
                var target = One(p => p.ID == assignment.ID);
                if (target != null)
                {
                    GetAll().Remove(target);
                }
            }
            else
            {
                var entity = assignment.ToEntity();

                db.GanttResourceAssignments.Attach(entity);
                db.GanttResourceAssignments.Remove(entity);
                db.SaveChanges();
            }
        }
        public ResourceAssignmentViewModel One(Func<ResourceAssignmentViewModel, bool> predicate)
        {
            return GetAll().FirstOrDefault(predicate);
        }

        public void Dispose()
        {
            db.Dispose();
        }
    }
}
```
**GanttDependency.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class GanttDependency
    {
        public int ID { get; set; }
        public int PredecessorID { get; set; }
        public int SuccessorID { get; set; }
        public int Type { get; set; }
    }
}

```
**GanttDependencyService.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Gantt
{
    using System.Linq;
    using System.Web.Mvc;
    using Kendo.Mvc.UI;
    using System;
    using System.Data;
    using System.Web;
    using System.Collections.Generic;

    public class GanttDependencyService
    {
        private static bool UpdateDatabase = false;
        private SampleEntities db;

        public GanttDependencyService(SampleEntities context)
        {
            db = context;
        }

        public GanttDependencyService()
            : this(new SampleEntities())
        {
        }

        public virtual IList<DependencyViewModel> GetAll()
        {
            var result = HttpContext.Current.Session["GanttDependencies"] as IList<DependencyViewModel>;

            if (result == null || UpdateDatabase)
            {
                result = db.GanttDependencies.ToList().Select(dependency => new DependencyViewModel
                {
                    DependencyID = dependency.ID,
                    PredecessorID = dependency.PredecessorID,
                    SuccessorID = dependency.SuccessorID,
                    Type = (DependencyType)dependency.Type
                }).ToList();

                HttpContext.Current.Session["GanttDependencies"] = result;
            }

            return result;
        }

        public virtual void Insert(DependencyViewModel dependency, ModelStateDictionary modelState)
        {
            if (!UpdateDatabase)
            {
                var first = GetAll().OrderByDescending(e => e.DependencyID).FirstOrDefault();
                var id = (first != null) ? first.DependencyID : 0;

                dependency.DependencyID = id + 1;

                GetAll().Insert(0, dependency);
            }
            else
            {
                var entity = dependency.ToEntity();

                db.GanttDependencies.Add(entity);
                db.SaveChanges();

                dependency.DependencyID = entity.ID;
            }
        }

        public virtual void Delete(DependencyViewModel dependency, ModelStateDictionary modelState)
        {
            if (!UpdateDatabase)
            {
                var target = GetAll().FirstOrDefault(p => p.DependencyID == dependency.DependencyID);
                if (target != null)
                {
                    GetAll().Remove(target);
                }
            }
            else
            {
                var entity = dependency.ToEntity();
                db.GanttDependencies.Attach(entity);
                db.GanttDependencies.Remove(entity);
                db.SaveChanges();
            }
        }

        public void Dispose()
        {
            db.Dispose();
        }
    }
}
```
**GanttResource.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class GanttResource
    {
        public int ID { get; set; }
        public string Name { get; set; }
        public string Color { get; set; }
    }
}

```
**GanttResourceAssignment.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class GanttResourceAssignment
    {
        public int ID { get; set; }
        public int TaskID { get; set; }
        public int ResourceID { get; set; }
        public decimal Units { get; set; }
    }
}

```
**GanttResourceService.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Gantt
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;

    public class GanttResourceService
    {
        private SampleEntities db;

        public GanttResourceService(SampleEntities context)
        {
            db = context;
        }

        public GanttResourceService()
            : this(new SampleEntities())
        {
        }

        public virtual IQueryable<ResourceViewModel> GetAll()
        {
            return db.GanttResources.ToList().Select(resource => new ResourceViewModel
            {
                ID = resource.ID,
                Name = resource.Name,
                Color = resource.Color
            }).AsQueryable();
        }

        public void Dispose()
        {
            db.Dispose();
        }
    }
}
```
**GanttTask.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class GanttTask
    {
        public GanttTask()
        {
            this.GanttTasks1 = new HashSet<GanttTask>();
        }

        public int ID { get; set; }
        public Nullable<int> ParentID { get; set; }
        public int OrderID { get; set; }
        public string Title { get; set; }
        public System.DateTime Start { get; set; }
        public System.DateTime End { get; set; }
        public decimal PercentComplete { get; set; }
        public bool Expanded { get; set; }
        public bool Summary { get; set; }

        public virtual ICollection<GanttTask> GanttTasks1 { get; set; }
        public virtual GanttTask GanttTask1 { get; set; }
    }
}

```
**GanttTaskService.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Gantt
{
    using System.Linq;
    using System.Web.Mvc;
    using Kendo.Mvc.UI;
    using System;
    using System.Data;
    using System.Web;
    using System.Collections.Generic;

    public class GanttTaskService
    {
        private static bool UpdateDatabase = false;
        private SampleEntities db;

        public GanttTaskService(SampleEntities context)
        {
            db = context;
        }

        public GanttTaskService()
            : this(new SampleEntities())
        {
        }

        public virtual IList<TaskViewModel> GetAll()
        {
            var result = HttpContext.Current.Session["GanttTasks"] as IList<TaskViewModel>;

            if (result == null || UpdateDatabase)
            {
                result = db.GanttTasks.ToList().Select(task => new TaskViewModel
                {
                    TaskID = task.ID,
                    Title = task.Title,
                    Start = DateTime.SpecifyKind(task.Start, DateTimeKind.Utc),
                    End = DateTime.SpecifyKind(task.End, DateTimeKind.Utc),
                    ParentID = task.ParentID,
                    PercentComplete = task.PercentComplete,
                    OrderId = task.OrderID,
                    Expanded = task.Expanded,
                    Summary = task.Summary
                }).ToList();

                HttpContext.Current.Session["GanttTasks"] = result;
            }

            return result;
        }

        public virtual void Insert(TaskViewModel task, ModelStateDictionary modelState)
        {
            if (ValidateModel(task, modelState))
            {
                if (!UpdateDatabase)
                {
                    var first = GetAll().OrderByDescending(e => e.TaskID).FirstOrDefault();
                    var id = (first != null) ? first.TaskID : 0;

                    task.TaskID = id + 1;

                    GetAll().Insert(0, task);
                }
                else
                {
                    if (string.IsNullOrEmpty(task.Title))
                    {
                        task.Title = "";
                    }

                    var entity = task.ToEntity();

                    db.GanttTasks.Add(entity);
                    db.SaveChanges();

                    task.TaskID = entity.ID;
                }
            }
        }

        public virtual void Update(TaskViewModel task, ModelStateDictionary modelState)
        {
            if (ValidateModel(task, modelState))
            {
                if (!UpdateDatabase)
                {
                    var target = One(e => e.TaskID == task.TaskID);

                    if (target != null)
                    {
                        target.Title = task.Title;
                        target.Start = task.Start;
                        target.End = task.End;
                        target.PercentComplete = task.PercentComplete;
                        target.OrderId = task.OrderId;
                        target.ParentID = task.ParentID;
                        target.Summary = task.Summary;
                        target.Expanded = task.Expanded;
                    }
                }
                else
                {
                    if (string.IsNullOrEmpty(task.Title))
                    {
                        task.Title = "";
                    }

                    var entity = task.ToEntity();
                    db.GanttTasks.Attach(entity);
                    db.Entry(entity).State = EntityState.Modified;
                    db.SaveChanges();
                }
            }
        }

        public virtual void Delete(TaskViewModel task, ModelStateDictionary modelState)
        {
            if (!UpdateDatabase)
            {
                var target = One(p => p.TaskID == task.TaskID);
                if (target != null)
                {
                    DeleteSessionChildren(target);

                    GetAll().Remove(target);
                }
            }
            else
            {
                var entity = task.ToEntity();
                db.GanttTasks.Attach(entity);

                DeleteEntityChildren(entity);

                db.GanttTasks.Remove(entity);
                db.SaveChanges();
            }
        }

        private void DeleteEntityChildren(GanttTask task)
        {
            var childTasks = db.GanttTasks.Where(t => t.ParentID == task.ID);

            foreach (var childTask in childTasks)
            {
                DeleteEntityChildren(childTask);
                db.GanttTasks.Remove(childTask);
            }
        }

        private void DeleteSessionChildren(TaskViewModel task)
        {
            var allTasks = GetAll();
            var childTasks = allTasks.Where(t => t.ParentID == task.TaskID).ToList();

            foreach (var childTask in childTasks)
            {
                DeleteSessionChildren(childTask);
                allTasks.Remove(childTask);
            }
        }

        private bool ValidateModel(TaskViewModel task, ModelStateDictionary modelState)
        {
            if (task.Start > task.End)
            {
                modelState.AddModelError("errors", "End date must be greater or equal to Start date.");
                return false;
            }

            return true;
        }

        public TaskViewModel One(Func<TaskViewModel, bool> predicate)
        {
            return GetAll().FirstOrDefault(predicate);
        }

        public void Dispose()
        {
            db.Dispose();
        }
    }
}
```
**GrandSlam.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class GrandSlam
    {
        public GrandSlam()
        {
        }

        public GrandSlam(int year, int win, int loss, string extremum = null)
        {
            Year = year;
            Win = win;
            Loss = loss;
            Extremum = extremum;
        }

        public int Year { get; set; }
        public int Win { get; set; }
        public int Loss { get; set; }
        public string Extremum { get; set; }
    }
}
```
**HeaderTemplateViewModel.cs**

```C#
using System.Collections.Generic;

namespace Kendo.Mvc.Examples.Models
{
    public class HeaderTemplateViewModel
    {
        public IEnumerable<ProductViewModel> Products { get; set; }
        public IEnumerable<ProductViewModel> SelectedProducts { get; set; }
    }
}
```
**HeatMapModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class HeatMapModel
    {
        public string Row { get; set; }
        public string Column { get; set; }
        public int Value { get; set; }
    }
}
```
**IFrameworkDescription.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public interface IFrameworkDescription
    {
        string Name { get; }

        IEnumerable<ExampleFile> GetFiles(HttpServerUtilityBase server, string example, string section);
    }
}

```
**InputGroupItemModel.cs**

```C#
using Kendo.Mvc.UI;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class InputGroupItemModel : IInputGroupItem
    {
        public IDictionary<string, object> HtmlAttributes { get; set; }

        public string CssClass { get; set; }

        public bool? Enabled { get; set; }

        public bool? Encoded { get; set; }

        public string Label { get; set; }

        public string Value { get; set; }
    }
}
```
**InternetUsers.cs**

```C#
using System;
using System.Linq;

namespace Kendo.Mvc.Examples.Models
{
    public class InternetUsers
    {
        public InternetUsers()
        {
        }

        public InternetUsers(int year, string country, double value)
        {
            Year = year;
            Value = value;
            Country = country;
        }

        public InternetUsers(int year, double value, string country)
        {
            Year = year;
            Value = value;
            Country = country;
        }

        public int Year { get; set; }
        public double Value { get; set; }
        public string Country { get; set; }
    }
}
```
**Intraday.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Intraday
    {
        public int ID { get; set; }
        public string Symbol { get; set; }
        public System.DateTime Date { get; set; }
        public decimal Open { get; set; }
        public decimal High { get; set; }
        public decimal Low { get; set; }
        public decimal Close { get; set; }
        public long Volume { get; set; }
    }
}

```
**IssueModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class IssueModel
    {
        public int Id { get; set; }

        public string Title { get; set; }

        public string AdditionalInfo { get; set; }

        public string Type { get; set; }

        public bool Approved { get; set; }
    }
}
```
**ItemsModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class ItemsModel
    {
        public IEnumerable<ProductViewModel> Products { get; set; }
    }
}
```
**JobGrowth.cs**

```C#
using System;
using System.Linq;

namespace Kendo.Mvc.Examples.Models
{
    public class JobGrowth
    {
        public int Growth;
        public int Jobs;
        public int Applications;
        public string Company;
        public int Year;
    }
}
```
**LessTheme.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Themes
{
    public class LessTheme : Theme
    {
        public string Common { get; set; }
    }
}
```
**MapDataRepository.cs**

```C#
using System.Collections.Generic;
using System;

namespace Kendo.Mvc.Examples.Models
{
    public partial class MapDataRepository
    {
        public static IList<Marker> StoreLocations()
        {
            return new Marker[]
            {
                new Marker(30.2675,-97.7409, "Zevo Toys"),
                new Marker(30.2707,-97.7490, "Foo Bars"),
                new Marker(30.2705,-97.7409, "Mainway Toys"),
                new Marker(30.2686,-97.7494, "Acme Toys")
            };
        }
    }
}
```
**Marker.cs**

```C#
using System;

namespace Kendo.Mvc.Examples.Models
{
    public class Marker
    {
        public Marker(double latitude, double longitude, string name)
        {
            LatLng = new double[] { latitude, longitude };
            Name = name;
        }

        public double[] LatLng { get; set; }
        public string Name { get; set; }
    }
}

```
**MarriagesDivorcesData.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models.Chart
{
    public class MarriagesDivorcesData
    {
        public string State;
        public double Marriages;
        public double Divorces;
        public int Population;
    }
}
```
**Medals.cs**

```C#
using System;
using System.Linq;

namespace Kendo.Mvc.Examples.Models
{
    public class Medals
    {
        public Medals()
        {
        }

        public Medals(int year, int standing, int number, string country)
        {
            Year = year;
            Standing = standing;
            Number = number;
            Country = country;
        }

        public int Year { get; set; }
        public int Standing { get; set; }
        public int Number { get; set; }
        public string Country { get; set; }
    }
}
```
**Meeting.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Meeting
    {
        public Meeting()
        {
            this.MeetingAttendees = new HashSet<MeetingAttendee>();
            this.Meetings1 = new HashSet<Meeting>();
        }

        public int MeetingID { get; set; }
        public System.DateTime Start { get; set; }
        public System.DateTime End { get; set; }
        public string Title { get; set; }
        public string Description { get; set; }
        public Nullable<int> RoomID { get; set; }
        public bool IsAllDay { get; set; }
        public string RecurrenceRule { get; set; }
        public Nullable<int> RecurrenceID { get; set; }
        public string RecurrenceException { get; set; }
        public string StartTimezone { get; set; }
        public string EndTimezone { get; set; }

        public virtual ICollection<MeetingAttendee> MeetingAttendees { get; set; }
        public virtual ICollection<Meeting> Meetings1 { get; set; }
        public virtual Meeting Meeting1 { get; set; }
    }
}

```
**MeetingAttendee.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class MeetingAttendee
    {
        public int MeetingID { get; set; }
        public int AttendeeID { get; set; }

        public virtual Meeting Meeting { get; set; }
    }
}

```
**MeetingSignalRViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Scheduler
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;
    using Kendo.Mvc.UI;

    public class MeetingSignalRViewModel : ISchedulerEvent
    {
        public Guid? ID { get; set; }
        public string Title { get; set; }
        public string Description { get; set; }

        private DateTime start;
        public DateTime Start
        {
            get
            {
                return start;
            }
            set
            {
                start = value.ToUniversalTime();
            }
        }

        public string StartTimezone { get; set; }

        private DateTime end;

        public DateTime End
        {
            get
            {
                return end;
            }
            set
            {
                end = value.ToUniversalTime();
            }
        }

        public string EndTimezone { get; set; }

        public string RecurrenceRule { get; set; }
        public int? RecurrenceID { get; set; }
        public string RecurrenceException { get; set; }
        public bool IsAllDay { get; set; }
        public string Timezone { get; set; }
        public int? RoomID { get; set; }
        public IEnumerable<int> Attendees { get; set; }
    }
}
```
**MeetingViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Scheduler
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;
    using Kendo.Mvc.UI;

    public class MeetingViewModel : ISchedulerEvent
    {
        public int MeetingID { get; set; }
        public string Title { get; set; }
        public string Description { get; set; }

        private DateTime start;
        public DateTime Start
        {
            get
            {
                return start;
            }
            set
            {
                start = value.ToUniversalTime();
            }
        }

        public string StartTimezone { get; set; }

        private DateTime end;

        public DateTime End
        {
            get
            {
                return end;
            }
            set
            {
                end = value.ToUniversalTime();
            }
        }

        public string EndTimezone { get; set; }

        public string RecurrenceRule { get; set; }
        public int? RecurrenceID { get; set; }
        public string RecurrenceException { get; set; }
        public bool IsAllDay { get; set; }
        public string Timezone { get; set; }
        public int? RoomID { get; set; }
        public IEnumerable<int> Attendees { get; set; }

        public Meeting ToEntity()
        {
            var meeting = new Meeting
            {
                MeetingID = MeetingID,
                Title = Title,
                Start = Start,
                StartTimezone = StartTimezone,
                End = End,
                EndTimezone = EndTimezone,
                Description = Description,
                IsAllDay = IsAllDay,
                RecurrenceRule = RecurrenceRule,
                RecurrenceException = RecurrenceException,
                RecurrenceID = RecurrenceID,
                RoomID = RoomID
            };

            return meeting;
        }
    }
}
```
**NavigationExample.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;

namespace Kendo.Mvc.Examples.Models
{
    public class NavigationExample : NavigationItem
    {
        public string Url { get; set; }
        public bool New { get; set; }
        public bool Updated { get; set; }
        public string Group { get; set; }
        public string Api { get; set; }

        public bool Deferred { get; set; }

        public string AltDescription { get; set; }

        public bool HasConsole { get; set; }
        public IEnumerable<ExampleLink> Links { get; set; }
    }
}

```
**NavigationItem.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;

namespace Kendo.Mvc.Examples.Models
{
    public class NavigationItem
    {
        public string Name { get; set; }
        public string Text { get; set; }
        public IDictionary<string, string> Meta { get; set; }
        public IDictionary<string, string> Description { get; set; }
        public IDictionary<string, IEnumerable<ExampleFile>> Sources { get; set; }
        public string[] Packages { get; set; }

        public bool ShouldInclude(string package = "aspnet-mvc")
        {
            if (Packages == null || Packages.Length == 0)
            {
                return true;
            }

            var invert = false;
            var match = false;

            foreach (var packageName in Packages)
            {
                var name = packageName;
                if (name[0] == '!')
                {
                    invert = true;
                    name = name.Substring(1);
                }

                if (name == package)
                {
                    match = true;
                }
            }

            return (!invert && match) || (invert && !match);
        }
    }
}

```
**NavigationWidget.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;

namespace Kendo.Mvc.Examples.Models
{
    public class NavigationWidget : NavigationItem
    {
        public string Api { get; set; }
        public string ThumbnailUrl { get; set; }
        public string Category { get; set; }
        public string SpriteCssClass { get; set; }
        public bool Expanded { get; set; }
        public bool New { get; set; }
        public bool Updated { get; set; }
        public bool Beta { get; set; }
        public IDictionary<string, string> Documentation { get; set; }
        public IDictionary<string, string> Forum { get; set; }
        public IDictionary<string, string> CodeLibrary { get; set; }
        public List<NavigationExample> Items { get; set; }
    }
}

```
**OfflineFilter.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Script.Serialization;

namespace Kendo.Mvc.Examples.Models
{
    public class OfflineFilter
    {
        public bool SkipAlways { get; set; }
        public bool SkipHtml { get; set; }
        public bool SkipMvc { get; set; }
    }
}
```
**Order.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Order
    {
        public Order()
        {
            this.Order_Details = new HashSet<Order_Detail>();
        }

        public int OrderID { get; set; }
        public string CustomerID { get; set; }
        public Nullable<int> EmployeeID { get; set; }
        public Nullable<System.DateTime> OrderDate { get; set; }
        public Nullable<System.DateTime> RequiredDate { get; set; }
        public Nullable<System.DateTime> ShippedDate { get; set; }
        public Nullable<int> ShipVia { get; set; }
        public Nullable<decimal> Freight { get; set; }
        public string ShipName { get; set; }
        public string ShipAddress { get; set; }
        public string ShipCity { get; set; }
        public string ShipRegion { get; set; }
        public string ShipPostalCode { get; set; }
        public string ShipCountry { get; set; }

        public virtual Customer Customer { get; set; }
        public virtual Employee Employee { get; set; }
        public virtual ICollection<Order_Detail> Order_Details { get; set; }
        public virtual Shipper Shipper { get; set; }
    }
}

```
**Order_Detail.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Order_Detail
    {
        public int OrderID { get; set; }
        public int ProductID { get; set; }
        public decimal UnitPrice { get; set; }
        public short Quantity { get; set; }
        public float Discount { get; set; }

        public virtual Order Order { get; set; }
        public virtual Product Product { get; set; }
    }
}

```
**OrderViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.ComponentModel.DataAnnotations;

    public class OrderViewModel
    {
        public int OrderID
        {
            get;
            set;
        }

        public string CustomerID { get; set; }

        public string ContactName
        {
            get;
            set;
        }

        public decimal? Freight
        {
            get;
            set;
        }

        public string ShipAddress
        {
            get;
            set;
        }

        [Required]
        public DateTime? OrderDate
        {
            get;
            set;
        }

        public DateTime? ShippedDate
        {
            get;
            set;
        }

        public string ShipCountry
        {
            get;
            set;
        }

        public string ShipCity
        {
            get;
            set;
        }

        public string ShipName
        {
            get;
            set;
        }

        public int? EmployeeID
        {
            get;
            set;
        }
    }
}

```
**OrgChartConnection.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class OrgChartConnection
    {
        public int Id { get; set; }
        public Nullable<int> FromShapeId { get; set; }
        public Nullable<int> ToShapeId { get; set; }
        public string Text { get; set; }
        public Nullable<int> FromPointX { get; set; }
        public Nullable<int> FromPointY { get; set; }
        public Nullable<int> ToPointX { get; set; }
        public Nullable<int> ToPointY { get; set; }
    }
}

```
**OrgChartEmployeeViewModel.cs**

```C#
using Kendo.Mvc.UI;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class OrgChartEmployeeViewModel
    {
        public int ID
        {
            get; set;
        }
        public int? ParentID
        {
            get; set;
        }
        public string Name
        {
            get; set;
        }
        public string Title
        {
            get; set;
        }
        public string Group
        {
            get; set;
        }
        public bool? Expanded
        {
            get; set;
        }
        public bool hasChildren
        {
            get; set;
        }
        public string Avatar
        {
            get; set;
        }
    }
}
```
**OrgChartShape.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class OrgChartShape
    {
        public int Id { get; set; }
        public string JobTitle { get; set; }
        public string Color { get; set; }
    }
}

```
**OzoneConcentration.cs**

```C#
using System.Collections.Generic;

namespace Kendo.Mvc.Examples.Models
{
    public class OzoneConcentration
    {
        public int Year { get; set; }
        public double Lower { get; set; }
        public double Q1 { get; set; }
        public double Median { get; set; }
        public double Q3 { get; set; }
        public double Upper { get; set; }
        public double Mean { get; set; }
        public List<double> Outliers { get; set; }
    }
}
```
**PagerViewModel.cs**

```C#
using System;
using System.Linq;

namespace Kendo.Mvc.Examples.Models
{
    public class PagerViewModel
    {
        public PagerViewModel()
        {
            Numeric = true;
            Info = true;
            PreviousNext = true;
        }

        public bool Input { get; set; }

        public bool Numeric { get; set; }

        public bool Info { get; set; }

        public bool PreviousNext { get; set; }

        public bool Refresh { get; set; }

        public bool PageSizes { get; set; }
    }
}
```
**PanelBarItemViewModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class PanelBarItemViewModel

    {
        public string id { get; set; }
        public string text { get; set; }
        public string spriteCssClass { get; set; }
        public string imageUrl { get; set; }
        public bool expanded { get; set; }
        public bool hasChildren { get; set; }
        public IEnumerable<PanelBarItemViewModel> items { get; set; }

        public PanelBarItemViewModel Clone()
        {
            PanelBarItemViewModel clone = new PanelBarItemViewModel
            {
                id = this.id,
                imageUrl = this.imageUrl,
                spriteCssClass = this.spriteCssClass,
                text = this.text,
                expanded = this.expanded,
                hasChildren = this.hasChildren
            };
            return clone;
        }
    }
}
```
**PanelBarRepository.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Kendo.Mvc.UI;

namespace Kendo.Mvc.Examples.Models
{
    public static class PanelBarRepository
    {
        private static List<PanelBarItemViewModel> projectData;

        static PanelBarRepository()
        {
            projectData = new List<PanelBarItemViewModel>();
            projectData.Add(new PanelBarItemViewModel
            {
                id = "1",
                text = "My Documents",
                expanded = true,
                hasChildren = true,
                spriteCssClass = "rootfolder",
                items = new List<PanelBarItemViewModel>
                       {
                           new PanelBarItemViewModel
                           {
                                id = "2",
                                text = "Kendo UI Project",
                                expanded  = true,
                                spriteCssClass = "folder",
                                hasChildren = true,
                                items = new List<PanelBarItemViewModel>
                                {
                                    new PanelBarItemViewModel
                                    {
                                            id = "3",
                                            text ="about.html",
                                            spriteCssClass = "html"
                                    },
                                    new PanelBarItemViewModel
                                    {
                                            id = "4",
                                            text ="index.html",
                                            spriteCssClass = "html"
                                    },
                                    new PanelBarItemViewModel
                                    {
                                            id = "5",
                                            text ="logo.png",
                                            spriteCssClass = "image"
                                    }
                                }
                           },
                           new PanelBarItemViewModel
                           {
                                id = "6",
                                text = "New Web Site",
                                expanded  = true,
                                spriteCssClass = "folder",
                                hasChildren = true,
                                items = new List<PanelBarItemViewModel>
                                {
                                    new PanelBarItemViewModel
                                    {
                                            id = "7",
                                            text ="mockup.jpg",
                                            spriteCssClass = "image"
                                    },
                                    new PanelBarItemViewModel
                                    {
                                            id = "8",
                                            text ="Research.pdf",
                                            spriteCssClass = "pdf"
                                    }
                                }
                           },
                           new PanelBarItemViewModel
                           {
                                id = "9",
                                text = "Reports",
                                expanded  = true,
                                spriteCssClass = "folder",
                                hasChildren = true,
                                items = new List<PanelBarItemViewModel>
                                {
                                    new PanelBarItemViewModel
                                    {
                                            id = "10",
                                            text ="February.pdf",
                                            spriteCssClass = "pdf"
                                    },
                                    new PanelBarItemViewModel
                                    {
                                            id = "11",
                                            text ="March.pdf",
                                            spriteCssClass = "pdf"
                                    },
                                        new PanelBarItemViewModel
                                    {
                                            id = "12",
                                            text ="April.pdf",
                                            spriteCssClass = "pdf"
                                    }
                                }
                           }
                       }
            });

        }

        public static List<PanelBarItemViewModel> GetProjectData()
        {
            return projectData;
        }

        public static IEnumerable<PanelBarItemViewModel> GetChildren(string id)
        {
            Queue<PanelBarItemViewModel> items = new Queue<PanelBarItemViewModel>(projectData);

            while (items.Count > 0)
            {
                var current = items.Dequeue();
                if (current.id == id)
                {
                    return current.items.Select(o => new PanelBarItemViewModel
                    {
                        id = o.id,
                        text = o.text,
                        expanded = o.expanded,
                        hasChildren = o.hasChildren,
                        imageUrl = o.imageUrl,
                        spriteCssClass = o.spriteCssClass
                    });
                }

                if (current.hasChildren)
                {
                    foreach (var item in current.items)
                    {
                        items.Enqueue(item);
                    }
                }
            }

            return new List<PanelBarItemViewModel>();
        }
    }
}
```
**PhotoContestModel.cs**

```C#
using System.Collections.Generic;

namespace Kendo.Mvc.Examples.Models
{
    public class PhotoContestModel
    {
        public int Participants
        {
            get;
            set;
        }

        public string Id { get; set; }

        public string Title
        {
            get;
            set;
        }
    }
}
```
**PopulationUSA.cs**

```C#
using System;
using System.Collections.Generic;

namespace Kendo.Mvc.Examples.Models
{
    public class PopulationUSA
    {
        public PopulationUSA(string name, int value, List<PopulationUSA> items)
        {
            Name = name;
            Value = value;
            Items = items;
        }

        public string Name { get; set; }
        public int Value { get; set; }

        public List<PopulationUSA> Items { get; set; }
    }
}

```
**PriceData.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class PriceData
    {
        public string Name { get; set; }
        public decimal? Value { get; set; }
        public string Summary { get; set; }
    }
}
```
**PricePerformance.cs**

```C#
using System;

namespace Kendo.Mvc.Examples.Models
{
    public class PricePerformance
    {
        public string Family { get; set; }

        public string Model { get; set; }

        public int Price { get; set; }

        public int Performance { get; set; }
    }
}

```
**PrintMargins.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Telerik.Windows.Documents.Spreadsheet.Model.Printing;
using Telerik.Windows.Documents.Spreadsheet.Utilities;

namespace Kendo.Models
{
    /// <summary>
    /// Model for print margins (cm)
    /// </summary>
    public class PrintMargins
    {
        public double Top { get; set; }
        public double Right { get; set; }
        public double Bottom { get; set; }
        public double Left { get; set; }

        /// <summary>
        /// Converts the margins to PageMargins object
        /// </summary>
        /// <param name="margins">Print margins set in cm</param>
        /// <returns>Page margins in device independent pixels</returns>
        public static implicit operator PageMargins(PrintMargins margins)
        {
            return new PageMargins(
                UnitHelper.CmToDip(margins.Left),
                UnitHelper.CmToDip(margins.Top),
                UnitHelper.CmToDip(margins.Right),
                UnitHelper.CmToDip(margins.Bottom)
            );
        }
    }
}

```
**PrintOptions.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Telerik.Windows.Documents.Model;
using Telerik.Windows.Documents.Spreadsheet.FormatProviders;
using Telerik.Windows.Documents.Spreadsheet.Model.Printing;

namespace Kendo.Models
{
    /// <summary>
    /// Model for Spreadsheet print options
    /// </summary>
    public class PrintOptions
    {
        public ExportWhat Source { get; set; }
        public PaperTypes PaperSize { get; set; }
        public PageOrientation Orientation { get; set; }
        public PrintMargins Margins { get; set; }
        public bool CenterHorizontally { get; set; }
        public bool CenterVertically { get; set; }
        public bool PrintGridlines { get; set; }
    }
}
```
**Product.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Product
    {
        public Product()
        {
            this.Order_Details = new HashSet<Order_Detail>();
        }

        public int ProductID { get; set; }
        public string ProductName { get; set; }
        public Nullable<int> SupplierID { get; set; }
        public Nullable<int> CategoryID { get; set; }
        public string QuantityPerUnit { get; set; }
        public Nullable<decimal> UnitPrice { get; set; }
        public Nullable<short> UnitsInStock { get; set; }
        public Nullable<short> UnitsOnOrder { get; set; }
        public Nullable<short> ReorderLevel { get; set; }
        public bool Discontinued { get; set; }

        public virtual Category Category { get; set; }
        public virtual ICollection<Order_Detail> Order_Details { get; set; }
        public virtual Supplier Supplier { get; set; }
    }
}

```
**ProductCategoriesModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models.Chart
{
    public class ProductCategoriesModel
    {
        public ProductCategoriesModel(string year, int vacantLand, int residentialProperties, int commercialProperties, int total)
        {
            Year = year;
            VacantLand = vacantLand;
            ResidentialProperties = residentialProperties;
            CommercialProperties = commercialProperties;
            Total = total;
        }

        public string Year { get; set; }
        public int VacantLand { get; set; }
        public int ResidentialProperties { get; set; }
        public int CommercialProperties { get; set; }
        public int Total { get; set; }
    }
}
```
**ProductPdfProcessing.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class ProductPdfProcessing
    {
        public ProductPdfProcessing(string name, params double[] q)
        {
            this.Name = name;
            this.Q = q;
        }

        public string Name { get; set; }
        public double[] Q { get; set; }

        public static ProductPdfProcessing[] GetProducts()
        {
            return new ProductPdfProcessing[] {
                new ProductPdfProcessing("Product1", 25000, 30000, 15000, 25000),
                new ProductPdfProcessing("Product2", 20000, 28000, 12000, 20000),
                new ProductPdfProcessing("Product3", 14000, 28000, 8400, 14000),
                new ProductPdfProcessing("Product4", 7000, 14000, 4200, 7000),
                new ProductPdfProcessing("Product5", 7700, 15400, 4620, 7700),
                new ProductPdfProcessing("Product6", 13090, 26180, 7854, 13090) };
        }
    }
}
```
**ProductService.cs**

```C#
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class ProductService : IDisposable
    {
        private static bool UpdateDatabase = false;
        private SampleEntities entities;

        public ProductService(SampleEntities entities)
        {
            this.entities = entities;
        }

        public IList<ProductViewModel> GetAll()
        {
            var result = HttpContext.Current.Session["Products"] as IList<ProductViewModel>;

            if (result == null || UpdateDatabase)
            {
                result = entities.Products.Select(product => new ProductViewModel
                {
                    ProductID = product.ProductID,
                    ProductName = product.ProductName,
                    UnitPrice = product.UnitPrice.HasValue ? product.UnitPrice.Value : default(decimal),
                    UnitsInStock = product.UnitsInStock.HasValue ? product.UnitsInStock.Value : default(short),
                    QuantityPerUnit = product.QuantityPerUnit,
                    Discontinued = product.Discontinued,
                    UnitsOnOrder = product.UnitsOnOrder.HasValue ? (int)product.UnitsOnOrder.Value : default(int),
                    CategoryID = product.CategoryID,
                    Category = new CategoryViewModel()
                    {
                        CategoryID = product.Category.CategoryID,
                        CategoryName = product.Category.CategoryName
                    },
                    LastSupply = DateTime.Today
                }).ToList();

                HttpContext.Current.Session["Products"] = result;
            }

            return result;
        }

        public IEnumerable<ProductViewModel> Read()
        {
            return GetAll();
        }

        public void Create(ProductViewModel product)
        {
            if (!UpdateDatabase)
            {
                var first = GetAll().OrderByDescending(e => e.ProductID).FirstOrDefault();
                var id = (first != null) ? first.ProductID : 0;

                product.ProductID = id + 1;

                if (product.CategoryID == null)
                {
                    product.CategoryID = 1;
                }

                if (product.Category == null)
                {
                    product.Category = new CategoryViewModel() { CategoryID = 1, CategoryName = "Beverages" };
                }

                GetAll().Insert(0, product);
            }
            else
            {
                var entity = new Product();

                entity.ProductName = product.ProductName;
                entity.UnitPrice = product.UnitPrice;
                entity.UnitsInStock = (short)product.UnitsInStock;
                entity.Discontinued = product.Discontinued;
                entity.CategoryID = product.CategoryID;

                if (entity.CategoryID == null)
                {
                    entity.CategoryID = 1;
                }

                if (product.Category != null)
                {
                    entity.CategoryID = product.Category.CategoryID;
                }

                entities.Products.Add(entity);
                entities.SaveChanges();

                product.ProductID = entity.ProductID;
            }
        }

        public void Update(ProductViewModel product)
        {
            if (!UpdateDatabase)
            {
                var target = One(e => e.ProductID == product.ProductID);

                if (target != null)
                {
                    target.ProductName = product.ProductName;
                    target.UnitPrice = product.UnitPrice;
                    target.UnitsInStock = product.UnitsInStock;
                    target.Discontinued = product.Discontinued;

                    if (product.CategoryID == null)
                    {
                        product.CategoryID = 1;
                    }

                    if (product.Category != null)
                    {
                        product.CategoryID = product.Category.CategoryID;
                    }
                    else
                    {
                        product.Category = new CategoryViewModel()
                        {
                            CategoryID = (int)product.CategoryID,
                            CategoryName = entities.Categories.Where(s => s.CategoryID == product.CategoryID).Select(s => s.CategoryName).First()
                        };
                    }

                    target.CategoryID = product.CategoryID;
                    target.Category = product.Category;
                }
            }
            else
            {
                var entity = new Product();

                entity.ProductID = product.ProductID;
                entity.ProductName = product.ProductName;
                entity.UnitPrice = product.UnitPrice;
                entity.UnitsInStock = (short)product.UnitsInStock;
                entity.Discontinued = product.Discontinued;
                entity.CategoryID = product.CategoryID;

                if (product.Category != null)
                {
                    entity.CategoryID = product.Category.CategoryID;
                }

                entities.Products.Attach(entity);
                entities.Entry(entity).State = EntityState.Modified;
                entities.SaveChanges();
            }
        }

        public void Destroy(ProductViewModel product)
        {
            if (!UpdateDatabase)
            {
                var target = GetAll().FirstOrDefault(p => p.ProductID == product.ProductID);
                if (target != null)
                {
                    GetAll().Remove(target);
                }
            }
            else
            {
                var entity = new Product();

                entity.ProductID = product.ProductID;

                entities.Products.Attach(entity);

                entities.Products.Remove(entity);

                var orderDetails = entities.Order_Details.Where(pd => pd.ProductID == entity.ProductID);

                foreach (var orderDetail in orderDetails)
                {
                    entities.Order_Details.Remove(orderDetail);
                }

                entities.SaveChanges();
            }
        }

        public ProductViewModel One(Func<ProductViewModel, bool> predicate)
        {
            return GetAll().FirstOrDefault(predicate);
        }

        public void Dispose()
        {
            entities.Dispose();
        }
    }
}
```
**ProductViewModel.cs**

```C#
using System.ComponentModel.DataAnnotations;
using System.ComponentModel;
using System;
using System.Web.Mvc;

namespace Kendo.Mvc.Examples.Models
{
    public class ProductViewModel
    {
        [ScaffoldColumn(false)]
        public int ProductID
        {
            get;
            set;
        }

        [Required]
        [DisplayName("Product name")]
        [Remote("IsProductName_Available", "Validation")]
        public string ProductName
        {
            get;
            set;
        }

        [DisplayName("Unit price")]
        [DataType(DataType.Currency)]
        [Range(0, int.MaxValue)]
        public decimal UnitPrice
        {
            get;
            set;
        }

        [DisplayName("Units in stock")]
        [DataType("Integer")]
        [Range(0, int.MaxValue)]
        public int UnitsInStock
        {
            get;
            set;
        }

        public bool Discontinued
        {
            get;
            set;
        }

        [DisplayName("Last supply")]
        [DataType(DataType.Date)]
        public DateTime LastSupply
        {
            get;
            set;
        }

        [DataType("Integer")]
        public int UnitsOnOrder
        {
            get;
            set;
        }

        [UIHint("ClientCategory")]
        public CategoryViewModel Category
        {
            get;
            set;
        }

        public int? CategoryID { get; set; }

        public string QuantityPerUnit { get; set; }
    }
}

```
**ProductViewModelGridPopUp.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.DataAnnotations;
    using System.Linq;
    using System.Web;

    public class ProductViewModelGridPopUp
    {
        [ScaffoldColumn(false)]
        public int ProductID
        {
            get;
            set;
        }

        [Required]
        [Display(Name = "Product name")]
        public string ProductName
        {
            get;
            set;
        }

        [Display(Name = "Unit price")]
        [DataType(DataType.Currency)]
        [Range(0, int.MaxValue)]
        public decimal UnitPrice
        {
            get;
            set;
        }

        [Display(Name = "Units in stock")]
        [DataType("Integer")]
        [Range(0, int.MaxValue)]
        public int UnitsInStock
        {
            get;
            set;
        }

        public bool Discontinued
        {
            get;
            set;
        }

        [ScaffoldColumn(false)]
        [DataType(DataType.Date)]
        public DateTime LastSupply
        {
            get;
            set;
        }
    }
}
```
**ProductViewODataModel.cs**

```C#
using System.ComponentModel.DataAnnotations;
using System.ComponentModel;
using System;
using System.Web.Mvc;

namespace Kendo.Mvc.Examples.Models
{
    public class ProductViewODataModel
    {
        [ScaffoldColumn(false)]
        public int ProductID
        {
            get;
            set;
        }

        [Required]
        [DisplayName("Product name")]
        [Remote("IsProductName_Available", "Validation")]
        public string ProductName
        {
            get;
            set;
        }

        [DisplayName("Unit price")]
        [DataType(DataType.Currency)]
        [Range(0, int.MaxValue)]
        public decimal UnitPrice
        {
            get;
            set;
        }

        [DisplayName("Units in stock")]
        [DataType("Integer")]
        [Range(0, int.MaxValue)]
        public int UnitsInStock
        {
            get;
            set;
        }

        public bool Discontinued
        {
            get;
            set;
        }

        [DataType("Integer")]
        public int UnitsOnOrder
        {
            get;
            set;
        }

        [UIHint("ClientCategory")]
        public CategoryViewModel Category
        {
            get;
            set;
        }

        public int? CategoryID { get; set; }

        public string QuantityPerUnit { get; set; }
    }
}

```
**Projection.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Scheduler
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;
    using Kendo.Mvc.UI;

    public class Projection : ISchedulerEvent
    {
        public string Title { get; set; }

        public string Image { get; set; }

        public string Imdb { get; set; }

        public DateTime Start { get; set; }

        public DateTime End { get; set; }

        public string Description { get; set; }

        public bool IsAllDay { get; set; }

        public string Recurrence { get; set; }

        public string RecurrenceRule { get; set; }

        public string RecurrenceException { get; set; }

        public string StartTimezone { get; set; }

        public string EndTimezone { get; set; }
    }
}
```
**ProteinScoreItem.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class ProteinScoreItem
    {
        public string Name { get; set; }
        public string Abbr { get; set; }
        public int Score { get; set; }

        public ProteinScoreItem(string name, string abbr, int score)
        {
            Name = name;
            Abbr = abbr;
            Score = score;
        }
    }
}
```
**RadioGroupViewModel.cs**

```C#
using Kendo.Mvc.UI;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class RadioGroupViewModel
    {
        public List<IInputGroupItem> Items { get; set; }

        public string RadioGroupValue { get; set; }
    }
}
```
**RangeBarChartsLocalDataViewModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class RangeBarChartsLocalDataViewModel
    {
        public int FromA { get; set; }
        public int ToA { get; set; }
        public int FromB { get; set; }
        public int ToB { get; set; }
        public string Day { get; set; }

        public RangeBarChartsLocalDataViewModel()
        {
        }

        public RangeBarChartsLocalDataViewModel(int fromA, int toA, int fromB, int toB, string day)
        {
            this.FromA = fromA;
            this.ToA = toA;
            this.FromB = fromB;
            this.ToB = toB;
            this.Day = day;
        }
    }
}
```
**Region.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Region
    {
        public Region()
        {
            this.Territories = new HashSet<Territory>();
        }

        public int RegionID { get; set; }
        public string RegionDescription { get; set; }

        public virtual ICollection<Territory> Territories { get; set; }
    }
}

```
**RegionSalesModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models.Chart
{
    public class RegionSalesModel
    {
        public RegionSalesModel(string region, double sales)
        {
            Region = region;
            Sales = sales;
        }

        public string Region { get; set; }
        public double Sales { get; set; }
    }
}
```
**RequestDetail.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class RequestDetail
    {
        public string Caption { get; set; }
        public int? Elapsed { get; set; }
        public string Summary { get; set; }
    }
}
```
**Resource.cs**

```C#
namespace Kendo.Mvc.Examples.Models.TaskBoard
{
    public class Resource
    {
        public string Text { get; set; }
        public string Value { get; set; }
        public string Color { get; set; }
    }
}

```
**ResourceAssignmentViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Gantt
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;

    public class ResourceAssignmentViewModel
    {
        public int ID { get; set; }
        public int TaskID { get; set; }
        public int ResourceID { get; set; }
        public decimal Units { get; set; }

        public GanttResourceAssignment ToEntity()
        {
            return new GanttResourceAssignment()
            {
                ID = ID,
                TaskID = TaskID,
                ResourceID = ResourceID,
                Units = Units
            };
        }
    }
}
```
**ResourceViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Gantt
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;

    public class ResourceViewModel
    {
        public int ID { get; set; }
        public string Name { get; set; }
        public string Color { get; set; }

        public GanttResource ToEntity()
        {
            return new GanttResource
            {
                ID = ID,
                Name = Name,
                Color = Color
            };
        }
    }
}
```
**SalesPerformersModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models.Chart
{
    public class SalesPerformersModel
    {
        public SalesPerformersModel(string salesPerson, int salesAmount)
        {
            SalesPerson = salesPerson;
            SalesAmount = salesAmount;
        }

        public string SalesPerson { get; set; }
        public int SalesAmount { get; set; }
    }
}
```
**Sample.Context.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Data.Entity;
    using System.Data.Entity.Infrastructure;

    public partial class SampleEntities : DbContext
    {
        public SampleEntities()
            : base("name=SampleEntities")
        {
        }

        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            throw new UnintentionalCodeFirstException();
        }

        public DbSet<Category> Categories { get; set; }
        public DbSet<CustomerDemographic> CustomerDemographics { get; set; }
        public DbSet<Customer> Customers { get; set; }
        public DbSet<Employee> Employees { get; set; }
        public DbSet<Intraday> Intradays { get; set; }
        public DbSet<MeetingAttendee> MeetingAttendees { get; set; }
        public DbSet<Meeting> Meetings { get; set; }
        public DbSet<Order_Detail> Order_Details { get; set; }
        public DbSet<Order> Orders { get; set; }
        public DbSet<Product> Products { get; set; }
        public DbSet<Region> Regions { get; set; }
        public DbSet<Shipper> Shippers { get; set; }
        public DbSet<Supplier> Suppliers { get; set; }
        public DbSet<Task> Tasks { get; set; }
        public DbSet<Territory> Territories { get; set; }
        public DbSet<Weather> Weathers { get; set; }
        public DbSet<Stock> Stocks { get; set; }
        public DbSet<GanttDependency> GanttDependencies { get; set; }
        public DbSet<GanttTask> GanttTasks { get; set; }
        public DbSet<UrbanArea> UrbanAreas { get; set; }
        public DbSet<EmployeeDirectory> EmployeeDirectory { get; set; }
        public DbSet<GanttResourceAssignment> GanttResourceAssignments { get; set; }
        public DbSet<GanttResource> GanttResources { get; set; }
        public DbSet<OrgChartConnection> OrgChartConnections { get; set; }
        public DbSet<OrgChartShape> OrgChartShapes { get; set; }
        public DbSet<Country> Countries { get; set; }
        public DbSet<DetailProduct> DetailProducts { get; set; }
    }
}

```
**Sample.Context.tt**

```C#
<#@ template language="C#" debug="false" hostspecific="true"#>
<#@ include file="EF.Utility.CS.ttinclude"#><#@
 output extension=".cs"#><#

const string inputFile = @"Sample.edmx";
var textTransform = DynamicTextTransformation.Create(this);
var code = new CodeGenerationTools(this);
var ef = new MetadataTools(this);
var typeMapper = new TypeMapper(code, ef, textTransform.Errors);
var loader = new EdmMetadataLoader(textTransform.Host, textTransform.Errors);
var itemCollection = loader.CreateEdmItemCollection(inputFile);
var modelNamespace = loader.GetModelNamespace(inputFile);
var codeStringGenerator = new CodeStringGenerator(code, typeMapper, ef);

var container = itemCollection.OfType<EntityContainer>().FirstOrDefault();
if (container == null)
{
    return string.Empty;
}
#>
//------------------------------------------------------------------------------
// <auto-generated>
// <#=GetResourceString("Template_GeneratedCodeCommentLine1")#>
//
// <#=GetResourceString("Template_GeneratedCodeCommentLine2")#>
// <#=GetResourceString("Template_GeneratedCodeCommentLine3")#>
// </auto-generated>
//------------------------------------------------------------------------------

<#

var codeNamespace = code.VsNamespaceSuggestion();
if (!String.IsNullOrEmpty(codeNamespace))
{
#>
namespace <#=code.EscapeNamespace(codeNamespace)#>
{
<#
    PushIndent("    ");
}

#>
using System;
using System.Data.Entity;
using System.Data.Entity.Infrastructure;
<#
if (container.FunctionImports.Any())
{
#>
using System.Data.Objects;
using System.Data.Objects.DataClasses;
using System.Linq;
<#
}
#>

<#=Accessibility.ForType(container)#> partial class <#=code.Escape(container)#> : DbContext
{
    public <#=code.Escape(container)#>()
        : base("name=<#=container.Name#>")
    {
<#
if (!loader.IsLazyLoadingEnabled(container))
{
#>
        this.Configuration.LazyLoadingEnabled = false;
<#
}
#>
    }

    protected override void OnModelCreating(DbModelBuilder modelBuilder)
    {
        throw new UnintentionalCodeFirstException();
    }

<#
    foreach (var entitySet in container.BaseEntitySets.OfType<EntitySet>())
    {
#>
    <#=codeStringGenerator.DbSet(entitySet)#>
<#
    }

    foreach (var edmFunction in container.FunctionImports)
    {
        WriteFunctionImport(typeMapper, codeStringGenerator, edmFunction, modelNamespace, includeMergeOption: false);
    }
#>
}
<#

if (!String.IsNullOrEmpty(codeNamespace))
{
    PopIndent();
#>
}
<#
}
#>
<#+

private void WriteFunctionImport(TypeMapper typeMapper, CodeStringGenerator codeStringGenerator, EdmFunction edmFunction, string modelNamespace, bool includeMergeOption)
{
    if (typeMapper.IsComposable(edmFunction))
    {
#>

    [EdmFunction("<#=edmFunction.NamespaceName#>", "<#=edmFunction.Name#>")]
    <#=codeStringGenerator.ComposableFunctionMethod(edmFunction, modelNamespace)#>
    {
<#+
        codeStringGenerator.WriteFunctionParameters(edmFunction, WriteFunctionParameter);
#>
        <#=codeStringGenerator.ComposableCreateQuery(edmFunction, modelNamespace)#>
    }
<#+
    }
    else
    {
#>

    <#=codeStringGenerator.FunctionMethod(edmFunction, modelNamespace, includeMergeOption)#>
    {
<#+
        codeStringGenerator.WriteFunctionParameters(edmFunction, WriteFunctionParameter);
#>
        <#=codeStringGenerator.ExecuteFunction(edmFunction, modelNamespace, includeMergeOption)#>
    }
<#+
        if (typeMapper.GenerateMergeOptionFunction(edmFunction, includeMergeOption))
        {
            WriteFunctionImport(typeMapper, codeStringGenerator, edmFunction, modelNamespace, includeMergeOption: true);
        }
    }
}

public void WriteFunctionParameter(string name, string isNotNull, string notNullInit, string nullInit)
{
#>
        var <#=name#> = <#=isNotNull#> ?
            <#=notNullInit#> :
            <#=nullInit#>;

<#+
}

public const string TemplateId = "CSharp_DbContext_Context_EF5";

public class CodeStringGenerator
{
    private readonly CodeGenerationTools _code;
    private readonly TypeMapper _typeMapper;
    private readonly MetadataTools _ef;

    public CodeStringGenerator(CodeGenerationTools code, TypeMapper typeMapper, MetadataTools ef)
    {
        ArgumentNotNull(code, "code");
        ArgumentNotNull(typeMapper, "typeMapper");
        ArgumentNotNull(ef, "ef");

        _code = code;
        _typeMapper = typeMapper;
        _ef = ef;
    }

    public string Property(EdmProperty edmProperty)
    {
        return string.Format(
            CultureInfo.InvariantCulture,
            "\{0\} \{1\} \{2\} \{\{ \{3\}get; \{4\}set; \}\}",
            Accessibility.ForProperty(edmProperty),
            _typeMapper.GetTypeName(edmProperty.TypeUsage),
            _code.Escape(edmProperty),
            _code.SpaceAfter(Accessibility.ForGetter(edmProperty)),
            _code.SpaceAfter(Accessibility.ForSetter(edmProperty)));
    }

    public string NavigationProperty(NavigationProperty navigationProperty)
    {
        var endType = _typeMapper.GetTypeName(navigationProperty.ToEndMember.GetEntityType());
        return string.Format(
            CultureInfo.InvariantCulture,
            "\{0\} \{1\} \{2\} \{\{ \{3\}get; \{4\}set; \}\}",
            AccessibilityAndVirtual(Accessibility.ForProperty(navigationProperty)),
            navigationProperty.ToEndMember.RelationshipMultiplicity == RelationshipMultiplicity.Many ? ("ICollection<" + endType + ">") : endType,
            _code.Escape(navigationProperty),
            _code.SpaceAfter(Accessibility.ForGetter(navigationProperty)),
            _code.SpaceAfter(Accessibility.ForSetter(navigationProperty)));
    }

    public string AccessibilityAndVirtual(string accessibility)
    {
        return accessibility + (accessibility != "private" ? " virtual" : "");
    }

    public string EntityClassOpening(EntityType entity)
    {
        return string.Format(
            CultureInfo.InvariantCulture,
            "\{0\} \{1\}partial class \{2\}\{3\}",
            Accessibility.ForType(entity),
            _code.SpaceAfter(_code.AbstractOption(entity)),
            _code.Escape(entity),
            _code.StringBefore(" : ", _typeMapper.GetTypeName(entity.BaseType)));
    }

    public string EnumOpening(SimpleType enumType)
    {
        return string.Format(
            CultureInfo.InvariantCulture,
            "\{0\} enum \{1\} : \{2\}",
            Accessibility.ForType(enumType),
            _code.Escape(enumType),
            _code.Escape(_typeMapper.UnderlyingClrType(enumType)));
        }

    public void WriteFunctionParameters(EdmFunction edmFunction, Action<string, string, string, string> writeParameter)
    {
        var parameters = FunctionImportParameter.Create(edmFunction.Parameters, _code, _ef);
        foreach (var parameter in parameters.Where(p => p.NeedsLocalVariable))
        {
            var isNotNull = parameter.IsNullableOfT ? parameter.FunctionParameterName + ".HasValue" : parameter.FunctionParameterName + " != null";
            var notNullInit = "new ObjectParameter(\"" + parameter.EsqlParameterName + "\", " + parameter.FunctionParameterName + ")";
            var nullInit = "new ObjectParameter(\"" + parameter.EsqlParameterName + "\", typeof(" + parameter.RawClrTypeName + "))";
            writeParameter(parameter.LocalVariableName, isNotNull, notNullInit, nullInit);
        }
    }

    public string ComposableFunctionMethod(EdmFunction edmFunction, string modelNamespace)
    {
        var parameters = _typeMapper.GetParameters(edmFunction);

        return string.Format(
            CultureInfo.InvariantCulture,
            "\{0\} IQueryable<\{1\}> \{2\}\(\{3\})",
            AccessibilityAndVirtual(Accessibility.ForMethod(edmFunction)),
            _typeMapper.GetTypeName(_typeMapper.GetReturnType(edmFunction), modelNamespace),
            _code.Escape(edmFunction),
            string.Join(", ", parameters.Select(p => p.FunctionParameterType + " " + p.FunctionParameterName).ToArray()));
    }

    public string ComposableCreateQuery(EdmFunction edmFunction, string modelNamespace)
    {
        var parameters = _typeMapper.GetParameters(edmFunction);

        return string.Format(
            CultureInfo.InvariantCulture,
            "return ((IObjectContextAdapter)this).ObjectContext.CreateQuery<\{0\}>(\"[\{1\}].[{\2\}](\{3\})\"\{4\});",
            _typeMapper.GetTypeName(_typeMapper.GetReturnType(edmFunction), modelNamespace),
            edmFunction.NamespaceName,
            edmFunction.Name,
            string.Join(", ", parameters.Select(p => "@" + p.EsqlParameterName).ToArray()),
            _code.StringBefore(", ", string.Join(", ", parameters.Select(p => p.ExecuteParameterName).ToArray())));
    }

    public string FunctionMethod(EdmFunction edmFunction, string modelNamespace, bool includeMergeOption)
    {
        var parameters = _typeMapper.GetParameters(edmFunction);
        var returnType = _typeMapper.GetReturnType(edmFunction);

        var paramList = String.Join(", ", parameters.Select(p => p.FunctionParameterType + " " + p.FunctionParameterName).ToArray());
        if (includeMergeOption)
        {
            paramList = _code.StringAfter(paramList, ", ") + "MergeOption mergeOption";
        }

        return string.Format(
            CultureInfo.InvariantCulture,
            "\{0\} \{1\} \{2\}(\{3\})",
            AccessibilityAndVirtual(Accessibility.ForMethod(edmFunction)),
            returnType == null ? "int" : "ObjectResult<" + _typeMapper.GetTypeName(returnType, modelNamespace) + ">",
            _code.Escape(edmFunction),
            paramList);
    }

    public string ExecuteFunction(EdmFunction edmFunction, string modelNamespace, bool includeMergeOption)
    {
        var parameters = _typeMapper.GetParameters(edmFunction);
        var returnType = _typeMapper.GetReturnType(edmFunction);

        var callParams = _code.StringBefore(", ", String.Join(", ", parameters.Select(p => p.ExecuteParameterName).ToArray()));
        if (includeMergeOption)
        {
            callParams = ", mergeOption" + callParams;
        }

        return string.Format(
            CultureInfo.InvariantCulture,
            "return ((IObjectContextAdapter)this).ObjectContext.ExecuteFunction{0}(\"{1}\"{2});",
            returnType == null ? "" : "<" + _typeMapper.GetTypeName(returnType, modelNamespace) + ">",
            edmFunction.Name,
            callParams);
    }

    public string DbSet(EntitySet entitySet)
    {
        return string.Format(
            CultureInfo.InvariantCulture,
            "{0} DbSet<{1}> {2} \{\{ get; set; \}\}",
            Accessibility.ForReadOnlyProperty(entitySet),
            _typeMapper.GetTypeName(entitySet.ElementType),
            _code.Escape(entitySet));
    }

    public string UsingDirectives(bool inHeader, bool includeCollections = true)
    {
        return inHeader == string.IsNullOrEmpty(_code.VsNamespaceSuggestion())
            ? string.Format(
                CultureInfo.InvariantCulture,
                "{0}using System;{1}" +
                "{2}",
                inHeader ? Environment.NewLine : "",
                includeCollections ? (Environment.NewLine + "using System.Collections.Generic;") : "",
                inHeader ? "" : Environment.NewLine)
            : "";
    }
}

public class TypeMapper
{
    private const string ExternalTypeNameAttributeName = @"http://schemas.microsoft.com/ado/2006/04/codegeneration:ExternalTypeName";

    private readonly System.Collections.IList _errors;
    private readonly CodeGenerationTools _code;
    private readonly MetadataTools _ef;

    public TypeMapper(CodeGenerationTools code, MetadataTools ef, System.Collections.IList errors)
    {
        ArgumentNotNull(code, "code");
        ArgumentNotNull(ef, "ef");
        ArgumentNotNull(errors, "errors");

        _code = code;
        _ef = ef;
        _errors = errors;
    }

    public string GetTypeName(TypeUsage typeUsage)
    {
        return typeUsage == null ? null : GetTypeName(typeUsage.EdmType, _ef.IsNullable(typeUsage), modelNamespace: null);
    }

    public string GetTypeName(EdmType edmType)
    {
        return GetTypeName(edmType, isNullable: null, modelNamespace: null);
    }

    public string GetTypeName(TypeUsage typeUsage, string modelNamespace)
    {
        return typeUsage == null ? null : GetTypeName(typeUsage.EdmType, _ef.IsNullable(typeUsage), modelNamespace);
    }

    public string GetTypeName(EdmType edmType, string modelNamespace)
    {
        return GetTypeName(edmType, isNullable: null, modelNamespace: modelNamespace);
    }

    public string GetTypeName(EdmType edmType, bool? isNullable, string modelNamespace)
    {
        if (edmType == null)
        {
            return null;
        }

        var collectionType = edmType as CollectionType;
        if (collectionType != null)
        {
            return String.Format(CultureInfo.InvariantCulture, "ICollection<{0}>", GetTypeName(collectionType.TypeUsage, modelNamespace));
        }

        var typeName = _code.Escape(edmType.MetadataProperties
                                .Where(p => p.Name == ExternalTypeNameAttributeName)
                                .Select(p => (string)p.Value)
                                .FirstOrDefault())
            ?? (modelNamespace != null && edmType.NamespaceName != modelNamespace ?
                _code.CreateFullName(_code.EscapeNamespace(edmType.NamespaceName), _code.Escape(edmType)) :
                _code.Escape(edmType));

        if (edmType is StructuralType)
        {
            return typeName;
        }

        if (edmType is SimpleType)
        {
            var clrType = UnderlyingClrType(edmType);
            if (!IsEnumType(edmType))
            {
                typeName = _code.Escape(clrType);
            }

            return clrType.IsValueType && isNullable == true ?
                String.Format(CultureInfo.InvariantCulture, "Nullable<{0}>", typeName) :
                typeName;
        }

        throw new ArgumentException("edmType");
    }

    public Type UnderlyingClrType(EdmType edmType)
    {
        ArgumentNotNull(edmType, "edmType");

        var primitiveType = edmType as PrimitiveType;
        if (primitiveType != null)
        {
            return primitiveType.ClrEquivalentType;
        }

        if (IsEnumType(edmType))
        {
            return GetEnumUnderlyingType(edmType).ClrEquivalentType;
        }

        return typeof(object);
    }

    public object GetEnumMemberValue(MetadataItem enumMember)
    {
        ArgumentNotNull(enumMember, "enumMember");

        var valueProperty = enumMember.GetType().GetProperty("Value");
        return valueProperty == null ? null : valueProperty.GetValue(enumMember, null);
    }

    public string GetEnumMemberName(MetadataItem enumMember)
    {
        ArgumentNotNull(enumMember, "enumMember");

        var nameProperty = enumMember.GetType().GetProperty("Name");
        return nameProperty == null ? null : (string)nameProperty.GetValue(enumMember, null);
    }

    public System.Collections.IEnumerable GetEnumMembers(EdmType enumType)
    {
        ArgumentNotNull(enumType, "enumType");

        var membersProperty = enumType.GetType().GetProperty("Members");
        return membersProperty != null
            ? (System.Collections.IEnumerable)membersProperty.GetValue(enumType, null)
            : Enumerable.Empty<MetadataItem>();
    }

    public bool EnumIsFlags(EdmType enumType)
    {
        ArgumentNotNull(enumType, "enumType");

        var isFlagsProperty = enumType.GetType().GetProperty("IsFlags");
        return isFlagsProperty != null && (bool)isFlagsProperty.GetValue(enumType, null);
    }

    public bool IsEnumType(GlobalItem edmType)
    {
        ArgumentNotNull(edmType, "edmType");

        return edmType.GetType().Name == "EnumType";
    }

    public PrimitiveType GetEnumUnderlyingType(EdmType enumType)
    {
        ArgumentNotNull(enumType, "enumType");

        return (PrimitiveType)enumType.GetType().GetProperty("UnderlyingType").GetValue(enumType, null);
    }

    public string CreateLiteral(object value)
    {
        if (value == null || value.GetType() != typeof(TimeSpan))
        {
            return _code.CreateLiteral(value);
        }

        return string.Format(CultureInfo.InvariantCulture, "new TimeSpan({0})", ((TimeSpan)value).Ticks);
    }

    public bool VerifyCaseInsensitiveTypeUniqueness(IEnumerable<string> types, string sourceFile)
    {
        ArgumentNotNull(types, "types");
        ArgumentNotNull(sourceFile, "sourceFile");

        var hash = new HashSet<string>(StringComparer.InvariantCultureIgnoreCase);
        if (types.Any(item => !hash.Add(item)))
        {
            _errors.Add(
                new CompilerError(sourceFile, -1, -1, "6023",
                    String.Format(CultureInfo.CurrentCulture, GetResourceString("Template_CaseInsensitiveTypeConflict"))));
            return false;
        }
        return true;
    }

    public IEnumerable<SimpleType> GetEnumItemsToGenerate(IEnumerable<GlobalItem> itemCollection)
    {
        return GetItemsToGenerate<SimpleType>(itemCollection)
            .Where(e => IsEnumType(e));
    }

    public IEnumerable<T> GetItemsToGenerate<T>(IEnumerable<GlobalItem> itemCollection) where T: EdmType
    {
        return itemCollection
            .OfType<T>()
            .Where(i => !i.MetadataProperties.Any(p => p.Name == ExternalTypeNameAttributeName))
            .OrderBy(i => i.Name);
    }

    public IEnumerable<string> GetAllGlobalItems(IEnumerable<GlobalItem> itemCollection)
    {
        return itemCollection
            .Where(i => i is EntityType || i is ComplexType || i is EntityContainer || IsEnumType(i))
            .Select(g => GetGlobalItemName(g));
    }

    public string GetGlobalItemName(GlobalItem item)
    {
        if (item is EdmType)
        {
            return ((EdmType)item).Name;
        }
        else
        {
            return ((EntityContainer)item).Name;
        }
    }

    public IEnumerable<EdmProperty> GetSimpleProperties(EntityType type)
    {
        return type.Properties.Where(p => p.TypeUsage.EdmType is SimpleType && p.DeclaringType == type);
    }

    public IEnumerable<EdmProperty> GetSimpleProperties(ComplexType type)
    {
        return type.Properties.Where(p => p.TypeUsage.EdmType is SimpleType && p.DeclaringType == type);
    }

    public IEnumerable<EdmProperty> GetComplexProperties(EntityType type)
    {
        return type.Properties.Where(p => p.TypeUsage.EdmType is ComplexType && p.DeclaringType == type);
    }

    public IEnumerable<EdmProperty> GetComplexProperties(ComplexType type)
    {
        return type.Properties.Where(p => p.TypeUsage.EdmType is ComplexType && p.DeclaringType == type);
    }

    public IEnumerable<EdmProperty> GetPropertiesWithDefaultValues(EntityType type)
    {
        return type.Properties.Where(p => p.TypeUsage.EdmType is SimpleType && p.DeclaringType == type && p.DefaultValue != null);
    }

    public IEnumerable<EdmProperty> GetPropertiesWithDefaultValues(ComplexType type)
    {
        return type.Properties.Where(p => p.TypeUsage.EdmType is SimpleType && p.DeclaringType == type && p.DefaultValue != null);
    }

    public IEnumerable<NavigationProperty> GetNavigationProperties(EntityType type)
    {
        return type.NavigationProperties.Where(np => np.DeclaringType == type);
    }

    public IEnumerable<NavigationProperty> GetCollectionNavigationProperties(EntityType type)
    {
        return type.NavigationProperties.Where(np => np.DeclaringType == type && np.ToEndMember.RelationshipMultiplicity == RelationshipMultiplicity.Many);
    }

    public FunctionParameter GetReturnParameter(EdmFunction edmFunction)
    {
        ArgumentNotNull(edmFunction, "edmFunction");

        var returnParamsProperty = edmFunction.GetType().GetProperty("ReturnParameters");
        return returnParamsProperty == null
            ? edmFunction.ReturnParameter
            : ((IEnumerable<FunctionParameter>)returnParamsProperty.GetValue(edmFunction, null)).FirstOrDefault();
    }

    public bool IsComposable(EdmFunction edmFunction)
    {
        ArgumentNotNull(edmFunction, "edmFunction");

        var isComposableProperty = edmFunction.GetType().GetProperty("IsComposableAttribute");
        return isComposableProperty != null && (bool)isComposableProperty.GetValue(edmFunction, null);
    }

    public IEnumerable<FunctionImportParameter> GetParameters(EdmFunction edmFunction)
    {
        return FunctionImportParameter.Create(edmFunction.Parameters, _code, _ef);
    }

    public TypeUsage GetReturnType(EdmFunction edmFunction)
    {
        var returnParam = GetReturnParameter(edmFunction);
        return returnParam == null ? null : _ef.GetElementType(returnParam.TypeUsage);
    }

    public bool GenerateMergeOptionFunction(EdmFunction edmFunction, bool includeMergeOption)
    {
        var returnType = GetReturnType(edmFunction);
        return !includeMergeOption && returnType != null && returnType.EdmType.BuiltInTypeKind == BuiltInTypeKind.EntityType;
    }
}

public class EdmMetadataLoader
{
    private readonly IDynamicHost _host;
    private readonly System.Collections.IList _errors;

    public EdmMetadataLoader(IDynamicHost host, System.Collections.IList errors)
    {
        ArgumentNotNull(host, "host");
        ArgumentNotNull(errors, "errors");

        _host = host;
        _errors = errors;
    }

    public IEnumerable<GlobalItem> CreateEdmItemCollection(string sourcePath)
    {
        ArgumentNotNull(sourcePath, "sourcePath");

        if (!ValidateInputPath(sourcePath))
        {
            return new EdmItemCollection();
        }

        var schemaElement = LoadRootElement(_host.ResolvePath(sourcePath));
        if (schemaElement != null)
        {
            using (var reader = schemaElement.CreateReader())
            {
                IList<EdmSchemaError> errors;
                var itemCollection = MetadataItemCollectionFactory.CreateEdmItemCollection(new[] { reader }, out errors);

                ProcessErrors(errors, sourcePath);

                return itemCollection;
            }
        }
        return new EdmItemCollection();
    }

    public string GetModelNamespace(string sourcePath)
    {
        ArgumentNotNull(sourcePath, "sourcePath");

        if (!ValidateInputPath(sourcePath))
        {
            return string.Empty;
        }

        var model = LoadRootElement(_host.ResolvePath(sourcePath));
        if (model == null)
        {
            return string.Empty;
        }

        var attribute = model.Attribute("Namespace");
        return attribute != null ? attribute.Value : "";
    }

    private bool ValidateInputPath(string sourcePath)
    {
        if (sourcePath == "$" + "edmxInputFile" + "$")
        {
            _errors.Add(
                new CompilerError(_host.TemplateFile ?? sourcePath, 0, 0, string.Empty,
                    GetResourceString("Template_ReplaceVsItemTemplateToken")));
            return false;
        }

        return true;
    }

    public XElement LoadRootElement(string sourcePath)
    {
        ArgumentNotNull(sourcePath, "sourcePath");

        var root = XElement.Load(sourcePath, LoadOptions.SetBaseUri | LoadOptions.SetLineInfo);
        return root.Elements()
            .Where(e => e.Name.LocalName == "Runtime")
            .Elements()
            .Where(e => e.Name.LocalName == "ConceptualModels")
            .Elements()
            .Where(e => e.Name.LocalName == "Schema")
            .FirstOrDefault()
                ?? root;
    }

    private void ProcessErrors(IEnumerable<EdmSchemaError> errors, string sourceFilePath)
    {
        foreach (var error in errors)
        {
            _errors.Add(
                new CompilerError(
                    error.SchemaLocation ?? sourceFilePath,
                    error.Line,
                    error.Column,
                    error.ErrorCode.ToString(CultureInfo.InvariantCulture),
                    error.Message)
                {
                    IsWarning = error.Severity == EdmSchemaErrorSeverity.Warning
                });
        }
    }

    public bool IsLazyLoadingEnabled(EntityContainer container)
    {
        string lazyLoadingAttributeValue;
        var lazyLoadingAttributeName = MetadataConstants.EDM_ANNOTATION_09_02 + ":LazyLoadingEnabled";
        bool isLazyLoading;
        return !MetadataTools.TryGetStringMetadataPropertySetting(container, lazyLoadingAttributeName, out lazyLoadingAttributeValue)
            || !bool.TryParse(lazyLoadingAttributeValue, out isLazyLoading)
            || isLazyLoading;
    }
}

public static void ArgumentNotNull<T>(T arg, string name) where T : class
{
    if (arg == null)
    {
        throw new ArgumentNullException(name);
    }
}

private static readonly Lazy<System.Resources.ResourceManager> ResourceManager =
    new Lazy<System.Resources.ResourceManager>(
        () => new System.Resources.ResourceManager("System.Data.Entity.Design", typeof(MetadataItemCollectionFactory).Assembly), isThreadSafe: true);

public static string GetResourceString(string resourceName)
{
    ArgumentNotNull(resourceName, "resourceName");

    return ResourceManager.Value.GetString(resourceName, null);
}

#>
```
**Sample.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------


```
**Sample.Designer.cs**

```C#
// T4 code generation is enabled for model 'C:\KendoRepo\kendo\wrappers\mvc\demos\Kendo.Mvc.Examples\Models\Sample.edmx'.
// To enable legacy code generation, change the value of the 'Code Generation Strategy' designer
// property to 'Legacy ObjectContext'. This property is available in the Properties Window when the model
// is open in the designer.

// If no context and entity classes have been generated, it may be because you created an empty model but
// have not yet chosen which version of Entity Framework to use. To generate a context class and entity
// classes for your model, open the model in the designer, right-click on the designer surface, and
// select 'Update Model from Database...', 'Generate Database from Model...', or 'Add Code Generation
// Item...'.
```
**Sample.edmx**

```C#
<?xml version="1.0" encoding="utf-8"?>
<edmx:Edmx Version="3.0" xmlns:edmx="http://schemas.microsoft.com/ado/2009/11/edmx">
  <!-- EF Runtime content -->
  <edmx:Runtime>
    <!-- SSDL content -->
    <edmx:StorageModels>
    <Schema Namespace="SampleModel.Store" Provider="System.Data.SqlClient" ProviderManifestToken="2008" Alias="Self" xmlns:store="http://schemas.microsoft.com/ado/2007/12/edm/EntityStoreSchemaGenerator" xmlns:customannotation="http://schemas.microsoft.com/ado/2013/11/edm/customannotation" xmlns="http://schemas.microsoft.com/ado/2009/11/edm/ssdl">
        <EntityType Name="Categories">
          <Key>
            <PropertyRef Name="CategoryID" />
          </Key>
          <Property Name="CategoryID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="CategoryName" Type="nvarchar" MaxLength="15" Nullable="false" />
          <Property Name="Description" Type="ntext" />
          <Property Name="Picture" Type="image" />
        </EntityType>
        <EntityType Name="Countries">
          <Key>
            <PropertyRef Name="CountryID" />
          </Key>
          <Property Name="CountryID" Type="tinyint" Nullable="false" />
          <Property Name="CountryNameShort" Type="nvarchar" MaxLength="3" Nullable="false" />
          <Property Name="CountryNameLong" Type="nvarchar" MaxLength="40" Nullable="false" />
        </EntityType>
        <EntityType Name="CustomerCustomerDemo">
          <Key>
            <PropertyRef Name="CustomerID" />
            <PropertyRef Name="CustomerTypeID" />
          </Key>
          <Property Name="CustomerID" Type="nchar" MaxLength="5" Nullable="false" />
          <Property Name="CustomerTypeID" Type="nchar" MaxLength="10" Nullable="false" />
        </EntityType>
        <EntityType Name="CustomerDemographics">
          <Key>
            <PropertyRef Name="CustomerTypeID" />
          </Key>
          <Property Name="CustomerTypeID" Type="nchar" MaxLength="10" Nullable="false" />
          <Property Name="CustomerDesc" Type="ntext" />
        </EntityType>
        <EntityType Name="Customers">
          <Key>
            <PropertyRef Name="CustomerID" />
          </Key>
          <Property Name="CustomerID" Type="nchar" MaxLength="5" Nullable="false" />
          <Property Name="CompanyName" Type="nvarchar" MaxLength="40" Nullable="false" />
          <Property Name="ContactName" Type="nvarchar" MaxLength="30" />
          <Property Name="ContactTitle" Type="nvarchar" MaxLength="30" />
          <Property Name="Address" Type="nvarchar" MaxLength="60" />
          <Property Name="City" Type="nvarchar" MaxLength="15" />
          <Property Name="Region" Type="nvarchar" MaxLength="15" />
          <Property Name="PostalCode" Type="nvarchar" MaxLength="10" />
          <Property Name="Country" Type="nvarchar" MaxLength="15" />
          <Property Name="Phone" Type="nvarchar" MaxLength="24" />
          <Property Name="Fax" Type="nvarchar" MaxLength="24" />
          <Property Name="Bool" Type="bit" />
        </EntityType>
        <EntityType Name="DetailProducts">
          <Key>
            <PropertyRef Name="ProductID" />
          </Key>
          <Property Name="ProductID" Type="int" Nullable="false" />
          <Property Name="ProductName" Type="nvarchar" MaxLength="40" Nullable="false" />
          <Property Name="UnitPrice" Type="decimal" Precision="5" Scale="2" />
          <Property Name="UnitsInStock" Type="smallint" />
          <Property Name="QuantityPerUnit" Type="nvarchar" MaxLength="20" />
          <Property Name="Discontinued" Type="bit" Nullable="false" />
          <Property Name="UnitsOnOrder" Type="int" />
          <Property Name="CategoryID" Type="int" />
          <Property Name="CountryID" Type="tinyint" />
          <Property Name="CustomerRating" Type="tinyint" />
          <Property Name="TargetSales" Type="int" />
          <Property Name="LastSupply" Type="datetime" />
        </EntityType>
        <EntityType Name="EmployeeDirectory">
          <Key>
            <PropertyRef Name="EmployeeID" />
          </Key>
          <Property Name="EmployeeID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="FirstName" Type="varchar" MaxLength="255" />
          <Property Name="LastName" Type="varchar" MaxLength="255" />
          <Property Name="ReportsTo" Type="int" />
          <Property Name="Address" Type="varchar" MaxLength="255" />
          <Property Name="City" Type="varchar" MaxLength="255" />
          <Property Name="Country" Type="varchar" MaxLength="100" />
          <Property Name="Phone" Type="varchar" MaxLength="100" />
          <Property Name="Extension" Type="int" />
          <Property Name="BirthDate" Type="datetime" />
          <Property Name="HireDate" Type="datetime" />
          <Property Name="Position" Type="nvarchar" MaxLength="255" />
        </EntityType>
        <EntityType Name="Employees">
          <Key>
            <PropertyRef Name="EmployeeID" />
          </Key>
          <Property Name="EmployeeID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="LastName" Type="nvarchar" MaxLength="20" Nullable="false" />
          <Property Name="FirstName" Type="nvarchar" MaxLength="10" Nullable="false" />
          <Property Name="Title" Type="nvarchar" MaxLength="30" />
          <Property Name="TitleOfCourtesy" Type="nvarchar" MaxLength="25" />
          <Property Name="BirthDate" Type="datetime" />
          <Property Name="HireDate" Type="datetime" />
          <Property Name="Address" Type="nvarchar" MaxLength="60" />
          <Property Name="City" Type="nvarchar" MaxLength="15" />
          <Property Name="Region" Type="nvarchar" MaxLength="15" />
          <Property Name="PostalCode" Type="nvarchar" MaxLength="10" />
          <Property Name="Country" Type="nvarchar" MaxLength="15" />
          <Property Name="HomePhone" Type="nvarchar" MaxLength="24" />
          <Property Name="Extension" Type="nvarchar" MaxLength="4" />
          <Property Name="Photo" Type="image" />
          <Property Name="Notes" Type="ntext" />
          <Property Name="ReportsTo" Type="int" />
          <Property Name="PhotoPath" Type="nvarchar" MaxLength="255" />
        </EntityType>
        <EntityType Name="EmployeeTerritories">
          <Key>
            <PropertyRef Name="EmployeeID" />
            <PropertyRef Name="TerritoryID" />
          </Key>
          <Property Name="EmployeeID" Type="int" Nullable="false" />
          <Property Name="TerritoryID" Type="nvarchar" MaxLength="20" Nullable="false" />
        </EntityType>
        <EntityType Name="GanttDependencies">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Name="ID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="PredecessorID" Type="int" Nullable="false" />
          <Property Name="SuccessorID" Type="int" Nullable="false" />
          <Property Name="Type" Type="int" Nullable="false" />
        </EntityType>
        <EntityType Name="GanttResourceAssignments">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Name="ID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="TaskID" Type="int" Nullable="false" />
          <Property Name="ResourceID" Type="int" Nullable="false" />
          <Property Name="Units" Type="decimal" Precision="5" Scale="2" Nullable="false" />
        </EntityType>
        <EntityType Name="GanttResources">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Name="ID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="Name" Type="nvarchar" MaxLength="50" Nullable="false" />
          <Property Name="Color" Type="nchar" MaxLength="10" />
        </EntityType>
        <EntityType Name="GanttTasks">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Name="ID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="ParentID" Type="int" />
          <Property Name="OrderID" Type="int" Nullable="false" />
          <Property Name="Title" Type="ntext" Nullable="false" />
          <Property Name="Start" Type="datetime" Nullable="false" />
          <Property Name="End" Type="datetime" Nullable="false" />
          <Property Name="PercentComplete" Type="decimal" Precision="5" Scale="2" Nullable="false" />
          <Property Name="Expanded" Type="bit" Nullable="false" />
          <Property Name="Summary" Type="bit" Nullable="false" />
        </EntityType>
        <EntityType Name="Intraday">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Name="ID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="Symbol" Type="varchar" MaxLength="10" Nullable="false" />
          <Property Name="Date" Type="datetime" Nullable="false" />
          <Property Name="Open" Type="decimal" Precision="9" Scale="3" Nullable="false" />
          <Property Name="High" Type="decimal" Precision="9" Scale="3" Nullable="false" />
          <Property Name="Low" Type="decimal" Precision="9" Scale="3" Nullable="false" />
          <Property Name="Close" Type="decimal" Precision="9" Scale="3" Nullable="false" />
          <Property Name="Volume" Type="bigint" Nullable="false" />
        </EntityType>
        <EntityType Name="MeetingAttendees">
          <Key>
            <PropertyRef Name="MeetingID" />
            <PropertyRef Name="AttendeeID" />
          </Key>
          <Property Name="MeetingID" Type="int" Nullable="false" />
          <Property Name="AttendeeID" Type="int" Nullable="false" />
        </EntityType>
        <EntityType Name="Meetings">
          <Key>
            <PropertyRef Name="MeetingID" />
          </Key>
          <Property Name="MeetingID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="Start" Type="datetime" Nullable="false" />
          <Property Name="End" Type="datetime" Nullable="false" />
          <Property Name="Title" Type="ntext" Nullable="false" />
          <Property Name="Description" Type="ntext" />
          <Property Name="RoomID" Type="int" />
          <Property Name="IsAllDay" Type="bit" Nullable="false" />
          <Property Name="RecurrenceRule" Type="ntext" />
          <Property Name="RecurrenceID" Type="int" />
          <Property Name="RecurrenceException" Type="ntext" />
          <Property Name="StartTimezone" Type="ntext" />
          <Property Name="EndTimezone" Type="ntext" />
        </EntityType>
        <EntityType Name="Order Details">
          <Key>
            <PropertyRef Name="OrderID" />
            <PropertyRef Name="ProductID" />
          </Key>
          <Property Name="OrderID" Type="int" Nullable="false" />
          <Property Name="ProductID" Type="int" Nullable="false" />
          <Property Name="UnitPrice" Type="decimal" Precision="5" Scale="2" Nullable="false" />
          <Property Name="Quantity" Type="smallint" Nullable="false" />
          <Property Name="Discount" Type="real" Nullable="false" />
        </EntityType>
        <EntityType Name="Orders">
          <Key>
            <PropertyRef Name="OrderID" />
          </Key>
          <Property Name="OrderID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="CustomerID" Type="nchar" MaxLength="5" />
          <Property Name="EmployeeID" Type="int" />
          <Property Name="OrderDate" Type="datetime" />
          <Property Name="RequiredDate" Type="datetime" />
          <Property Name="ShippedDate" Type="datetime" />
          <Property Name="ShipVia" Type="int" />
          <Property Name="Freight" Type="decimal" Precision="6" Scale="2" />
          <Property Name="ShipName" Type="nvarchar" MaxLength="40" />
          <Property Name="ShipAddress" Type="nvarchar" MaxLength="60" />
          <Property Name="ShipCity" Type="nvarchar" MaxLength="15" />
          <Property Name="ShipRegion" Type="nvarchar" MaxLength="15" />
          <Property Name="ShipPostalCode" Type="nvarchar" MaxLength="10" />
          <Property Name="ShipCountry" Type="nvarchar" MaxLength="15" />
        </EntityType>
        <EntityType Name="OrgChartConnections">
          <Key>
            <PropertyRef Name="Id" />
          </Key>
          <Property Name="Id" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="FromShapeId" Type="int" />
          <Property Name="ToShapeId" Type="int" />
          <Property Name="Text" Type="ntext" />
          <Property Name="FromPointX" Type="int" />
          <Property Name="FromPointY" Type="int" />
          <Property Name="ToPointX" Type="int" />
          <Property Name="ToPointY" Type="int" />
        </EntityType>
        <EntityType Name="OrgChartShapes">
          <Key>
            <PropertyRef Name="Id" />
          </Key>
          <Property Name="Id" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="JobTitle" Type="nvarchar" MaxLength="200" />
          <Property Name="Color" Type="nvarchar" MaxLength="50" />
        </EntityType>
        <EntityType Name="Products">
          <Key>
            <PropertyRef Name="ProductID" />
          </Key>
          <Property Name="ProductID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="ProductName" Type="nvarchar" MaxLength="40" Nullable="false" />
          <Property Name="SupplierID" Type="int" />
          <Property Name="CategoryID" Type="int" />
          <Property Name="QuantityPerUnit" Type="nvarchar" MaxLength="20" />
          <Property Name="UnitPrice" Type="decimal" Precision="5" Scale="2" />
          <Property Name="UnitsInStock" Type="smallint" />
          <Property Name="UnitsOnOrder" Type="smallint" />
          <Property Name="ReorderLevel" Type="smallint" />
          <Property Name="Discontinued" Type="bit" Nullable="false" />
        </EntityType>
        <EntityType Name="Region">
          <Key>
            <PropertyRef Name="RegionID" />
          </Key>
          <Property Name="RegionID" Type="int" Nullable="false" />
          <Property Name="RegionDescription" Type="nchar" MaxLength="50" Nullable="false" />
        </EntityType>
        <EntityType Name="Shippers">
          <Key>
            <PropertyRef Name="ShipperID" />
          </Key>
          <Property Name="ShipperID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="CompanyName" Type="nvarchar" MaxLength="40" Nullable="false" />
          <Property Name="Phone" Type="nvarchar" MaxLength="24" />
        </EntityType>
        <EntityType Name="Stock">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Name="ID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="Symbol" Type="varchar" MaxLength="10" Nullable="false" />
          <Property Name="Date" Type="datetime" Nullable="false" />
          <Property Name="Open" Type="decimal" Precision="9" Scale="3" Nullable="false" />
          <Property Name="High" Type="decimal" Precision="9" Scale="3" Nullable="false" />
          <Property Name="Low" Type="decimal" Precision="9" Scale="3" Nullable="false" />
          <Property Name="Close" Type="decimal" Precision="9" Scale="3" Nullable="false" />
          <Property Name="Volume" Type="bigint" Nullable="false" />
        </EntityType>
        <EntityType Name="Suppliers">
          <Key>
            <PropertyRef Name="SupplierID" />
          </Key>
          <Property Name="SupplierID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="CompanyName" Type="nvarchar" MaxLength="40" Nullable="false" />
          <Property Name="ContactName" Type="nvarchar" MaxLength="30" />
          <Property Name="ContactTitle" Type="nvarchar" MaxLength="30" />
          <Property Name="Address" Type="nvarchar" MaxLength="60" />
          <Property Name="City" Type="nvarchar" MaxLength="15" />
          <Property Name="Region" Type="nvarchar" MaxLength="15" />
          <Property Name="PostalCode" Type="nvarchar" MaxLength="10" />
          <Property Name="Country" Type="nvarchar" MaxLength="15" />
          <Property Name="Phone" Type="nvarchar" MaxLength="24" />
          <Property Name="Fax" Type="nvarchar" MaxLength="24" />
          <Property Name="HomePage" Type="ntext" />
        </EntityType>
        <EntityType Name="Tasks">
          <Key>
            <PropertyRef Name="TaskID" />
          </Key>
          <Property Name="TaskID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="Start" Type="datetime" Nullable="false" />
          <Property Name="End" Type="datetime" Nullable="false" />
          <Property Name="Title" Type="ntext" Nullable="false" />
          <Property Name="Description" Type="ntext" />
          <Property Name="OwnerID" Type="int" />
          <Property Name="IsAllDay" Type="bit" Nullable="false" />
          <Property Name="RecurrenceRule" Type="ntext" />
          <Property Name="RecurrenceID" Type="int" />
          <Property Name="RecurrenceException" Type="ntext" />
          <Property Name="StartTimezone" Type="ntext" />
          <Property Name="EndTimezone" Type="ntext" />
        </EntityType>
        <EntityType Name="Territories">
          <Key>
            <PropertyRef Name="TerritoryID" />
          </Key>
          <Property Name="TerritoryID" Type="nvarchar" MaxLength="20" Nullable="false" />
          <Property Name="TerritoryDescription" Type="nchar" MaxLength="50" Nullable="false" />
          <Property Name="RegionID" Type="int" Nullable="false" />
        </EntityType>
        <EntityType Name="UrbanAreas">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Name="ID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="City" Type="nvarchar" MaxLength="256" Nullable="false" />
          <Property Name="Country" Type="nvarchar" MaxLength="256" Nullable="false" />
          <Property Name="Latitude" Type="decimal" Precision="9" Scale="6" Nullable="false" />
          <Property Name="Longitude" Type="decimal" Precision="9" Scale="6" Nullable="false" />
          <Property Name="Country_ISO3" Type="char" MaxLength="3" Nullable="false" />
          <Property Name="Pop1950" Type="int" Nullable="false" />
          <Property Name="Pop1955" Type="int" Nullable="false" />
          <Property Name="Pop1960" Type="int" Nullable="false" />
          <Property Name="Pop1965" Type="int" Nullable="false" />
          <Property Name="Pop1970" Type="int" Nullable="false" />
          <Property Name="Pop1975" Type="int" Nullable="false" />
          <Property Name="Pop1980" Type="int" Nullable="false" />
          <Property Name="Pop1985" Type="int" Nullable="false" />
          <Property Name="Pop1990" Type="int" Nullable="false" />
          <Property Name="Pop1995" Type="int" Nullable="false" />
          <Property Name="Pop2000" Type="int" Nullable="false" />
          <Property Name="Pop2005" Type="int" Nullable="false" />
          <Property Name="Pop2010" Type="int" Nullable="false" />
          <Property Name="Pop2015" Type="int" Nullable="false" />
          <Property Name="Pop2020" Type="int" Nullable="false" />
          <Property Name="Pop2025" Type="int" Nullable="false" />
          <Property Name="Pop2050" Type="int" Nullable="false" />
        </EntityType>
        <!--Errors Found During Generation:
warning 6002: The table/view 'C:\KENDOREPO\KENDO\WRAPPERS\MVC\DEMOS\KENDO.MVC.EXAMPLES\APP_DATA\SAMPLE.MDF.dbo.Weather' does not have a primary key defined. The key has been inferred and the definition was created as a read-only table/view.-->
        <EntityType Name="Weather">
          <Key>
            <PropertyRef Name="ID" />
            <PropertyRef Name="Station" />
            <PropertyRef Name="Date" />
            <PropertyRef Name="TMax" />
            <PropertyRef Name="TMin" />
            <PropertyRef Name="Wind" />
            <PropertyRef Name="Rain" />
          </Key>
          <Property Name="ID" Type="int" StoreGeneratedPattern="Identity" Nullable="false" />
          <Property Name="Station" Type="varchar" MaxLength="255" Nullable="false" />
          <Property Name="Date" Type="datetime" Nullable="false" />
          <Property Name="TMax" Type="decimal" Precision="5" Scale="2" Nullable="false" />
          <Property Name="TMin" Type="decimal" Precision="5" Scale="2" Nullable="false" />
          <Property Name="Wind" Type="decimal" Precision="5" Scale="2" Nullable="false" />
          <Property Name="Gust" Type="decimal" Precision="5" Scale="2" />
          <Property Name="Rain" Type="decimal" Precision="5" Scale="2" Nullable="false" />
          <Property Name="Snow" Type="decimal" Precision="5" Scale="2" />
          <Property Name="Events" Type="varchar" MaxLength="255" />
        </EntityType>
        <Association Name="FK__DetailPro__Categ__12C8C788">
          <End Role="Categories" Type="Self.Categories" Multiplicity="0..1" />
          <End Role="DetailProducts" Type="Self.DetailProducts" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Categories">
              <PropertyRef Name="CategoryID" />
            </Principal>
            <Dependent Role="DetailProducts">
              <PropertyRef Name="CategoryID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK__DetailPro__Count__13BCEBC1">
          <End Role="Countries" Type="Self.Countries" Multiplicity="0..1" />
          <End Role="DetailProducts" Type="Self.DetailProducts" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Countries">
              <PropertyRef Name="CountryID" />
            </Principal>
            <Dependent Role="DetailProducts">
              <PropertyRef Name="CountryID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_CustomerCustomerDemo">
          <End Role="CustomerDemographics" Type="Self.CustomerDemographics" Multiplicity="1" />
          <End Role="CustomerCustomerDemo" Type="Self.CustomerCustomerDemo" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="CustomerDemographics">
              <PropertyRef Name="CustomerTypeID" />
            </Principal>
            <Dependent Role="CustomerCustomerDemo">
              <PropertyRef Name="CustomerTypeID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_CustomerCustomerDemo_Customers">
          <End Role="Customers" Type="Self.Customers" Multiplicity="1" />
          <End Role="CustomerCustomerDemo" Type="Self.CustomerCustomerDemo" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Customers">
              <PropertyRef Name="CustomerID" />
            </Principal>
            <Dependent Role="CustomerCustomerDemo">
              <PropertyRef Name="CustomerID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_EmployeeDirectory_EmployeeDirectory">
          <End Role="EmployeeDirectory" Type="Self.EmployeeDirectory" Multiplicity="0..1" />
          <End Role="EmployeeDirectory1" Type="Self.EmployeeDirectory" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="EmployeeDirectory">
              <PropertyRef Name="EmployeeID" />
            </Principal>
            <Dependent Role="EmployeeDirectory1">
              <PropertyRef Name="ReportsTo" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Employees_Employees">
          <End Role="Employees" Type="Self.Employees" Multiplicity="0..1" />
          <End Role="Employees1" Type="Self.Employees" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Employees">
              <PropertyRef Name="EmployeeID" />
            </Principal>
            <Dependent Role="Employees1">
              <PropertyRef Name="ReportsTo" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_EmployeeTerritories_Employees">
          <End Role="Employees" Type="Self.Employees" Multiplicity="1" />
          <End Role="EmployeeTerritories" Type="Self.EmployeeTerritories" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Employees">
              <PropertyRef Name="EmployeeID" />
            </Principal>
            <Dependent Role="EmployeeTerritories">
              <PropertyRef Name="EmployeeID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_EmployeeTerritories_Territories">
          <End Role="Territories" Type="Self.Territories" Multiplicity="1" />
          <End Role="EmployeeTerritories" Type="Self.EmployeeTerritories" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Territories">
              <PropertyRef Name="TerritoryID" />
            </Principal>
            <Dependent Role="EmployeeTerritories">
              <PropertyRef Name="TerritoryID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_GanttTasks_GanttTasks">
          <End Role="GanttTasks" Type="Self.GanttTasks" Multiplicity="0..1" />
          <End Role="GanttTasks1" Type="Self.GanttTasks" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="GanttTasks">
              <PropertyRef Name="ID" />
            </Principal>
            <Dependent Role="GanttTasks1">
              <PropertyRef Name="ParentID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_MeetingAtendee_Meeting">
          <End Role="Meetings" Type="Self.Meetings" Multiplicity="1" />
          <End Role="MeetingAttendees" Type="Self.MeetingAttendees" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Meetings">
              <PropertyRef Name="MeetingID" />
            </Principal>
            <Dependent Role="MeetingAttendees">
              <PropertyRef Name="MeetingID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Meetings_Meetings">
          <End Role="Meetings" Type="Self.Meetings" Multiplicity="0..1" />
          <End Role="Meetings1" Type="Self.Meetings" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Meetings">
              <PropertyRef Name="MeetingID" />
            </Principal>
            <Dependent Role="Meetings1">
              <PropertyRef Name="RecurrenceID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Order_Details_Orders">
          <End Role="Orders" Type="Self.Orders" Multiplicity="1" />
          <End Role="Order Details" Type="Self.Order Details" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Orders">
              <PropertyRef Name="OrderID" />
            </Principal>
            <Dependent Role="Order Details">
              <PropertyRef Name="OrderID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Order_Details_Products">
          <End Role="Products" Type="Self.Products" Multiplicity="1" />
          <End Role="Order Details" Type="Self.Order Details" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Products">
              <PropertyRef Name="ProductID" />
            </Principal>
            <Dependent Role="Order Details">
              <PropertyRef Name="ProductID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Orders_Customers">
          <End Role="Customers" Type="Self.Customers" Multiplicity="0..1" />
          <End Role="Orders" Type="Self.Orders" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Customers">
              <PropertyRef Name="CustomerID" />
            </Principal>
            <Dependent Role="Orders">
              <PropertyRef Name="CustomerID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Orders_Employees">
          <End Role="Employees" Type="Self.Employees" Multiplicity="0..1" />
          <End Role="Orders" Type="Self.Orders" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Employees">
              <PropertyRef Name="EmployeeID" />
            </Principal>
            <Dependent Role="Orders">
              <PropertyRef Name="EmployeeID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Orders_Shippers">
          <End Role="Shippers" Type="Self.Shippers" Multiplicity="0..1" />
          <End Role="Orders" Type="Self.Orders" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Shippers">
              <PropertyRef Name="ShipperID" />
            </Principal>
            <Dependent Role="Orders">
              <PropertyRef Name="ShipVia" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Products_Categories">
          <End Role="Categories" Type="Self.Categories" Multiplicity="0..1" />
          <End Role="Products" Type="Self.Products" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Categories">
              <PropertyRef Name="CategoryID" />
            </Principal>
            <Dependent Role="Products">
              <PropertyRef Name="CategoryID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Products_Suppliers">
          <End Role="Suppliers" Type="Self.Suppliers" Multiplicity="0..1" />
          <End Role="Products" Type="Self.Products" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Suppliers">
              <PropertyRef Name="SupplierID" />
            </Principal>
            <Dependent Role="Products">
              <PropertyRef Name="SupplierID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Tasks_Tasks">
          <End Role="Tasks" Type="Self.Tasks" Multiplicity="0..1" />
          <End Role="Tasks1" Type="Self.Tasks" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Tasks">
              <PropertyRef Name="TaskID" />
            </Principal>
            <Dependent Role="Tasks1">
              <PropertyRef Name="RecurrenceID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Territories_Region">
          <End Role="Region" Type="Self.Region" Multiplicity="1" />
          <End Role="Territories" Type="Self.Territories" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Region">
              <PropertyRef Name="RegionID" />
            </Principal>
            <Dependent Role="Territories">
              <PropertyRef Name="RegionID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <EntityContainer Name="SampleModelStoreContainer">
          <EntitySet Name="Categories" EntityType="Self.Categories" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Countries" EntityType="Self.Countries" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="CustomerCustomerDemo" EntityType="Self.CustomerCustomerDemo" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="CustomerDemographics" EntityType="Self.CustomerDemographics" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Customers" EntityType="Self.Customers" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="DetailProducts" EntityType="Self.DetailProducts" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="EmployeeDirectory" EntityType="Self.EmployeeDirectory" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Employees" EntityType="Self.Employees" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="EmployeeTerritories" EntityType="Self.EmployeeTerritories" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="GanttDependencies" EntityType="Self.GanttDependencies" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="GanttResourceAssignments" EntityType="Self.GanttResourceAssignments" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="GanttResources" EntityType="Self.GanttResources" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="GanttTasks" EntityType="Self.GanttTasks" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Intraday" EntityType="Self.Intraday" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="MeetingAttendees" EntityType="Self.MeetingAttendees" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Meetings" EntityType="Self.Meetings" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Order Details" EntityType="Self.Order Details" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Orders" EntityType="Self.Orders" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="OrgChartConnections" EntityType="Self.OrgChartConnections" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="OrgChartShapes" EntityType="Self.OrgChartShapes" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Products" EntityType="Self.Products" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Region" EntityType="Self.Region" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Shippers" EntityType="Self.Shippers" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Stock" EntityType="Self.Stock" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Suppliers" EntityType="Self.Suppliers" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Tasks" EntityType="Self.Tasks" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Territories" EntityType="Self.Territories" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="UrbanAreas" EntityType="Self.UrbanAreas" Schema="dbo" store:Type="Tables" />
          <EntitySet Name="Weather" EntityType="Self.Weather" store:Type="Tables" store:Schema="dbo">
            <DefiningQuery>SELECT
[Weather].[ID] AS [ID],
[Weather].[Station] AS [Station],
[Weather].[Date] AS [Date],
[Weather].[TMax] AS [TMax],
[Weather].[TMin] AS [TMin],
[Weather].[Wind] AS [Wind],
[Weather].[Gust] AS [Gust],
[Weather].[Rain] AS [Rain],
[Weather].[Snow] AS [Snow],
[Weather].[Events] AS [Events]
FROM [dbo].[Weather] AS [Weather]</DefiningQuery>
          </EntitySet>
          <AssociationSet Name="FK__DetailPro__Categ__12C8C788" Association="Self.FK__DetailPro__Categ__12C8C788">
            <End Role="Categories" EntitySet="Categories" />
            <End Role="DetailProducts" EntitySet="DetailProducts" />
          </AssociationSet>
          <AssociationSet Name="FK__DetailPro__Count__13BCEBC1" Association="Self.FK__DetailPro__Count__13BCEBC1">
            <End Role="Countries" EntitySet="Countries" />
            <End Role="DetailProducts" EntitySet="DetailProducts" />
          </AssociationSet>
          <AssociationSet Name="FK_CustomerCustomerDemo" Association="Self.FK_CustomerCustomerDemo">
            <End Role="CustomerDemographics" EntitySet="CustomerDemographics" />
            <End Role="CustomerCustomerDemo" EntitySet="CustomerCustomerDemo" />
          </AssociationSet>
          <AssociationSet Name="FK_CustomerCustomerDemo_Customers" Association="Self.FK_CustomerCustomerDemo_Customers">
            <End Role="Customers" EntitySet="Customers" />
            <End Role="CustomerCustomerDemo" EntitySet="CustomerCustomerDemo" />
          </AssociationSet>
          <AssociationSet Name="FK_EmployeeDirectory_EmployeeDirectory" Association="Self.FK_EmployeeDirectory_EmployeeDirectory">
            <End Role="EmployeeDirectory" EntitySet="EmployeeDirectory" />
            <End Role="EmployeeDirectory1" EntitySet="EmployeeDirectory" />
          </AssociationSet>
          <AssociationSet Name="FK_Employees_Employees" Association="Self.FK_Employees_Employees">
            <End Role="Employees" EntitySet="Employees" />
            <End Role="Employees1" EntitySet="Employees" />
          </AssociationSet>
          <AssociationSet Name="FK_EmployeeTerritories_Employees" Association="Self.FK_EmployeeTerritories_Employees">
            <End Role="Employees" EntitySet="Employees" />
            <End Role="EmployeeTerritories" EntitySet="EmployeeTerritories" />
          </AssociationSet>
          <AssociationSet Name="FK_EmployeeTerritories_Territories" Association="Self.FK_EmployeeTerritories_Territories">
            <End Role="Territories" EntitySet="Territories" />
            <End Role="EmployeeTerritories" EntitySet="EmployeeTerritories" />
          </AssociationSet>
          <AssociationSet Name="FK_GanttTasks_GanttTasks" Association="Self.FK_GanttTasks_GanttTasks">
            <End Role="GanttTasks" EntitySet="GanttTasks" />
            <End Role="GanttTasks1" EntitySet="GanttTasks" />
          </AssociationSet>
          <AssociationSet Name="FK_MeetingAtendee_Meeting" Association="Self.FK_MeetingAtendee_Meeting">
            <End Role="Meetings" EntitySet="Meetings" />
            <End Role="MeetingAttendees" EntitySet="MeetingAttendees" />
          </AssociationSet>
          <AssociationSet Name="FK_Meetings_Meetings" Association="Self.FK_Meetings_Meetings">
            <End Role="Meetings" EntitySet="Meetings" />
            <End Role="Meetings1" EntitySet="Meetings" />
          </AssociationSet>
          <AssociationSet Name="FK_Order_Details_Orders" Association="Self.FK_Order_Details_Orders">
            <End Role="Orders" EntitySet="Orders" />
            <End Role="Order Details" EntitySet="Order Details" />
          </AssociationSet>
          <AssociationSet Name="FK_Order_Details_Products" Association="Self.FK_Order_Details_Products">
            <End Role="Products" EntitySet="Products" />
            <End Role="Order Details" EntitySet="Order Details" />
          </AssociationSet>
          <AssociationSet Name="FK_Orders_Customers" Association="Self.FK_Orders_Customers">
            <End Role="Customers" EntitySet="Customers" />
            <End Role="Orders" EntitySet="Orders" />
          </AssociationSet>
          <AssociationSet Name="FK_Orders_Employees" Association="Self.FK_Orders_Employees">
            <End Role="Employees" EntitySet="Employees" />
            <End Role="Orders" EntitySet="Orders" />
          </AssociationSet>
          <AssociationSet Name="FK_Orders_Shippers" Association="Self.FK_Orders_Shippers">
            <End Role="Shippers" EntitySet="Shippers" />
            <End Role="Orders" EntitySet="Orders" />
          </AssociationSet>
          <AssociationSet Name="FK_Products_Categories" Association="Self.FK_Products_Categories">
            <End Role="Categories" EntitySet="Categories" />
            <End Role="Products" EntitySet="Products" />
          </AssociationSet>
          <AssociationSet Name="FK_Products_Suppliers" Association="Self.FK_Products_Suppliers">
            <End Role="Suppliers" EntitySet="Suppliers" />
            <End Role="Products" EntitySet="Products" />
          </AssociationSet>
          <AssociationSet Name="FK_Tasks_Tasks" Association="Self.FK_Tasks_Tasks">
            <End Role="Tasks" EntitySet="Tasks" />
            <End Role="Tasks1" EntitySet="Tasks" />
          </AssociationSet>
          <AssociationSet Name="FK_Territories_Region" Association="Self.FK_Territories_Region">
            <End Role="Region" EntitySet="Region" />
            <End Role="Territories" EntitySet="Territories" />
          </AssociationSet>
        </EntityContainer>
      </Schema></edmx:StorageModels>
    <!-- CSDL content -->
    <edmx:ConceptualModels>
      <Schema Namespace="SampleModel" Alias="Self" p1:UseStrongSpatialTypes="false" xmlns:annotation="http://schemas.microsoft.com/ado/2009/02/edm/annotation" xmlns:p1="http://schemas.microsoft.com/ado/2009/02/edm/annotation" xmlns="http://schemas.microsoft.com/ado/2009/11/edm">
        <EntityContainer Name="SampleEntities" p1:LazyLoadingEnabled="true">
          <EntitySet Name="Categories" EntityType="SampleModel.Category" />
          <EntitySet Name="CustomerDemographics" EntityType="SampleModel.CustomerDemographic" />
          <EntitySet Name="Customers" EntityType="SampleModel.Customer" />
          <EntitySet Name="Employees" EntityType="SampleModel.Employee" />
          <EntitySet Name="Intradays" EntityType="SampleModel.Intraday" />
          <EntitySet Name="MeetingAttendees" EntityType="SampleModel.MeetingAttendee" />
          <EntitySet Name="Meetings" EntityType="SampleModel.Meeting" />
          <EntitySet Name="Order_Details" EntityType="SampleModel.Order_Detail" />
          <EntitySet Name="Orders" EntityType="SampleModel.Order" />
          <EntitySet Name="Products" EntityType="SampleModel.Product" />
          <EntitySet Name="Regions" EntityType="SampleModel.Region" />
          <EntitySet Name="Shippers" EntityType="SampleModel.Shipper" />
          <EntitySet Name="Suppliers" EntityType="SampleModel.Supplier" />
          <EntitySet Name="Tasks" EntityType="SampleModel.Task" />
          <EntitySet Name="Territories" EntityType="SampleModel.Territory" />
          <EntitySet Name="Weathers" EntityType="SampleModel.Weather" />
          <AssociationSet Name="FK_Products_Categories" Association="SampleModel.FK_Products_Categories">
            <End Role="Categories" EntitySet="Categories" />
            <End Role="Products" EntitySet="Products" />
          </AssociationSet>
          <AssociationSet Name="FK_Orders_Customers" Association="SampleModel.FK_Orders_Customers">
            <End Role="Customers" EntitySet="Customers" />
            <End Role="Orders" EntitySet="Orders" />
          </AssociationSet>
          <AssociationSet Name="FK_Employees_Employees" Association="SampleModel.FK_Employees_Employees">
            <End Role="Employees" EntitySet="Employees" />
            <End Role="Employees1" EntitySet="Employees" />
          </AssociationSet>
          <AssociationSet Name="FK_Orders_Employees" Association="SampleModel.FK_Orders_Employees">
            <End Role="Employees" EntitySet="Employees" />
            <End Role="Orders" EntitySet="Orders" />
          </AssociationSet>
          <AssociationSet Name="FK_MeetingAttendee_Meeting" Association="SampleModel.FK_MeetingAttendee_Meeting">
            <End Role="Meetings" EntitySet="Meetings" />
            <End Role="MeetingAttendees" EntitySet="MeetingAttendees" />
          </AssociationSet>
          <AssociationSet Name="FK_Meetings_Meetings" Association="SampleModel.FK_Meetings_Meetings">
            <End Role="Meetings" EntitySet="Meetings" />
            <End Role="Meetings1" EntitySet="Meetings" />
          </AssociationSet>
          <AssociationSet Name="FK_Order_Details_Orders" Association="SampleModel.FK_Order_Details_Orders">
            <End Role="Orders" EntitySet="Orders" />
            <End Role="Order_Details" EntitySet="Order_Details" />
          </AssociationSet>
          <AssociationSet Name="FK_Order_Details_Products" Association="SampleModel.FK_Order_Details_Products">
            <End Role="Products" EntitySet="Products" />
            <End Role="Order_Details" EntitySet="Order_Details" />
          </AssociationSet>
          <AssociationSet Name="FK_Orders_Shippers" Association="SampleModel.FK_Orders_Shippers">
            <End Role="Shippers" EntitySet="Shippers" />
            <End Role="Orders" EntitySet="Orders" />
          </AssociationSet>
          <AssociationSet Name="FK_Products_Suppliers" Association="SampleModel.FK_Products_Suppliers">
            <End Role="Suppliers" EntitySet="Suppliers" />
            <End Role="Products" EntitySet="Products" />
          </AssociationSet>
          <AssociationSet Name="FK_Territories_Region" Association="SampleModel.FK_Territories_Region">
            <End Role="Region" EntitySet="Regions" />
            <End Role="Territories" EntitySet="Territories" />
          </AssociationSet>
          <AssociationSet Name="FK_Tasks_Tasks" Association="SampleModel.FK_Tasks_Tasks">
            <End Role="Tasks" EntitySet="Tasks" />
            <End Role="Tasks1" EntitySet="Tasks" />
          </AssociationSet>
          <AssociationSet Name="CustomerCustomerDemo" Association="SampleModel.CustomerCustomerDemo">
            <End Role="CustomerDemographics" EntitySet="CustomerDemographics" />
            <End Role="Customers" EntitySet="Customers" />
          </AssociationSet>
          <AssociationSet Name="EmployeeTerritories" Association="SampleModel.EmployeeTerritories">
            <End Role="Employees" EntitySet="Employees" />
            <End Role="Territories" EntitySet="Territories" />
          </AssociationSet>
          <EntitySet Name="Stocks" EntityType="SampleModel.Stock" />
          <EntitySet Name="GanttDependencies" EntityType="SampleModel.GanttDependency" />
          <EntitySet Name="GanttTasks" EntityType="SampleModel.GanttTask" />
          <AssociationSet Name="FK_GanttTasks_GanttTasks" Association="SampleModel.FK_GanttTasks_GanttTasks">
            <End Role="GanttTask" EntitySet="GanttTasks" />
            <End Role="GanttTask1" EntitySet="GanttTasks" />
          </AssociationSet>
          <EntitySet Name="UrbanAreas" EntityType="SampleModel.UrbanArea" />
          <EntitySet Name="EmployeeDirectory" EntityType="SampleModel.EmployeeDirectory" />
          <AssociationSet Name="FK_EmployeeDirectory_EmployeeDirectory" Association="SampleModel.FK_EmployeeDirectory_EmployeeDirectory">
            <End Role="EmployeeDirectory" EntitySet="EmployeeDirectory" />
            <End Role="EmployeeDirectory1" EntitySet="EmployeeDirectory" />
          </AssociationSet>
          <EntitySet Name="GanttResourceAssignments" EntityType="SampleModel.GanttResourceAssignment" />
          <EntitySet Name="GanttResources" EntityType="SampleModel.GanttResource" />
          <EntitySet Name="OrgChartConnections" EntityType="SampleModel.OrgChartConnection" />
          <EntitySet Name="OrgChartShapes" EntityType="SampleModel.OrgChartShape" />
          <EntitySet Name="Countries" EntityType="SampleModel.Country" />
          <EntitySet Name="DetailProducts" EntityType="SampleModel.DetailProduct" />
          <AssociationSet Name="FK__DetailPro__Categ__12C8C788" Association="SampleModel.FK__DetailPro__Categ__12C8C788">
            <End Role="Category" EntitySet="Categories" />
            <End Role="DetailProduct" EntitySet="DetailProducts" />
          </AssociationSet>
          <AssociationSet Name="FK__DetailPro__Count__13BCEBC1" Association="SampleModel.FK__DetailPro__Count__13BCEBC1">
            <End Role="Country" EntitySet="Countries" />
            <End Role="DetailProduct" EntitySet="DetailProducts" />
          </AssociationSet>
        </EntityContainer>
        <EntityType Name="Category">
          <Key>
            <PropertyRef Name="CategoryID" />
          </Key>
          <Property Name="CategoryID" Type="Int32" Nullable="false" p1:StoreGeneratedPattern="Identity" />
          <Property Name="CategoryName" Type="String" Nullable="false" MaxLength="15" Unicode="true" FixedLength="false" />
          <Property Name="Description" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <Property Name="Picture" Type="Binary" MaxLength="Max" FixedLength="false" />
          <NavigationProperty Name="Products" Relationship="SampleModel.FK_Products_Categories" FromRole="Categories" ToRole="Products" />
          <NavigationProperty Name="DetailProducts" Relationship="SampleModel.FK__DetailPro__Categ__12C8C788" FromRole="Category" ToRole="DetailProduct" />
        </EntityType>
        <EntityType Name="CustomerDemographic">
          <Key>
            <PropertyRef Name="CustomerTypeID" />
          </Key>
          <Property Name="CustomerTypeID" Type="String" Nullable="false" MaxLength="10" Unicode="true" FixedLength="true" />
          <Property Name="CustomerDesc" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <NavigationProperty Name="Customers" Relationship="SampleModel.CustomerCustomerDemo" FromRole="CustomerDemographics" ToRole="Customers" />
        </EntityType>
        <EntityType Name="Customer">
          <Key>
            <PropertyRef Name="CustomerID" />
          </Key>
          <Property Name="CustomerID" Type="String" Nullable="false" MaxLength="5" Unicode="true" FixedLength="true" />
          <Property Name="CompanyName" Type="String" Nullable="false" MaxLength="40" Unicode="true" FixedLength="false" />
          <Property Name="ContactName" Type="String" MaxLength="30" Unicode="true" FixedLength="false" />
          <Property Name="ContactTitle" Type="String" MaxLength="30" Unicode="true" FixedLength="false" />
          <Property Name="Address" Type="String" MaxLength="60" Unicode="true" FixedLength="false" />
          <Property Name="City" Type="String" MaxLength="15" Unicode="true" FixedLength="false" />
          <Property Name="Region" Type="String" MaxLength="15" Unicode="true" FixedLength="false" />
          <Property Name="PostalCode" Type="String" MaxLength="10" Unicode="true" FixedLength="false" />
          <Property Name="Country" Type="String" MaxLength="15" Unicode="true" FixedLength="false" />
          <Property Name="Phone" Type="String" MaxLength="24" Unicode="true" FixedLength="false" />
          <Property Name="Fax" Type="String" MaxLength="24" Unicode="true" FixedLength="false" />
          <Property Name="Bool" Type="Boolean" />
          <NavigationProperty Name="Orders" Relationship="SampleModel.FK_Orders_Customers" FromRole="Customers" ToRole="Orders" />
          <NavigationProperty Name="CustomerDemographics" Relationship="SampleModel.CustomerCustomerDemo" FromRole="Customers" ToRole="CustomerDemographics" />
        </EntityType>
        <EntityType Name="Employee">
          <Key>
            <PropertyRef Name="EmployeeID" />
          </Key>
          <Property Name="EmployeeID" Type="Int32" Nullable="false" p1:StoreGeneratedPattern="Identity" />
          <Property Name="LastName" Type="String" Nullable="false" MaxLength="20" Unicode="true" FixedLength="false" />
          <Property Name="FirstName" Type="String" Nullable="false" MaxLength="10" Unicode="true" FixedLength="false" />
          <Property Name="Title" Type="String" MaxLength="30" Unicode="true" FixedLength="false" />
          <Property Name="TitleOfCourtesy" Type="String" MaxLength="25" Unicode="true" FixedLength="false" />
          <Property Name="BirthDate" Type="DateTime" Precision="3" />
          <Property Name="HireDate" Type="DateTime" Precision="3" />
          <Property Name="Address" Type="String" MaxLength="60" Unicode="true" FixedLength="false" />
          <Property Name="City" Type="String" MaxLength="15" Unicode="true" FixedLength="false" />
          <Property Name="Region" Type="String" MaxLength="15" Unicode="true" FixedLength="false" />
          <Property Name="PostalCode" Type="String" MaxLength="10" Unicode="true" FixedLength="false" />
          <Property Name="Country" Type="String" MaxLength="15" Unicode="true" FixedLength="false" />
          <Property Name="HomePhone" Type="String" MaxLength="24" Unicode="true" FixedLength="false" />
          <Property Name="Extension" Type="String" MaxLength="4" Unicode="true" FixedLength="false" />
          <Property Name="Photo" Type="Binary" MaxLength="Max" FixedLength="false" />
          <Property Name="Notes" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <Property Name="ReportsTo" Type="Int32" />
          <Property Name="PhotoPath" Type="String" MaxLength="255" Unicode="true" FixedLength="false" />
          <NavigationProperty Name="Employees1" Relationship="SampleModel.FK_Employees_Employees" FromRole="Employees" ToRole="Employees1" />
          <NavigationProperty Name="Employee1" Relationship="SampleModel.FK_Employees_Employees" FromRole="Employees1" ToRole="Employees" />
          <NavigationProperty Name="Orders" Relationship="SampleModel.FK_Orders_Employees" FromRole="Employees" ToRole="Orders" />
          <NavigationProperty Name="Territories" Relationship="SampleModel.EmployeeTerritories" FromRole="Employees" ToRole="Territories" />
        </EntityType>
        <EntityType Name="Intraday">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Name="ID" Type="Int32" Nullable="false" p1:StoreGeneratedPattern="Identity" />
          <Property Name="Symbol" Type="String" Nullable="false" MaxLength="10" Unicode="false" FixedLength="false" />
          <Property Name="Date" Type="DateTime" Nullable="false" Precision="3" />
          <Property Name="Open" Type="Decimal" Nullable="false" Precision="9" Scale="3" />
          <Property Name="High" Type="Decimal" Nullable="false" Precision="9" Scale="3" />
          <Property Name="Low" Type="Decimal" Nullable="false" Precision="9" Scale="3" />
          <Property Name="Close" Type="Decimal" Nullable="false" Precision="9" Scale="3" />
          <Property Name="Volume" Type="Int64" Nullable="false" />
        </EntityType>
        <EntityType Name="MeetingAttendee">
          <Key>
            <PropertyRef Name="MeetingID" />
            <PropertyRef Name="AttendeeID" />
          </Key>
          <Property Name="MeetingID" Type="Int32" Nullable="false" />
          <Property Name="AttendeeID" Type="Int32" Nullable="false" />
          <NavigationProperty Name="Meeting" Relationship="SampleModel.FK_MeetingAttendee_Meeting" FromRole="MeetingAttendees" ToRole="Meetings" />
        </EntityType>
        <EntityType Name="Meeting">
          <Key>
            <PropertyRef Name="MeetingID" />
          </Key>
          <Property Name="MeetingID" Type="Int32" Nullable="false" p1:StoreGeneratedPattern="Identity" />
          <Property Name="Start" Type="DateTime" Nullable="false" Precision="3" />
          <Property Name="End" Type="DateTime" Nullable="false" Precision="3" />
          <Property Name="Title" Type="String" Nullable="false" MaxLength="Max" Unicode="true" FixedLength="false" />
          <Property Name="Description" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <Property Name="RoomID" Type="Int32" />
          <Property Name="IsAllDay" Type="Boolean" Nullable="false" />
          <Property Name="RecurrenceRule" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <Property Name="RecurrenceID" Type="Int32" />
          <Property Name="RecurrenceException" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <Property Name="StartTimezone" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <Property Name="EndTimezone" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <NavigationProperty Name="MeetingAttendees" Relationship="SampleModel.FK_MeetingAttendee_Meeting" FromRole="Meetings" ToRole="MeetingAttendees" />
          <NavigationProperty Name="Meetings1" Relationship="SampleModel.FK_Meetings_Meetings" FromRole="Meetings" ToRole="Meetings1" />
          <NavigationProperty Name="Meeting1" Relationship="SampleModel.FK_Meetings_Meetings" FromRole="Meetings1" ToRole="Meetings" />
        </EntityType>
        <EntityType Name="Order_Detail">
          <Key>
            <PropertyRef Name="OrderID" />
            <PropertyRef Name="ProductID" />
          </Key>
          <Property Name="OrderID" Type="Int32" Nullable="false" />
          <Property Name="ProductID" Type="Int32" Nullable="false" />
          <Property Name="UnitPrice" Type="Decimal" Nullable="false" Precision="5" Scale="2" />
          <Property Name="Quantity" Type="Int16" Nullable="false" />
          <Property Name="Discount" Type="Single" Nullable="false" />
          <NavigationProperty Name="Order" Relationship="SampleModel.FK_Order_Details_Orders" FromRole="Order_Details" ToRole="Orders" />
          <NavigationProperty Name="Product" Relationship="SampleModel.FK_Order_Details_Products" FromRole="Order_Details" ToRole="Products" />
        </EntityType>
        <EntityType Name="Order">
          <Key>
            <PropertyRef Name="OrderID" />
          </Key>
          <Property Name="OrderID" Type="Int32" Nullable="false" p1:StoreGeneratedPattern="Identity" />
          <Property Name="CustomerID" Type="String" MaxLength="5" Unicode="true" FixedLength="true" />
          <Property Name="EmployeeID" Type="Int32" />
          <Property Name="OrderDate" Type="DateTime" Precision="3" />
          <Property Name="RequiredDate" Type="DateTime" Precision="3" />
          <Property Name="ShippedDate" Type="DateTime" Precision="3" />
          <Property Name="ShipVia" Type="Int32" />
          <Property Name="Freight" Type="Decimal" Precision="6" Scale="2" />
          <Property Name="ShipName" Type="String" MaxLength="40" Unicode="true" FixedLength="false" />
          <Property Name="ShipAddress" Type="String" MaxLength="60" Unicode="true" FixedLength="false" />
          <Property Name="ShipCity" Type="String" MaxLength="15" Unicode="true" FixedLength="false" />
          <Property Name="ShipRegion" Type="String" MaxLength="15" Unicode="true" FixedLength="false" />
          <Property Name="ShipPostalCode" Type="String" MaxLength="10" Unicode="true" FixedLength="false" />
          <Property Name="ShipCountry" Type="String" MaxLength="15" Unicode="true" FixedLength="false" />
          <NavigationProperty Name="Customer" Relationship="SampleModel.FK_Orders_Customers" FromRole="Orders" ToRole="Customers" />
          <NavigationProperty Name="Employee" Relationship="SampleModel.FK_Orders_Employees" FromRole="Orders" ToRole="Employees" />
          <NavigationProperty Name="Order_Details" Relationship="SampleModel.FK_Order_Details_Orders" FromRole="Orders" ToRole="Order_Details" />
          <NavigationProperty Name="Shipper" Relationship="SampleModel.FK_Orders_Shippers" FromRole="Orders" ToRole="Shippers" />
        </EntityType>
        <EntityType Name="Product">
          <Key>
            <PropertyRef Name="ProductID" />
          </Key>
          <Property Name="ProductID" Type="Int32" Nullable="false" p1:StoreGeneratedPattern="Identity" />
          <Property Name="ProductName" Type="String" Nullable="false" MaxLength="40" Unicode="true" FixedLength="false" />
          <Property Name="SupplierID" Type="Int32" />
          <Property Name="CategoryID" Type="Int32" />
          <Property Name="QuantityPerUnit" Type="String" MaxLength="20" Unicode="true" FixedLength="false" />
          <Property Name="UnitPrice" Type="Decimal" Precision="5" Scale="2" />
          <Property Name="UnitsInStock" Type="Int16" />
          <Property Name="UnitsOnOrder" Type="Int16" />
          <Property Name="ReorderLevel" Type="Int16" />
          <Property Name="Discontinued" Type="Boolean" Nullable="false" />
          <NavigationProperty Name="Category" Relationship="SampleModel.FK_Products_Categories" FromRole="Products" ToRole="Categories" />
          <NavigationProperty Name="Order_Details" Relationship="SampleModel.FK_Order_Details_Products" FromRole="Products" ToRole="Order_Details" />
          <NavigationProperty Name="Supplier" Relationship="SampleModel.FK_Products_Suppliers" FromRole="Products" ToRole="Suppliers" />
        </EntityType>
        <EntityType Name="Region">
          <Key>
            <PropertyRef Name="RegionID" />
          </Key>
          <Property Name="RegionID" Type="Int32" Nullable="false" />
          <Property Name="RegionDescription" Type="String" Nullable="false" MaxLength="50" Unicode="true" FixedLength="true" />
          <NavigationProperty Name="Territories" Relationship="SampleModel.FK_Territories_Region" FromRole="Region" ToRole="Territories" />
        </EntityType>
        <EntityType Name="Shipper">
          <Key>
            <PropertyRef Name="ShipperID" />
          </Key>
          <Property Name="ShipperID" Type="Int32" Nullable="false" p1:StoreGeneratedPattern="Identity" />
          <Property Name="CompanyName" Type="String" Nullable="false" MaxLength="40" Unicode="true" FixedLength="false" />
          <Property Name="Phone" Type="String" MaxLength="24" Unicode="true" FixedLength="false" />
          <NavigationProperty Name="Orders" Relationship="SampleModel.FK_Orders_Shippers" FromRole="Shippers" ToRole="Orders" />
        </EntityType>
        <EntityType Name="Supplier">
          <Key>
            <PropertyRef Name="SupplierID" />
          </Key>
          <Property Name="SupplierID" Type="Int32" Nullable="false" p1:StoreGeneratedPattern="Identity" />
          <Property Name="CompanyName" Type="String" Nullable="false" MaxLength="40" Unicode="true" FixedLength="false" />
          <Property Name="ContactName" Type="String" MaxLength="30" Unicode="true" FixedLength="false" />
          <Property Name="ContactTitle" Type="String" MaxLength="30" Unicode="true" FixedLength="false" />
          <Property Name="Address" Type="String" MaxLength="60" Unicode="true" FixedLength="false" />
          <Property Name="City" Type="String" MaxLength="15" Unicode="true" FixedLength="false" />
          <Property Name="Region" Type="String" MaxLength="15" Unicode="true" FixedLength="false" />
          <Property Name="PostalCode" Type="String" MaxLength="10" Unicode="true" FixedLength="false" />
          <Property Name="Country" Type="String" MaxLength="15" Unicode="true" FixedLength="false" />
          <Property Name="Phone" Type="String" MaxLength="24" Unicode="true" FixedLength="false" />
          <Property Name="Fax" Type="String" MaxLength="24" Unicode="true" FixedLength="false" />
          <Property Name="HomePage" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <NavigationProperty Name="Products" Relationship="SampleModel.FK_Products_Suppliers" FromRole="Suppliers" ToRole="Products" />
        </EntityType>
        <EntityType Name="Task">
          <Key>
            <PropertyRef Name="TaskID" />
          </Key>
          <Property Name="TaskID" Type="Int32" Nullable="false" p1:StoreGeneratedPattern="Identity" />
          <Property Name="Start" Type="DateTime" Nullable="false" Precision="3" />
          <Property Name="End" Type="DateTime" Nullable="false" Precision="3" />
          <Property Name="Title" Type="String" Nullable="false" MaxLength="Max" Unicode="true" FixedLength="false" />
          <Property Name="Description" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <Property Name="OwnerID" Type="Int32" />
          <Property Name="IsAllDay" Type="Boolean" Nullable="false" />
          <Property Name="RecurrenceRule" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <Property Name="RecurrenceID" Type="Int32" />
          <Property Name="RecurrenceException" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <Property Name="StartTimezone" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <Property Name="EndTimezone" Type="String" MaxLength="Max" Unicode="true" FixedLength="false" />
          <NavigationProperty Name="Tasks1" Relationship="SampleModel.FK_Tasks_Tasks" FromRole="Tasks" ToRole="Tasks1" />
          <NavigationProperty Name="Task1" Relationship="SampleModel.FK_Tasks_Tasks" FromRole="Tasks1" ToRole="Tasks" />
        </EntityType>
        <EntityType Name="Territory">
          <Key>
            <PropertyRef Name="TerritoryID" />
          </Key>
          <Property Name="TerritoryID" Type="String" Nullable="false" MaxLength="20" Unicode="true" FixedLength="false" />
          <Property Name="TerritoryDescription" Type="String" Nullable="false" MaxLength="50" Unicode="true" FixedLength="true" />
          <Property Name="RegionID" Type="Int32" Nullable="false" />
          <NavigationProperty Name="Region" Relationship="SampleModel.FK_Territories_Region" FromRole="Territories" ToRole="Region" />
          <NavigationProperty Name="Employees" Relationship="SampleModel.EmployeeTerritories" FromRole="Territories" ToRole="Employees" />
        </EntityType>
        <EntityType Name="Weather">
          <Key>
            <PropertyRef Name="ID" />
            <PropertyRef Name="Station" />
            <PropertyRef Name="Date" />
            <PropertyRef Name="TMax" />
            <PropertyRef Name="TMin" />
            <PropertyRef Name="Wind" />
            <PropertyRef Name="Rain" />
          </Key>
          <Property Name="ID" Type="Int32" Nullable="false" p1:StoreGeneratedPattern="Identity" />
          <Property Name="Station" Type="String" Nullable="false" MaxLength="255" Unicode="false" FixedLength="false" />
          <Property Name="Date" Type="DateTime" Nullable="false" Precision="3" />
          <Property Name="TMax" Type="Decimal" Nullable="false" Precision="5" Scale="2" />
          <Property Name="TMin" Type="Decimal" Nullable="false" Precision="5" Scale="2" />
          <Property Name="Wind" Type="Decimal" Nullable="false" Precision="5" Scale="2" />
          <Property Name="Gust" Type="Decimal" Precision="5" Scale="2" />
          <Property Name="Rain" Type="Decimal" Nullable="false" Precision="5" Scale="2" />
          <Property Name="Snow" Type="Decimal" Precision="5" Scale="2" />
          <Property Name="Events" Type="String" MaxLength="255" Unicode="false" FixedLength="false" />
        </EntityType>
        <Association Name="FK_Products_Categories">
          <End Role="Categories" Type="SampleModel.Category" Multiplicity="0..1" />
          <End Role="Products" Type="SampleModel.Product" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Categories">
              <PropertyRef Name="CategoryID" />
            </Principal>
            <Dependent Role="Products">
              <PropertyRef Name="CategoryID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Orders_Customers">
          <End Role="Customers" Type="SampleModel.Customer" Multiplicity="0..1" />
          <End Role="Orders" Type="SampleModel.Order" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Customers">
              <PropertyRef Name="CustomerID" />
            </Principal>
            <Dependent Role="Orders">
              <PropertyRef Name="CustomerID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Employees_Employees">
          <End Role="Employees" Type="SampleModel.Employee" Multiplicity="0..1" />
          <End Role="Employees1" Type="SampleModel.Employee" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Employees">
              <PropertyRef Name="EmployeeID" />
            </Principal>
            <Dependent Role="Employees1">
              <PropertyRef Name="ReportsTo" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Orders_Employees">
          <End Role="Employees" Type="SampleModel.Employee" Multiplicity="0..1" />
          <End Role="Orders" Type="SampleModel.Order" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Employees">
              <PropertyRef Name="EmployeeID" />
            </Principal>
            <Dependent Role="Orders">
              <PropertyRef Name="EmployeeID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_MeetingAttendee_Meeting">
          <End Role="Meetings" Type="SampleModel.Meeting" Multiplicity="1" />
          <End Role="MeetingAttendees" Type="SampleModel.MeetingAttendee" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Meetings">
              <PropertyRef Name="MeetingID" />
            </Principal>
            <Dependent Role="MeetingAttendees">
              <PropertyRef Name="MeetingID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Meetings_Meetings">
          <End Role="Meetings" Type="SampleModel.Meeting" Multiplicity="0..1" />
          <End Role="Meetings1" Type="SampleModel.Meeting" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Meetings">
              <PropertyRef Name="MeetingID" />
            </Principal>
            <Dependent Role="Meetings1">
              <PropertyRef Name="RecurrenceID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Order_Details_Orders">
          <End Role="Orders" Type="SampleModel.Order" Multiplicity="1" />
          <End Role="Order_Details" Type="SampleModel.Order_Detail" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Orders">
              <PropertyRef Name="OrderID" />
            </Principal>
            <Dependent Role="Order_Details">
              <PropertyRef Name="OrderID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Order_Details_Products">
          <End Role="Products" Type="SampleModel.Product" Multiplicity="1" />
          <End Role="Order_Details" Type="SampleModel.Order_Detail" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Products">
              <PropertyRef Name="ProductID" />
            </Principal>
            <Dependent Role="Order_Details">
              <PropertyRef Name="ProductID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Orders_Shippers">
          <End Role="Shippers" Type="SampleModel.Shipper" Multiplicity="0..1" />
          <End Role="Orders" Type="SampleModel.Order" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Shippers">
              <PropertyRef Name="ShipperID" />
            </Principal>
            <Dependent Role="Orders">
              <PropertyRef Name="ShipVia" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Products_Suppliers">
          <End Role="Suppliers" Type="SampleModel.Supplier" Multiplicity="0..1" />
          <End Role="Products" Type="SampleModel.Product" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Suppliers">
              <PropertyRef Name="SupplierID" />
            </Principal>
            <Dependent Role="Products">
              <PropertyRef Name="SupplierID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Territories_Region">
          <End Role="Region" Type="SampleModel.Region" Multiplicity="1" />
          <End Role="Territories" Type="SampleModel.Territory" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Region">
              <PropertyRef Name="RegionID" />
            </Principal>
            <Dependent Role="Territories">
              <PropertyRef Name="RegionID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK_Tasks_Tasks">
          <End Role="Tasks" Type="SampleModel.Task" Multiplicity="0..1" />
          <End Role="Tasks1" Type="SampleModel.Task" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Tasks">
              <PropertyRef Name="TaskID" />
            </Principal>
            <Dependent Role="Tasks1">
              <PropertyRef Name="RecurrenceID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="CustomerCustomerDemo">
          <End Role="CustomerDemographics" Type="SampleModel.CustomerDemographic" Multiplicity="*" />
          <End Role="Customers" Type="SampleModel.Customer" Multiplicity="*" />
        </Association>
        <Association Name="EmployeeTerritories">
          <End Role="Employees" Type="SampleModel.Employee" Multiplicity="*" />
          <End Role="Territories" Type="SampleModel.Territory" Multiplicity="*" />
        </Association>
        <EntityType Name="Stock">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Type="Int32" Name="ID" Nullable="false" annotation:StoreGeneratedPattern="Identity" />
          <Property Type="String" Name="Symbol" Nullable="false" MaxLength="10" FixedLength="false" Unicode="false" />
          <Property Type="DateTime" Name="Date" Nullable="false" Precision="3" />
          <Property Type="Decimal" Name="Open" Nullable="false" Precision="9" Scale="3" />
          <Property Type="Decimal" Name="High" Nullable="false" Precision="9" Scale="3" />
          <Property Type="Decimal" Name="Low" Nullable="false" Precision="9" Scale="3" />
          <Property Type="Decimal" Name="Close" Nullable="false" Precision="9" Scale="3" />
          <Property Type="Int64" Name="Volume" Nullable="false" />
        </EntityType>
        <EntityType Name="GanttDependency">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Type="Int32" Name="ID" Nullable="false" annotation:StoreGeneratedPattern="Identity" />
          <Property Type="Int32" Name="PredecessorID" Nullable="false" />
          <Property Type="Int32" Name="SuccessorID" Nullable="false" />
          <Property Type="Int32" Name="Type" Nullable="false" />
        </EntityType>
        <EntityType Name="GanttTask">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Type="Int32" Name="ID" Nullable="false" annotation:StoreGeneratedPattern="Identity" />
          <Property Type="Int32" Name="ParentID" />
          <Property Type="Int32" Name="OrderID" Nullable="false" />
          <Property Type="String" Name="Title" Nullable="false" MaxLength="Max" FixedLength="false" Unicode="true" />
          <Property Type="DateTime" Name="Start" Nullable="false" Precision="3" />
          <Property Type="DateTime" Name="End" Nullable="false" Precision="3" />
          <Property Type="Decimal" Name="PercentComplete" Nullable="false" Precision="5" Scale="2" />
          <Property Type="Boolean" Name="Expanded" Nullable="false" />
          <NavigationProperty Name="GanttTasks1" Relationship="SampleModel.FK_GanttTasks_GanttTasks" FromRole="GanttTask" ToRole="GanttTask1" />
          <NavigationProperty Name="GanttTask1" Relationship="SampleModel.FK_GanttTasks_GanttTasks" FromRole="GanttTask1" ToRole="GanttTask" />
          <Property Type="Boolean" Name="Summary" Nullable="false" />
        </EntityType>
        <Association Name="FK_GanttTasks_GanttTasks">
          <End Type="SampleModel.GanttTask" Role="GanttTask" Multiplicity="0..1" />
          <End Type="SampleModel.GanttTask" Role="GanttTask1" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="GanttTask">
              <PropertyRef Name="ID" />
            </Principal>
            <Dependent Role="GanttTask1">
              <PropertyRef Name="ParentID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <EntityType Name="UrbanArea">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Type="Int32" Name="ID" Nullable="false" annotation:StoreGeneratedPattern="Identity" />
          <Property Type="String" Name="City" Nullable="false" MaxLength="256" FixedLength="false" Unicode="true" />
          <Property Type="String" Name="Country" Nullable="false" MaxLength="256" FixedLength="false" Unicode="true" />
          <Property Type="Decimal" Name="Latitude" Nullable="false" Precision="9" Scale="6" />
          <Property Type="Decimal" Name="Longitude" Nullable="false" Precision="9" Scale="6" />
          <Property Type="String" Name="Country_ISO3" Nullable="false" MaxLength="3" FixedLength="true" Unicode="false" />
          <Property Type="Int32" Name="Pop1950" Nullable="false" />
          <Property Type="Int32" Name="Pop1955" Nullable="false" />
          <Property Type="Int32" Name="Pop1960" Nullable="false" />
          <Property Type="Int32" Name="Pop1965" Nullable="false" />
          <Property Type="Int32" Name="Pop1970" Nullable="false" />
          <Property Type="Int32" Name="Pop1975" Nullable="false" />
          <Property Type="Int32" Name="Pop1980" Nullable="false" />
          <Property Type="Int32" Name="Pop1985" Nullable="false" />
          <Property Type="Int32" Name="Pop1990" Nullable="false" />
          <Property Type="Int32" Name="Pop1995" Nullable="false" />
          <Property Type="Int32" Name="Pop2000" Nullable="false" />
          <Property Type="Int32" Name="Pop2005" Nullable="false" />
          <Property Type="Int32" Name="Pop2010" Nullable="false" />
          <Property Type="Int32" Name="Pop2015" Nullable="false" />
          <Property Type="Int32" Name="Pop2020" Nullable="false" />
          <Property Type="Int32" Name="Pop2025" Nullable="false" />
          <Property Type="Int32" Name="Pop2050" Nullable="false" />
        </EntityType>
        <EntityType Name="EmployeeDirectory">
          <Key>
            <PropertyRef Name="EmployeeID" />
          </Key>
          <Property Type="Int32" Name="EmployeeID" Nullable="false" annotation:StoreGeneratedPattern="Identity" />
          <Property Type="String" Name="FirstName" MaxLength="255" FixedLength="false" Unicode="false" />
          <Property Type="String" Name="LastName" MaxLength="255" FixedLength="false" Unicode="false" />
          <Property Type="Int32" Name="ReportsTo" />
          <Property Type="String" Name="Address" MaxLength="255" FixedLength="false" Unicode="false" />
          <Property Type="String" Name="City" MaxLength="255" FixedLength="false" Unicode="false" />
          <Property Type="String" Name="Country" MaxLength="100" FixedLength="false" Unicode="false" />
          <Property Type="String" Name="Phone" MaxLength="100" FixedLength="false" Unicode="false" />
          <Property Type="Int32" Name="Extension" />
          <Property Type="DateTime" Name="BirthDate" Precision="3" />
          <Property Type="DateTime" Name="HireDate" Precision="3" />
          <Property Type="String" Name="Position" MaxLength="255" FixedLength="false" Unicode="true" />
          <NavigationProperty Name="EmployeeDirectory1" Relationship="SampleModel.FK_EmployeeDirectory_EmployeeDirectory" FromRole="EmployeeDirectory" ToRole="EmployeeDirectory1" />
          <NavigationProperty Name="EmployeeDirectory2" Relationship="SampleModel.FK_EmployeeDirectory_EmployeeDirectory" FromRole="EmployeeDirectory1" ToRole="EmployeeDirectory" />
        </EntityType>
        <Association Name="FK_EmployeeDirectory_EmployeeDirectory">
          <End Type="SampleModel.EmployeeDirectory" Role="EmployeeDirectory" Multiplicity="0..1" />
          <End Type="SampleModel.EmployeeDirectory" Role="EmployeeDirectory1" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="EmployeeDirectory">
              <PropertyRef Name="EmployeeID" />
            </Principal>
            <Dependent Role="EmployeeDirectory1">
              <PropertyRef Name="ReportsTo" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <EntityType Name="GanttResourceAssignment">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Type="Int32" Name="ID" Nullable="false" annotation:StoreGeneratedPattern="Identity" />
          <Property Type="Int32" Name="TaskID" Nullable="false" />
          <Property Type="Int32" Name="ResourceID" Nullable="false" />
          <Property Type="Decimal" Name="Units" Nullable="false" Precision="5" Scale="2" />
        </EntityType>
        <EntityType Name="GanttResource">
          <Key>
            <PropertyRef Name="ID" />
          </Key>
          <Property Type="Int32" Name="ID" Nullable="false" annotation:StoreGeneratedPattern="Identity" />
          <Property Type="String" Name="Name" Nullable="false" MaxLength="50" FixedLength="false" Unicode="true" />
          <Property Type="String" Name="Color" MaxLength="10" FixedLength="true" Unicode="true" />
        </EntityType>
        <EntityType Name="OrgChartConnection">
          <Key>
            <PropertyRef Name="Id" />
          </Key>
          <Property Type="Int32" Name="Id" Nullable="false" annotation:StoreGeneratedPattern="Identity" />
          <Property Type="Int32" Name="FromShapeId" />
          <Property Type="Int32" Name="ToShapeId" />
          <Property Type="String" Name="Text" MaxLength="Max" FixedLength="false" Unicode="true" />
          <Property Type="Int32" Name="FromPointX" />
          <Property Type="Int32" Name="FromPointY" />
          <Property Type="Int32" Name="ToPointX" />
          <Property Type="Int32" Name="ToPointY" />
        </EntityType>
        <EntityType Name="OrgChartShape">
          <Key>
            <PropertyRef Name="Id" />
          </Key>
          <Property Type="Int32" Name="Id" Nullable="false" annotation:StoreGeneratedPattern="Identity" />
          <Property Type="String" Name="JobTitle" MaxLength="200" FixedLength="false" Unicode="true" />
          <Property Type="String" Name="Color" MaxLength="50" FixedLength="false" Unicode="true" />
        </EntityType>
        <EntityType Name="Country">
          <Key>
            <PropertyRef Name="CountryID" />
          </Key>
          <Property Name="CountryID" Type="Byte" Nullable="false" />
          <Property Name="CountryNameShort" Type="String" Nullable="false" MaxLength="3" FixedLength="false" Unicode="true" />
          <Property Name="CountryNameLong" Type="String" Nullable="false" MaxLength="40" FixedLength="false" Unicode="true" />
          <NavigationProperty Name="DetailProducts" Relationship="SampleModel.FK__DetailPro__Count__13BCEBC1" FromRole="Country" ToRole="DetailProduct" />
        </EntityType>
        <EntityType Name="DetailProduct">
          <Key>
            <PropertyRef Name="ProductID" />
          </Key>
          <Property Name="ProductID" Type="Int32" Nullable="false" />
          <Property Name="ProductName" Type="String" Nullable="false" MaxLength="40" FixedLength="false" Unicode="true" />
          <Property Name="UnitPrice" Type="Decimal" Precision="5" Scale="2" />
          <Property Name="UnitsInStock" Type="Int16" />
          <Property Name="QuantityPerUnit" Type="String" MaxLength="20" FixedLength="false" Unicode="true" />
          <Property Name="Discontinued" Type="Boolean" Nullable="false" />
          <Property Name="UnitsOnOrder" Type="Int32" />
          <Property Name="CategoryID" Type="Int32" />
          <Property Name="CountryID" Type="Byte" />
          <Property Name="CustomerRating" Type="Byte" />
          <Property Name="TargetSales" Type="Int32" />
          <Property Name="LastSupply" Type="DateTime" Precision="3" />
          <NavigationProperty Name="Category" Relationship="SampleModel.FK__DetailPro__Categ__12C8C788" FromRole="DetailProduct" ToRole="Category" />
          <NavigationProperty Name="Country" Relationship="SampleModel.FK__DetailPro__Count__13BCEBC1" FromRole="DetailProduct" ToRole="Country" />
        </EntityType>
        <Association Name="FK__DetailPro__Categ__12C8C788">
          <End Type="SampleModel.Category" Role="Category" Multiplicity="0..1" />
          <End Type="SampleModel.DetailProduct" Role="DetailProduct" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Category">
              <PropertyRef Name="CategoryID" />
            </Principal>
            <Dependent Role="DetailProduct">
              <PropertyRef Name="CategoryID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
        <Association Name="FK__DetailPro__Count__13BCEBC1">
          <End Type="SampleModel.Country" Role="Country" Multiplicity="0..1" />
          <End Type="SampleModel.DetailProduct" Role="DetailProduct" Multiplicity="*" />
          <ReferentialConstraint>
            <Principal Role="Country">
              <PropertyRef Name="CountryID" />
            </Principal>
            <Dependent Role="DetailProduct">
              <PropertyRef Name="CountryID" />
            </Dependent>
          </ReferentialConstraint>
        </Association>
      </Schema>
    </edmx:ConceptualModels>
    <!-- C-S mapping content -->
    <edmx:Mappings>
      <Mapping Space="C-S" xmlns="http://schemas.microsoft.com/ado/2009/11/mapping/cs">
        <EntityContainerMapping StorageEntityContainer="SampleModelStoreContainer" CdmEntityContainer="SampleEntities">
          <EntitySetMapping Name="Categories">
            <EntityTypeMapping TypeName="SampleModel.Category">
              <MappingFragment StoreEntitySet="Categories">
                <ScalarProperty Name="CategoryID" ColumnName="CategoryID" />
                <ScalarProperty Name="CategoryName" ColumnName="CategoryName" />
                <ScalarProperty Name="Description" ColumnName="Description" />
                <ScalarProperty Name="Picture" ColumnName="Picture" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="CustomerDemographics">
            <EntityTypeMapping TypeName="SampleModel.CustomerDemographic">
              <MappingFragment StoreEntitySet="CustomerDemographics">
                <ScalarProperty Name="CustomerTypeID" ColumnName="CustomerTypeID" />
                <ScalarProperty Name="CustomerDesc" ColumnName="CustomerDesc" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Customers">
            <EntityTypeMapping TypeName="SampleModel.Customer">
              <MappingFragment StoreEntitySet="Customers">
                <ScalarProperty Name="CustomerID" ColumnName="CustomerID" />
                <ScalarProperty Name="CompanyName" ColumnName="CompanyName" />
                <ScalarProperty Name="ContactName" ColumnName="ContactName" />
                <ScalarProperty Name="ContactTitle" ColumnName="ContactTitle" />
                <ScalarProperty Name="Address" ColumnName="Address" />
                <ScalarProperty Name="City" ColumnName="City" />
                <ScalarProperty Name="Region" ColumnName="Region" />
                <ScalarProperty Name="PostalCode" ColumnName="PostalCode" />
                <ScalarProperty Name="Country" ColumnName="Country" />
                <ScalarProperty Name="Phone" ColumnName="Phone" />
                <ScalarProperty Name="Fax" ColumnName="Fax" />
                <ScalarProperty Name="Bool" ColumnName="Bool" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Employees">
            <EntityTypeMapping TypeName="SampleModel.Employee">
              <MappingFragment StoreEntitySet="Employees">
                <ScalarProperty Name="EmployeeID" ColumnName="EmployeeID" />
                <ScalarProperty Name="LastName" ColumnName="LastName" />
                <ScalarProperty Name="FirstName" ColumnName="FirstName" />
                <ScalarProperty Name="Title" ColumnName="Title" />
                <ScalarProperty Name="TitleOfCourtesy" ColumnName="TitleOfCourtesy" />
                <ScalarProperty Name="BirthDate" ColumnName="BirthDate" />
                <ScalarProperty Name="HireDate" ColumnName="HireDate" />
                <ScalarProperty Name="Address" ColumnName="Address" />
                <ScalarProperty Name="City" ColumnName="City" />
                <ScalarProperty Name="Region" ColumnName="Region" />
                <ScalarProperty Name="PostalCode" ColumnName="PostalCode" />
                <ScalarProperty Name="Country" ColumnName="Country" />
                <ScalarProperty Name="HomePhone" ColumnName="HomePhone" />
                <ScalarProperty Name="Extension" ColumnName="Extension" />
                <ScalarProperty Name="Photo" ColumnName="Photo" />
                <ScalarProperty Name="Notes" ColumnName="Notes" />
                <ScalarProperty Name="ReportsTo" ColumnName="ReportsTo" />
                <ScalarProperty Name="PhotoPath" ColumnName="PhotoPath" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Intradays">
            <EntityTypeMapping TypeName="SampleModel.Intraday">
              <MappingFragment StoreEntitySet="Intraday">
                <ScalarProperty Name="ID" ColumnName="ID" />
                <ScalarProperty Name="Symbol" ColumnName="Symbol" />
                <ScalarProperty Name="Date" ColumnName="Date" />
                <ScalarProperty Name="Open" ColumnName="Open" />
                <ScalarProperty Name="High" ColumnName="High" />
                <ScalarProperty Name="Low" ColumnName="Low" />
                <ScalarProperty Name="Close" ColumnName="Close" />
                <ScalarProperty Name="Volume" ColumnName="Volume" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="MeetingAttendees">
            <EntityTypeMapping TypeName="SampleModel.MeetingAttendee">
              <MappingFragment StoreEntitySet="MeetingAttendees">
                <ScalarProperty Name="MeetingID" ColumnName="MeetingID" />
                <ScalarProperty Name="AttendeeID" ColumnName="AttendeeID" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Meetings">
            <EntityTypeMapping TypeName="SampleModel.Meeting">
              <MappingFragment StoreEntitySet="Meetings">
                <ScalarProperty Name="MeetingID" ColumnName="MeetingID" />
                <ScalarProperty Name="Start" ColumnName="Start" />
                <ScalarProperty Name="End" ColumnName="End" />
                <ScalarProperty Name="Title" ColumnName="Title" />
                <ScalarProperty Name="Description" ColumnName="Description" />
                <ScalarProperty Name="RoomID" ColumnName="RoomID" />
                <ScalarProperty Name="IsAllDay" ColumnName="IsAllDay" />
                <ScalarProperty Name="RecurrenceRule" ColumnName="RecurrenceRule" />
                <ScalarProperty Name="RecurrenceID" ColumnName="RecurrenceID" />
                <ScalarProperty Name="RecurrenceException" ColumnName="RecurrenceException" />
                <ScalarProperty Name="StartTimezone" ColumnName="StartTimezone" />
                <ScalarProperty Name="EndTimezone" ColumnName="EndTimezone" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Order_Details">
            <EntityTypeMapping TypeName="SampleModel.Order_Detail">
              <MappingFragment StoreEntitySet="Order Details">
                <ScalarProperty Name="OrderID" ColumnName="OrderID" />
                <ScalarProperty Name="ProductID" ColumnName="ProductID" />
                <ScalarProperty Name="UnitPrice" ColumnName="UnitPrice" />
                <ScalarProperty Name="Quantity" ColumnName="Quantity" />
                <ScalarProperty Name="Discount" ColumnName="Discount" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Orders">
            <EntityTypeMapping TypeName="SampleModel.Order">
              <MappingFragment StoreEntitySet="Orders">
                <ScalarProperty Name="OrderID" ColumnName="OrderID" />
                <ScalarProperty Name="CustomerID" ColumnName="CustomerID" />
                <ScalarProperty Name="EmployeeID" ColumnName="EmployeeID" />
                <ScalarProperty Name="OrderDate" ColumnName="OrderDate" />
                <ScalarProperty Name="RequiredDate" ColumnName="RequiredDate" />
                <ScalarProperty Name="ShippedDate" ColumnName="ShippedDate" />
                <ScalarProperty Name="ShipVia" ColumnName="ShipVia" />
                <ScalarProperty Name="Freight" ColumnName="Freight" />
                <ScalarProperty Name="ShipName" ColumnName="ShipName" />
                <ScalarProperty Name="ShipAddress" ColumnName="ShipAddress" />
                <ScalarProperty Name="ShipCity" ColumnName="ShipCity" />
                <ScalarProperty Name="ShipRegion" ColumnName="ShipRegion" />
                <ScalarProperty Name="ShipPostalCode" ColumnName="ShipPostalCode" />
                <ScalarProperty Name="ShipCountry" ColumnName="ShipCountry" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Products">
            <EntityTypeMapping TypeName="SampleModel.Product">
              <MappingFragment StoreEntitySet="Products">
                <ScalarProperty Name="ProductID" ColumnName="ProductID" />
                <ScalarProperty Name="ProductName" ColumnName="ProductName" />
                <ScalarProperty Name="SupplierID" ColumnName="SupplierID" />
                <ScalarProperty Name="CategoryID" ColumnName="CategoryID" />
                <ScalarProperty Name="QuantityPerUnit" ColumnName="QuantityPerUnit" />
                <ScalarProperty Name="UnitPrice" ColumnName="UnitPrice" />
                <ScalarProperty Name="UnitsInStock" ColumnName="UnitsInStock" />
                <ScalarProperty Name="UnitsOnOrder" ColumnName="UnitsOnOrder" />
                <ScalarProperty Name="ReorderLevel" ColumnName="ReorderLevel" />
                <ScalarProperty Name="Discontinued" ColumnName="Discontinued" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Regions">
            <EntityTypeMapping TypeName="SampleModel.Region">
              <MappingFragment StoreEntitySet="Region">
                <ScalarProperty Name="RegionID" ColumnName="RegionID" />
                <ScalarProperty Name="RegionDescription" ColumnName="RegionDescription" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Shippers">
            <EntityTypeMapping TypeName="SampleModel.Shipper">
              <MappingFragment StoreEntitySet="Shippers">
                <ScalarProperty Name="ShipperID" ColumnName="ShipperID" />
                <ScalarProperty Name="CompanyName" ColumnName="CompanyName" />
                <ScalarProperty Name="Phone" ColumnName="Phone" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Suppliers">
            <EntityTypeMapping TypeName="SampleModel.Supplier">
              <MappingFragment StoreEntitySet="Suppliers">
                <ScalarProperty Name="SupplierID" ColumnName="SupplierID" />
                <ScalarProperty Name="CompanyName" ColumnName="CompanyName" />
                <ScalarProperty Name="ContactName" ColumnName="ContactName" />
                <ScalarProperty Name="ContactTitle" ColumnName="ContactTitle" />
                <ScalarProperty Name="Address" ColumnName="Address" />
                <ScalarProperty Name="City" ColumnName="City" />
                <ScalarProperty Name="Region" ColumnName="Region" />
                <ScalarProperty Name="PostalCode" ColumnName="PostalCode" />
                <ScalarProperty Name="Country" ColumnName="Country" />
                <ScalarProperty Name="Phone" ColumnName="Phone" />
                <ScalarProperty Name="Fax" ColumnName="Fax" />
                <ScalarProperty Name="HomePage" ColumnName="HomePage" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Tasks">
            <EntityTypeMapping TypeName="SampleModel.Task">
              <MappingFragment StoreEntitySet="Tasks">
                <ScalarProperty Name="TaskID" ColumnName="TaskID" />
                <ScalarProperty Name="Start" ColumnName="Start" />
                <ScalarProperty Name="End" ColumnName="End" />
                <ScalarProperty Name="Title" ColumnName="Title" />
                <ScalarProperty Name="Description" ColumnName="Description" />
                <ScalarProperty Name="OwnerID" ColumnName="OwnerID" />
                <ScalarProperty Name="IsAllDay" ColumnName="IsAllDay" />
                <ScalarProperty Name="RecurrenceRule" ColumnName="RecurrenceRule" />
                <ScalarProperty Name="RecurrenceID" ColumnName="RecurrenceID" />
                <ScalarProperty Name="RecurrenceException" ColumnName="RecurrenceException" />
                <ScalarProperty Name="StartTimezone" ColumnName="StartTimezone" />
                <ScalarProperty Name="EndTimezone" ColumnName="EndTimezone" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Territories">
            <EntityTypeMapping TypeName="SampleModel.Territory">
              <MappingFragment StoreEntitySet="Territories">
                <ScalarProperty Name="TerritoryID" ColumnName="TerritoryID" />
                <ScalarProperty Name="TerritoryDescription" ColumnName="TerritoryDescription" />
                <ScalarProperty Name="RegionID" ColumnName="RegionID" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Weathers">
            <EntityTypeMapping TypeName="SampleModel.Weather">
              <MappingFragment StoreEntitySet="Weather">
                <ScalarProperty Name="ID" ColumnName="ID" />
                <ScalarProperty Name="Station" ColumnName="Station" />
                <ScalarProperty Name="Date" ColumnName="Date" />
                <ScalarProperty Name="TMax" ColumnName="TMax" />
                <ScalarProperty Name="TMin" ColumnName="TMin" />
                <ScalarProperty Name="Wind" ColumnName="Wind" />
                <ScalarProperty Name="Gust" ColumnName="Gust" />
                <ScalarProperty Name="Rain" ColumnName="Rain" />
                <ScalarProperty Name="Snow" ColumnName="Snow" />
                <ScalarProperty Name="Events" ColumnName="Events" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <AssociationSetMapping Name="CustomerCustomerDemo" TypeName="SampleModel.CustomerCustomerDemo" StoreEntitySet="CustomerCustomerDemo">
            <EndProperty Name="CustomerDemographics">
              <ScalarProperty Name="CustomerTypeID" ColumnName="CustomerTypeID" />
            </EndProperty>
            <EndProperty Name="Customers">
              <ScalarProperty Name="CustomerID" ColumnName="CustomerID" />
            </EndProperty>
          </AssociationSetMapping>
          <AssociationSetMapping Name="EmployeeTerritories" TypeName="SampleModel.EmployeeTerritories" StoreEntitySet="EmployeeTerritories">
            <EndProperty Name="Employees">
              <ScalarProperty Name="EmployeeID" ColumnName="EmployeeID" />
            </EndProperty>
            <EndProperty Name="Territories">
              <ScalarProperty Name="TerritoryID" ColumnName="TerritoryID" />
            </EndProperty>
          </AssociationSetMapping>
          <EntitySetMapping Name="Stocks">
            <EntityTypeMapping TypeName="SampleModel.Stock">
              <MappingFragment StoreEntitySet="Stock">
                <ScalarProperty Name="Volume" ColumnName="Volume" />
                <ScalarProperty Name="Close" ColumnName="Close" />
                <ScalarProperty Name="Low" ColumnName="Low" />
                <ScalarProperty Name="High" ColumnName="High" />
                <ScalarProperty Name="Open" ColumnName="Open" />
                <ScalarProperty Name="Date" ColumnName="Date" />
                <ScalarProperty Name="Symbol" ColumnName="Symbol" />
                <ScalarProperty Name="ID" ColumnName="ID" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="GanttDependencies">
            <EntityTypeMapping TypeName="SampleModel.GanttDependency">
              <MappingFragment StoreEntitySet="GanttDependencies">
                <ScalarProperty Name="Type" ColumnName="Type" />
                <ScalarProperty Name="SuccessorID" ColumnName="SuccessorID" />
                <ScalarProperty Name="PredecessorID" ColumnName="PredecessorID" />
                <ScalarProperty Name="ID" ColumnName="ID" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="GanttTasks">
            <EntityTypeMapping TypeName="SampleModel.GanttTask">
              <MappingFragment StoreEntitySet="GanttTasks">
                <ScalarProperty Name="Summary" ColumnName="Summary" />
                <ScalarProperty Name="Expanded" ColumnName="Expanded" />
                <ScalarProperty Name="PercentComplete" ColumnName="PercentComplete" />
                <ScalarProperty Name="End" ColumnName="End" />
                <ScalarProperty Name="Start" ColumnName="Start" />
                <ScalarProperty Name="Title" ColumnName="Title" />
                <ScalarProperty Name="OrderID" ColumnName="OrderID" />
                <ScalarProperty Name="ParentID" ColumnName="ParentID" />
                <ScalarProperty Name="ID" ColumnName="ID" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="UrbanAreas">
            <EntityTypeMapping TypeName="SampleModel.UrbanArea">
              <MappingFragment StoreEntitySet="UrbanAreas">
                <ScalarProperty Name="Pop2050" ColumnName="Pop2050" />
                <ScalarProperty Name="Pop2025" ColumnName="Pop2025" />
                <ScalarProperty Name="Pop2020" ColumnName="Pop2020" />
                <ScalarProperty Name="Pop2015" ColumnName="Pop2015" />
                <ScalarProperty Name="Pop2010" ColumnName="Pop2010" />
                <ScalarProperty Name="Pop2005" ColumnName="Pop2005" />
                <ScalarProperty Name="Pop2000" ColumnName="Pop2000" />
                <ScalarProperty Name="Pop1995" ColumnName="Pop1995" />
                <ScalarProperty Name="Pop1990" ColumnName="Pop1990" />
                <ScalarProperty Name="Pop1985" ColumnName="Pop1985" />
                <ScalarProperty Name="Pop1980" ColumnName="Pop1980" />
                <ScalarProperty Name="Pop1975" ColumnName="Pop1975" />
                <ScalarProperty Name="Pop1970" ColumnName="Pop1970" />
                <ScalarProperty Name="Pop1965" ColumnName="Pop1965" />
                <ScalarProperty Name="Pop1960" ColumnName="Pop1960" />
                <ScalarProperty Name="Pop1955" ColumnName="Pop1955" />
                <ScalarProperty Name="Pop1950" ColumnName="Pop1950" />
                <ScalarProperty Name="Country_ISO3" ColumnName="Country_ISO3" />
                <ScalarProperty Name="Longitude" ColumnName="Longitude" />
                <ScalarProperty Name="Latitude" ColumnName="Latitude" />
                <ScalarProperty Name="Country" ColumnName="Country" />
                <ScalarProperty Name="City" ColumnName="City" />
                <ScalarProperty Name="ID" ColumnName="ID" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="EmployeeDirectory">
            <EntityTypeMapping TypeName="SampleModel.EmployeeDirectory">
              <MappingFragment StoreEntitySet="EmployeeDirectory">
                <ScalarProperty Name="Position" ColumnName="Position" />
                <ScalarProperty Name="HireDate" ColumnName="HireDate" />
                <ScalarProperty Name="BirthDate" ColumnName="BirthDate" />
                <ScalarProperty Name="Extension" ColumnName="Extension" />
                <ScalarProperty Name="Phone" ColumnName="Phone" />
                <ScalarProperty Name="Country" ColumnName="Country" />
                <ScalarProperty Name="City" ColumnName="City" />
                <ScalarProperty Name="Address" ColumnName="Address" />
                <ScalarProperty Name="ReportsTo" ColumnName="ReportsTo" />
                <ScalarProperty Name="LastName" ColumnName="LastName" />
                <ScalarProperty Name="FirstName" ColumnName="FirstName" />
                <ScalarProperty Name="EmployeeID" ColumnName="EmployeeID" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="GanttResourceAssignments">
            <EntityTypeMapping TypeName="SampleModel.GanttResourceAssignment">
              <MappingFragment StoreEntitySet="GanttResourceAssignments">
                <ScalarProperty Name="Units" ColumnName="Units" />
                <ScalarProperty Name="ResourceID" ColumnName="ResourceID" />
                <ScalarProperty Name="TaskID" ColumnName="TaskID" />
                <ScalarProperty Name="ID" ColumnName="ID" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="GanttResources">
            <EntityTypeMapping TypeName="SampleModel.GanttResource">
              <MappingFragment StoreEntitySet="GanttResources">
                <ScalarProperty Name="Color" ColumnName="Color" />
                <ScalarProperty Name="Name" ColumnName="Name" />
                <ScalarProperty Name="ID" ColumnName="ID" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="OrgChartConnections">
            <EntityTypeMapping TypeName="SampleModel.OrgChartConnection">
              <MappingFragment StoreEntitySet="OrgChartConnections">
                <ScalarProperty Name="ToPointY" ColumnName="ToPointY" />
                <ScalarProperty Name="ToPointX" ColumnName="ToPointX" />
                <ScalarProperty Name="FromPointY" ColumnName="FromPointY" />
                <ScalarProperty Name="FromPointX" ColumnName="FromPointX" />
                <ScalarProperty Name="Text" ColumnName="Text" />
                <ScalarProperty Name="ToShapeId" ColumnName="ToShapeId" />
                <ScalarProperty Name="FromShapeId" ColumnName="FromShapeId" />
                <ScalarProperty Name="Id" ColumnName="Id" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="OrgChartShapes">
            <EntityTypeMapping TypeName="SampleModel.OrgChartShape">
              <MappingFragment StoreEntitySet="OrgChartShapes">
                <ScalarProperty Name="Color" ColumnName="Color" />
                <ScalarProperty Name="JobTitle" ColumnName="JobTitle" />
                <ScalarProperty Name="Id" ColumnName="Id" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="Countries">
            <EntityTypeMapping TypeName="SampleModel.Country">
              <MappingFragment StoreEntitySet="Countries">
                <ScalarProperty Name="CountryNameLong" ColumnName="CountryNameLong" />
                <ScalarProperty Name="CountryNameShort" ColumnName="CountryNameShort" />
                <ScalarProperty Name="CountryID" ColumnName="CountryID" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
          <EntitySetMapping Name="DetailProducts">
            <EntityTypeMapping TypeName="SampleModel.DetailProduct">
              <MappingFragment StoreEntitySet="DetailProducts">
                <ScalarProperty Name="LastSupply" ColumnName="LastSupply" />
                <ScalarProperty Name="TargetSales" ColumnName="TargetSales" />
                <ScalarProperty Name="CustomerRating" ColumnName="CustomerRating" />
                <ScalarProperty Name="CountryID" ColumnName="CountryID" />
                <ScalarProperty Name="CategoryID" ColumnName="CategoryID" />
                <ScalarProperty Name="UnitsOnOrder" ColumnName="UnitsOnOrder" />
                <ScalarProperty Name="Discontinued" ColumnName="Discontinued" />
                <ScalarProperty Name="QuantityPerUnit" ColumnName="QuantityPerUnit" />
                <ScalarProperty Name="UnitsInStock" ColumnName="UnitsInStock" />
                <ScalarProperty Name="UnitPrice" ColumnName="UnitPrice" />
                <ScalarProperty Name="ProductName" ColumnName="ProductName" />
                <ScalarProperty Name="ProductID" ColumnName="ProductID" />
              </MappingFragment>
            </EntityTypeMapping>
          </EntitySetMapping>
        </EntityContainerMapping>
      </Mapping>
    </edmx:Mappings>
  </edmx:Runtime>
  <!-- EF Designer content (DO NOT EDIT MANUALLY BELOW HERE) -->
  <Designer xmlns="http://schemas.microsoft.com/ado/2009/11/edmx">
    <Connection>
      <DesignerInfoPropertySet>
        <DesignerProperty Name="MetadataArtifactProcessing" Value="EmbedInOutputAssembly" />
      </DesignerInfoPropertySet>
    </Connection>
    <Options>
      <DesignerInfoPropertySet>
        <DesignerProperty Name="ValidateOnBuild" Value="true" />
        <DesignerProperty Name="EnablePluralization" Value="True" />
        <DesignerProperty Name="IncludeForeignKeysInModel" Value="True" />
        <DesignerProperty Name="CodeGenerationStrategy" Value="None" />
        <DesignerProperty Name="UseLegacyProvider" Value="True" />
      </DesignerInfoPropertySet>
    </Options>
    <!-- Diagram content (shape and connector positions) -->
    <Diagrams></Diagrams>
  </Designer>
</edmx:Edmx>
```
**Sample.edmx.diagram**

```C#
<?xml version="1.0" encoding="utf-8"?>
<edmx:Edmx Version="3.0" xmlns:edmx="http://schemas.microsoft.com/ado/2009/11/edmx">
 <!-- EF Designer content (DO NOT EDIT MANUALLY BELOW HERE) -->
  <edmx:Designer xmlns="http://schemas.microsoft.com/ado/2009/11/edmx">
    <!-- Diagram content (shape and connector positions) -->
    <edmx:Diagrams>
      <Diagram DiagramId="db683a1a9da24938aa445abea7d80740" Name="Diagram1" ZoomLevel="71">
        <EntityTypeShape EntityType="SampleModel.Category" Width="1.5" PointX="3" PointY="19.5" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.CustomerDemographic" Width="1.5" PointX="0.75" PointY="2.5" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.Customer" Width="1.5" PointX="3" PointY="1.375" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.Employee" Width="1.5" PointX="3" PointY="9.25" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.Intraday" Width="1.5" PointX="10.75" PointY="9.75" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.MeetingAttendee" Width="1.5" PointX="8" PointY="8.125" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.Meeting" Width="1.5" PointX="5.75" PointY="7" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.Order_Detail" Width="1.5" PointX="7.5" PointY="2.125" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.Order" Width="1.5" PointX="5.25" PointY="1" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.Product" Width="1.5" PointX="5.25" PointY="20.875" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.Region" Width="1.5" PointX="9.75" PointY="1.125" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.Shipper" Width="1.5" PointX="3" PointY="15.25" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.Supplier" Width="1.5" PointX="3" PointY="22.25" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.Task" Width="1.5" PointX="7.75" PointY="10.75" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.Territory" Width="1.5" PointX="12" PointY="6.875" IsExpanded="true" />
        <EntityTypeShape EntityType="SampleModel.Weather" Width="1.5" PointX="11.75" PointY="0.75" IsExpanded="true" />
        <AssociationConnector Association="SampleModel.FK_Products_Categories" ManuallyRouted="false" />
        <AssociationConnector Association="SampleModel.FK_Orders_Customers" ManuallyRouted="false" />
        <AssociationConnector Association="SampleModel.FK_Employees_Employees" ManuallyRouted="false" />
        <AssociationConnector Association="SampleModel.FK_Orders_Employees" ManuallyRouted="false" />
        <AssociationConnector Association="SampleModel.FK_MeetingAttendee_Meeting" ManuallyRouted="false" />
        <AssociationConnector Association="SampleModel.FK_Meetings_Meetings" ManuallyRouted="false" />
        <AssociationConnector Association="SampleModel.FK_Order_Details_Orders" ManuallyRouted="false" />
        <AssociationConnector Association="SampleModel.FK_Order_Details_Products" ManuallyRouted="false" />
        <AssociationConnector Association="SampleModel.FK_Orders_Shippers" ManuallyRouted="false" />
        <AssociationConnector Association="SampleModel.FK_Products_Suppliers" ManuallyRouted="false" />
        <AssociationConnector Association="SampleModel.FK_Territories_Region" ManuallyRouted="false" />
        <AssociationConnector Association="SampleModel.FK_Tasks_Tasks" ManuallyRouted="false" />
        <AssociationConnector Association="SampleModel.CustomerCustomerDemo" ManuallyRouted="false" />
        <AssociationConnector Association="SampleModel.EmployeeTerritories" ManuallyRouted="false" />
        <EntityTypeShape EntityType="SampleModel.Stock" Width="1.5" PointX="10.431285386174583" PointY="20.458878616084753" />
        <EntityTypeShape EntityType="SampleModel.GanttDependency" Width="1.5" PointX="8.375" PointY="15.5" />
        <EntityTypeShape EntityType="SampleModel.GanttTask" Width="1.5" PointX="10.125" PointY="15.5" />
        <AssociationConnector Association="SampleModel.FK_GanttTasks_GanttTasks" />
        <EntityTypeShape EntityType="SampleModel.UrbanArea" Width="1.5" PointX="1.4793553787653127" PointY="15.978519208719265" />
        <EntityTypeShape EntityType="SampleModel.EmployeeDirectory" Width="1.5" PointX="8.25" PointY="20.5" />
        <AssociationConnector Association="SampleModel.FK_EmployeeDirectory_EmployeeDirectory" />
        <EntityTypeShape EntityType="SampleModel.GanttResourceAssignment" Width="1.5" PointX="11.875" PointY="15.5" />
        <EntityTypeShape EntityType="SampleModel.GanttResource" Width="1.5" PointX="11.875" PointY="17.75" />
        <EntityTypeShape EntityType="SampleModel.OrgChartConnection" Width="1.5" PointX="12.375" PointY="20.5" />
        <EntityTypeShape EntityType="SampleModel.OrgChartShape" Width="1.5" PointX="14.375" PointY="20.5" />
        <EntityTypeShape EntityType="SampleModel.Country" Width="1.5" PointX="3" PointY="6.75" />
        <EntityTypeShape EntityType="SampleModel.DetailProduct" Width="1.5" PointX="5.25" PointY="15.75" />
        <AssociationConnector Association="SampleModel.FK__DetailPro__Categ__12C8C788" />
        <AssociationConnector Association="SampleModel.FK__DetailPro__Count__13BCEBC1" />
      </Diagram>
    </edmx:Diagrams>
  </edmx:Designer>
</edmx:Edmx>
```
**Sample.tt**

```C#
<#@ template language="C#" debug="false" hostspecific="true"#>
<#@ include file="EF.Utility.CS.ttinclude"#><#@
 output extension=".cs"#><#

const string inputFile = @"Sample.edmx";
var textTransform = DynamicTextTransformation.Create(this);
var code = new CodeGenerationTools(this);
var ef = new MetadataTools(this);
var typeMapper = new TypeMapper(code, ef, textTransform.Errors);
var	fileManager = EntityFrameworkTemplateFileManager.Create(this);
var itemCollection = new EdmMetadataLoader(textTransform.Host, textTransform.Errors).CreateEdmItemCollection(inputFile);
var codeStringGenerator = new CodeStringGenerator(code, typeMapper, ef);

if (!typeMapper.VerifyCaseInsensitiveTypeUniqueness(typeMapper.GetAllGlobalItems(itemCollection), inputFile))
{
    return string.Empty;
}

WriteHeader(codeStringGenerator, fileManager);

foreach (var entity in typeMapper.GetItemsToGenerate<EntityType>(itemCollection))
{
    fileManager.StartNewFile(entity.Name + ".cs");
    BeginNamespace(code);
#>
<#=codeStringGenerator.UsingDirectives(inHeader: false)#>
<#=codeStringGenerator.EntityClassOpening(entity)#>
{
<#
    var propertiesWithDefaultValues = typeMapper.GetPropertiesWithDefaultValues(entity);
    var collectionNavigationProperties = typeMapper.GetCollectionNavigationProperties(entity);
    var complexProperties = typeMapper.GetComplexProperties(entity);

    if (propertiesWithDefaultValues.Any() || collectionNavigationProperties.Any() || complexProperties.Any())
    {
#>
    public <#=code.Escape(entity)#>()
    {
<#
        foreach (var edmProperty in propertiesWithDefaultValues)
        {
#>
        this.<#=code.Escape(edmProperty)#> = <#=typeMapper.CreateLiteral(edmProperty.DefaultValue)#>;
<#
        }

        foreach (var navigationProperty in collectionNavigationProperties)
        {
#>
        this.<#=code.Escape(navigationProperty)#> = new HashSet<<#=typeMapper.GetTypeName(navigationProperty.ToEndMember.GetEntityType())#>>();
<#
        }

        foreach (var complexProperty in complexProperties)
        {
#>
        this.<#=code.Escape(complexProperty)#> = new <#=typeMapper.GetTypeName(complexProperty.TypeUsage)#>();
<#
        }
#>
    }

<#
    }

    var simpleProperties = typeMapper.GetSimpleProperties(entity);
    if (simpleProperties.Any())
    {
        foreach (var edmProperty in simpleProperties)
        {
#>
    <#=codeStringGenerator.Property(edmProperty)#>
<#
        }
    }

    if (complexProperties.Any())
    {
#>

<#
        foreach(var complexProperty in complexProperties)
        {
#>
    <#=codeStringGenerator.Property(complexProperty)#>
<#
        }
    }

    var navigationProperties = typeMapper.GetNavigationProperties(entity);
    if (navigationProperties.Any())
    {
#>

<#
        foreach (var navigationProperty in navigationProperties)
        {
#>
    <#=codeStringGenerator.NavigationProperty(navigationProperty)#>
<#
        }
    }
#>
}
<#
    EndNamespace(code);
}

foreach (var complex in typeMapper.GetItemsToGenerate<ComplexType>(itemCollection))
{
    fileManager.StartNewFile(complex.Name + ".cs");
    BeginNamespace(code);
#>
<#=codeStringGenerator.UsingDirectives(inHeader: false, includeCollections: false)#>
<#=Accessibility.ForType(complex)#> partial class <#=code.Escape(complex)#>
{
<#
    var complexProperties = typeMapper.GetComplexProperties(complex);
    var propertiesWithDefaultValues = typeMapper.GetPropertiesWithDefaultValues(complex);

    if (propertiesWithDefaultValues.Any() || complexProperties.Any())
    {
#>
    public <#=code.Escape(complex)#>()
    {
<#
        foreach (var edmProperty in propertiesWithDefaultValues)
        {
#>
        this.<#=code.Escape(edmProperty)#> = <#=typeMapper.CreateLiteral(edmProperty.DefaultValue)#>;
<#
        }

        foreach (var complexProperty in complexProperties)
        {
#>
        this.<#=code.Escape(complexProperty)#> = new <#=typeMapper.GetTypeName(complexProperty.TypeUsage)#>();
<#
        }
#>
    }

<#
    }

    var simpleProperties = typeMapper.GetSimpleProperties(complex);
    if (simpleProperties.Any())
    {
        foreach(var edmProperty in simpleProperties)
        {
#>
    <#=codeStringGenerator.Property(edmProperty)#>
<#
        }
    }

    if (complexProperties.Any())
    {
#>

<#
        foreach(var edmProperty in complexProperties)
        {
#>
    <#=codeStringGenerator.Property(edmProperty)#>
<#
        }
    }
#>
}
<#
    EndNamespace(code);
}

foreach (var enumType in typeMapper.GetEnumItemsToGenerate(itemCollection))
{
    fileManager.StartNewFile(enumType.Name + ".cs");
    BeginNamespace(code);
#>
<#=codeStringGenerator.UsingDirectives(inHeader: false, includeCollections: false)#>
<#
    if (typeMapper.EnumIsFlags(enumType))
    {
#>
[Flags]
<#
    }
#>
<#=codeStringGenerator.EnumOpening(enumType)#>
{
<#
    var foundOne = false;

    foreach (MetadataItem member in typeMapper.GetEnumMembers(enumType))
    {
        foundOne = true;
#>
    <#=code.Escape(typeMapper.GetEnumMemberName(member))#> = <#=typeMapper.GetEnumMemberValue(member)#>,
<#
    }

    if (foundOne)
    {
        this.GenerationEnvironment.Remove(this.GenerationEnvironment.Length - 3, 1);
    }
#>
}
<#
    EndNamespace(code);
}

fileManager.Process();

#>
<#+

public void WriteHeader(CodeStringGenerator codeStringGenerator, EntityFrameworkTemplateFileManager fileManager)
{
    fileManager.StartHeader();
#>
//------------------------------------------------------------------------------
// <auto-generated>
// <#=GetResourceString("Template_GeneratedCodeCommentLine1")#>
//
// <#=GetResourceString("Template_GeneratedCodeCommentLine2")#>
// <#=GetResourceString("Template_GeneratedCodeCommentLine3")#>
// </auto-generated>
//------------------------------------------------------------------------------
<#=codeStringGenerator.UsingDirectives(inHeader: true)#>
<#+
    fileManager.EndBlock();
}

public void BeginNamespace(CodeGenerationTools code)
{
    var codeNamespace = code.VsNamespaceSuggestion();
    if (!String.IsNullOrEmpty(codeNamespace))
    {
#>
namespace <#=code.EscapeNamespace(codeNamespace)#>
{
<#+
        PushIndent("    ");
    }
}

public void EndNamespace(CodeGenerationTools code)
{
    if (!String.IsNullOrEmpty(code.VsNamespaceSuggestion()))
    {
        PopIndent();
#>
}
<#+
    }
}

public const string TemplateId = "CSharp_DbContext_Types_EF5";

public class CodeStringGenerator
{
    private readonly CodeGenerationTools _code;
    private readonly TypeMapper _typeMapper;
    private readonly MetadataTools _ef;

    public CodeStringGenerator(CodeGenerationTools code, TypeMapper typeMapper, MetadataTools ef)
    {
        ArgumentNotNull(code, "code");
        ArgumentNotNull(typeMapper, "typeMapper");
        ArgumentNotNull(ef, "ef");

        _code = code;
        _typeMapper = typeMapper;
        _ef = ef;
    }

    public string Property(EdmProperty edmProperty)
    {
        return string.Format(
            CultureInfo.InvariantCulture,
            "\{0\} \{1\} \{2\} \{\{ \{3\}get; \{4\}set; \}\}",
            Accessibility.ForProperty(edmProperty),
            _typeMapper.GetTypeName(edmProperty.TypeUsage),
            _code.Escape(edmProperty),
            _code.SpaceAfter(Accessibility.ForGetter(edmProperty)),
            _code.SpaceAfter(Accessibility.ForSetter(edmProperty)));
    }

    public string NavigationProperty(NavigationProperty navigationProperty)
    {
        var endType = _typeMapper.GetTypeName(navigationProperty.ToEndMember.GetEntityType());
        return string.Format(
            CultureInfo.InvariantCulture,
            "\{0\} \{1\} \{2\} \{\{ \{3\}get; \{4\}set; \}\}",
            AccessibilityAndVirtual(Accessibility.ForProperty(navigationProperty)),
            navigationProperty.ToEndMember.RelationshipMultiplicity == RelationshipMultiplicity.Many ? ("ICollection<" + endType + ">") : endType,
            _code.Escape(navigationProperty),
            _code.SpaceAfter(Accessibility.ForGetter(navigationProperty)),
            _code.SpaceAfter(Accessibility.ForSetter(navigationProperty)));
    }

    public string AccessibilityAndVirtual(string accessibility)
    {
        return accessibility + (accessibility != "private" ? " virtual" : "");
    }

    public string EntityClassOpening(EntityType entity)
    {
        return string.Format(
            CultureInfo.InvariantCulture,
            "\{0\} \{1\}partial class \{2\}\{3\}",
            Accessibility.ForType(entity),
            _code.SpaceAfter(_code.AbstractOption(entity)),
            _code.Escape(entity),
            _code.StringBefore(" : ", _typeMapper.GetTypeName(entity.BaseType)));
    }

    public string EnumOpening(SimpleType enumType)
    {
        return string.Format(
            CultureInfo.InvariantCulture,
            "{0} enum {1} : {2}",
            Accessibility.ForType(enumType),
            _code.Escape(enumType),
            _code.Escape(_typeMapper.UnderlyingClrType(enumType)));
        }

    public void WriteFunctionParameters(EdmFunction edmFunction, Action<string, string, string, string> writeParameter)
    {
        var parameters = FunctionImportParameter.Create(edmFunction.Parameters, _code, _ef);
        foreach (var parameter in parameters.Where(p => p.NeedsLocalVariable))
        {
            var isNotNull = parameter.IsNullableOfT ? parameter.FunctionParameterName + ".HasValue" : parameter.FunctionParameterName + " != null";
            var notNullInit = "new ObjectParameter(\"" + parameter.EsqlParameterName + "\", " + parameter.FunctionParameterName + ")";
            var nullInit = "new ObjectParameter(\"" + parameter.EsqlParameterName + "\", typeof(" + parameter.RawClrTypeName + "))";
            writeParameter(parameter.LocalVariableName, isNotNull, notNullInit, nullInit);
        }
    }

    public string ComposableFunctionMethod(EdmFunction edmFunction, string modelNamespace)
    {
        var parameters = _typeMapper.GetParameters(edmFunction);

        return string.Format(
            CultureInfo.InvariantCulture,
            "\{0\} IQueryable<\{1\}> \{2\}(\{3\})",
            AccessibilityAndVirtual(Accessibility.ForMethod(edmFunction)),
            _typeMapper.GetTypeName(_typeMapper.GetReturnType(edmFunction), modelNamespace),
            _code.Escape(edmFunction),
            string.Join(", ", parameters.Select(p => p.FunctionParameterType + " " + p.FunctionParameterName).ToArray()));
    }

    public string ComposableCreateQuery(EdmFunction edmFunction, string modelNamespace)
    {
        var parameters = _typeMapper.GetParameters(edmFunction);

        return string.Format(
            CultureInfo.InvariantCulture,
            "return ((IObjectContextAdapter)this).ObjectContext.CreateQuery<{0}>(\"[\{1\}].[\{2\}](\{3\})\"\{4\});",
            _typeMapper.GetTypeName(_typeMapper.GetReturnType(edmFunction), modelNamespace),
            edmFunction.NamespaceName,
            edmFunction.Name,
            string.Join(", ", parameters.Select(p => "@" + p.EsqlParameterName).ToArray()),
            _code.StringBefore(", ", string.Join(", ", parameters.Select(p => p.ExecuteParameterName).ToArray())));
    }

    public string FunctionMethod(EdmFunction edmFunction, string modelNamespace, bool includeMergeOption)
    {
        var parameters = _typeMapper.GetParameters(edmFunction);
        var returnType = _typeMapper.GetReturnType(edmFunction);

        var paramList = String.Join(", ", parameters.Select(p => p.FunctionParameterType + " " + p.FunctionParameterName).ToArray());
        if (includeMergeOption)
        {
            paramList = _code.StringAfter(paramList, ", ") + "MergeOption mergeOption";
        }

        return string.Format(
            CultureInfo.InvariantCulture,
            "\{0\} \{1\} \{2\}(\{3\})",
            AccessibilityAndVirtual(Accessibility.ForMethod(edmFunction)),
            returnType == null ? "int" : "ObjectResult<" + _typeMapper.GetTypeName(returnType, modelNamespace) + ">",
            _code.Escape(edmFunction),
            paramList);
    }

    public string ExecuteFunction(EdmFunction edmFunction, string modelNamespace, bool includeMergeOption)
    {
        var parameters = _typeMapper.GetParameters(edmFunction);
        var returnType = _typeMapper.GetReturnType(edmFunction);

        var callParams = _code.StringBefore(", ", String.Join(", ", parameters.Select(p => p.ExecuteParameterName).ToArray()));
        if (includeMergeOption)
        {
            callParams = ", mergeOption" + callParams;
        }

        return string.Format(
            CultureInfo.InvariantCulture,
            "return ((IObjectContextAdapter)this).ObjectContext.ExecuteFunction{0}(\"{1}\"{2});",
            returnType == null ? "" : "<" + _typeMapper.GetTypeName(returnType, modelNamespace) + ">",
            edmFunction.Name,
            callParams);
    }

    public string DbSet(EntitySet entitySet)
    {
        return string.Format(
            CultureInfo.InvariantCulture,
            "{0} DbSet<{1}> {2} \{\{ get; set; \}\}",
            Accessibility.ForReadOnlyProperty(entitySet),
            _typeMapper.GetTypeName(entitySet.ElementType),
            _code.Escape(entitySet));
    }

    public string UsingDirectives(bool inHeader, bool includeCollections = true)
    {
        return inHeader == string.IsNullOrEmpty(_code.VsNamespaceSuggestion())
            ? string.Format(
                CultureInfo.InvariantCulture,
                "{0}using System;{1}" +
                "{2}",
                inHeader ? Environment.NewLine : "",
                includeCollections ? (Environment.NewLine + "using System.Collections.Generic;") : "",
                inHeader ? "" : Environment.NewLine)
            : "";
    }
}

public class TypeMapper
{
    private const string ExternalTypeNameAttributeName = @"http://schemas.microsoft.com/ado/2006/04/codegeneration:ExternalTypeName";

    private readonly System.Collections.IList _errors;
    private readonly CodeGenerationTools _code;
    private readonly MetadataTools _ef;

    public TypeMapper(CodeGenerationTools code, MetadataTools ef, System.Collections.IList errors)
    {
        ArgumentNotNull(code, "code");
        ArgumentNotNull(ef, "ef");
        ArgumentNotNull(errors, "errors");

        _code = code;
        _ef = ef;
        _errors = errors;
    }

    public string GetTypeName(TypeUsage typeUsage)
    {
        return typeUsage == null ? null : GetTypeName(typeUsage.EdmType, _ef.IsNullable(typeUsage), modelNamespace: null);
    }

    public string GetTypeName(EdmType edmType)
    {
        return GetTypeName(edmType, isNullable: null, modelNamespace: null);
    }

    public string GetTypeName(TypeUsage typeUsage, string modelNamespace)
    {
        return typeUsage == null ? null : GetTypeName(typeUsage.EdmType, _ef.IsNullable(typeUsage), modelNamespace);
    }

    public string GetTypeName(EdmType edmType, string modelNamespace)
    {
        return GetTypeName(edmType, isNullable: null, modelNamespace: modelNamespace);
    }

    public string GetTypeName(EdmType edmType, bool? isNullable, string modelNamespace)
    {
        if (edmType == null)
        {
            return null;
        }

        var collectionType = edmType as CollectionType;
        if (collectionType != null)
        {
            return String.Format(CultureInfo.InvariantCulture, "ICollection<\{0\}>", GetTypeName(collectionType.TypeUsage, modelNamespace));
        }

        var typeName = _code.Escape(edmType.MetadataProperties
                                .Where(p => p.Name == ExternalTypeNameAttributeName)
                                .Select(p => (string)p.Value)
                                .FirstOrDefault())
            ?? (modelNamespace != null && edmType.NamespaceName != modelNamespace ?
                _code.CreateFullName(_code.EscapeNamespace(edmType.NamespaceName), _code.Escape(edmType)) :
                _code.Escape(edmType));

        if (edmType is StructuralType)
        {
            return typeName;
        }

        if (edmType is SimpleType)
        {
            var clrType = UnderlyingClrType(edmType);
            if (!IsEnumType(edmType))
            {
                typeName = _code.Escape(clrType);
            }

            return clrType.IsValueType && isNullable == true ?
                String.Format(CultureInfo.InvariantCulture, "Nullable<{0}>", typeName) :
                typeName;
        }

        throw new ArgumentException("edmType");
    }

    public Type UnderlyingClrType(EdmType edmType)
    {
        ArgumentNotNull(edmType, "edmType");

        var primitiveType = edmType as PrimitiveType;
        if (primitiveType != null)
        {
            return primitiveType.ClrEquivalentType;
        }

        if (IsEnumType(edmType))
        {
            return GetEnumUnderlyingType(edmType).ClrEquivalentType;
        }

        return typeof(object);
    }

    public object GetEnumMemberValue(MetadataItem enumMember)
    {
        ArgumentNotNull(enumMember, "enumMember");

        var valueProperty = enumMember.GetType().GetProperty("Value");
        return valueProperty == null ? null : valueProperty.GetValue(enumMember, null);
    }

    public string GetEnumMemberName(MetadataItem enumMember)
    {
        ArgumentNotNull(enumMember, "enumMember");

        var nameProperty = enumMember.GetType().GetProperty("Name");
        return nameProperty == null ? null : (string)nameProperty.GetValue(enumMember, null);
    }

    public System.Collections.IEnumerable GetEnumMembers(EdmType enumType)
    {
        ArgumentNotNull(enumType, "enumType");

        var membersProperty = enumType.GetType().GetProperty("Members");
        return membersProperty != null
            ? (System.Collections.IEnumerable)membersProperty.GetValue(enumType, null)
            : Enumerable.Empty<MetadataItem>();
    }

    public bool EnumIsFlags(EdmType enumType)
    {
        ArgumentNotNull(enumType, "enumType");

        var isFlagsProperty = enumType.GetType().GetProperty("IsFlags");
        return isFlagsProperty != null && (bool)isFlagsProperty.GetValue(enumType, null);
    }

    public bool IsEnumType(GlobalItem edmType)
    {
        ArgumentNotNull(edmType, "edmType");

        return edmType.GetType().Name == "EnumType";
    }

    public PrimitiveType GetEnumUnderlyingType(EdmType enumType)
    {
        ArgumentNotNull(enumType, "enumType");

        return (PrimitiveType)enumType.GetType().GetProperty("UnderlyingType").GetValue(enumType, null);
    }

    public string CreateLiteral(object value)
    {
        if (value == null || value.GetType() != typeof(TimeSpan))
        {
            return _code.CreateLiteral(value);
        }

        return string.Format(CultureInfo.InvariantCulture, "new TimeSpan({0})", ((TimeSpan)value).Ticks);
    }

    public bool VerifyCaseInsensitiveTypeUniqueness(IEnumerable<string> types, string sourceFile)
    {
        ArgumentNotNull(types, "types");
        ArgumentNotNull(sourceFile, "sourceFile");

        var hash = new HashSet<string>(StringComparer.InvariantCultureIgnoreCase);
        if (types.Any(item => !hash.Add(item)))
        {
            _errors.Add(
                new CompilerError(sourceFile, -1, -1, "6023",
                    String.Format(CultureInfo.CurrentCulture, GetResourceString("Template_CaseInsensitiveTypeConflict"))));
            return false;
        }
        return true;
    }

    public IEnumerable<SimpleType> GetEnumItemsToGenerate(IEnumerable<GlobalItem> itemCollection)
    {
        return GetItemsToGenerate<SimpleType>(itemCollection)
            .Where(e => IsEnumType(e));
    }

    public IEnumerable<T> GetItemsToGenerate<T>(IEnumerable<GlobalItem> itemCollection) where T: EdmType
    {
        return itemCollection
            .OfType<T>()
            .Where(i => !i.MetadataProperties.Any(p => p.Name == ExternalTypeNameAttributeName))
            .OrderBy(i => i.Name);
    }

    public IEnumerable<string> GetAllGlobalItems(IEnumerable<GlobalItem> itemCollection)
    {
        return itemCollection
            .Where(i => i is EntityType || i is ComplexType || i is EntityContainer || IsEnumType(i))
            .Select(g => GetGlobalItemName(g));
    }

    public string GetGlobalItemName(GlobalItem item)
    {
        if (item is EdmType)
        {
            return ((EdmType)item).Name;
        }
        else
        {
            return ((EntityContainer)item).Name;
        }
    }

    public IEnumerable<EdmProperty> GetSimpleProperties(EntityType type)
    {
        return type.Properties.Where(p => p.TypeUsage.EdmType is SimpleType && p.DeclaringType == type);
    }

    public IEnumerable<EdmProperty> GetSimpleProperties(ComplexType type)
    {
        return type.Properties.Where(p => p.TypeUsage.EdmType is SimpleType && p.DeclaringType == type);
    }

    public IEnumerable<EdmProperty> GetComplexProperties(EntityType type)
    {
        return type.Properties.Where(p => p.TypeUsage.EdmType is ComplexType && p.DeclaringType == type);
    }

    public IEnumerable<EdmProperty> GetComplexProperties(ComplexType type)
    {
        return type.Properties.Where(p => p.TypeUsage.EdmType is ComplexType && p.DeclaringType == type);
    }

    public IEnumerable<EdmProperty> GetPropertiesWithDefaultValues(EntityType type)
    {
        return type.Properties.Where(p => p.TypeUsage.EdmType is SimpleType && p.DeclaringType == type && p.DefaultValue != null);
    }

    public IEnumerable<EdmProperty> GetPropertiesWithDefaultValues(ComplexType type)
    {
        return type.Properties.Where(p => p.TypeUsage.EdmType is SimpleType && p.DeclaringType == type && p.DefaultValue != null);
    }

    public IEnumerable<NavigationProperty> GetNavigationProperties(EntityType type)
    {
        return type.NavigationProperties.Where(np => np.DeclaringType == type);
    }

    public IEnumerable<NavigationProperty> GetCollectionNavigationProperties(EntityType type)
    {
        return type.NavigationProperties.Where(np => np.DeclaringType == type && np.ToEndMember.RelationshipMultiplicity == RelationshipMultiplicity.Many);
    }

    public FunctionParameter GetReturnParameter(EdmFunction edmFunction)
    {
        ArgumentNotNull(edmFunction, "edmFunction");

        var returnParamsProperty = edmFunction.GetType().GetProperty("ReturnParameters");
        return returnParamsProperty == null
            ? edmFunction.ReturnParameter
            : ((IEnumerable<FunctionParameter>)returnParamsProperty.GetValue(edmFunction, null)).FirstOrDefault();
    }

    public bool IsComposable(EdmFunction edmFunction)
    {
        ArgumentNotNull(edmFunction, "edmFunction");

        var isComposableProperty = edmFunction.GetType().GetProperty("IsComposableAttribute");
        return isComposableProperty != null && (bool)isComposableProperty.GetValue(edmFunction, null);
    }

    public IEnumerable<FunctionImportParameter> GetParameters(EdmFunction edmFunction)
    {
        return FunctionImportParameter.Create(edmFunction.Parameters, _code, _ef);
    }

    public TypeUsage GetReturnType(EdmFunction edmFunction)
    {
        var returnParam = GetReturnParameter(edmFunction);
        return returnParam == null ? null : _ef.GetElementType(returnParam.TypeUsage);
    }

    public bool GenerateMergeOptionFunction(EdmFunction edmFunction, bool includeMergeOption)
    {
        var returnType = GetReturnType(edmFunction);
        return !includeMergeOption && returnType != null && returnType.EdmType.BuiltInTypeKind == BuiltInTypeKind.EntityType;
    }
}

public class EdmMetadataLoader
{
    private readonly IDynamicHost _host;
    private readonly System.Collections.IList _errors;

    public EdmMetadataLoader(IDynamicHost host, System.Collections.IList errors)
    {
        ArgumentNotNull(host, "host");
        ArgumentNotNull(errors, "errors");

        _host = host;
        _errors = errors;
    }

    public IEnumerable<GlobalItem> CreateEdmItemCollection(string sourcePath)
    {
        ArgumentNotNull(sourcePath, "sourcePath");

        if (!ValidateInputPath(sourcePath))
        {
            return new EdmItemCollection();
        }

        var schemaElement = LoadRootElement(_host.ResolvePath(sourcePath));
        if (schemaElement != null)
        {
            using (var reader = schemaElement.CreateReader())
            {
                IList<EdmSchemaError> errors;
                var itemCollection = MetadataItemCollectionFactory.CreateEdmItemCollection(new[] { reader }, out errors);

                ProcessErrors(errors, sourcePath);

                return itemCollection;
            }
        }
        return new EdmItemCollection();
    }

    public string GetModelNamespace(string sourcePath)
    {
        ArgumentNotNull(sourcePath, "sourcePath");

        if (!ValidateInputPath(sourcePath))
        {
            return string.Empty;
        }

        var model = LoadRootElement(_host.ResolvePath(sourcePath));
        if (model == null)
        {
            return string.Empty;
        }

        var attribute = model.Attribute("Namespace");
        return attribute != null ? attribute.Value : "";
    }

    private bool ValidateInputPath(string sourcePath)
    {
        if (sourcePath == "$" + "edmxInputFile" + "$")
        {
            _errors.Add(
                new CompilerError(_host.TemplateFile ?? sourcePath, 0, 0, string.Empty,
                    GetResourceString("Template_ReplaceVsItemTemplateToken")));
            return false;
        }

        return true;
    }

    public XElement LoadRootElement(string sourcePath)
    {
        ArgumentNotNull(sourcePath, "sourcePath");

        var root = XElement.Load(sourcePath, LoadOptions.SetBaseUri | LoadOptions.SetLineInfo);
        return root.Elements()
            .Where(e => e.Name.LocalName == "Runtime")
            .Elements()
            .Where(e => e.Name.LocalName == "ConceptualModels")
            .Elements()
            .Where(e => e.Name.LocalName == "Schema")
            .FirstOrDefault()
                ?? root;
    }

    private void ProcessErrors(IEnumerable<EdmSchemaError> errors, string sourceFilePath)
    {
        foreach (var error in errors)
        {
            _errors.Add(
                new CompilerError(
                    error.SchemaLocation ?? sourceFilePath,
                    error.Line,
                    error.Column,
                    error.ErrorCode.ToString(CultureInfo.InvariantCulture),
                    error.Message)
                {
                    IsWarning = error.Severity == EdmSchemaErrorSeverity.Warning
                });
        }
    }

    public bool IsLazyLoadingEnabled(EntityContainer container)
    {
        string lazyLoadingAttributeValue;
        var lazyLoadingAttributeName = MetadataConstants.EDM_ANNOTATION_09_02 + ":LazyLoadingEnabled";
        bool isLazyLoading;
        return !MetadataTools.TryGetStringMetadataPropertySetting(container, lazyLoadingAttributeName, out lazyLoadingAttributeValue)
            || !bool.TryParse(lazyLoadingAttributeValue, out isLazyLoading)
            || isLazyLoading;
    }
}

public static void ArgumentNotNull<T>(T arg, string name) where T : class
{
    if (arg == null)
    {
        throw new ArgumentNullException(name);
    }
}

private static readonly Lazy<System.Resources.ResourceManager> ResourceManager =
    new Lazy<System.Resources.ResourceManager>(
        () => new System.Resources.ResourceManager("System.Data.Entity.Design", typeof(MetadataItemCollectionFactory).Assembly), isThreadSafe: true);

public static string GetResourceString(string resourceName)
{
    ArgumentNotNull(resourceName, "resourceName");

    return ResourceManager.Value.GetString(resourceName, null);
}

#>
```
**SassTheme.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Themes
{
    public class SassTheme : Theme
    {
        public string Primary { get; set; }

        public Theme[] Swatches { get; set; }
    }
}
```
**SchedulerMeetingService.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Scheduler
{
    using Kendo.Mvc.UI;
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;
    using System.Web.Mvc;

    public class SchedulerMeetingService : ISchedulerEventService<MeetingViewModel>
    {
        private static bool UpdateDatabase = false;
        private SampleEntities db;

        public SchedulerMeetingService(SampleEntities context)
        {
            db = context;
        }

        public SchedulerMeetingService()
            : this(new SampleEntities())
        {
        }

        public virtual IList<MeetingViewModel> GetAll()
        {
            var result = HttpContext.Current.Session["SchedulerMeetings"] as IList<MeetingViewModel>;

            if (result == null || UpdateDatabase)
            {
                result = db.Meetings.ToList().Select(meeting => new MeetingViewModel
                {
                    MeetingID = meeting.MeetingID,
                    Title = meeting.Title,
                    Start = DateTime.SpecifyKind(meeting.Start, DateTimeKind.Utc),
                    End = DateTime.SpecifyKind(meeting.End, DateTimeKind.Utc),
                    StartTimezone = meeting.StartTimezone,
                    EndTimezone = meeting.EndTimezone,
                    Description = meeting.Description,
                    IsAllDay = meeting.IsAllDay,
                    RoomID = meeting.RoomID,
                    RecurrenceRule = meeting.RecurrenceRule,
                    RecurrenceException = meeting.RecurrenceException,
                    RecurrenceID = meeting.RecurrenceID,
                    Attendees = meeting.MeetingAttendees.Select(m => m.AttendeeID).ToArray()
                }).ToList();

                HttpContext.Current.Session["SchedulerMeetings"] = result;
            }

            return result;
        }

        public virtual IList<MeetingViewModel> GetHierarchicalMeetings()
        {
            var result = HttpContext.Current.Session["SchedulerHierarchicalMeetings"] as IList<MeetingViewModel>;
            var firstRoomAttendees = new List<int>() { 1, 2 };
            var secondRoomAttendees = new List<int>() { 1, 3 };

            if (result == null || UpdateDatabase)
            {
                result = db.Meetings.ToList()
                .Where(m => (m.RoomID == 1 && m.MeetingAttendees.All(a => firstRoomAttendees.Contains(a.AttendeeID))) ||
                            (m.RoomID == 2 && m.MeetingAttendees.All(a => secondRoomAttendees.Contains(a.AttendeeID))))
                .Select(meeting => new MeetingViewModel
                {
                    MeetingID = meeting.MeetingID,
                    Title = meeting.Title,
                    Start = DateTime.SpecifyKind(meeting.Start, DateTimeKind.Utc),
                    End = DateTime.SpecifyKind(meeting.End, DateTimeKind.Utc),
                    StartTimezone = meeting.StartTimezone,
                    EndTimezone = meeting.EndTimezone,
                    Description = meeting.Description,
                    IsAllDay = meeting.IsAllDay,
                    RoomID = meeting.RoomID,
                    RecurrenceRule = meeting.RecurrenceRule,
                    RecurrenceException = meeting.RecurrenceException,
                    RecurrenceID = meeting.RecurrenceID,
                    Attendees = meeting.MeetingAttendees.Select(m => m.AttendeeID).ToArray()
                }).ToList();

                HttpContext.Current.Session["SchedulerHierarchicalMeetings"] = result;
            }

            return result;
        }

        public virtual void Insert(MeetingViewModel meeting, ModelStateDictionary modelState)
        {
            if (ValidateModel(meeting, modelState))
            {
                if (!UpdateDatabase)
                {
                    var first = GetAll().OrderByDescending(e => e.MeetingID).FirstOrDefault();
                    var id = (first != null) ? first.MeetingID : 0;

                    meeting.MeetingID = id + 1;

                    GetAll().Insert(0, meeting);
                }
                else
                {
                    if (meeting.Attendees == null)
                    {
                        meeting.Attendees = new int[0];
                    }

                    if (string.IsNullOrEmpty(meeting.Title))
                    {
                        meeting.Title = "";
                    }

                    var entity = meeting.ToEntity();

                    foreach (var attendeeId in meeting.Attendees)
                    {
                        entity.MeetingAttendees.Add(new MeetingAttendee
                        {
                            AttendeeID = attendeeId
                        });
                    }

                    db.Meetings.Add(entity);
                    db.SaveChanges();

                    meeting.MeetingID = entity.MeetingID;
                }
            }
        }

        public virtual void Update(MeetingViewModel meeting, ModelStateDictionary modelState)
        {
            if (ValidateModel(meeting, modelState))
            {
                if (!UpdateDatabase)
                {
                    var target = One(e => e.MeetingID == meeting.MeetingID);

                    if (target != null)
                    {
                        target.Title = meeting.Title;
                        target.Start = meeting.Start;
                        target.End = meeting.End;
                        target.StartTimezone = meeting.StartTimezone;
                        target.EndTimezone = meeting.EndTimezone;
                        target.Description = meeting.Description;
                        target.IsAllDay = meeting.IsAllDay;
                        target.RecurrenceRule = meeting.RecurrenceRule;
                        target.RoomID = meeting.RoomID;
                        target.RecurrenceException = meeting.RecurrenceException;
                        target.RecurrenceID = meeting.RecurrenceID;
                        target.Attendees = meeting.Attendees;
                    }
                }
                else
                {
                    if (string.IsNullOrEmpty(meeting.Title))
                    {
                        meeting.Title = "";
                    }

                    var entity = db.Meetings.Include("MeetingAttendees").FirstOrDefault(m => m.MeetingID == meeting.MeetingID);

                    entity.Title = meeting.Title;
                    entity.Start = meeting.Start;
                    entity.End = meeting.End;
                    entity.Description = meeting.Description;
                    entity.IsAllDay = meeting.IsAllDay;
                    entity.RoomID = meeting.RoomID;
                    entity.RecurrenceID = meeting.RecurrenceID;
                    entity.RecurrenceRule = meeting.RecurrenceRule;
                    entity.RecurrenceException = meeting.RecurrenceException;
                    entity.StartTimezone = meeting.StartTimezone;
                    entity.EndTimezone = meeting.EndTimezone;

                    foreach (var meetingAttendee in entity.MeetingAttendees.ToList())
                    {
                        entity.MeetingAttendees.Remove(meetingAttendee);
                    }

                    if (meeting.Attendees != null)
                    {
                        foreach (var attendeeId in meeting.Attendees)
                        {
                            var meetingAttendee = new MeetingAttendee
                            {
                                MeetingID = entity.MeetingID,
                                AttendeeID = attendeeId
                            };

                            entity.MeetingAttendees.Add(meetingAttendee);
                        }
                    }

                    db.SaveChanges();
                }
            }
        }

        public virtual void Delete(MeetingViewModel meeting, ModelStateDictionary modelState)
        {
            if (!UpdateDatabase)
            {
                var target = One(p => p.MeetingID == meeting.MeetingID);
                if (target != null)
                {
                    GetAll().Remove(target);

                    var recurrenceExceptions = GetAll().Where(m => m.RecurrenceID == meeting.MeetingID).ToList();

                    foreach (var recurrenceException in recurrenceExceptions)
                    {
                        GetAll().Remove(recurrenceException);
                    }
                }
            }
            else
            {
                if (meeting.Attendees == null)
                {
                    meeting.Attendees = new int[0];
                }

                var entity = meeting.ToEntity();

                db.Meetings.Attach(entity);

                var attendees = meeting.Attendees.Select(attendee => new MeetingAttendee
                {
                    AttendeeID = attendee,
                    MeetingID = entity.MeetingID
                });

                foreach (var attendee in attendees)
                {
                    db.MeetingAttendees.Attach(attendee);
                }

                entity.MeetingAttendees.Clear();

                var recurrenceExceptions = db.Meetings.Where(m => m.RecurrenceID == entity.MeetingID);

                foreach (var recurrenceException in recurrenceExceptions)
                {
                    db.Meetings.Remove(recurrenceException);
                }

                db.Meetings.Remove(entity);
                db.SaveChanges();
            }
        }

        private bool ValidateModel(MeetingViewModel appointment, ModelStateDictionary modelState)
        {
            if (appointment.Start > appointment.End)
            {
                modelState.AddModelError("errors", "End date must be greater or equal to Start date.");
                return false;
            }

            return true;
        }

        public MeetingViewModel One(Func<MeetingViewModel, bool> predicate)
        {
            return GetAll().FirstOrDefault(predicate);
        }

        public void Dispose()
        {
            db.Dispose();
        }
    }
}
```
**SchedulerResourceModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models.Scheduler
{
    public class SchedulerResourceModel
    {
        public string Text { get; set; }
        public int Value { get; set; }
        public int? Parent { get; set; }
        public string Color { get; set; }
    }
}
```
**SchedulerTaskService.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Scheduler
{
    using System.Linq;
    using System.Web.Mvc;
    using Kendo.Mvc.UI;
    using System;
    using System.Data;
    using System.Collections.Generic;
    using System.Web;

    public class SchedulerTaskService : ISchedulerEventService<TaskViewModel>
    {
        private static bool UpdateDatabase = false;
        private SampleEntities db;

        public SchedulerTaskService(SampleEntities context)
        {
            db = context;
        }

        public SchedulerTaskService()
            : this(new SampleEntities())
        {
        }

        public virtual IList<TaskViewModel> GetAll()
        {
            bool IsWebApiRequest = HttpContext.Current.Request.AppRelativeCurrentExecutionFilePath.StartsWith("~/api");
            IList <TaskViewModel> result = null;

            if(!IsWebApiRequest){
                result = HttpContext.Current.Session["SchedulerTasks"] as IList<TaskViewModel>;
            }

            if (result == null || UpdateDatabase)
            {
                result = db.Tasks.ToList().Select(task => new TaskViewModel
                {
                    TaskID = task.TaskID,
                    Title = task.Title,
                    Start = DateTime.SpecifyKind(task.Start, DateTimeKind.Utc),
                    End = DateTime.SpecifyKind(task.End, DateTimeKind.Utc),
                    StartTimezone = task.StartTimezone,
                    EndTimezone = task.EndTimezone,
                    Description = task.Description,
                    IsAllDay = task.IsAllDay,
                    RecurrenceRule = task.RecurrenceRule,
                    RecurrenceException = task.RecurrenceException,
                    RecurrenceID = task.RecurrenceID,
                    OwnerID = task.OwnerID
                }).ToList();

                if (!IsWebApiRequest)
                {
                    HttpContext.Current.Session["SchedulerTasks"] = result;
                }
            }

            return result;
        }

        public virtual void Insert(TaskViewModel task, ModelStateDictionary modelState)
        {
            if (ValidateModel(task, modelState))
            {
                if (!UpdateDatabase)
                {
                    var first = GetAll().OrderByDescending(e => e.TaskID).FirstOrDefault();
                    var id = (first != null) ? first.TaskID : 0;

                    task.TaskID = id + 1;

                    GetAll().Insert(0, task);
                }
                else
                {
                    if (string.IsNullOrEmpty(task.Title))
                    {
                        task.Title = "";
                    }

                    var entity = task.ToEntity();

                    db.Tasks.Add(entity);
                    db.SaveChanges();

                    task.TaskID = entity.TaskID;
                }
            }
        }

        public virtual void Update(TaskViewModel task, ModelStateDictionary modelState)
        {
            if (ValidateModel(task, modelState))
            {
                if (!UpdateDatabase)
                {
                    var target = One(e => e.TaskID == task.TaskID);

                    if (target != null)
                    {
                        target.Title = task.Title;
                        target.Start = task.Start;
                        target.End = task.End;
                        target.StartTimezone = task.StartTimezone;
                        target.EndTimezone = task.EndTimezone;
                        target.Description = task.Description;
                        target.IsAllDay = task.IsAllDay;
                        target.RecurrenceRule = task.RecurrenceRule;
                        target.RecurrenceException = task.RecurrenceException;
                        target.RecurrenceID = task.RecurrenceID;
                        target.OwnerID = task.OwnerID;
                    }
                }
                else
                {
                    if (string.IsNullOrEmpty(task.Title))
                    {
                        task.Title = "";
                    }

                    var entity = task.ToEntity();
                    db.Tasks.Attach(entity);
                    db.Entry(entity).State = EntityState.Modified;
                    db.SaveChanges();
                }
            }
        }

        public virtual void Delete(TaskViewModel task, ModelStateDictionary modelState)
        {
            if (!UpdateDatabase)
            {
                var target = One(p => p.TaskID == task.TaskID);
                if (target != null)
                {
                    GetAll().Remove(target);

                    var recurrenceExceptions = GetAll().Where(m => m.RecurrenceID == task.TaskID).ToList();

                    foreach (var recurrenceException in recurrenceExceptions)
                    {
                        GetAll().Remove(recurrenceException);
                    }
                }
            }
            else
            {
                var entity = task.ToEntity();
                db.Tasks.Attach(entity);

                var recurrenceExceptions = db.Tasks.Where(t => t.RecurrenceID == task.TaskID);

                foreach (var recurrenceException in recurrenceExceptions)
                {
                    db.Tasks.Remove(recurrenceException);
                }

                db.Tasks.Remove(entity);
                db.SaveChanges();
            }
        }

        private bool ValidateModel(TaskViewModel appointment, ModelStateDictionary modelState)
        {
            if (appointment.Start > appointment.End)
            {
                modelState.AddModelError("errors", "End date must be greater or equal to Start date.");
                return false;
            }

            return true;
        }

        public TaskViewModel One(Func<TaskViewModel, bool> predicate)
        {
            return GetAll().FirstOrDefault(predicate);
        }

        public void Dispose()
        {
            db.Dispose();
        }
    }
}
```
**ScreenResolution.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class ScreenResolution
    {
        public ScreenResolution()
        {
        }

        public ScreenResolution(string year,string resolution,int share, bool visibleInLegend, int orderNumber)
        {
            Year = year;
            Resolution = resolution;
            Share = share;
            VisibleInLegend = visibleInLegend;
            OrderNumber = orderNumber;
        }

        public string Year { get; set; }
        public string Resolution { get; set; }
        public int Share { get; set; }
        public bool VisibleInLegend { get; set; }
        public int OrderNumber { get; set; }
    }
}
```
**ScreenResolutionRemoteDataViewModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class ScreenResolutionRemoteDataViewModel : ScreenResolution
    {
        public ScreenResolutionRemoteDataViewModel()
        {
        }

        public ScreenResolutionRemoteDataViewModel(ScreenResolution screenResolution)
            : base(screenResolution.Year, screenResolution.Resolution, screenResolution.Share, screenResolution.VisibleInLegend, screenResolution.OrderNumber)
        {
        }

        public string Color { get; set; }
    }
}
```
**ScriptGroups.cs**

```C#
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;

namespace Kendo.Mvc.Examples.Models
{
    public static class ScriptGroups
    {
        private static string jQueryPath
        {
            get {
                var CDN_ROOT = ConfigurationManager.AppSettings["CDN_ROOT"];
                if (CDN_ROOT == "$CDN_ROOT")
                {
                    return "jquery.min.js";
                }

                return string.Format(
                    "//code.jquery.com/jquery-{0}.min.js",
                    ConfigurationManager.AppSettings["JQUERY_VERSION"]
                );
            }
        }

        private static readonly string JSZipPath = "jszip.min.js";

        public static IList<string> All = new string[]
        {
            jQueryPath,
            JSZipPath,
            "kendo.all.min.js",
            "kendo.aspnetmvc.min.js",
            "kendo.timezones.min.js"
        };
    }
}

```
**SessionUploadInitialFilesRepository.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;

    public static class SessionUploadInitialFilesRepository
    {
        public static IList<UploadInitialFile> GetAllInitialFiles()
        {
            IList<UploadInitialFile> initialFiles = (IList<UploadInitialFile>)HttpContext.Current.Session["InitialFiles"];

            if (initialFiles == null)
            {
                initialFiles = new List<UploadInitialFile>();
                HttpContext.Current.Session["InitialFiles"] = initialFiles;
            }

            return initialFiles;
        }

        public static void Add(UploadInitialFile file)
        {
            GetAllInitialFiles().Add(file);
        }

        public static void Remove(string fileName)
        {
            var initialFiles = GetAllInitialFiles();
            var fileToRemove = initialFiles.FirstOrDefault(f => f.Name == fileName);

            initialFiles.Remove(fileToRemove);
        }
    }
}
```
**Shipper.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Shipper
    {
        public Shipper()
        {
            this.Orders = new HashSet<Order>();
        }

        public int ShipperID { get; set; }
        public string CompanyName { get; set; }
        public string Phone { get; set; }

        public virtual ICollection<Order> Orders { get; set; }
    }
}

```
**Shipping.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models.SpreadStreamProcessing
{
    public enum Shipping
    {
        Express,
        OneDay,
        TwoDays,
        Regular
    }
}
```
**SignatureFieldsModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class SignatureFieldsModel
    {
        public bool IsDocumentModified { get; set; }
        public bool IsCertificateValid { get; set; }
        public string SignerInformation { get; set; }
        public string HashAlgorithm { get; set; }
        public string ImgUrl { get; set; }
        public string ExceptionMessage { get; set; }
    }
}
```
**SiteOmptimizationItem.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class SiteOptimizationItem
    {
        public SiteOptimizationItem()
        {
        }

        public SiteOptimizationItem(string description, int visitors)
        {
            Visitors = visitors;
            Description = description;
        }

        public string Description { get; set; }
        public int Visitors { get; set; }
    }
}
```
**SocialBenefits.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class SocialBenefits
    {
        public SocialBenefits()
        {
        }

        public SocialBenefits(SocialBenefitType type, double value)
        {
            Type = type;
            Value = value;
        }

        public SocialBenefitType Type { get; set; }
        public double Value { get; set; }
    }
}
```
**SocialBenefitType.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public enum SocialBenefitType
    {
        Social,
        Direct
    }
}
```
**SpreadsheetProductService.cs**

```C#
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class SpreadsheetProductService : IDisposable
    {
        private static bool UpdateDatabase = false;
        private SampleEntities entities;

        public SpreadsheetProductService(SampleEntities entities)
        {
            this.entities = entities;
        }

        public virtual IList<SpreadsheetProductViewModel> GetAll()
        {
            var result = HttpContext.Current.Session["SpreadsheetProducts"] as IList<SpreadsheetProductViewModel>;

            if (result == null || UpdateDatabase)
            {
                result = entities.Products.Select(product => new SpreadsheetProductViewModel
                {
                    ProductID = product.ProductID,
                    ProductName = product.ProductName,
                    UnitPrice = product.UnitPrice.HasValue ? product.UnitPrice.Value : default(decimal),
                    UnitsInStock = product.UnitsInStock.HasValue ? product.UnitsInStock.Value : default(short),
                    Discontinued = product.Discontinued
                }).ToList();

                HttpContext.Current.Session["SpreadsheetProducts"] = result;
            }

            return result;
        }

        public IEnumerable<SpreadsheetProductViewModel> Read()
        {
            return GetAll();
        }

        public void Create(SpreadsheetProductViewModel product)
        {
            if (!UpdateDatabase)
            {
                var first = GetAll().OrderByDescending(e => e.ProductID).FirstOrDefault();
                var id = (first != null) ? first.ProductID : 0;

                product.ProductID = id + 1;

                GetAll().Insert(0, product);
            }
            else
            {
                var entity = new Product();

                entity.ProductName = product.ProductName;
                entity.UnitPrice = product.UnitPrice;
                entity.UnitsInStock = (short)product.UnitsInStock;
                entity.Discontinued = product.Discontinued;

                if (entity.CategoryID == null)
                {
                    entity.CategoryID = 1;
                }

                entities.Products.Add(entity);
                entities.SaveChanges();

                product.ProductID = entity.ProductID;
            }
        }

        public void Update(SpreadsheetProductViewModel product)
        {
            if (!UpdateDatabase)
            {
                var target = One(e => e.ProductID == product.ProductID);

                if (target != null)
                {
                    target.ProductName = product.ProductName;
                    target.UnitPrice = product.UnitPrice;
                    target.UnitsInStock = product.UnitsInStock;
                    target.Discontinued = product.Discontinued;
                }
            }
            else
            {
                var entity = new Product();

                entity.ProductID = product.ProductID;
                entity.ProductName = product.ProductName;
                entity.UnitPrice = product.UnitPrice;
                entity.UnitsInStock = (short)product.UnitsInStock;
                entity.Discontinued = product.Discontinued;

                entities.Products.Attach(entity);
                entities.Entry(entity).State = EntityState.Modified;
                entities.SaveChanges();
            }
        }

        public void Destroy(SpreadsheetProductViewModel product)
        {
            if (!UpdateDatabase)
            {
                var target = GetAll().FirstOrDefault(p => p.ProductID == product.ProductID);
                if (target != null)
                {
                    GetAll().Remove(target);
                }
            }
            else
            {
                var entity = new Product();

                entity.ProductID = product.ProductID;

                entities.Products.Attach(entity);
                entities.Products.Remove(entity);

                var orderDetails = entities.Order_Details.Where(pd => pd.ProductID == entity.ProductID);

                foreach (var orderDetail in orderDetails)
                {
                    entities.Order_Details.Remove(orderDetail);
                }

                entities.SaveChanges();
            }
        }

        public SpreadsheetProductViewModel One(Func<SpreadsheetProductViewModel, bool> predicate)
        {
            return GetAll().FirstOrDefault(predicate);
        }

        public void Dispose()
        {
            entities.Dispose();
        }
    }
}
```
**SpreadsheetProductViewModel.cs**

```C#
using System.ComponentModel.DataAnnotations;
using System.ComponentModel;
using System;

namespace Kendo.Mvc.Examples.Models
{
    public class SpreadsheetProductViewModel
    {
        [ScaffoldColumn(false)]
        public int ProductID
        {
            get;
            set;
        }

        [Required]
        [DisplayName("Product name")]
        public string ProductName
        {
            get;
            set;
        }

        [DisplayName("Unit price")]
        [DataType(DataType.Currency)]
        [Range(0, int.MaxValue)]
        public decimal UnitPrice
        {
            get;
            set;
        }

        [DisplayName("Units in stock")]
        [DataType("Integer")]
        [Range(0, int.MaxValue)]
        public int UnitsInStock
        {
            get;
            set;
        }

        public bool Discontinued
        {
            get;
            set;
        }
    }
}

```
**SpreadsheetSubmitViewModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class SpreadsheetSubmitViewModel
    {
        public IList<SpreadsheetProductViewModel> Created { get; set; }

        public IList<SpreadsheetProductViewModel> Destroyed { get; set; }

        public IList<SpreadsheetProductViewModel> Updated { get; set; }
    }
}
```
**StepperViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class StepperViewModel
    {
        public bool Label { get; set; }
        public bool Indicator { get; set; }
        public bool Linear { get; set; }
        public bool SelectOnFocus { get; set; }

    }
}

```
**Stock.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Stock
    {
        public int ID { get; set; }
        public string Symbol { get; set; }
        public System.DateTime Date { get; set; }
        public decimal Open { get; set; }
        public decimal High { get; set; }
        public decimal Low { get; set; }
        public decimal Close { get; set; }
        public long Volume { get; set; }
    }
}

```
**StockDataModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models.Chart
{
    public class StockDataModel
    {
        public DateTime Date { get; set; }

        public decimal Close { get; set; }

        public long Volume { get; set; }

        public decimal Open { get; set; }

        public decimal High { get; set; }

        public decimal Low { get; set; }
    }
}
```
**StockDataPoint.cs**

```C#
using System;

namespace Kendo.Mvc.Examples.Models
{
    public class StockDataPoint
    {
        public DateTime Date { get; set; }

        public decimal Close { get; set; }

        public long Volume { get; set; }

        public decimal Open { get; set; }

        public decimal High { get; set; }

        public decimal Low { get; set; }

        public string Symbol { get; set; }
    }
}

```
**StyleGroups.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;

namespace Kendo.Mvc.Examples.Models
{
    public static class StyleGroups
    {
        public static readonly IList<string> All = new string[]
        {
            "kendo.CURRENT_COMMON.min.css",
            "kendo.rtl.min.css",
            "kendo.CURRENT_THEME.min.css",
            "kendo.CURRENT_THEME.mobile.min.css"
        };
    }
}

```
**SubCategoryItem.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class SubCategoryItem
    {
        public string SubCategoryName { get; set; }
    }
}
```
**SunPositionItem.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Chart
{
    public class SunPositionItem
    {
        public string Time { get; set; }
        public double Altitude { get; set; }
        public double Azimuth { get; set; }

        public SunPositionItem(string time, double altitude, double azimuth)
        {
            Time = time;
            Altitude = altitude;
            Azimuth = azimuth;
        }
    }
}
```
**Supplier.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Supplier
    {
        public Supplier()
        {
            this.Products = new HashSet<Product>();
        }

        public int SupplierID { get; set; }
        public string CompanyName { get; set; }
        public string ContactName { get; set; }
        public string ContactTitle { get; set; }
        public string Address { get; set; }
        public string City { get; set; }
        public string Region { get; set; }
        public string PostalCode { get; set; }
        public string Country { get; set; }
        public string Phone { get; set; }
        public string Fax { get; set; }
        public string HomePage { get; set; }

        public virtual ICollection<Product> Products { get; set; }
    }
}

```
**Sushi.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class Sushi
    {
        public int id { get; set; }
        public string name { get; set; }
        public double price { get; set; }
        public string image { get; set; }
        public string category { get; set; }
        public string description { get; set; }
        public bool featured { get; set; }
    }
}
```
**Task.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Task
    {
        public Task()
        {
            this.Tasks1 = new HashSet<Task>();
        }

        public int TaskID { get; set; }
        public System.DateTime Start { get; set; }
        public System.DateTime End { get; set; }
        public string Title { get; set; }
        public string Description { get; set; }
        public Nullable<int> OwnerID { get; set; }
        public bool IsAllDay { get; set; }
        public string RecurrenceRule { get; set; }
        public Nullable<int> RecurrenceID { get; set; }
        public string RecurrenceException { get; set; }
        public string StartTimezone { get; set; }
        public string EndTimezone { get; set; }

        public virtual ICollection<Task> Tasks1 { get; set; }
        public virtual Task Task1 { get; set; }
    }
}

```
**TaskViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Gantt
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;
    using Kendo.Mvc.UI;

    public class TaskViewModel : IGanttTask
    {
        public int TaskID { get; set; }
        public int? ParentID { get; set; }

        public string Title { get; set; }

        private DateTime start;
        public DateTime Start
        {
            get
            {
                return start;
            }
            set
            {
                start = value.ToUniversalTime();
            }
        }

        private DateTime end;
        public DateTime End
        {
            get
            {
                return end;
            }
            set
            {
                end = value.ToUniversalTime();
            }
        }

        private DateTime plannedStart;
        public DateTime PlannedStart
        {
            get
            {
                return plannedStart;
            }
            set
            {
                plannedStart = value.ToUniversalTime();
            }
        }

        private DateTime plannedEnd;
        public DateTime PlannedEnd
        {
            get
            {
                return plannedEnd;
            }
            set
            {
                plannedEnd = value.ToUniversalTime();
            }
        }

        public string TeamLead { get; set; }

        public bool Summary { get; set; }
        public bool Expanded { get; set; }
        public decimal PercentComplete { get; set; }
        public int OrderId { get; set; }

        public GanttTask ToEntity()
        {
            return new GanttTask
            {
                ID = TaskID,
                ParentID = ParentID,
                Title = Title,
                Start = Start,
                End = End,
                Summary = Summary,
                Expanded = Expanded,
                PercentComplete = PercentComplete,
                OrderID = OrderId
            };
        }
    }
}
```
**TaskViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Scheduler
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Web;
    using Kendo.Mvc.UI;

    public class TaskViewModel : ISchedulerEvent
    {
        public int TaskID { get; set; }
        public string Title { get; set; }
        public string Description { get; set; }

        private DateTime start;
        public DateTime Start
        {
            get
            {
                return start;
            }
            set
            {
                start = value.ToUniversalTime();
            }
        }

        public string StartTimezone { get; set; }

        private DateTime end;
        public DateTime End
        {
            get
            {
                return end;
            }
            set
            {
                end = value.ToUniversalTime();
            }
        }

        public string EndTimezone { get; set; }

        public string RecurrenceRule { get; set; }
        public int? RecurrenceID { get; set; }
        public string RecurrenceException { get; set; }
        public bool IsAllDay { get; set; }
        public int? OwnerID { get; set; }

        public Task ToEntity()
        {
            return new Task
            {
                TaskID = TaskID,
                Title = Title,
                Start = Start,
                StartTimezone = StartTimezone,
                End = End,
                EndTimezone = EndTimezone,
                Description = Description,
                RecurrenceRule = RecurrenceRule,
                RecurrenceException = RecurrenceException,
                RecurrenceID = RecurrenceID,
                IsAllDay = IsAllDay,
                OwnerID = OwnerID
            };
        }
    }
}
```
**Territory.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Territory
    {
        public Territory()
        {
            this.Employees = new HashSet<Employee>();
        }

        public string TerritoryID { get; set; }
        public string TerritoryDescription { get; set; }
        public int RegionID { get; set; }

        public virtual Region Region { get; set; }
        public virtual ICollection<Employee> Employees { get; set; }
    }
}

```
**Theme.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Themes
{
    public class Theme
    {
        public string Name { get; set; }

        public string Title { get; set; }

        public string[] Palette { get; set; }
    }
}
```
**TimelineEventModel.cs**

```C#
using System;
using System.Collections.Generic;

namespace Kendo.Mvc.Examples.Models
{
	public class TimelineEventModel
    {
        public string Title { get; set; }
        public string Subtitle { get; set; }
        public string Description { get; set; }

        public DateTime EventDate { get; set; }

        public string AltField { get; set; }

        public List<TimelineEventModelImage> Images { get; set; }
        public List<TimelineEventModelAction> Actions { get; set; }
    }

    public class TimelineEventModelImage
    {
        public string src { get; set; }
    }
    public class TimelineEventModelAction
    {
        public string text { get; set; }
        public string url { get; set; }
    }


}
```
**TreeMapDataRepository.cs**

```C#
using System.Collections.Generic;
using System;
using System.Linq;

namespace Kendo.Mvc.Examples.Models
{
    public partial class TreeMapDataRepository
    {
        public static List<PopulationUSA> PopulationUSAData()
        {
            List<PopulationUSA> result = new List<PopulationUSA>();

            PopulationUSA usa = new PopulationUSA("Population in USA", 316128839, new List<PopulationUSA>());
            result.Add(usa);

            PopulationUSA alabama = new PopulationUSA("Alabama", 4833722, new List<PopulationUSA>());
            usa.Items.Add(alabama);
            alabama.Items.Add(new PopulationUSA("Birmingham", 212113, null));
            alabama.Items.Add(new PopulationUSA("Montgomery", 201332, null));
            alabama.Items.Add(new PopulationUSA("Mobile", 194899, null));
            alabama.Items.Add(new PopulationUSA("Huntsville", 186254, null));
            alabama.Items.Add(new PopulationUSA("Tuscaloosa", 95334, null));
            alabama.Items.Add(new PopulationUSA("Hoover", 84126, null));
            alabama.Items.Add(new PopulationUSA("Dothan", 68001, null));
            alabama.Items.Add(new PopulationUSA("Auburn", 58582, null));
            alabama.Items.Add(new PopulationUSA("Decatur", 55816, null));

            PopulationUSA alaska = new PopulationUSA("Alaska", 735132, new List<PopulationUSA>());
            usa.Items.Add(alaska);
            alaska.Items.Add(new PopulationUSA("Anchorage", 300950, null));
            alaska.Items.Add(new PopulationUSA("Badger", 20200, null));
            alaska.Items.Add(new PopulationUSA("College", 13400, null));
            alaska.Items.Add(new PopulationUSA("Fairbanks", 32324, null));
            alaska.Items.Add(new PopulationUSA("Juneau", 32660, null));
            alaska.Items.Add(new PopulationUSA("Ketchikan", 8214, null));
            alaska.Items.Add(new PopulationUSA("Sitka", 9020, null));

            PopulationUSA arizona = new PopulationUSA("Arizona" , 6626624, new List<PopulationUSA>());
            usa.Items.Add(arizona);
            arizona.Items.Add(new PopulationUSA("Phoenix", 1513367, null));
            arizona.Items.Add(new PopulationUSA("Tucson", 526116, null));
            arizona.Items.Add(new PopulationUSA("Mesa", 457587, null));
            arizona.Items.Add(new PopulationUSA("Chandler", 249146, null));
            arizona.Items.Add(new PopulationUSA("Glendale", 234632, null));
            arizona.Items.Add(new PopulationUSA("Gilbert", 229972, null));
            arizona.Items.Add(new PopulationUSA("Scottsdale", 226918, null));
            arizona.Items.Add(new PopulationUSA("Tempe", 168228, null));
            arizona.Items.Add(new PopulationUSA("Peoria", 162592, null));
            arizona.Items.Add(new PopulationUSA("Surprise", 123546, null));

            PopulationUSA arkansas = new PopulationUSA("Arkansas", 2959373, new List<PopulationUSA>());
            usa.Items.Add(arkansas);
            arkansas.Items.Add(new PopulationUSA("Little Rock", 197357, null));
            arkansas.Items.Add(new PopulationUSA("Fort Smith", 87650, null));
            arkansas.Items.Add(new PopulationUSA("Fayetteville", 78960, null));
            arkansas.Items.Add(new PopulationUSA("Springdale", 75229, null));
            arkansas.Items.Add(new PopulationUSA("Jonesboro", 71551, null));
            arkansas.Items.Add(new PopulationUSA("North Little Rock", 66075, null));
            arkansas.Items.Add(new PopulationUSA("Conway", 63816, null));
            arkansas.Items.Add(new PopulationUSA("Rogers", 60112, null));
            arkansas.Items.Add(new PopulationUSA("Pine Bluff", 46094, null));
            arkansas.Items.Add(new PopulationUSA("Bentonville", 40167, null));

            PopulationUSA california = new PopulationUSA("California", 38332521, new List<PopulationUSA>());
            usa.Items.Add(california);
            california.Items.Add(new PopulationUSA("Los Angeles", 3884307, null));
            california.Items.Add(new PopulationUSA("San Diego", 1355896, null));
            california.Items.Add(new PopulationUSA("San Jose", 998537, null));
            california.Items.Add(new PopulationUSA("San Francisco", 837442, null));
            california.Items.Add(new PopulationUSA("Fresno", 509924, null));
            california.Items.Add(new PopulationUSA("Sacramento", 479686, null));
            california.Items.Add(new PopulationUSA("Long Beach", 469428, null));
            california.Items.Add(new PopulationUSA("Oakland", 406253, null));
            california.Items.Add(new PopulationUSA("Bakersfield", 363630, null));
            california.Items.Add(new PopulationUSA("Anaheim", 345012, null));
            california.Items.Add(new PopulationUSA("Santa Ana", 334227, null));

            PopulationUSA colorado = new PopulationUSA("Colorado", 5268367, new List<PopulationUSA>());
            usa.Items.Add(colorado);
            colorado.Items.Add(new PopulationUSA("Denver", 649495, null));
            colorado.Items.Add(new PopulationUSA("Colorado Springs", 439886, null));
            colorado.Items.Add(new PopulationUSA("Aurora", 345803, null));
            colorado.Items.Add(new PopulationUSA("Fort Collins", 152061, null));
            colorado.Items.Add(new PopulationUSA("Lakewood", 147214, null));
            colorado.Items.Add(new PopulationUSA("Thornton", 127359, null));
            colorado.Items.Add(new PopulationUSA("Arvada", 111707, null));
            colorado.Items.Add(new PopulationUSA("Westminster", 110945, null));
            colorado.Items.Add(new PopulationUSA("Pueblo", 108249, null));
            colorado.Items.Add(new PopulationUSA("Centennial", 106114, null));
            colorado.Items.Add(new PopulationUSA("Boulder", 103166, null));
            colorado.Items.Add(new PopulationUSA("Highlands Ranch", 102000, null));

            PopulationUSA connecticut = new PopulationUSA("Connecticut", 3596080, new List<PopulationUSA>());
            usa.Items.Add(connecticut);
            connecticut.Items.Add(new PopulationUSA("Bridgeport", 147216, null));
            connecticut.Items.Add(new PopulationUSA("New Haven", 130660, null));
            connecticut.Items.Add(new PopulationUSA("Stamford", 126456, null));
            connecticut.Items.Add(new PopulationUSA("Hartford", 125017, null));
            connecticut.Items.Add(new PopulationUSA("Waterbury", 109676, null));
            connecticut.Items.Add(new PopulationUSA("Norwalk", 87776, null));
            connecticut.Items.Add(new PopulationUSA("Danbury", 83684, null));
            connecticut.Items.Add(new PopulationUSA("New Britain", 72939, null));
            connecticut.Items.Add(new PopulationUSA("West Hartford", 63371, null));
            connecticut.Items.Add(new PopulationUSA("Bristol", 60568, null));
            connecticut.Items.Add(new PopulationUSA("Meriden", 60456, null));

            return result;
        }
    }
}
```
**TreeViewItemModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class TreeViewItemViewModel

    {
        public string id { get; set; }
        public string text { get; set; }
        public string spriteCssClass { get; set; }
        public string imageUrl { get; set; }
        public bool expanded { get; set; }
        public bool hasChildren { get; set; }
        public IEnumerable<TreeViewItemViewModel> items { get; set; }

        public TreeViewItemViewModel Clone()
        {
            TreeViewItemViewModel clone = new TreeViewItemViewModel
                {
                    id = this.id,
                    imageUrl = this.imageUrl,
                    spriteCssClass = this.spriteCssClass,
                    text = this.text,
                    expanded = this.expanded,
                    hasChildren = this.hasChildren
                };
            return clone;
        }
    }
}
```
**TreeViewRepository.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Kendo.Mvc.UI;

namespace Kendo.Mvc.Examples.Models
{
    public static class TreeViewRepository
    {
        private static List<TreeViewItemViewModel> projectData;

        static TreeViewRepository()
        {
            projectData = new List<TreeViewItemViewModel>();
            projectData.Add(new TreeViewItemViewModel
                {
                    id = "1",
                    text = "My Documents",
                    expanded = true,
                    hasChildren = true,
                    spriteCssClass = "rootfolder",
                    items = new List<TreeViewItemViewModel>
                       {
                           new TreeViewItemViewModel
                           {
                                id = "2",
                                text = "Kendo UI Project",
                                expanded  = true,
                                spriteCssClass = "folder",
                                hasChildren = true,
                                items = new List<TreeViewItemViewModel>
                                {
                                    new TreeViewItemViewModel
                                    {
                                            id = "3",
                                            text ="about.html",
                                            spriteCssClass = "html"
                                    },
                                    new TreeViewItemViewModel
                                    {
                                            id = "4",
                                            text ="index.html",
                                            spriteCssClass = "html"
                                    },
                                    new TreeViewItemViewModel
                                    {
                                            id = "5",
                                            text ="logo.png",
                                            spriteCssClass = "image"
                                    }
                                }
                           },
                           new TreeViewItemViewModel
                           {
                                id = "6",
                                text = "New Web Site",
                                expanded  = true,
                                spriteCssClass = "folder",
                                hasChildren = true,
                                items = new List<TreeViewItemViewModel>
                                {
                                    new TreeViewItemViewModel
                                    {
                                            id = "7",
                                            text ="mockup.jpg",
                                            spriteCssClass = "image"
                                    },
                                    new TreeViewItemViewModel
                                    {
                                            id = "8",
                                            text ="Research.pdf",
                                            spriteCssClass = "pdf"
                                    }
                                }
                           },
                           new TreeViewItemViewModel
                           {
                                id = "9",
                                text = "Reports",
                                expanded  = true,
                                spriteCssClass = "folder",
                                hasChildren = true,
                                items = new List<TreeViewItemViewModel>
                                {
                                    new TreeViewItemViewModel
                                    {
                                            id = "10",
                                            text ="February.pdf",
                                            spriteCssClass = "pdf"
                                    },
                                    new TreeViewItemViewModel
                                    {
                                            id = "11",
                                            text ="March.pdf",
                                            spriteCssClass = "pdf"
                                    },
                                        new TreeViewItemViewModel
                                    {
                                            id = "12",
                                            text ="April.pdf",
                                            spriteCssClass = "pdf"
                                    }
                                }
                           }
                       }
                });

        }

        public static List<TreeViewItemViewModel> GetProjectData()
        {
            return projectData;
        }

        public static IEnumerable<TreeViewItemViewModel> GetChildren(string id)
        {
            Queue<TreeViewItemViewModel> items = new Queue<TreeViewItemViewModel>(projectData);

            while (items.Count > 0)
            {
                var current = items.Dequeue();
                if (current.id == id)
                {
                    return current.items.Select(o => new TreeViewItemViewModel
                        {
                            id = o.id,
                            text = o.text,
                            expanded = o.expanded,
                            hasChildren = o.hasChildren,
                            imageUrl = o.imageUrl,
                            spriteCssClass = o.spriteCssClass
                        });
                }

                if (current.hasChildren)
                {
                    foreach (var item in current.items)
                    {
                        items.Enqueue(item);
                    }
                }
            }

            return new List<TreeViewItemViewModel>();
        }
    }
}
```
**UploadInitialFile.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class UploadInitialFile
    {
        public string Name { get; set; }
        public long Size { get; set; }
        public string Extension { get; set; }

        public UploadInitialFile(string name, long size, string extension)
        {
            this.Name = name;
            this.Size = size;
            this.Extension = extension;
        }
    }
}
```
**UploadOverviewModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class UploadOverviewModel
    {
        public bool IsLimited { get; set; }
        public string[] AllowedExtensions { get; set; }
    }
}
```
**UrbanArea.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class UrbanArea
    {
        public int ID { get; set; }
        public string City { get; set; }
        public string Country { get; set; }
        public decimal Latitude { get; set; }
        public decimal Longitude { get; set; }
        public string Country_ISO3 { get; set; }
        public int Pop1950 { get; set; }
        public int Pop1955 { get; set; }
        public int Pop1960 { get; set; }
        public int Pop1965 { get; set; }
        public int Pop1970 { get; set; }
        public int Pop1975 { get; set; }
        public int Pop1980 { get; set; }
        public int Pop1985 { get; set; }
        public int Pop1990 { get; set; }
        public int Pop1995 { get; set; }
        public int Pop2000 { get; set; }
        public int Pop2005 { get; set; }
        public int Pop2010 { get; set; }
        public int Pop2015 { get; set; }
        public int Pop2020 { get; set; }
        public int Pop2025 { get; set; }
        public int Pop2050 { get; set; }
    }
}

```
**UrbanArea.cs**

```C#
using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace Kendo.Mvc.Examples.Models
{
    public partial class UrbanArea
    {
        [DatabaseGenerated(DatabaseGeneratedOption.Computed)]
        public decimal[] Location {
            get
            {
                return new decimal[] { this.Latitude, this.Longitude };
            }

            private set { }
        }
    }
}

```
**UserViewModel.cs**

```C#
namespace Kendo.Mvc.Examples.Models.Form
{
    using System;
    using System.ComponentModel.DataAnnotations;

    public class UserViewModel
    {
        public int UserID
        {
            get;
            set;
        }

        [Required]
        public string UserName
        {
            get;
            set;
        }

        [Required(ErrorMessage = "First Name is Required")]
        public string FirstName
        {
            get; set;
        }

        [Required(ErrorMessage = "Last Name is Required")]
        public string LastName
        {
            get;
            set;
        }

        [RegularExpression(@"^[A-Za-z0-9](([_\.\-]?[a-zA-Z0-9]+)*)@([A-Za-z0-9]+)(([\.\-‌​]?[a-zA-Z0-9]+)*)\.([A-Za-z]{2,})$", ErrorMessage = "Email is not valid")]
        public string Email
        {
            get;
            set;
        }

        [Required]
        public string Password
        {
            get;
            set;
        }

        [Required]
        public bool Agree
        {
            get;
            set;
        }

        public DateTime? DateOfBirth { get; set; }

        public DateTime? HireDate { get; set; }

        public DateTime? RetireDate { get; set; }

        public string Company { get; set; }

        public string Feedback { get; set; }
    }
}

```
**Video.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class Video
    {
        public string title { get; set; }
        public string source { get; set; }
        public string poster { get; set; }
    }
}
```
**VisitorConversionViewModel.cs**

```C#
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Kendo.Mvc.Examples.Models
{
    public class VisitorConversionViewModel
    {
        public int Conversion { get; set; }

        public int Users { get; set; }

        public string Channel { get; set; }

        public double Value { get; set; }

        public DateTime Date { get; set; }
    }
}
```
**Weather.cs**

```C#
//------------------------------------------------------------------------------
// <auto-generated>
//    This code was generated from a template.
//
//    Manual changes to this file may cause unexpected behavior in your application.
//    Manual changes to this file will be overwritten if the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Kendo.Mvc.Examples.Models
{
    using System;
    using System.Collections.Generic;

    public partial class Weather
    {
        public int ID { get; set; }
        public string Station { get; set; }
        public System.DateTime Date { get; set; }
        public decimal TMax { get; set; }
        public decimal TMin { get; set; }
        public decimal Wind { get; set; }
        public Nullable<decimal> Gust { get; set; }
        public decimal Rain { get; set; }
        public Nullable<decimal> Snow { get; set; }
        public string Events { get; set; }
    }
}

```
**WebMail.cs**

```C#
using System;

namespace Kendo.Mvc.Examples.Models
{
    public class WebMail
    {
        public int MailID { get; set; }

        public int FromID { get; set; }

        public string From { get; set; }

        public string Date { get; set; }

        public string Title { get; set; }
    }
}

```
**WebMailDataRepository.cs**

```C#
using System.Collections.Generic;
using System;

namespace Kendo.Mvc.Examples.Models
{
    public partial class WebMailDataRepository
    {
        public static IEnumerable<WebMail> WebMailData()
        {
            return new List<WebMail>
            {
                new WebMail {
                    MailID = 1,
                    FromID = 1,
                    From = "Ivo Nedkov",
                    Date = "2/22/2009",
                    Title = "RE: New version of Telerik Trainer"
                },

                new WebMail {
                    MailID = 2,
                    FromID = 2,
                    From = "Jytte Petersen",
                    Date = "2/22/2009",
                    Title = "RE: New version of Telerik Trainer"
                },

                new WebMail {
                    MailID = 3,
                    FromID = 3,
                    From = "Renate Messner",
                    Date = "2/22/2009",
                    Title = "RE: Conferences?"
                },

                new WebMail {
                    MailID = 4,
                    FromID = 4,
                    From = "Kevin Babcock",
                    Date = "2/21/2009",
                    Title = "RE: Conferences?"
                },

                new WebMail {
                    MailID = 5,
                    FromID = 5,
                    From = "Hari Kumar",
                    Date = "2/21/2009",
                    Title = "RE: New 'Your Links' menu on telerik.com"
                }

            };
        }

    }
}
```
**WindDataItem.cs**

```C#
namespace Kendo.Mvc.Examples.Models
{
    public class WindDataItem
    {
        public int Dir { get; set; }
        public string DirText { get; set; }
        public string Category { get; set; }
        public double Frequency { get; set; }

        public WindDataItem(int dir, string dirText, string category, double frequency)
        {
            Dir = dir;
            DirText = dirText;
            Category = category;
            Frequency = frequency;
        }
    }
}
```




