---
title: Video Onboarding
page_title: Video Onboarding
description: "Get started with {{ site.product_short }} by following a step-by-step video tutorial on developing a real-life project."
slug: virtualclass_uiformvc
position: 5
previous_url: /getting-started/virtual-classroom-mvc, /virtual-classroom
permalink: /getting-started/video-onboarding
---

# Video Onboarding

Telerik UI for ASP.NET MVC has its [own video getting started experience](https://learn.telerik.com/learn/course/internal/view/elearning/3/telerik-ui-for-aspnet-mvc) available to both active trial users and active license holders in [Virtual Classroom](https://learn.telerik.com/learn). The training course is developed to help you get started with the Telerik UI for ASP.NET MVC components and features. It aims to put you in the shoes of an engineer who adds new features to an existing application.

The process starts by adding basic Telerik UI components and widgets to the application and shows how to harness the power of the Telerik UI for ASP.NET MVC controls and features in no time. Further on, you'll get into more advanced components, like the Chart and the Grid, and learn how to incorporate Telerik UI components to interact with existing functionality and with each other. Finally, the course will explore how to build your own theme and change it for all components at once.

## Course Overview

The next video shares a glimpse of the format and structure of the whole training and provides a brief overview of what will be accomplished through the steps.
<iframe width="560" height="315" src="https://www.youtube.com/embed/1PtAbW6Vyx0" title="ASP.NET MVC - Virtual Classroom Course Overview" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

## Project Overview

This video explains the details around the project you will be modifying&mdash;what it is, what needs to be added, and what the accomplished state will look like. 
<iframe width="560" height="315" src="https://www.youtube.com/embed/rFH8_NTuw_8" title="ASP.NET MVC - Virtual Classroom Project Overview" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

## Onboarding Modules

The Telerik UI for ASP.NET MVC technical online training has an approximate duration of 3 hours and is split into nine modules with the following learning path:

* **Chapter 1: Welcome** (Prerequisites, Resources, Tour of Demo Application for Telerik UI for ASP.NET Core)
* **Chapter 2: Getting Started** (Installation and Creating First Telerik UI for ASP.NET Core application, Solution structure)
* **Chapter 3: Fundamentals** (Server-side setup, Tag and HTML helpers, Script rendering, Kendo Scripts and Styles)
* **Chapter 4: Basic UI Components** (DropDownList, Slider, TabStrip, ComboBox)
* **Chapter 5: Chart** (Chart setup, data, categories, series and styling)
* **Chapter 6: Grid** (Grid setup and rendering, Grid columns, paging and sorting, Grid events)
* **Chapter 7: Styling and Theming** (Built-In Themes, Creating Custom Theme, Styling and Icons)
* **Chapter 8: More Components** (Tile Layout, Upload)*
* **Chapter 9: Enriching your ASP.NET Core App** (Globalization, Localization, RTL, Accessibility, Keyboard Navigation, Document Processing and integration with other Telerik products)*

If you wish to learn more and continue with the video onboarding [enroll in the training](https://learn.telerik.com/learn/course/internal/view/elearning/3/telerik-ui-for-aspnet-mvc) from the [Virtual Classroom](https://learn.telerik.com/learn).

  
