---
title: Overview
page_title: VS Integration Overview
description: "Learn how to enhance experience of developing web applications with Telerik UI for ASP.NET MVC."
slug: overview_visualstudio_aspnetmvc
position: 1
permalink: /getting-started/vs-integration/introduction
---

# Visual Studio Integration Overview

The Progress&reg; Telerik&reg; UI for ASP.NET MVC Visual Studio (VS) Extensions enhance the experience in developing MVC web applications with Telerik UI for ASP.NET MVC.

The extensions handle the following major points:

* Project [Creation]({% slug newprojectwizards_visualstudio_aspnetmvc %}) and [Configuration]({% slug projectwizardconfig_visualstudio_aspnetmvc %}) Wizards&mdash;Web asset management, adding the required settings to `web.config`, changing the theme.
* Project [Upgrade]({% slug projectwizardupgrade_visualstudio_aspnetmvc %})&mdash;Upgrading Telerik UI for ASP.NET MVC to a new version.

The Telerik UI for ASP.NET MVC VS Extensions are distributed with the Telerik UI for ASP.NET MVC installer. They support Visual Studio 2022, 2019, 2017, 2015, 2013 and 2012.

> VS Express editions are not supported.

The VS Extensions can be accessed through the **Telerik | Telerik UI for ASP.NET MVC** menu which has different menu items depending on the selected project in VS. Additionally, the extensions can be accessed through the Solution Explorer context menu of any supported ASP.NET MVC Web Application projects.

![Visual Studio with no selected projects](../../getting-started-mvc/vs-integration/images/create_menu.png)

![The selected project in VS is a standard ASP.NET MVC 4 or 5 web application](../../getting-started-mvc/vs-integration/images/convert_menu.png)

![The selected project in VS is a Telerik UI for ASP.NET MVC web application](../../getting-started-mvc/vs-integration/images/configure_menu.png)

When installed, the extensions add the project templates to the New Project dialog of VS.

* C# Telerik UI for ASP.NET MVC web application
* VB Telerik UI for ASP.NET MVC web application

![The added project templates](../../getting-started-mvc/vs-integration/images/project_template.png)

These are available in the language-specific nodes of the dialog as well. The **Add New Project** dialog contains the Telerik UI for ASP.NET MVC web application under both the `CSharp\Web` and `Visual Basic\Web` nodes.

The following additional project templates are also available:
* [C# Telerik ASP.NET Core MVC application](https://docs.telerik.com/aspnet-core/introduction)
* [Kendo UI ASP.NET MVC 5 application]({% slug newprojectwizard_visualstudio_kendoui %})

The new ASP.NET MVC 4 project wizard also contains the Telerik UI for ASP.NET MVC web application.

![The MVC wizard](../../getting-started-mvc/vs-integration/images/mvc_wizard.png)

## See Also

* [Creating New Projects with Visual Studio]({% slug newprojectwizards_visualstudio_aspnetmvc %})
* [Downloading the Latest Telerik UI for ASP.NET Core Versions]({% slug latestversionretrieval_visualstudio_aspnetmvc %})
