---
title: Color Alternating Rows
page_title: Color Alternating Rows
description: "Customize the Excel document the Grid generates during exporting and color alternating rows in ASP.NET MVC applications."
previous_url: /helpers/data-management/grid/how-to/Export/alternating-rows
slug: howto_alternatingrows_aspnetmvcgrid
---

# Color Alternating Rows

The demo on how to color the alternating rows of an exported Grid to Excel uses the [`background`](https://docs.telerik.com/kendo-ui/api/javascript/ooxml/workbook#configuration-sheets.rows.cells.background) option of the cell to set the background color of the alternating rows.

To see the example, refer to the project on [coloring alternating rows](https://github.com/telerik/ui-for-aspnet-mvc-examples/tree/master/grid/alternating-rows).

> These projects require a UI for ASP.NET MVC 2014.3.1125 version or later. Earlier versions do not expose the `ExcelExport` event through the fluent API.

For more information on how Excel documents work, refer to the [introductory article on Excel](https://docs.telerik.com/kendo-ui/framework/excel/introduction).

## See Also

* [Overview of the Grid HtmlHelper]({% slug htmlhelpers_grid_aspnetcore_overview %})
* [GridBuilder API Reference](https://docs.telerik.com/aspnet-mvc/api/Kendo.Mvc.UI.Fluent/GridBuilder)
