---
title: Edit Grids Using ComboBoxes with Remote Binding and Filtering
page_title: Edit Grids Using ComboBoxes with Remote Binding and Filtering
description: "Edit the Kendo UI Grid by using a ComboBox with remote binding and filtering."
previous_url: /helpers/data-management/grid/how-to/editing/grid-editing-with-combobox-remote-binding-and-filtering
slug: howto_editusingcomboboxremotebindfilter_gridaspnetmvc
---

# Edit Grids Using ComboBoxes with Remote Binding and Filtering

This project demonstrates how to implement a [custom MVVM binding](https://docs.telerik.com/kendo-ui/framework/mvvm/overview) and disable the default value binding for a ComboBox.

The approach prevents the initial binding when a selected value is set. It can also be used to avoid the default [value binding](https://docs.telerik.com/kendo-ui/framework/mvvm/bindings/value#value-binding-of-elements-select) behavior when the ComboBox is bound to a great amount of data.

To see the example, refer to the project on how to [use ComboBoxes with remote binding and filtering](https://github.com/telerik/ui-for-aspnet-mvc-examples/tree/master/grid/grid-editing-with-combobox-remote-binding-and-filtering).

## See Also

* [Overview of the Grid HtmlHelper]({% slug htmlhelpers_grid_aspnetcore_overview %})
* [GridBuilder API Reference](https://docs.telerik.com/aspnet-mvc/api/Kendo.Mvc.UI.Fluent/GridBuilder)
