---
title: Overview
page_title: Accessibility
description: "Get started with the {{ site.product_short }} Pager by Telerik UI and learn about its accessibility support for WAI-ARIA, Section 508, and WCAG 2.1."
slug: accessibility_aspnetcore_pager
position: 1
---

# Pager Accessibility

The pager is accessible by screen readers and provides WAI-ARIA, Section 508, WCAG 2.1, and keyboard support.

For more information, refer to:
* [Keyboard navigation by the {{ site.product_short }} Pager]({% slug keynav_aspnetcore_pager %})
* [Accessibility in {{ site.product }}]({% slug overview_accessibility %})

## WAI-ARIA

The component follows the WAI-ARIA Authoring Practices for implementing the keyboard navigation for its component role and is tested against the popular screen readers. For more information, refer to the article on [WAI-ARIA support in {{ site.product_short }}]({% slug overview_accessibility %}#wai-aria).

## Section 508

The Pager is compliant with the Section 508 requirements. For more information, refer to the article on [Section 508 support in Kendo UI for jQuery]({% slug overview_accessibility %}#section-508).

## WCAG 2.1

The pager supports the standards for providing accessible web content which are set by the [Web Content Accessibility Guidelines 2.1](https://www.w3.org/TR/WCAG/).

For more information, refer to:
* [WCAG 2.1 support by the Pager (demo)](https://demos.telerik.com/{{ site.platform }}/pager/index)
* [WCAG 2.1 compliance in {{ site.product_short }} ]({% slug overview_accessibility %}#wcag-21)

## See Also

* [WCAG 2.1 Support by the Pager HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/pager/index)
* [Keyboard Navigation by the Pager HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/pager/keyboard-navigation)
* [Keyboard Navigation by the Pager HtmlHelper for {{ site.framework }}]({% slug keynav_aspnetcore_pager %})
* [Accessibility Compliance in {{ site.product }}]({% slug compliance_accessibility %})
