---
title: Data Binding
page_title: Data Binding
description: "Get started with the Telerik UI PivotGrid HtmlHelper for {{ site.framework }} and learn about the OLAP cube configuration for performing Ajax data binding with the Telerik UI PivotGrid HtmlHelper for {{ site.framework }}."
slug: databinding_pivotgridhelper_aspnetcore
position: 1
---

# Data Binding

The PivotGrid for {{ site.framework }} supports Ajax data binding to an HTTP accessible Online Analytical Processing (OLAP) cube and to flat data.

Telerik UI provides an OLAP service dll that can be used for testing and is hosted at `https://demos.telerik.com/olap/msmdpump.dll`. To see the responses, the service needs to be queried and cannot be opened directly in the browser. For more information on binding the PivotGrid to data over an OLAP cube, refer to the following articles:
* [OLAP Cube Fundamentals]({% slug htmlhelpers_pivotgrid_aspnetcore_fundamentals %})
* [OLAP Cube Setup]({% slug htmlhelpers_pivotgrid_aspnetcore_olap_cube_setup %})
* [PivotConfigurator Overview]({% slug htmlhelpers_pivotgrid_aspnetcore_configurator %})

When the PivotGrid is bound to flat data, it creates a client-side cube which allows the categorization of the flat data. For runnable examples on binding the PivotGrid to flat data, refer to the following online demos:
* [Local binding of the PivotGrid HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/pivotgrid/local-flat-data-binding)
* [Remote binding of the PivotGrid HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/pivotgrid/remote-flat-data-binding)

## See Also

* [Local Data Binding by the PivotGrid HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/pivotgrid/local-flat-data-binding)
* [Remote Data Binding by the PivotGrid HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/pivotgrid/remote-flat-data-binding)
* [Server-Side API](/api/pivotgrid)
