---
title: List of Keyboard Shortcuts
page_title: Spreadsheet
description: "A list of the keyboard shortcuts supported by the Telerik UI Spreadsheet HtmlHelper for {{ site.framework }}."
slug: htmlhelpers_spreadsheet_list_of_shortcuts_aspnetcore
position: 3
---

# List of Keyboard Shortcuts

The following table provides a list of the keyboard shortcuts the Spreadsheet supports.

| Shortcuts                                  | Description				                                |
| :---                                       | :---						                                    |
| `Ctrl` + `A`                               | Selects the whole worksheet								        |
| `Ctrl` + `C`                               | Copies selected cells    						        	    |
| `Ctrl` + `P`                               | Displays the **Print** dialog box                  |
| `Ctrl` + `S`                               | Saves the active spreadsheet file                  |
| `Ctrl` + `V`                               | Inserts copied or cut cells to a selected location within the worksheet |
| `Ctrl` + `X`                               | Cuts selected cells										            |
| `Ctrl` + `Y`                               | Repeats the last action, if possible by using the `Redo` command |
| `Ctrl` + `Z`                               | Reverses the last action or deletes the last typed entry by using the `Undo` command |
| `Ctrl` + select a cell                     | Selects an adjacent or non adjacent cell |
| `Ctrl` + select cells                      | Selects a range of adjacent or nonadjacent cells. To simultaneously select more than one range of cells, repeat this command. The selected ranges can also overlap. |
| `Ctrl` + select a row or column 	         | Selects an adjacent or nonadjacent row or column.  |
| `Ctrl` + select rows or columns            | Selects a range of adjacent or nonadjacent rows or columns. To simultaneously select more than one range of rows or columns, repeat this command. The selected ranges can also overlap. |
| `Arrow` keys                               | Move a cell up, down, left, or right in a worksheet          |
| `Ctrl` + `Arrow` key                       | Moves to the edge of the current data region of the active worksheet |
| `Shift` + `Arrow` key                      | Selects (a range of) adjacent cells, rows, or columns, by extending the selection by one cell, row, or column |
| `Ctrl` + `Shift` + `Arrow` key             | Extends the selection of cells to the last nonblank cell in the same row or column as the active cell |
| `Down Arrow` / `Up Arrow` key              | <ul><li>Selects the next or previous command when a menu or submenu is open</li> <li>In a dialog box, the arrow keys move between options in an active drop-down list, or between options in a group of options</li></ul> |
| `F2` | Enters editing mode for the currently selected cell |
| `F10` | Focuses the first tool of Spreadsheet toolbar |
| `Backspace`                                | <ul><li>Deletes one character to the left in the **Formula Bar**</li> <li>Removes the content of the active cell</li> <li>In cell editing mode, it deletes the character to the left of the insertion point</li></ul> |
| `Delete`                                   | <ul><li>Removes the content from selected cells without affecting cell formats</li> <li>In cell editing mode, it deletes the character to the right of the insertion point</li></ul> |
| `End`                                      | <ul><li>Goes to the far right cell of the active row</li> <li>Selects the last command on a visible and active menu or submenu</li></ul>
| `Ctrl` + `End`                             | <ul><li>Moves to the last cell on a worksheet, in the lowest used row of the used column on the far right</li> <li>If the cursor is in the formula bar, `Ctrl` + `End` moves the cursor to the end of the text</li> <li>`Ctrl` + `End` moves to the last cell on a worksheet, in the lowest used row of the used column on the far right</li></ul> |
| `Ctrl` + `Shift` + `End`                   | <ul><li>Extends the selection of cells to the last used cell on the worksheet located in lower-right corner</li> <li>If the cursor is in the formula bar, `Ctrl` + `Shift` + `End` selects all text in the formula bar from the cursor position to the end</li></ul> |
| `Enter`                                    | <ul><li>Completes a cell entry from the cell or the **Formula Bar**, and selects the cell below</li> <li>In a data form, it moves to the first field in the next record</li> <li>Opens a selected menu or performs the action for a selected command</li> <li>In a dialog box, it performs the action for the default command button in the dialog box (the button with the bold outline)</li></ul> |
| `Alt` + `Enter` | In cell editing mode or in the **Formula bar** creates a new row within the cell |
| `Esc`                                      | <ul><li>Cancels an entry in the cell or **Formula Bar**</li> <li>Closes an open menu or submenu, dialog box, or message window</li></ul> |
| `Home`                                     | <ul><li>Moves to the beginning of a row in a worksheet</li> <li>Selects the first command on the menu when a menu or submenu is visible</li></ul> |
| `Ctrl` + `Home`                            | Moves to the beginning of a worksheet                        |
| `Ctrl` + `Shift` + `Home`                  | Extends the selection of cells to the beginning of the worksheet |
| `Page Down`                                | Moves one screen down in a worksheet                         |
| `Page Up`                                  | Moves one screen up in a worksheet                           |
| `Spacebar`                                 | In a dialog box, performs the action for the selected button, or selects or clears a check box |
| `Alt` + `Spacebar`                         | Displays the **Control** menu for the Spreadsheet window     |
| `Tab`                                      | <ul><li>Moves one cell to the right in a worksheet</li> <li>Moves to the next option or option group in a dialog box</li> <li>Moves a cell within an active range of cells, rows, or columns.</li></ul> |
| `Shift` + `Tab`                            | Moves to the previous cell in a worksheet or the previous option in a dialog box |

## See Also

* [List of Formulas and Functions]({% slug htmlhelpers_spreadsheet_list_of_formulas_aspnetcore %})
* [User Guide]({% slug htmlhelpers_spreadsheet_user_guide_aspnetcore %})
