---
title: Overview
page_title: Accessibility
description: "Get started with the Telerik UI DateTimePicker for {{ site.framework }} and learn about its accessibility support for WAI-ARIA, Section 508, and WCAG 2.1."
slug: accessibility_datetimepicker_aspnetcore
position: 1
---

# DateTimePicker Accessibility

The DateTimePicker is accessible by screen readers and provides WAI-ARIA, Section 508, WCAG 2.1, and keyboard support.

For more information, refer to:
* [Keyboard navigation by the Telerik UI DateTimePicker]({% slug keynav_datetimepicker_aspnetcore %})
* [Accessibility in {{ site.product }}]({% slug overview_accessibility %})

## WAI-ARIA

The component follows the WAI-ARIA Authoring Practices for implementing the keyboard navigation for its component role and is tested against the popular screen readers. For more information, refer to the article on [WAI-ARIA support in {{ site.product }}]({% slug overview_accessibility %}#wai-aria).

To customize the `aria-label` text of the currently focused cell in the calendar, use the [`ARIATemplate`](/api/Kendo.Mvc.UI.Fluent/DateTimePickerBuilder#ariatemplatesystemstring) configuration option.

## Section 508

The DateTimePicker is compliant with the Section 508 requirements. For more information, refer to the article on [Section 508 support in {{ site.product }}]({% slug overview_accessibility %}#section-508).

## WCAG 2.1

The DateTimePicker supports the standards for providing accessible web content which are set by the [Web Content Accessibility Guidelines 2.1](https://www.w3.org/TR/WCAG/). For more information, refer to the article on [WCAG 2.1 compliance in {{ site.product }}]({% slug overview_accessibility %}#wcag-21).

## See Also

* [Keyboard Navigation by the DateTimePicker HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/datetimepicker/index)
* [Accessibility in {{ site.product }}]({% slug overview_accessibility %})
