---
title: Overview
page_title: Accessibility
description: "Get started with the Telerik UI ListBox for {{ site.framework }} and learn about its accessibility support for WAI-ARIA, Section 508, and WCAG 2.1."
slug: htmlhelpers_listbox_accessibility_aspnetcore
position: 1
---

# ListBox Accessibility

The ListBox is accessible by screen readers and provides WAI-ARIA, Section 508, WCAG 2.1, and keyboard support.

For more information, refer to:
* [Keyboard navigation by the Telerik UI ListBox HtmlHelper for {{ site.framework }}]({% slug htmlhelpers_listbox_navigation_aspnetcore %})
* [Accessibility in {{ site.product }}]({% slug overview_accessibility %})

## WAI-ARIA

The component follows the WAI-ARIA Authoring Practices for implementing the keyboard navigation for its component role and is tested against the popular screen readers. For more information, refer to the article on [accessibility support in {{ site.product }}]({% slug compliance_accessibility %}).

## Section 508

The ListBox is compliant with the Section 508 requirements. For more information, refer to the article on [accessibility support in {{ site.product }}]({% slug compliance_accessibility %}).

## WCAG 2.1

The ListBox supports the standards for providing accessible web content which are set by the [Web Content Accessibility Guidelines 2.1](https://www.w3.org/TR/WCAG/). For more information, refer to the article on [accessibility support in {{ site.product }}]({% slug compliance_accessibility %}).

## See Also

* [Keyboard Navigation by the ListBox HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/listbox/keyboard-navigation)
* [Keyboard Navigation by the ListBox HtmlHelper for {{ site.framework }}]({% slug htmlhelpers_listbox_navigation_aspnetcore %})
* [Accessibility in {{ site.product }}]({% slug compliance_accessibility %})
