---
title: Accessibility
page_title: MaskedTextBox Accessibility
description: "Get started with the Telerik UI MaskedTextBox for {{ site.framework }} and learn about its accessibility support for WAI-ARIA, Section 508, and WCAG 2.1."
slug: accessibility_maskedtextbox_aspnetcore
position: 60
---

# MaskedTextBox Accessibility

The MaskedTextBox is accessible by screen readers and provides WAI-ARIA, Section 508, WCAG 2.1, and keyboard support.

For more information, refer to the article on [accessibility in {{ site.product }}]({% slug overview_accessibility %}).

## WAI-ARIA

The component follows the WAI-ARIA Authoring Practices for implementing the keyboard navigation for its component role and is tested against the popular screen readers.

## Section 508

The MaskedTextBox is compliant with the Section 508 requirements.

## WCAG 2.1

The MaskedTextBox supports the standards for providing accessible web content which are set by the [Web Content Accessibility Guidelines 2.1](https://www.w3.org/TR/WCAG/).

## See Also

* [Basic Usage of the MaskedTextBox HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/maskedtextbox/index)
* [Using the API of the MaskedTextBox HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/maskedtextbox/api)
* [Server-Side API](/api/maskedtextbox)
