---
title: Overview
page_title: Globalization
description: "Get started with the Telerik UI MaskedTextBox for {{ site.framework }} and learn about the globalization options it supports."
slug: globalization_maskedtextbox_aspnetcore
position: 1
---

# MaskedTextBox Globalization

The globalization process combines the translation of component messages (localization) with adapting them to specific cultures (internationalization and right-to-left support).

To determine the currency symbol and other culture-specific properties, the MaskedTextBox uses the `kendo.culture.current` culture.

The globalization functionality of the MaskedTextBox is enabled through its [right-to-left support]({% slug rtl_maskedtextbox_aspnetcore %}). For a complete example, refer to the [demo on globalization of the MaskedTextBox](https://demos.telerik.com/{{ site.platform }}/maskedtextbox/globalization).

For more information on using localization and right-to-left languages with {{ site.product }} HTML Helpers, refer to the article on [globalization support by {{ site.product }}]({% slug overview_globalization_core %}).

## See Also

* [RTL Support by the MaskedTextBox HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/maskedtextbox/right-to-left-support)
* [Globalization by the MaskedTextBox HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/maskedtextbox/globalization)
* [Globalization in {{ site.product }}]({% slug overview_globalization_core %})
* [Server-Side API](/api/maskedtextbox)
