---
title: Overview
page_title: Globalization
description: "Get started with the Telerik UI NumericTextBox for {{ site.framework }} and learn about the globalization options it supports."
slug: globalization_numerictextbox_aspnetcore
position: 1
---

# NumericTextBox Globalization

The globalization process combines the translation of component messages (localization) with adapting them to specific cultures (internationalization and right-to-left support).

To determine the number precision and other culture-specific properties, the NumericTextBox uses the `kendo.culture.current` culture.

The globalization functionality of the NumericTextBox is enabled through:
* [Localization of messages]({% slug localization_numerictextbox_aspnetcore %})
* [Right-to-left support]({% slug rtl_numerictextbox_aspnetcore %})

For a complete example, refer to the [demo on globalization of the NumericTextBox](https://demos.telerik.com/{{ site.platform }}/numerictextbox/globalization).

## See Also

* [Globalization Support by the NumericTextBox HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/numerictextbox/globalization)
* [RTL Support by the NumericTextBox HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/numerictextbox/right-to-left-support)
* [Server-Side API](/api/numerictextbox)
