---
title: Overview
page_title: Accessibility
description: "Get started with the {{ site.product_short }} RadioGroup by Telerik UI and learn about its accessibility support for WAI-ARIA, Section 508, and WCAG 2.1."
slug: htmlhelpers_accessibility_radiogroup_aspnetcore
position: 1
---

# RadioGroup Accessibility

The RadioGroup is accessible by screen readers and provides WAI-ARIA, Section 508, WCAG 2.1, and keyboard support.

For more information, refer to:
* [Keyboard navigation by the {{ site.product_short }} RadioGroup]({% slug htmlhelpers_radiogroup_keyboardnavigation_aspnetcore %})
* [Accessibility in {{ site.product }}]({% slug overview_accessibility %})

## WAI-ARIA

The component follows the WAI-ARIA Authoring Practices for implementing the keyboard navigation for its component role and is tested against the popular screen readers. For more information, refer to the article on [WAI-ARIA support in {{ site.product }}]({% slug overview_accessibility %}#wai-aria).

## Section 508

The RadioGroup is compliant with the Section 508 requirements. For more information, refer to the article on [Section 508 support in {{ site.product }}]({% slug overview_accessibility %}#section-508).

## WCAG 2.1

The RadioGroup supports the standards for providing accessible web content which are set by the [Web Content Accessibility Guidelines 2.1](https://www.w3.org/TR/WCAG/). For more information, refer to the article on [WCAG 2.1 compliance in {{ site.product_short }} ]({% slug overview_accessibility %}#wcag-21)

## See Also

* [Keyboard Navigation by the RadioGroup HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/radiogroup/keyboard-navigation)
* [Keyboard Navigation by the RadioGroup HtmlHelper for {{ site.framework }}]({% slug htmlhelpers_radiogroup_keyboardnavigation_aspnetcore %})
* [Accessibility in {{ site.product }}]({% slug compliance_accessibility %})
