---
title: Overview
page_title: Accessibility
description: "Get started with the {{ site.product_short }} MediaPlayer by Telerik UI and learn about its accessibility support for WAI-ARIA, Section 508, and WCAG 2.1."
previous_url: /helpers/media/mediaplayer/accessibility/overview
slug: htmlhelpers_mediaplayer_accessibility_overview_aspnetcore
position: 1
---

# MediaPlayer Accessibility

The MediaPlayer is accessible by screen readers and provides WAI-ARIA, Section 508, WCAG 2.1, and keyboard support.

For more information, refer to:
* [Keyboard navigation in the Telerik UI MediaPlayer for {{ site.framework }}]({% slug htmlhelpers_mediaplayer_accessibility_keyboard_navigation_aspnetcore %})
* [Accessibility in {{ site.product_short }}]({% slug overview_accessibility %})

## WAI-ARIA

The MediaPlayer follows the WAI-ARIA Authoring Practices for implementing the keyboard navigation for its component role and is tested against the popular screen readers. For more information, refer to the article on [WAI-ARIA support in {{ site.product_short }}]({% slug overview_accessibility %}#wai-aria).

## Section 508

The MediaPlayer is compliant with the Section 508 requirements. For more information, refer to the article on [Section 508 support in Kendo UI for jQuery]({% slug overview_accessibility %}#section-508).

## WCAG 2.1

The MediaPlayer supports the standards for providing accessible web content which are set by the [Web Content Accessibility Guidelines 2.1](https://www.w3.org/TR/WCAG/).

For more information, refer to:
* [WCAG 2.1 support by the MediaPlayer (demo)](https://demos.telerik.com/{{ site.platform }}/mediaplayer)
* [WCAG 2.1 compliance in {{ site.product_short }} ]({% slug overview_accessibility %}#wcag-21)

## See Also

* [Keyboard Navigation by the MediaPlayer HtmlHelper for {{ site.framework }} (Demo)](https://demos.telerik.com/{{ site.platform }}/mediaplayer/keyboard-navigation)
* [Keyboard Navigation by the MediaPlayer HtmlHelper for {{ site.framework }}]({% slug htmlhelpers_mediaplayer_accessibility_keyboard_navigation_aspnetcore %})
* [Accessibility Compliance in {{ site.product }}]({% slug compliance_accessibility %})
