---
title: Overview
page_title: Download and Installation Overview | Download and Installation | Kendo UI for jQuery
description: "Get started with Kendo UI for jQuery and learn how to download the library and initialize its widgets."
slug: overviewdownload_kendoui
position: 1
---

# Download and Installation Overview

This article provides general information on the Kendo UI distributions that you can download as well as the available Kendo UI installation and widget initialization approaches.  

Kendo UI also offers various download approaches which allow you to use the technology with which you feel most comfortable to work with:  

* To install Kendo UI for jQuery widgets, you can use the available Kendo UI CDN services which are hosted on [Amazon CloudFront](https://aws.amazon.com/cloudfront/).

  For more information, refer to the article on [obtaining Kendo UI by using CDN]({% slug kendoui_cdn_services_installation %}).

* Another approach to install Kendo UI is by accessing the [Node Package Manager (NPM)](http://npmjs.com/) JavaScript package manager and downloading the available Kendo UI packages on NPM.

  For more information, refer to the article on [installing Kendo UI with NPM]({% slug kendoui_npm_packages_kendoui_installation %}).

* If you are a registered user, you can use the available Kendo UI NuGet packages from the private Kendo UI NuGet feed. [NuGet](https://www.nuget.org) is an open-source .NET package manager which hosts Kendo UI packages for the jQuery and ASP.NET MVC flavors.  

  For more information, refer to the article on [installing Kendo UI with NuGet]({% slug kendoui_nuget_packages %}).

* You can also install part of the Kendo UI for jQuery widgets and framework components that your project requires and include only what you need by picking the combined or individual scripts, by building a custom combined script, or by using Gulp to build a custom script.

  For more information, refer to the article on [creating your own custom bundles with Kendo UI]({% slug include_only_what_you_need_kendoui_scripts %}).

* Kendo UI for jQuery uses the [Bower web package manager](https://bower.io/) which handles frameworks, libraries, assets, and utilities. The library maintains the Kendo UI Core and the Kendo UI Professional Bower packages which provide all official releases, service packs, and internal Kendo UI for jQuery builds.

  For more information, refer to the article on [installing Kendo UI as a Bower package]({% slug kendoui_bower_packages_kendoui_installation %}).

## Next Steps

* [Create your own custom bundles]({% slug include_only_what_you_need_kendoui_scripts %})
* [Create your own custom widgets]({% slug createcustomkendouiwidgets_gettingstarted %})
* [Initialize widgets as jQuery plugins]({% slug initialize_widgets_using_jquery_plugins_installation %})
* [Initialize widgets with MVVM]({% slug mvvm_initialization_kendoui %})
* [Explore the widget script dependencies]({% slug script_filesfor_barcodes_widgets %})

## See Also

* [Hosting Kendo UI in Your Project]({% slug hosting_kendoui %})
* [Installing Kendo UI with Bower]({% slug kendoui_bower_packages_kendoui_installation %})
* [Obtaining Kendo UI by Using the CDN Services]({% slug kendoui_cdn_services_installation %})
* [Installing Kendo UI with NPM]({% slug kendoui_npm_packages_kendoui_installation %})
* [Installing Kendo UI with NuGet]({% slug kendoui_nuget_packages %})
* [Getting Up and Running with Your Kendo UI Project (Guide)]({% slug getting_started_installation_kendoui %})
