---
title: jQuery Support
page_title: jQuery Support | Support and Distribution | Kendo UI for jQuery
description: "Get started with Kendo UI for jQuery and learn about the jQuery version support which is delivered by the Kendo UI for jQuery library."
previous_url: /install/prerequisites, /javascript-dependencies, /intro/prerequisites, /technical-requirements
slug: jquerysupport_kendoui
position: 3
---

# jQuery Support

The Kendo UI library is based on [jQuery](https://jquery.com/) and all Kendo UI bundles include the corresponding minified jQuery library in their `js` directories.

> In order for the Kendo UI scripts to work as expected, include a reference to the jQuery library in the document before the scripts.

## Supported Versions

The current official version of Kendo UI requires jQuery version 1.12.4. Usually, each newly released jQuery version introduces breaking changes and is not compatible with the existing Kendo UI versions. In such cases, use the previous jQuery version until the next official Kendo UI version that resolves the issue is released. Normally, the jQuery version that is shipped with the Kendo UI service packs is not changed but is updated in major releases.

The following table provides a list of the jQuery versions that are compatible with the major Kendo UI releases and their corresponding service packs.

| Major Releases												                                         | jQuery Version    | Comments  |
| :---															                                             | :---			         | :---	     |
| [Kendo UI 2021.3.914 (R3 2021)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r3-2021)|1.12.4| Also compatible with 1.10.x, 2.2.x and 3.6.0|
| [Kendo UI 2021.2.511 (R2 2021)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r2-2021)|1.12.4| Also compatible with 1.10.x, 2.2.x and 3.6.0|
| [Kendo UI 2021.1.119 (R1 2021)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r1-2021)|1.12.4| Also compatible with 1.10.x, 2.2.x and 3.5.1|
| [Kendo UI 2020.3.915 (R3 2020)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r3-2020)|1.12.4| Also compatible with 1.10.x, 2.2.x and 3.5.1|
| [Kendo UI 2020.2.513 (R2 2020)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r2-2020)|1.12.4| Also compatible with 1.10.x, 2.2.x and 3.5.1|
| [Kendo UI 2020.1.114 (R1 2020)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r1-2020)|1.12.4| Also compatible with 1.10.x, 2.2.x and 3.4.1|
| [Kendo UI 2019.3.917 (R3 2019)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r3-2019)|1.12.4| Also compatible with 1.10.x, 2.2.x and 3.4.1|
| [Kendo UI 2019.2.514 (R2 2019)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r2-2019)|1.12.4| Also compatible with 1.10.x, 2.2.x and 3.4.1|
| [Kendo UI 2019.1.115 (R1 2019)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/progress-kendo-ui-2019-1-115-changelog-)|1.12.4| Also compatible with 1.10.x, 2.2.x and 3.3.1|
| [Kendo UI 2018.3.911 (R3 2018)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r3-2018)	|1.12.4| Also compatible with 1.10.x, 2.2.x and 3.3.1|
| [Kendo UI 2018.2.516 (R2 2018)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r2-2018)	|1.12.4| Also compatible with 1.10.x, 2.2.x and 3.3.1|
| [Kendo UI 2018.1.117 (R1 2018)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r1-2018)	|1.12.4| Also compatible with 1.10.x, 2.2.x and 3.1.1|
| [Kendo UI 2017.3.913 (R3 2017)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r3-2017)	|1.12.3| Also compatible with 1.10.x, 2.2.x and 3.1.1|
| [Kendo UI 2017.2.504 (R2 2017)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r2-2017)	|1.12.3| Also compatible with 1.10.x, 2.2.x and 3.1.1|
| [Kendo UI 2017.1.118 (R1 2017)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r1-2017)	|1.12.3| Also compatible with 1.10.x, 2.2.x and 3.1.1|
| [Kendo UI 2016.3.1118 (R3 2016 SP2)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r3-2016-sp2)	|1.12.3| Also compatible with 1.10.x, 2.2.x and 3.1.1|
| [Kendo UI 2016.3.914 (R3 2016)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-r3-2016)	|1.12.3| Also compatible with 1.10.x and 2.2.x|
| [Kendo UI 2016.2.504 (R2 2016)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-q2-2016)	|1.12.3| Also compatible with 1.10.x and 2.2.x|
| [Kendo UI 2016.1.112 (Q1 2016)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-q1-2016)	|1.9.1| Also compatible with 1.10.x and 2.1.x|
| [Kendo UI 2015.3.930 (Q3 2015)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-q3-2015)	|1.9.1| Also compatible with 1.10.x and 2.1.x|
| [Kendo UI 2015.2.624 (Q2 2015)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-q2-2015)	|1.9.1| Also compatible with 1.10.x and 2.1.x|
| [Kendo UI 2015.1.318 (Q1 2015)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-q1-2015)	|1.9.1| Also compatible with 1.10.x and 2.1.x|
| [Kendo UI 2014.3.1119 (Q3 2014)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/kendo-ui-q3-2014)	|1.9.1| Also compatible with 1.10.x and 2.1.x|
| [Kendo UI 2014.2.716 (Q2 2014)](https://www.telerik.com/support/whats-new/kendo-ui/release-history/q2-2014-kendouicomplete-2014-2-716)	|1.9.1| Also compatible with 1.10.x and 2.1.x|
| [Kendo UI 2014.1.318 (Q1 2014)]({% slug breakingchanges2014_kendoui%}#kendo-ui-2014-q1)	                    |1.9.1| Also compatible with 1.10.x and 2.0.x|
| [Kendo UI 2013.3.1119 (Q3 2013)]({% slug breakingchanges2014_kendoui%}#kendo-ui-2014-q3)	                  |1.9.1| Also compatible with 1.10.x and 2.0.x|
| [Kendo UI 2013.2.716 (Q2 2013)]({% slug breakingchanges2013_kendoui%}#kendo-ui-2013-q2)	                    |1.9.1| - |
| [Kendo UI 2013.1.319 (Q1 2013)]({% slug breakingchanges2013_kendoui %}#kendo-ui-2013-q1)	                  |1.9.1| - |
| [Kendo UI 2012.3.1114 (Q3 2012)]({% slug breakingchanges2012_kendoui %}#kendo-ui-2012-q3)	                  |1.8.2| - |
| [Kendo UI 2012.2.710 (Q2 2012)]({% slug breakingchanges2012_kendoui %}#kendo-ui-2012-q2)	                  |1.7.1| - |
| [Kendo UI 2012.1.322 (Q1 2012)]({% slug breakingchanges2012_kendoui %}#kendo-ui-2012-q1-20121322)	          |1.7.1| - |
| [Kendo UI 2011.3.1129 (Q3 2011)]({% slug breakingchanges2012_kendoui %}#changes-from-2011-q3-sp1-201131407) |1.7.1| - |

## Working with Earlier Versions

Occasionally, a legacy web application might require an earlier jQuery version with which Kendo UI is not compatible. In such cases, use a recent jQuery version together with the [jQuery Migrate plugin](https://github.com/jquery/jquery-migrate/). It restores the jQuery features that have been depreciated and provides for the required backward compatibility.

## See Also

* [Web Browser Support by Kendo UI]({% slug wbe_browserand_operating_system_support %})
* [PDF and Excel Export Support by Kendo UI]({% slug export_support_kendoui %})
* [Operation System Support by Kendo UI]({% slug ossupport_kendo %})
* [Earlier Versions Support Policy by Kendo UI]({% slug old_versions_support_policy %})
