---
title: Earlier Versions Support Policy
page_title: Support Policy for Earlier Kendo UI Versions | Support and Distribution | Kendo UI for jQuery
description: "Get started with Kendo UI for jQuery and learn about the support policy on earlier versions, how bug fixes and feature requests are implemented, and how you can get them."
slug: old_versions_support_policy
position: 50
---

# Earlier Versions Support Policy

This article provides information on the provided support for earlier Kendo UI versions.

The support policy includes the way bug fixes, feature enhancements, and browser compatibility are updated and applied across the Progress&reg; Kendo&reg; UI for jQuery, Progress&reg; Telerik&reg; UI for ASP.NET MVC, Progress&reg; Telerik&reg; UI for ASP.NET Core, Progress&reg; Telerik&reg; UI for JSP, and Progress&reg; Telerik&reg; UI for PHP suites.

* [Bug Fixes](#bug-fixes)
* [New Features and Widgets](#new-features-and-widgets)
* [Browser Compatibility](#browser-compatibility)
* [Implementation Support](#implementation-support)

> For best performance results, use the latest Kendo UI versions which contain all recent features and fixes that are available.

## Bug Fixes

Bugs in Kendo UI widgets are fixed depending on the priority set by the product management and based on the [public Feedback portal](https://feedback.telerik.com/kendo-jquery-ui), [support system](https://www.telerik.com/account/support-tickets/available-support-list.aspx), surveys, interviews, and other means at management discretion.

Bug fixes are then implemented in the product by the Development team and later introduced in the first [official product release](https://www.telerik.com/support/whats-new/kendo-ui/release-history). Internal (nightly) builds may also contain bug fixes before an official release is available and you can use them to keep developing your application. However, avoid promoting them to production.

To get a bug fix, you have to upgrade your project to the same release as the release that contains the fix, or later.

* [Upgrading your Kendo UI for jQuery project (new script or style referral)]({% slug hosting_kendoui %})
* [Upgrading your Telerik&reg; UI for ASP.NET MVC project](https://docs.telerik.com/aspnet-mvc/introduction#upgrade)
* [Upgrading your Telerik&reg; UI for ASP.NET Core project](https://docs.telerik.com/aspnet-core/introduction#upgrade)

If a workaround for an earlier version is technically feasible, you may be provided with such in the ticketing system. However, Progress Software Corporation cannot guarantee that bug fixes in earlier versions will be available and cannot give warranty for any workarounds that are provided.

## New Features and Widgets

Feature enhancements and new widgets become publicly available in the first major release and after their implementation by the Development team.

New features and widgets are not available for versions which come before the first version in which they were released.

## Browser Compatibility

Kendo UI versions support only browsers that were available at the time of their release&mdash;for example, a 2012 Kendo UI version does not support IE11 because IE11 was released in 2013. For more information, refer to the article on [web browser and operating system support]({% slug wbe_browserand_operating_system_support %}).

## Implementation Support

For earlier versions, you can get suggestions on how to implement certain scenarios, features, and Kendo UI tools in your project in the ticketing system and depending on their technical feasibility. If such an implementation relies on the API, fixes, or enhancements that are implemented in later versions, you will need to upgrade to a release which contains the feature you need.

## See Also

* [License Agreement](https://www.telerik.com/purchase/license-agreement/kendo-ui)
