---
title: Change Size of Popup Editor
description: An example on how to specify dimensions for the Kendo UI Grid popup editor.
type: how-to
page_title: Change Popup Editor Dimensions | Kendo UI Grid for jQuery
slug: grid-adjust-popup-size
tags: grid, popup, edit, editor, window, size, width, height, dimensions
ticketid: 1144949
res_type: kb
component: grid
---

## Environment

<table>
 <tr>
  <td>Product</td>
  <td>Progress Kendo UI Grid</td>
 </tr>
 <tr>
  <td>Progress Kendo UI version</td>
  <td>Created with the 2020.3.1021 version</td>
 </tr>
</table>

## Description

How can I change the width and height of the popup editor window in the Grid?

## Solution

1. Handle the [`edit`](https://docs.telerik.com/kendo-ui/api/javascript/ui/grid/events/edit) event of the Grid and add a custom CSS rule which explicitly specifies the dimensions of the popup wrapper.
1. Add a custom CSS rule which sets an auto width and height for `.k-edit-form-container`.

```dojo

<style>
    div.k-edit-form-container {
        width: auto;
        height: auto;
    }
</style>

<div id="grid"></div>

<script>
    $(document).ready(function () {
        var crudServiceBaseUrl = "https://demos.telerik.com/kendo-ui/service",
            dataSource = new kendo.data.DataSource({
                transport: {
                    read: {
                        url: crudServiceBaseUrl + "/Products",
                        dataType: "jsonp"
                    },
                    update: {
                        url: crudServiceBaseUrl + "/Products/Update",
                        dataType: "jsonp"
                    },
                    destroy: {
                        url: crudServiceBaseUrl + "/Products/Destroy",
                        dataType: "jsonp"
                    },
                    create: {
                        url: crudServiceBaseUrl + "/Products/Create",
                        dataType: "jsonp"
                    },
                    parameterMap: function (options, operation) {
                        if (operation !== "read" && options.models) {
                            return { models: kendo.stringify(options.models) };
                        }
                    }
                },
                batch: true,
                pageSize: 20,
                schema: {
                    model: {
                        id: "ProductID",
                        fields: {
                            ProductID: { editable: false, nullable: true },
                            ProductName: { validation: { required: true } },
                            UnitPrice: { type: "number", validation: { required: true, min: 1 } },
                            Discontinued: { type: "boolean" },
                            UnitsInStock: { type: "number", validation: { min: 0, required: true } }
                        }
                    }
                }
            });

        $("#grid").kendoGrid({
            dataSource: dataSource,
            pageable: true,
            height: 550,
            toolbar: ["create"],
            edit: function (e) {
                $(e.container).parent().css({
                    width: '500px',
                    height: '500px'
                });
            },
            columns: [
                { field: "ProductName", title: "Product Name" },
                { field: "UnitPrice", title: "Unit Price", format: "{0:c}", width: "120px" },
                { field: "UnitsInStock", title: "Units In Stock", width: "120px" },
                { field: "Discontinued", width: "120px" },
                { command: ["edit", "destroy"], title: "&nbsp;", width: "250px" }],
            editable: "popup"
        });
    });
</script>
```
