---
title: Kendo UI Design files for Adobe XD
page_title: Kendo UI Design files for Adobe XD | Kendo UI Styles and Appearance
description: "Learn how to apply CSS classes to the Kendo UI desktop widgets to change their appearance and further customize their style."
slug: adobexd_design_files_kendoui
position: 10
---

# Kendo UI Design files for Adobe XD

UX guidelines and components library working together to craft exceptional experiences.

![Kendo UI Design files for Adobe XD](images/design-files/01-Kendo-UI-Design-Files-for-Adobe-XD.png)

**We provide Kendo UI components design building blocks for Adobe XD, to help designers, front-ends and developers collaborate efficiently.**

Kendo UI design files cover all Kendo flavours - Angular, React, Vue, jQuery.
The detailed anatomy, metrics and theming of the components will help you design better apps, be more productive and enable seamless handover to developers. To ensure perfect design implementation we provide Kendo UI default theme in the design resources, with ready-to-use components - all with typography, color swatches and metrics.

We’ve made the Adobe XD files to be intuitive to use and require no additional XD knowledge - just use the components in their corresponding states in your design and the developers will get the exact same appearance out of the box from the Kendo UI framework.

## Adobe XD Design Files Download

Download the resources to help you design faster and implement with precision.

<img src="images/design-files/XD.png" alt="XD-logo" style="padding-right:20px;"> [Download Kendo UI Design Files for Adobe XD](https://github.com/telerik/kendo-ux/tree/master/Kendo%20UI%20Design%20Filer%20for%20Adobe%20XD)

Download and navigate to **kendo-default-masters.xd** file.
This master file contains KendoUI colors, typography and the most used icons.

![navigate-to-master](images/design-files/02-navigate-to-master.png)

Open it and save it as a cloud document to your Adobe Creative Cloud account. Now the file is in your account and it’s ready to be used as a linked master file for all design files.

![save-as-cloud](images/design-files/03-save-as-cloud.png)

## Relink assets to master

Open a component file and relink the missing links to master file from your Adobe Creative Cloud account.

![relink-to-master](images/design-files/04-relink-to-master.png)

## File Layout

Each Kendo UI design file for Adobe XD, has an artboard containing the following elements:

 - **Component Anatomy**
 - **Component Metrics**
 - **Component Interaction States**

All master components are located outside the artboard area - in Adobe XD pasteboard.

![file-layout](images/design-files/05-file-layout.png)

## Component Architecture

Most of the components shares common structure:

 - **Component (parent)**
 - **Content**
 - **Component background**

The content folder is based on “stack” functionality of Adobe XD, and contains all nested child elements, like texts and icons.
Each of the elements could be toggled as shown/hidden from the layer panel.
The content group is also responsible for common padding metrics, creating the component size.

![component-architecture](images/design-files/06-component-architecture.png)

Content group is also responsible for main padding metrics.

![component-padding](images/design-files/07-component-padding.png)

## Component Interaction States

Component states are one of the most powerful feature of Kendo UI design files for Adobe XD.
You can just copy a component to your design layout and then change to the desired state (e.g. Hover, Active, etc.)

![component-interaction-states](images/design-files/08-component-interaction-states.png)

## Icon Font

In all components with icons, the “WebComponentsIcons” font is used. It is provided in the downloadable archive with Kendo UI design files for Adobe XD.

![used-icon-font](images/design-files/09-used-icon-font.png)

<img src="images/design-files/XD.png" alt="XD-logo" style="padding-right:20px;"> [Download Kendo UI Design Files for Adobe XD](https://github.com/telerik/kendo-ux/tree/master/Kendo%20UI%20Design%20Filer%20for%20Adobe%20XD)

We’ll continue to release Adobe XD resources to fully cover the Kendo UI framework.
Please, use the form below, if you chose to leave your feedback and comments.
