---
title: JavaScript Errors
page_title: JavaScript Errors | Kendo UI Troubleshooting
description: "Learn about the solutions of JavaScript related issues that may occur while working with Kendo UI controls."
slug: troubleshooting_javascript_errors_kendoui
---

# JavaScript Errors

This page provides solutions for JavaScript related issues you may encounter while working with Kendo UI widgets.

## Unhandled JavaScript Errors

### Application Does Not Function at All

**Solution**

JavaScript errors are likely to prevent a web page from working as expected. By default all browsers hide the JavaScript errors from the end user. Use the browser developer tools to locate and debug JavaScript errors:

* [For Google Chrome, use Console](https://developer.chrome.com/devtools/docs/console)
* [For Internet Explorer, press `F12` and use the **Tools** Console](https://msdn.microsoft.com/en-us/library/gg589530(v=vs.85).aspx)
* [For Firefox, use the **JavaScript** Console](https://developer.mozilla.org/en-US/Learn/Discover_browser_developer_tools#The_JavaScript_console)

### Application Is Limited to Static Content

For a solution, see the [Application Does Not Function at All](#application-does-not-function-at-all) section above.

### Kendo UI Widgets Are Not Instantiated

For a solution, see the [Application Does Not Function at All](#application-does-not-function-at-all) section above.

## See Also

* [Common Issues in Kendo UI]({% slug troubleshooting_common_issues_kendoui %})
* [Performance Issues]({% slug troubleshooting_system_memory_symptoms_kendoui %})
* [Content Security Policy]({% slug troubleshooting_content_security_policy_kendoui %})
* [Common Issues in Kendo UI Excel Export]({% slug troubleshooting_excel_export_kendoui %})
* [Common Issues in Kendo UI Charts]({% slug troubleshooting_chart_widget %})
* [Performance Issues in Kendo UI Widgets for Data Visualization]({% slug tipsandtricks_kendouistyling %})
* [Common Issues in Kendo UI ComboBox]({% slug troubleshooting_common_issues_combobox_kendoui %})
* [Common Issues in Kendo UI Diagram]({% slug troubleshooting_diagram_widget %})
* [Common Issues in Kendo UI DropDownList]({% slug troubleshooting_common_issues_dropdownlist_kendoui %})
* [Common Issues in Kendo UI Editor]({% slug troubleshooting_editor_widget %})
* [Common Issues in Kendo UI MultiSelect]({% slug troubleshooting_common_issues_multiselect_kendoui %})
* [Common Issues in Kendo UI Scheduler]({% slug troubleshooting_scheduler_widget %})
* [Common Issues in Kendo UI Upload]({% slug troubleshooting_upload_widget %})
* [Common Issues in Telerik UI for ASP.NET MVC](https://docs.telerik.com/aspnet-mvc/troubleshoot/troubleshooting)
* [Validation Issues in Telerik UI for ASP.NET MVC](https://docs.telerik.com/aspnet-mvc/troubleshoot/troubleshooting-validation)
* [Scaffolding Issues in Telerik UI for ASP.NET MVC](https://docs.telerik.com/aspnet-mvc/troubleshoot/troubleshooting-scaffolding)
* [Common Issues in the Grid ASP.NET MVC HtmlHelper Extension](https://docs.telerik.com/aspnet-mvc/helpers/grid/troubleshoot/troubleshooting)
* [Excel Export with the Grid ASP.NET MVC HtmlHelper Extension](https://docs.telerik.com/aspnet-mvc/helpers/grid/troubleshoot/excel-export-issues)
* [Common Issues in the Spreadsheet ASP.NET MVC HtmlHelper Extension](https://docs.telerik.com/aspnet-mvc/helpers/spreadsheet/troubleshoot/troubleshooting)
* [Common Issues in the Upload ASP.NET MVC HtmlHelper Extension](https://docs.telerik.com/aspnet-mvc/helpers/upload/troubleshoot/troubleshooting)
