---
title: Overview
page_title: Overview | Team Efficiency Dashboard Tutorial
description: "Start building the Team Efficiency Dashboard application by using Progress Telerik UI for ASP.NET MVC."
slug: overview_timeefficiencyapp_aspnetmvc6
previous_url: /tutorials/tutorial-aspnetmvc-quick-start/chapter0
position: 1
---

# Overview

The tutorial on how to build the Team Efficiency Dashboard application by using Telerik UI for ASP.NET MVC is contributed by Developer Advocate Ed Charbeneau.

## Introduction

Welcome to the [Telerik UI for ASP.NET MVC](https://www.telerik.com/aspnet-mvc) quick start guide. In this guided tutorial you will learn how to install, configure, and utilize Telerik UI for ASP.NET MVC to build a rich single-page dashboard application that works beautifully on any device.

### What You're Building

This guide will walk you through building Team Efficiency Dashboard, a single page app that does the following things:

- Connects rich chart visualizations and grids to an SQL data source.
- Provides an interactive master/detail dashboard with filtering, sorting and exporting.
- Looks great on any device size including: mobile, tablet and desktop.

If you follow along until the end, here is what the finished app will look like.

![](images/chapter0/dashboard.jpg)

And here is what the app will look like on mobile.

![](images/chapter0/mobile-dashboard.jpg)

### Telerik UI for ASP.NET MVC vs Kendo UI Widgets

From client-side point of view, the vanilla HTML/JavaScript **Kendo UI** widgets and the rendered **Telerik UI for ASP.NET MVC** represent the same thing and provide the same capabilities.
However, the Telerik UI for ASP.NET MVC wrappers provide additional capabilities for use with ASP.NET MVC and tooling for VisualStudio. Refer to the [documentation]({% slug overview_aspnetmvc6_aspnetmvc %}#widgets-vs-helpers) for a complete feature comparison.

### Important Resources

- [Documentation - Telerik UI for ASP.NET MVC]({% slug overview_aspnetmvc6_aspnetmvc %})
- [API References - Telerik UI for ASP.NET MVC](https://docs.telerik.com/aspnet-mvc/api/)
- [Support](https://www.telerik.com/account/support-tickets/my-support-tickets)

## Next Steps

* [Chapter 1: Getting Up and Running]({% slug gettingupandrunning_timeefficiencyapp_aspnetmvc6 %}#getting-up-and-running)
* [Chapter 2: Input Controls]({% slug gettingupandrunning_timeefficiencyapp_aspnetmvc6 %}#input-controls)
* [Chapter 3: Scaffolding]({% slug gettingupandrunning_timeefficiencyapp_aspnetmvc6 %}#scaffolding)
* [Chapter 4: Add and Configure the Kendo UI Grid]({% slug gettingupandrunning_timeefficiencyapp_aspnetmvc6 %}#kendo-ui-grid)
* [Chapter 5: Add and Configure the Kendo UI ListView]({% slug gettingupandrunning_timeefficiencyapp_aspnetmvc6 %}#kendo-ui-listview)
* [Chapter 6: Manage the Client Side]({% slug gettingupandrunning_timeefficiencyapp_aspnetmvc6 %}#client-side)
* [Chapter 7: Handle the Kendo UI Datasource]({% slug gettingupandrunning_timeefficiencyapp_aspnetmvc6 %}#kendo-ui-datasource)
* [Chapter 8: Add and Configure the Kendo UI Charts]({% slug gettingupandrunning_timeefficiencyapp_aspnetmvc6 %}#kendo-ui-charts)
* [Chapter 9: Make the Application Responsive]({% slug gettingupandrunning_timeefficiencyapp_aspnetmvc6 %}#go-responsive)
* [Chapter 10: Add and Configure the Kendo UI Themes]({% slug gettingupandrunning_timeefficiencyapp_aspnetmvc6 %}#kendo-ui-themes)
