﻿var graph = { "nodes": [{ "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/35225" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/35225/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/35225/databases" }], "identifier": 35225, "description": "The process in which a signal is secreted or discharged into the extracellular medium from a cellular source.", "isObsolete": true, "name": "signal release", "databaseSpecificId": "GO:0023061", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0023061" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/15118" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/15118/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/15118/databases" }], "identifier": 15118, "description": "The controlled release of a substance by a cell.", "isObsolete": true, "name": "secretion by cell", "databaseSpecificId": "GO:0032940", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0032940" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/1228" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/1228/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/1228/databases" }], "identifier": 1228, "description": "The cellular process that creates a physical entity or change in state, i.e. a signal, that originates in one cell and is used to transfer information to another cell. This process begins with the initial formation of the signal and ends with the mature form and placement of the signal.", "isObsolete": true, "name": "generation of a signal involved in cell-cell signaling", "databaseSpecificId": "GO:0003001", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0003001" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/25556" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/25556/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/25556/databases" }], "identifier": 25556, "description": "Any process that is carried out at the cellular level, occurring within a single organism.", "isObsolete": true, "name": "single-organism cellular process", "databaseSpecificId": "GO:0044763", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0044763" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/8041" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/8041/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/8041/databases" }], "identifier": 8041, "description": "The directed movement of a substance or cellular entity, such as a protein complex or organelle, to a specific location within, or in the membrane of, a cell.", "isObsolete": true, "name": "establishment of localization in cell", "databaseSpecificId": "GO:0051649", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0051649" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/35264" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/35264/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/35264/databases" }], "identifier": 35264, "description": "The controlled release of a substance by a cell or a tissue.", "isObsolete": true, "name": "secretion", "databaseSpecificId": "GO:0046903", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0046903" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/17733" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/17733/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/17733/databases" }], "identifier": 17733, "description": "Any process that mediates the transfer of information from one cell to another.", "isObsolete": true, "name": "cell-cell signaling", "databaseSpecificId": "GO:0007267", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0007267" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/2348" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/2348/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/2348/databases" }], "identifier": 2348, "description": "Any process that is carried out at the cellular level, but not necessarily restricted to a single cell. For example, cell communication occurs among more than one cell, but occurs at the cellular level.", "isObsolete": true, "name": "cellular process", "databaseSpecificId": "GO:0009987", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0009987" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/25499" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/25499/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/25499/databases" }], "identifier": 25499, "description": "A biological process that involves only one organism.", "isObsolete": true, "name": "single-organism process", "databaseSpecificId": "GO:0044699", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0044699" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/27496" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/27496/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/27496/databases" }], "identifier": 27496, "description": "The directed movement of a cell, substance or cellular entity, such as a protein complex or organelle, to a specific location.", "isObsolete": true, "name": "establishment of localization", "databaseSpecificId": "GO:0051234", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0051234" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/8040" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/8040/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/8040/databases" }], "identifier": 8040, "description": "A localization process that takes place at the cellular level; as a result of a cellular localization process, a substance or cellular entity, such as a protein complex or organelle, is transported to, and/or maintained in, a specific location within or in the membrane of a cell.", "isObsolete": true, "name": "cellular localization", "databaseSpecificId": "GO:0051641", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0051641" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/6947" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/6947/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/6947/databases" }], "identifier": 6947, "description": "The directed movement of substances (such as macromolecules, small molecules, ions) into, out of or within a cell, or between cells, or within a multicellular organism by means of some agent such as a transporter or pore, involving a single organism.", "isObsolete": true, "name": "single-organism transport", "databaseSpecificId": "GO:0044765", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0044765" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/1813" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/1813/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/1813/databases" }], "identifier": 1813, "description": "Any process that mediates interactions between a cell and its surroundings. Encompasses interactions such as signaling or attachment between one cell and another cell, between a cell and an extracellular matrix, or between a cell and any other aspect of its environment.", "isObsolete": true, "name": "cell communication", "databaseSpecificId": "GO:0007154", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0007154" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/25500" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/25500/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/25500/databases" }], "identifier": 25500, "description": "A signaling process occurring within a single organism.", "isObsolete": true, "name": "single organism signaling", "databaseSpecificId": "GO:0044700", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0044700" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/1988" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/1988/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/1988/databases" }], "identifier": 1988, "description": "Any process specifically pertinent to the functioning of integrated living units: cells, tissues, organs, and organisms. A process is a collection of molecular events with a defined beginning and end.", "isObsolete": true, "name": "biological process", "databaseSpecificId": "GO:0008150", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0008150" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/27470" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/27470/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/27470/databases" }], "identifier": 27470, "description": "Any process in which a cell, a substance, or a cellular entity, such as a protein complex or organelle, is transported to, and/or maintained in a specific location.", "isObsolete": true, "name": "localization", "databaseSpecificId": "GO:0051179", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0051179" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/17520" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/17520/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/17520/databases" }], "identifier": 17520, "description": "The directed movement of substances (such as macromolecules, small molecules, ions) into, out of or within a cell, or between cells, or within a multicellular organism by means of some agent such as a transporter or pore.", "isObsolete": true, "name": "transport", "databaseSpecificId": "GO:0006810", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0006810" }, { "links": [{ "rel": "self", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/15365" }, { "rel": "references", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/15365/references" }, { "rel": "databases", "href": "http://webappdevel.advaitacorporation.net:8080/ars_oauth/go_terms/15365/databases" }], "identifier": 15365, "description": "The entirety of a process in which information is transmitted within a biological system. This process begins with an active signal and ends when a cellular response has been triggered.", "isObsolete": true, "name": "signaling", "databaseSpecificId": "GO:0023052", "rootOntology": "BP", "link": "http://amigo.geneontology.org/cgi-bin/amigo/term_details?term=GO:0023052" }], "relationships": [{ "source": 35225, "target": 15118, "rel": "is_a" }, { "source": 35225, "target": 1228, "rel": "part_of" }, { "source": 15118, "target": 25556, "rel": "is_a" }, { "source": 15118, "target": 8041, "rel": "is_a" }, { "source": 15118, "target": 35264, "rel": "is_a" }, { "source": 1228, "target": 25556, "rel": "is_a" }, { "source": 1228, "target": 17733, "rel": "part_of" }, { "source": 25556, "target": 2348, "rel": "is_a" }, { "source": 25556, "target": 25499, "rel": "is_a" }, { "source": 8041, "target": 27496, "rel": "is_a" }, { "source": 8041, "target": 8040, "rel": "part_of" }, { "source": 35264, "target": 6947, "rel": "is_a" }, { "source": 17733, "target": 1813, "rel": "is_a" }, { "source": 17733, "target": 25500, "rel": "is_a" }, { "source": 2348, "target": 1988, "rel": "is_a" }, { "source": 25499, "target": 1988, "rel": "is_a" }, { "source": 27496, "target": 1988, "rel": "is_a" }, { "source": 27496, "target": 27470, "rel": "part_of" }, { "source": 8040, "target": 25556, "rel": "is_a" }, { "source": 8040, "target": 27470, "rel": "is_a" }, { "source": 6947, "target": 17520, "rel": "is_a" }, { "source": 6947, "target": 25499, "rel": "is_a" }, { "source": 1813, "target": 25556, "rel": "is_a" }, { "source": 25500, "target": 15365, "rel": "is_a" }, { "source": 25500, "target": 25499, "rel": "is_a" }, { "source": 27470, "target": 1988, "rel": "is_a" }, { "source": 17520, "target": 27496, "rel": "is_a" }, { "source": 15365, "target": 1988, "rel": "is_a" }], "relationshipTypes": [{ "code": "is_a", "displayName": "Is a" }, { "code": "regulates", "displayName": "Regulates" }, { "code": "negatively_regulates", "displayName": "Negatively regulates" }, { "code": "part_of", "displayName": "Part of" }, { "code": "positively_regulates", "displayName": "Postively regulates" }] };





var margin = { top: 20, right: 20, bottom: 20, left: 20 };


var width = (1024 - margin.left - margin.right);
var height = (1500 - margin.top - margin.bottom);



var svg = d3.select("body").append("svg")
    .attr("width", width)
    .attr("height", height)
    .append("g")
    .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

var iterations = { "unconstrained": 10, "userConstrained": 10, "allConstraints": 1 };



var nodeWidth = 120;
var nodeHeight = 75;
var nodeSpacing = 85;
var nodeMargin = 30;
var nodeSplineOffset = 25;
var markerSize = 10;

var nodeColor = "rgb(255,255,255)";
var rootNodeColor = "rgb(255,255,208)";
var highlightColor = "rgb(255,208,208)";

var defaultOpacity = 0.9;
var fadedOpacity = 0.3;

var linkWidth = 2;
var highlightLinkWidth = 5;

var nodeCharEm = 1.0;
var nodeCharPx = 7;
var nodeLinePadPx = 12; // node box padding for line wrapping
var nodeHeaderHeight = 18; // GO term node header box height
var nodeHeaderBtmPadEm = 0.2; // move node term text down by this amount, for IE font differences
var maxNodeLines = 3;
var baseLinkDistance = 120;
var baseSymDiffLengths = 43;

var relScaleThreshold = 50; // graphs with more than this many nodes will have a scaling factor applied to help the solver

var linkScaleFactor = 10; // increase link distance for large plots by total relationships divided by this value
var symDiffFactor = 10; // increase symmetric diff lengths for large plots by total relationships divided by this value

var linkDistance = baseLinkDistance;
var symDiffLengths = baseSymDiffLengths;

var legendWidth = 210;
var legendHeight = 220;
var legendMargin = 40;
var legendSpacing = 40;
var legendNodeWidth = 25;
var legendNodeHeight = 25;

var controlsHeight = 120;
var controlsWidth = legendWidth;

var enablePanning = true; // by default dragging the container is enabled - disable for node drag
var translateBuffer = [0, 0];
var newCoords = [0, 0]; // computed position for nodes inside zoom container to account for disabled dragging


var rect = svg.append("rect")
    .attr("width", width)
    .attr("height", height)
    .style("fill", "none")
    .style("pointer-events", "all");


var container = svg.append("g");



//scope.draw = function(graph) {

var relCnt = graph.relationships.length;
console.log(relCnt + " relationships in this graph ");

// pre-process some values based on graph size
if (relCnt > relScaleThreshold) {
    ald = (Math.round(relCnt / linkScaleFactor));
    linkDistance += ald;
    console.log("adding " + ald + " linkDistance to large graph ");
}
if (relCnt > relScaleThreshold) {
    asdl = (Math.round(relCnt / symDiffFactor));
    symDiffLengths += asdl;
    console.log("adding " + asdl + " symDiffLength to large graph ");
}


var rootNode = true;
graph.nodes.forEach(function (el) {
    // inititalize the root node (first node)
    if (rootNode) {
        el.rootNode = rootNode;
        rootNode = false;
    }
    // overwrite (or initialize) the nodes w/h and maxDepth values
    el.width = (nodeWidth + nodeMargin); // add a bit of margin to route the edges 
    el.height = nodeHeight;
    el.maxDepth = 0;
    el.childNodes = [];
    el.x = 400;
    el.y = 120; // no clue what the purpose of this originally was
});


var d3cola = cola.d3adaptor()
    .linkDistance(linkDistance)
    .avoidOverlaps(true)
    .size([width, height]);




// initialize constraints object
graph.constraints = [{ "type": "alignment", "axis": "x", "offsets": [{ "node": "0", "offset": "0" }] },
                    { "type": "alignment", "axis": "y", "offsets": [{ "node": "0", "offset": "0" }] }];

// initialize offsets which will be used to generate constraints after maxDepth recursion
graph.xOffsets = [];
graph.yOffsets = [];


// re-index relationships by array key using IDs
graph.relationships.forEach(function (el) {
    // could be optimized by iterating once and creating tmp array, then selecting by key
    var i = 0;
    graph.nodes.forEach(function (myNode) {
        if (myNode.identifier == el.source) { el.source = i; }
        if (myNode.identifier == el.target) { el.target = i; }
        i++;
    });
});



// compute max depth from root node for a given node index, assigning max depth to the node
var nodeIdx, myDepth, myIdx, newBranch, pad;
var recurseNodeRels = function (nodeIdx, myDepth, myIdx, newBranch, pad) {
    var hasChild = false;
    pad = pad + "  ";
    graph.relationships.forEach(function (rel) {
        if (rel.source == myIdx) { // the current node has a child
            hasChild = true;
            graph.nodes[myIdx].childNodes[rel.target] = rel.target; // dont just add target here, must be multi-dimensional
            if (newBranch) {
                myDepth = graph.nodes[rel.source].maxDepth; // reset the depth when starting a new branch
                newBranch = false;
            }
            if (myDepth > graph.nodes[myIdx].maxDepth) {
                graph.nodes[myIdx].maxDepth = myDepth;
                graph.yOffsets[myIdx] = { "node": myIdx, "offset": (-(myDepth * linkDistance)) };
            }
            myDepth++;
            recurseNodeRels(nodeIdx, myDepth, rel.target, newBranch, pad);
            newBranch = true;
        }
    });
    if (!hasChild) {
        if (myDepth > graph.nodes[myIdx].maxDepth) {
            graph.nodes[myIdx].maxDepth = (myDepth);
            graph.yOffsets[myIdx] = { "node": myIdx, "offset": (-(myDepth * linkDistance)) };
        }
    }
};

// trace the heirarchy and assign the depth value to each node
recurseNodeRels(0, 0, 0, true, '');

// after recursion, set the y constraints with offsets (heirarchy row maxDepth)
graph.yOffsets.forEach(function (el) { graph.constraints[1].offsets.push(el); });

// build x offset array with node ids for each depth value
var xCnts = [];
graph.nodes.forEach(function (myNode) {
    if (!xCnts[myNode.maxDepth]) { xCnts[myNode.maxDepth] = []; }// initialize a number value for counting
    xCnts[myNode.maxDepth].push(graph.nodes.indexOf(myNode)); // save each index 
});

console.log('xCnts');
console.log(xCnts);


// for a given node, find the proper x offset
var computeXOffset = function (myNode) {
    rowRange = ((xCnts[myNode.maxDepth].length()) * linkDistance); // compute row pixel width for all the nodes at this depth
    myCtr = (rowRange / 2);
};

// we know how many nodes fall at each depth, now assign the offset value to the node
var n = 0;
xCnts.forEach(function (d) {
    d.forEach(function (x) {
        constraint = { "node": x, "offset": ((nodeWidth + nodeSpacing) * d.indexOf(x)) };
    });
    n++;
});


d3cola
    .nodes(graph.nodes)
    .links(graph.relationships)
    .constraints(graph.constraints)
    // .flowLayout("y", -100)
    .symmetricDiffLinkLengths(symDiffLengths)
    .avoidOverlaps(true)
    .start(iterations.unconstrained, iterations.userConstrained, iterations.allConstraints);


var relColor = function (relCode) {
    // console.log('rel code '+relCode);
    if (relCode == 'is_a') { return "#555"; }
    if (relCode == 'part_of') { return "blue"; }
    if (relCode == 'has_part') { return "purple"; }
    if (relCode == 'regulates') { return "orange"; }
    if (relCode == 'positively_regulates') { return "green"; }
    if (relCode == 'negatively_regulates') { return "red"; }
    if (relCode == 'occurs_in') { return "cyan"; }
};

var link = container.selectAll(".link")
    .data(graph.relationships)
    .enter().append("path")
    .style('stroke-width', '2px')
    .style('stroke-opacity', 0.8)
    .style('stroke', function (d) { return relColor(d.rel); })
    .style('fill', 'none')
    //.enter().append("line")
    .attr("class", function (d) { return "link " + d.rel; });




var linkMarker = container.selectAll(".marker")
    .data(graph.relationships)
    .enter().append("path")
    .style('fill-opacity', defaultOpacity)
    .style('stroke', function (d) { return relColor(d.rel); })
    .style('fill', function (d) { return relColor(d.rel); })
    .attr("class", function (d) { return "marker " + d.rel; });


var guideline = container.selectAll(".guideline")
    .data(graph.constraints.filter(function (c) { return c.type === 'alignment'; }))
    .enter().append("line")
    .attr("class", "guideline")
    .attr("stroke-dasharray", "5,5");

var node = container.selectAll(".node")
    .data(graph.nodes)
    .enter()
    .append("rect")
    // .attr("class", "node")
    .attr("width", nodeWidth)
    .attr("height", nodeHeight)
    // .attr("rx", 2).attr("ry", 2)
    .style('stroke', '#222')
    .style('stroke-width', '1px')
    .style('background', 'white')
    .style('fill-opacity', defaultOpacity)
    .style("fill", function (d) {
        if (d.rootNode) { return rootNodeColor; }
        else { return nodeColor; }
    });

// node header box with GO ID 
var nodeHeader = container.selectAll(".nodeHeader")
    .data(graph.nodes)
    .enter().append("rect")
    .attr("class", "nodeHeader")
    .attr("width", nodeWidth)
    .attr("height", nodeHeaderHeight)
    .style('stroke', '#222')
    .style('stroke-width', '1px')
    .style('background', 'white')
    .style('fill-opacity', 0)
    .style('fill', 'red')
    .style('cursor', 'pointer');


var outputTSpan = function (d, el, line, idx, lineCnt) {
    // shift lines down by index, and up by 1/2 line count, minus 1 line for title
    var dyVal = (((idx * nodeCharEm) - ((lineCnt * 0.5) * nodeCharEm) + nodeCharEm) + nodeHeaderBtmPadEm);
    d3.select(el).append("tspan")
                .text(line)
                .attr("dy", dyVal + "em") // y offset per line index
                .attr("x", 0) // positioned on tick
                .attr("y", 0) // positioned on tick
                .style('fill', '#222')
                .style('font-family', 'Arial')
                .style('font-size', '13px')
                .style('text-anchor', 'middle')
                .style('text-align', 'center')
                .style('dominant-baseline', 'middle')
                .attr("class", "nodeTextSpan");
};

var wrapText = function (d, el) {
    var arr = d.name.split(" "); // array split by space
    // console.log(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  doing GO term: "+d.name);
    if (arr !== undefined) {
        var linePxW = 0; // counting approximate pixel width- will only work well for monospaced font.  choose an average value on the low side.
        var linePxWNext = 0; // counting what the character count will be for i+1 words, to pre-determine how to wrap or hyphenate
        var ln = 0; // line count
        var outLines = [];
        var myLine = "";
        var innerNodeWidth = (nodeWidth - (2 * nodeLinePadPx)); // inside box minus padding for word wrap
        // first split any hyphenated words that are longer than a line.
        for (i = 0; i < arr.length; i++) {
            undIdx = arr[i].indexOf("-");
            if (undIdx > 0) {
                wordPxW = (arr[i].length * nodeCharPx);
                if (wordPxW >= innerNodeWidth) {
                    firstPart = (arr[i].substring(0, (undIdx + 1)));
                    lastPart = (arr[i].substring(undIdx + 1));
                    // console.log('first: '+firstPart+' last: '+lastPart);
                    arr.splice(i, 1, firstPart, lastPart);
                }
            }
        }
        // console.log(arr);
        for (i = 0; i < arr.length; i++) {
            // get approximate px width of word arr[i]
            wordPxW = (arr[i].length * nodeCharPx);
            linePxW += wordPxW; // current pixel width of the line
            linePxWNext = linePxW;
            // width line will be, after adding the next word, if one exists
            if (arr[i + 1]) { linePxWNext = (linePxWNext + 1 + (arr[i + 1].length * nodeCharPx)); }
            myLine = (myLine + " " + arr[i]);
            // console.log("myLine = "+myLine);
            // if we will exceed the max width in px, wrap the line.
            if (linePxWNext >= innerNodeWidth) {
                outLines.push(myLine);
                ln++; // increment the line
                linePxW = 0; // reset the line px count
                linePxWNext = 0; // reset the line px next count
                myLine = ""; // reset the line txt
            } else if (outLines.length && (!arr[i + 1])) {
                // this is the last line, and we're already building the multi-line arr so go with it
                outLines.push(myLine);
            }
        }
        // generate the text lines using our line array
        if (outLines.length) {
            var outLinesTot = outLines.length;
            if (outLinesTot > maxNodeLines) { outLinesTot = maxNodeLines; }
            for (i = 0; i < outLines.length; i++) {
                if ((i >= (maxNodeLines - 1)) && (outLines[i + 1])) {
                    toOutput = (outLines[i] + "..."); // truncate
                    outputTSpan(d, el, toOutput, i, outLinesTot);
                    break;
                }
                outputTSpan(d, el, outLines[i], i, outLinesTot);
            }
        } else {
            // console.log("outputting d.name directly = "+d.name);
            outputTSpan(d, el, d.name, 0, 1);
        }
    }
};




var nodeHeaderText = container.selectAll(".nodeHeaderText")
    .data(graph.nodes)
    .enter().append("text")
    .text(function (d, i) { return d.databaseSpecificId; })
    // .text(function (d,i) { return d.databaseSpecificId + " id=" + i+" d=" + d.maxDepth; })
    .attr("x", 0) // positioned on tick
    .attr("y", 0) // positioned on tick
    .style('fill', '#777')
    .style('font-family', 'Arial')
    .style('font-size', '11px')
    .style('text-anchor', 'left')
    .style('text-align', 'left')
    .style('cursor', 'pointer')
    .attr("class", "nodeHeaderText");


var label = container.selectAll(".nodeTextContainer")
    .data(graph.nodes)
    .enter().append("g")
    .style('text-align', 'center')
    .style('text-anchor', 'middle')
    .style('margin', 0)
    .style('padding', 0)
    .attr("class", "nodeTextContainer")
    .append("text")
        .attr("class", "nodeText")
        .style('text-align', 'center')
        .style('text-anchor', 'middle')
        .each(function (d) { wrapText(d, this); });





/* overlay node gets the drag behavior */
var nodeOverlay = container.selectAll(".nodeOverlay")
    .data(graph.nodes)
    .enter()
    .append("rect")
    .attr("class", "nodeOverlay")
    .style('fill-opacity', 0.2)
    .style('fill', 'green')
    .style('cursor', 'move')
    .attr("width", nodeWidth)
    .attr("height", nodeHeight - nodeHeaderHeight)
    // .call(force.drag);
    .call(d3cola.drag);


nodeOverlay.append("title")
    .text(function (d) { return (d.name); });

var ticking = true;

// force.on("tick", function () {
d3cola.on("tick", function () {
    //if (!ticking) return;
    ticking = false;
    link.attr("d", linkSpline);
    linkMarker.attr("d", markerPath);

    node.attr("x", function (d) { return d.x - nodeWidth / 2; })
        .attr("y", function (d) { return d.y - d.height / 2; });

    nodeOverlay.attr("x", function (d) { return d.x - (nodeWidth / 2); })
        .attr("y", function (d) { return d.y - (d.height / 2) + nodeHeaderHeight; });


    label.attr("transform", function (d) {
        return "translate(" + d.x + "," + d.y + ")";
    });
    nodeHeader.attr("transform", function (d) {
        return "translate(" + (d.x - nodeWidth / 2) + "," + (d.y - d.height / 2) + ")";
    });
    nodeHeaderText.attr("transform", function (d) {
        return "translate(" + ((d.x - nodeWidth / 2) + 4) + "," + ((d.y - d.height / 2) + 13) + ")";
    });


});



//};




function linkSpline(d) {
    // source position
    var xS = (d.source.bounds.x + (d.source.width / 2)); // center of source node
    var yS = (d.source.bounds.y); // top of source node
    // target position
    var xT = (d.target.bounds.X - (d.target.width / 2)); // x center of target node
    var yT = (d.target.bounds.Y + markerSize); // bottom of target node, accounting for marker height
    // source control point
    var xSc = xS;
    var ySc = (yS - nodeSplineOffset);
    // target control point
    var xTc = xT;
    var yTc = (yT + nodeSplineOffset);
    // second node
    var x2 = (xT);
    var y2 = (yS - nodeSplineOffset);
    // second control point
    var x2c = x2;
    var y2c = yS;

    var x3 = (xT);
    var y3 = (yT + (nodeSpacing / 2));

    var x4 = (xT - xS); // this should be dynamically generated to route thru parent levels
    var y4 = (yT + nodeSpacing);

    // simple cubic b spline  with 2 control points, end to end
    b = "M" + xS + "," + yS + " C" + xSc + "," + ySc + " " + xTc + "," + yTc + " " + xT + "," + yT + " ";
    return b;
}



function markerPath(d) {
    // manual markers since angular breaks svg markers
    var m1x = (d.target.bounds.X - (d.target.width / 2));
    var m1y = (d.target.bounds.Y);

    var m2x = (d.target.bounds.X - (d.target.width / 2)) - (markerSize / 2);
    var m2y = (d.target.bounds.Y + markerSize);

    var m3x = (d.target.bounds.X - (d.target.width / 2)) + (markerSize / 2);
    var m3y = m2y;

    var mTx = m1x;
    var mTy = m1y;

    b = "M" + m1x + "," + m1y + " L" + m2x + "," + m2y + " L" + m3x + "," + m3y + " L" + mTx + "," + mTy + "Z";
    return b;
}


