'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.IcoSphereGeometry = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _math = require('../math');

var _geometry = require('../core/geometry');

var _geometry2 = _interopRequireDefault(_geometry);

var _model = require('../core/model');

var _model2 = _interopRequireDefault(_model);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/* eslint-disable comma-spacing, max-statements, complexity */

function noop() {}

var ICO_POSITIONS = [-1, 0, 0, 0, 1, 0, 0, 0, -1, 0, 0, 1, 0, -1, 0, 1, 0, 0];
var ICO_INDICES = [3, 4, 5, 3, 5, 1, 3, 1, 0, 3, 0, 4, 4, 0, 2, 4, 2, 5, 2, 0, 1, 5, 2, 1];

var IcoSphereGeometry = exports.IcoSphereGeometry = function (_Geometry) {
  _inherits(IcoSphereGeometry, _Geometry);

  function IcoSphereGeometry() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    var _ref$iterations = _ref.iterations;
    var iterations = _ref$iterations === undefined ? 0 : _ref$iterations;
    var _ref$onAddVertex = _ref.onAddVertex;
    var onAddVertex = _ref$onAddVertex === undefined ? noop : _ref$onAddVertex;

    var opts = _objectWithoutProperties(_ref, ['iterations', 'onAddVertex']);

    _classCallCheck(this, IcoSphereGeometry);

    var PI = Math.PI;
    var PI2 = PI * 2;

    var positions = [].concat(ICO_POSITIONS);
    var indices = [].concat(ICO_INDICES);

    positions.push();
    indices.push();

    var getMiddlePoint = function () {
      var pointMemo = {};

      return function (i1, i2) {
        i1 *= 3;
        i2 *= 3;
        var mini = i1 < i2 ? i1 : i2;
        var maxi = i1 > i2 ? i1 : i2;
        var key = mini + '|' + maxi;

        if (key in pointMemo) {
          return pointMemo[key];
        }

        var x1 = positions[i1];
        var y1 = positions[i1 + 1];
        var z1 = positions[i1 + 2];
        var x2 = positions[i2];
        var y2 = positions[i2 + 1];
        var z2 = positions[i2 + 2];
        var xm = (x1 + x2) / 2;
        var ym = (y1 + y2) / 2;
        var zm = (z1 + z2) / 2;
        var len = Math.sqrt(xm * xm + ym * ym + zm * zm);

        xm /= len;
        ym /= len;
        zm /= len;

        positions.push(xm, ym, zm);

        return pointMemo[key] = positions.length / 3 - 1;
      };
    }();

    for (var i = 0; i < iterations; i++) {
      var indices2 = [];
      for (var j = 0; j < indices.length; j += 3) {
        var a = getMiddlePoint(indices[j + 0], indices[j + 1]);
        var b = getMiddlePoint(indices[j + 1], indices[j + 2]);
        var c = getMiddlePoint(indices[j + 2], indices[j + 0]);

        indices2.push(c, indices[j + 0], a, a, indices[j + 1], b, b, indices[j + 2], c, a, b, c);
      }
      indices = indices2;
    }

    // Calculate texCoords and normals
    var normals = new Array(indices.length * 3);
    var texCoords = new Array(indices.length * 2);

    var l = indices.length;
    for (var _i = l - 3; _i >= 0; _i -= 3) {
      var i1 = indices[_i + 0];
      var i2 = indices[_i + 1];
      var i3 = indices[_i + 2];
      var in1 = i1 * 3;
      var in2 = i2 * 3;
      var in3 = i3 * 3;
      var iu1 = i1 * 2;
      var iu2 = i2 * 2;
      var iu3 = i3 * 2;
      var x1 = positions[in1 + 0];
      var y1 = positions[in1 + 1];
      var z1 = positions[in1 + 2];
      var theta1 = Math.acos(z1 / Math.sqrt(x1 * x1 + y1 * y1 + z1 * z1));
      var phi1 = Math.atan2(y1, x1) + PI;
      var v1 = theta1 / PI;
      var u1 = 1 - phi1 / PI2;
      var x2 = positions[in2 + 0];
      var y2 = positions[in2 + 1];
      var z2 = positions[in2 + 2];
      var theta2 = Math.acos(z2 / Math.sqrt(x2 * x2 + y2 * y2 + z2 * z2));
      var phi2 = Math.atan2(y2, x2) + PI;
      var v2 = theta2 / PI;
      var u2 = 1 - phi2 / PI2;
      var x3 = positions[in3 + 0];
      var y3 = positions[in3 + 1];
      var z3 = positions[in3 + 2];
      var theta3 = Math.acos(z3 / Math.sqrt(x3 * x3 + y3 * y3 + z3 * z3));
      var phi3 = Math.atan2(y3, x3) + PI;
      var v3 = theta3 / PI;
      var u3 = 1 - phi3 / PI2;
      var vec1 = [x3 - x2, y3 - y2, z3 - z2];
      var vec2 = [x1 - x2, y1 - y2, z1 - z2];
      var normal = _math.Vector3.cross(vec1, vec2).normalize();
      var newIndex = void 0;

      if ((u1 === 0 || u2 === 0 || u3 === 0) && (u1 === 0 || u1 > 0.5) && (u2 === 0 || u2 > 0.5) && (u3 === 0 || u3 > 0.5)) {

        positions.push(positions[in1 + 0], positions[in1 + 1], positions[in1 + 2]);
        newIndex = positions.length / 3 - 1;
        indices.push(newIndex);
        texCoords[newIndex * 2 + 0] = 1;
        texCoords[newIndex * 2 + 1] = v1;
        normals[newIndex * 3 + 0] = normal.x;
        normals[newIndex * 3 + 1] = normal.y;
        normals[newIndex * 3 + 2] = normal.z;

        positions.push(positions[in2 + 0], positions[in2 + 1], positions[in2 + 2]);
        newIndex = positions.length / 3 - 1;
        indices.push(newIndex);
        texCoords[newIndex * 2 + 0] = 1;
        texCoords[newIndex * 2 + 1] = v2;
        normals[newIndex * 3 + 0] = normal.x;
        normals[newIndex * 3 + 1] = normal.y;
        normals[newIndex * 3 + 2] = normal.z;

        positions.push(positions[in3 + 0], positions[in3 + 1], positions[in3 + 2]);
        newIndex = positions.length / 3 - 1;
        indices.push(newIndex);
        texCoords[newIndex * 2 + 0] = 1;
        texCoords[newIndex * 2 + 1] = v3;
        normals[newIndex * 3 + 0] = normal.x;
        normals[newIndex * 3 + 1] = normal.y;
        normals[newIndex * 3 + 2] = normal.z;
      }

      normals[in1 + 0] = normals[in2 + 0] = normals[in3 + 0] = normal.x;
      normals[in1 + 1] = normals[in2 + 1] = normals[in3 + 1] = normal.y;
      normals[in1 + 2] = normals[in2 + 2] = normals[in3 + 2] = normal.z;

      texCoords[iu1 + 0] = u1;
      texCoords[iu1 + 1] = v1;

      texCoords[iu2 + 0] = u2;
      texCoords[iu2 + 1] = v2;

      texCoords[iu3 + 0] = u3;
      texCoords[iu3 + 1] = v3;
    }

    return _possibleConstructorReturn(this, (IcoSphereGeometry.__proto__ || Object.getPrototypeOf(IcoSphereGeometry)).call(this, _extends({}, opts, {
      attributes: {
        positions: new Float32Array(positions),
        normals: new Float32Array(normals),
        texCoords: new Float32Array(texCoords),
        indices: new Uint16Array(indices)
      }
    })));
  }

  return IcoSphereGeometry;
}(_geometry2.default);

var IcoSphere = function (_Model) {
  _inherits(IcoSphere, _Model);

  function IcoSphere() {
    var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, IcoSphere);

    return _possibleConstructorReturn(this, (IcoSphere.__proto__ || Object.getPrototypeOf(IcoSphere)).call(this, _extends({}, opts, {
      geometry: new IcoSphereGeometry(opts)
    })));
  }

  return IcoSphere;
}(_model2.default);

exports.default = IcoSphere;
//# sourceMappingURL=data:application/json;base64,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