'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (doc) {
  if (!doc) doc = {};
  if (typeof doc === 'string') doc = { cookie: doc };
  if (doc.cookie === undefined) doc.cookie = '';

  return {
    get: function get(key) {
      var splat = doc.cookie.split(/;\s*/);
      for (var i = 0; i < splat.length; i++) {
        var ps = splat[i].split('=');
        var k = unescape(ps[0]);
        if (k === key) {
          return unescape(ps[1]);
        }
      }
      return undefined;
    },
    set: function set(key, value) {
      var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

      var expires = _ref.expires;
      var path = _ref.path;
      var domain = _ref.domain;
      var secure = _ref.secure;

      var s = escape(key) + '=' + escape(value);
      if (expires) {
        s += '; expires=' + expires;
      }
      if (path) {
        s += '; path=' + escape(path);
      }
      if (domain) {
        s += '; domain=' + escape(domain);
      }
      if (secure) {
        s += '; secure';
      }
      doc.cookie = s;
      return s;
    }
  };
};

; /* eslint-disable */
// Adapted from https://github.com/substack/cookie-cutter (under MIT license)


if (typeof document !== 'undefined') {
  var cookie = exports(document);
  exports.get = cookie.get;
  exports.set = cookie.set;
}
//# sourceMappingURL=data:application/json;base64,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