'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GL_BUFFER_USAGE = exports.BUFFER_USAGE = exports.GL_TARGETS = exports.TARGETS = exports.GL_DRAW_MODES = exports.DRAW_MODES = exports.GL_INDEX_TYPES = exports.INDEX_TYPES = undefined;

var _webglTypes = require('./webgl-types');

Object.keys(_webglTypes).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _webglTypes[key];
    }
  });
});
exports.isIndexType = isIndexType;
exports.isGLIndexType = isGLIndexType;
exports.assertIndexType = assertIndexType;
exports.isDrawMode = isDrawMode;
exports.isGLDrawMode = isGLDrawMode;
exports.assertDrawMode = assertDrawMode;

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// INDEX TYPES

// For drawElements, size of indices
// Helper definitions for validation of webgl parameters
/* eslint-disable no-inline-comments, max-len */
var INDEX_TYPES = exports.INDEX_TYPES = ['UNSIGNED_BYTE', 'UNSIGNED_SHORT'];
var GL_INDEX_TYPES = exports.GL_INDEX_TYPES = function GL_INDEX_TYPES(gl) {
  return INDEX_TYPES.map(function (constant) {
    return gl[constant];
  });
};

function isIndexType(type) {
  return INDEX_TYPES.indexOf(type) !== -1;
}
function isGLIndexType(gl, glType) {
  return GL_INDEX_TYPES(gl).indexOf(glType) !== -1;
}

function assertIndexType(gl, glType, source) {
  (0, _assert2.default)(isGLIndexType(gl, glType), 'Bad index type gl.' + getKey(gl, glType) + ' ' + source);
}

// DRAW MODES

var DRAW_MODES = exports.DRAW_MODES = ['POINTS', 'LINE_STRIP', 'LINE_LOOP', 'LINES', 'TRIANGLE_STRIP', 'TRIANGLE_FAN', 'TRIANGLES'];
var GL_DRAW_MODES = exports.GL_DRAW_MODES = function GL_DRAW_MODES(gl) {
  return DRAW_MODES.map(function (constant) {
    return gl[constant];
  });
};

function isDrawMode(mode) {
  return DRAW_MODES.indexOf(mode) !== -1;
}
function isGLDrawMode(gl, glMode) {
  return GL_DRAW_MODES(gl).indexOf(glMode) !== -1;
}

function assertDrawMode(gl, glType, source) {
  (0, _assert2.default)(isGLDrawMode(gl, glType), 'Bad draw mode gl.' + getKey(gl, glType) + ' ' + source);
}

// TARGET TYPES

var TARGETS = exports.TARGETS = ['ARRAY_BUFFER', // vertex attributes (e.g. vertex/texture coords or color)
'ELEMENT_ARRAY_BUFFER', // Buffer used for element indices.
// For WebGL 2 contexts
'COPY_READ_BUFFER', // Buffer for copying from one buffer object to another
'COPY_WRITE_BUFFER', // Buffer for copying from one buffer object to another
'TRANSFORM_FEEDBACK_BUFFER', // Buffer for transform feedback operations
'UNIFORM_BUFFER', // Buffer used for storing uniform blocks
'PIXEL_PACK_BUFFER', // Buffer used for pixel transfer operations
'PIXEL_UNPACK_BUFFER' // Buffer used for pixel transfer operations
];

var GL_TARGETS = exports.GL_TARGETS = function GL_TARGETS(gl) {
  return TARGETS.map(function (constant) {
    return gl[constant];
  }).filter(function (constant) {
    return constant;
  });
};

// USAGE TYPES

var BUFFER_USAGE = exports.BUFFER_USAGE = ['STATIC_DRAW', // Buffer used often and not change often. Contents are written to the buffer, but not read.
'DYNAMIC_DRAW', // Buffer used often and change often. Contents are written to the buffer, but not read.
'STREAM_DRAW', // Buffer not used often. Contents are written to the buffer, but not read.
// For WebGL 2 contexts
'STATIC_READ', // Buffer used often and not change often. Contents are read from the buffer, but not written.
'DYNAMIC_READ', // Buffer used often and change often. Contents are read from the buffer, but not written.
'STREAM_READ', // Contents of the buffer are likely to not be used often. Contents are read from the buffer, but not written.
'STATIC_COPY', // Buffer used often and not change often. Contents are neither written or read by the user.
'DYNAMIC_COPY', // Buffer used often and change often. Contents are neither written or read by the user.
'STREAM_COPY' // Buffer used often and not change often. Contents are neither written or read by the user.
];

var GL_BUFFER_USAGE = exports.GL_BUFFER_USAGE = function GL_BUFFER_USAGE(gl) {
  return BUFFER_USAGE.map(function (constant) {
    return gl[constant];
  }).filter(function (constant) {
    return constant;
  });
};

function getKey(gl, value) {
  for (var key in gl) {
    if (gl[key] === value) {
      return key;
    }
  }
  return String(value);
}
//# sourceMappingURL=data:application/json;base64,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